/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.patch;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporter;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.common.util.reporting.logging.LoggingReporter;
import com.oracle.cie.common.xmldiff.XmlDiffApplicator;
import com.oracle.cie.common.xmldiff.XmlDiffAspect;
import com.oracle.cie.common.xmldiff.XmlDiffException;
import com.oracle.cie.common.xmldiff.XmlDiffTree;
import com.oracle.cie.common.xmldiff.XmlDiffTreeFilter;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.carbdiff.Strategy;
import com.oracle.cie.gdr.dao.cmn.QuickReference;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.rgy.ComponentInfo;
import com.oracle.cie.gdr.dao.rgy.DistributionInfo;
import com.oracle.cie.gdr.dao.rgy.FeatureInfo;
import com.oracle.cie.gdr.dao.rgy.PatchInfo;
import com.oracle.cie.gdr.dao.rgy.SessionAction;
import com.oracle.cie.gdr.dao.rgy.SessionInfo;
import com.oracle.cie.gdr.dao.rgy.TargetInfo;
import com.oracle.cie.gdr.deinstallation.DeInstallationSession;
import com.oracle.cie.gdr.deinstallation.PatchComponentArchiveDeInstaller;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.LocaleInfoHelper;
import com.oracle.cie.gdr.helpers.PlatformInfoHelper;
import com.oracle.cie.gdr.helpers.RegenerationHelper;
import com.oracle.cie.gdr.helpers.RegistryHelper;
import com.oracle.cie.gdr.installation.PatchComponentArchiveInstallationSession;
import com.oracle.cie.gdr.installation.PatchComponentArchiveInstaller;
import com.oracle.cie.gdr.installation.ReferenceCounter;
import com.oracle.cie.gdr.nio.NioCopy;
import com.oracle.cie.gdr.nio.NioDelete;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.orchestration.InstallActionException;
import com.oracle.cie.gdr.orchestration.InstallActionFactory;
import com.oracle.cie.gdr.orchestration.InstallActionHelper;
import com.oracle.cie.gdr.patch.FeatureSetMetaDataPatchHandler;
import com.oracle.cie.gdr.patch.HomeOperationsImpl;
import com.oracle.cie.gdr.patch.InternalPatchHandler;
import com.oracle.cie.gdr.patch.PatchHandlerImpl;
import com.oracle.cie.gdr.patch.SharedPatchMetaDataHandler;
import com.oracle.cie.gdr.selection.Status;
import com.oracle.cie.gdr.services.PatchTrackerService;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.gdr.utils.PatchScriptHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.ComponentCheckResult;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchCheckResults;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.Result;
import oracle.glcm.opatch.common.api.install.InventoryComponentInfo;

public class ComponentMetaDataPatchHandler
extends SharedPatchMetaDataHandler<ComponentInfo> {
    private static final Logger _log = Logger.getLogger(ComponentMetaDataPatchHandler.class.getName());
    private ComponentHelper _componentHelper;
    private PatchCheckResults _patchCheckResults;
    private List<Path> _affectedFilePaths;
    private Map<Reference, Component> _componentMap = new HashMap<Reference, Component>();
    private Map<Path, Reference> _componentRefMap = new HashMap<Path, Reference>();
    private Map<FeatureSet, Set<Component>> _featureSetMap = new HashMap<FeatureSet, Set<Component>>();
    private Map<ComponentReference, Map<Path, Path>> _overwrittenFilesMap = new HashMap<ComponentReference, Map<Path, Path>>();

    public ComponentMetaDataPatchHandler(InternalPatchHandler patchHandler, Patch patch, PatchCheckResults patchCheckResults, List<Path> affectedFilePaths) {
        super(patchHandler, patch);
        this._componentHelper = ComponentHelper.getInstance(patchHandler.getHome().getClassLoader());
        this._patchCheckResults = patchCheckResults;
        this._affectedFilePaths = affectedFilePaths;
    }

    public PatchCheckResults getPatchCheckResults() {
        return this._patchCheckResults;
    }

    public void setPatchCheckResults(PatchCheckResults patchCheckResults) {
        this._patchCheckResults = patchCheckResults;
    }

    public List<Path> getAffectedFilePaths() {
        return this._affectedFilePaths;
    }

    public void setAffectedFilePaths(List<Path> affectedFilePaths) {
        this._affectedFilePaths = affectedFilePaths;
    }

    @Override
    public void applyUpgradePatches() throws GdrException, IOException, DataHandlerException {
        List<PatchInventory.Component> patchComponents = ComponentMetaDataPatchHandler.getProcessedPatchComponents(this.getPatch(), this.getPatchCheckResults(), this.getPatchHandler().getHome());
        if (patchComponents != null && !patchComponents.isEmpty()) {
            List<PatchInventory.Component> list;
            List<InventoryComponentInfo> list2;
            MetaDataHome metaDataHome = this.getPatchHandler().getHome().getMetaDataHome();
            HashSet<Component> upgradeComponents = new HashSet<Component>();
            HashSet<Component> installComponents = new HashSet<Component>();
            HashSet<Component> deinstallComponents = new HashSet<Component>();
            for (PatchInventory.Component component : patchComponents) {
                Path patchCompDefFile;
                if ("oracle.nextgen.metadata".equals(component.getName()) || !Files.exists(patchCompDefFile = this._componentHelper.getComponentArchiveDir(metaDataHome.getGdrMetaDataHomePath(), component.getName(), component.getVersion()).resolve("upgrades").resolve(this.getPatch().getPatchUpi()).resolve(ComponentHelper.getComponentDefFileName()), new LinkOption[0])) continue;
                upgradeComponents.add(this._componentHelper.getRootWrapper(patchCompDefFile));
            }
            ArrayList<ComponentInfo> allComponentInfos = null;
            if (!upgradeComponents.isEmpty()) {
                allComponentInfos = new ArrayList<ComponentInfo>(this.getRegistryHelper().getComponentInfos(this.getPatchHandler().getLockedRegistry().getDistributions()));
                for (Component upgradeComponent : upgradeComponents) {
                    Map<SessionInfo, ComponentInfo> updatedComponentInfos;
                    List<ComponentInfo> matchingInfos = this.getMatchingInstalledRegistryInfos(allComponentInfos, upgradeComponent.getName(), upgradeComponent.getVersion().replace(".", "\\."));
                    if (matchingInfos.isEmpty() || (updatedComponentInfos = this.applyPatchRegistryInfo(matchingInfos, upgradeComponent.getVersion(), upgradeComponent.getPatchLevel())).isEmpty()) continue;
                    for (Map.Entry<SessionInfo, ComponentInfo> entry : updatedComponentInfos.entrySet()) {
                        String patchLevel = upgradeComponent.getPatchLevel();
                        String previousPatchLevel = entry.getValue().getPatchLevel();
                        if (!StringUtil.isNullOrEmpty((String)previousPatchLevel, (boolean)true)) {
                            entry.getKey().setPreviousPatchLevel(previousPatchLevel);
                        }
                        entry.getValue().setPatchLevel(patchLevel);
                        entry.getKey().setPatchLevel(patchLevel);
                    }
                    Path componentVersionDir = this._componentHelper.getComponentArchiveDir(metaDataHome.getGdrMetaDataHomePath(), upgradeComponent.getName(), upgradeComponent.getVersion());
                    Path upgradeCompDefFile = ComponentMetaDataPatchHandler.getUpgradeCompDefFile(componentVersionDir, null);
                    Path origCompDefFile = Files.exists(upgradeCompDefFile, new LinkOption[0]) ? upgradeCompDefFile : componentVersionDir.resolve(ComponentHelper.getComponentDefFileName());
                    Component previousCompDef = this._componentHelper.getRootWrapper(origCompDefFile);
                    List<FileMap> fileMaps = previousCompDef.getFileMaps();
                    List<Path> affectedFilePaths = this.getAffectedFilePaths();
                    if (affectedFilePaths != null) {
                        ArrayList<FileTarget> deletedFiles = new ArrayList<FileTarget>();
                        Collection<ComponentTarget> componentTargets = ComponentMetaDataPatchHandler.getComponentTargets(this.getPatchHandler().getHome(), previousCompDef);
                        for (ComponentTarget compTarget : componentTargets) {
                            for (FileTarget fileTarget : compTarget.getFileTargets()) {
                                Path destFile = NioHelper.getInstance().getPath(this.getPatchHandler().getHome().getHome() + File.separator + fileTarget.getDest(), new String[0]);
                                if (Files.exists(destFile, new LinkOption[0]) || !affectedFilePaths.contains(destFile)) continue;
                                deletedFiles.add(fileTarget);
                            }
                        }
                        for (FileMap filemap : fileMaps) {
                            for (com.oracle.cie.gdr.dao.cpd.File file : filemap.getFiles()) {
                                String string = file.getDest();
                            }
                        }
                    }
                    fileMaps.addAll(upgradeComponent.getFileMaps());
                    upgradeComponent.setFileMaps(fileMaps);
                    Path componentPatchDir = componentVersionDir.resolve("patches");
                    Path mergedCompDefFile = componentPatchDir.resolve(ComponentHelper.getComponentDefFileName());
                    this._componentHelper.save((IDataHandlerWrapper)upgradeComponent, mergedCompDefFile);
                    this._componentHelper.save((IDataHandlerWrapper)upgradeComponent, upgradeCompDefFile);
                    this._componentHelper.save((IDataHandlerWrapper)upgradeComponent, ComponentMetaDataPatchHandler.getUpgradeCompDefFile(componentVersionDir, this.getPatch().getPatchUpi()));
                }
            }
            if (this.getPatch() instanceof HomeOperationsImpl.PatchInfoWrapper && (list2 = ((HomeOperationsImpl.PatchInfoWrapper)this.getPatch()).getInventoryComponents()) != null) {
                for (InventoryComponentInfo inventoryComp : list2) {
                    if (inventoryComp.getComponentCheckResult() == null || !inventoryComp.getComponentCheckResult().getResult().isProcessComponent()) continue;
                    if (inventoryComp.getAction().isAdd()) {
                        installComponents.add(this._componentMap.get((Object)new QuickReference(inventoryComp.getName(), inventoryComp.getVersion())));
                        continue;
                    }
                    if (!inventoryComp.getAction().isRemove()) continue;
                    deinstallComponents.add(this._componentMap.get((Object)new QuickReference(inventoryComp.getName(), inventoryComp.getVersion())));
                }
            }
            if (!deinstallComponents.isEmpty()) {
                this.performComponentDeinstallation(deinstallComponents);
            }
            if (!installComponents.isEmpty()) {
                this.performComponentInstallation(installComponents);
            }
            if ((list = ComponentMetaDataPatchHandler.getResultFilteredPatchComponents(Result.PROCESSING_NOT_REQUIRED, this.getPatch(), this.getPatchCheckResults(), this.getPatchHandler().getHome(), false)) != null && !list.isEmpty()) {
                for (PatchInventory.Component patchComponent : patchComponents) {
                    if ("oracle.nextgen.metadata".equals(patchComponent.getName())) continue;
                    if (allComponentInfos == null) {
                        allComponentInfos = new ArrayList<ComponentInfo>(this.getRegistryHelper().getComponentInfos(this.getPatchHandler().getLockedRegistry().getDistributions()));
                    }
                    List<ComponentInfo> matchingInfos = this.getMatchingInstalledRegistryInfos(allComponentInfos, patchComponent.getName(), patchComponent.getVersion().replace(".", "\\."));
                    this.applyPatchRegistryInfo(matchingInfos, patchComponent.getVersion(), patchComponent.getPatchLevel(), true);
                }
            }
        }
    }

    @Override
    protected int compareVersions(ComponentInfo registryInfo, String versionB, String patchLevelB) {
        return this.compareVersions(registryInfo.getVersion(), registryInfo.getPatchLevel(), versionB, patchLevelB);
    }

    @Override
    public void rollbackUpgradePatches() throws GdrException, IOException, DataHandlerException {
        List<ComponentInfo> componentInfosForPatch = this.getRegistryHelper().getComponentInfosForPatch(this.getPatchHandler().getLockedRegistry(), this.getPatch().getPatchUpi(), true);
        List<SharedPatchMetaDataHandler.RolledBackRegistryInfo> rolledBack = this.rollbackPatchRegistryInfo(componentInfosForPatch);
        if (!rolledBack.isEmpty()) {
            for (SharedPatchMetaDataHandler.RolledBackRegistryInfo info : rolledBack) {
                Path previousUpgradeCompDefFile;
                ComponentInfo componentInfo = (ComponentInfo)info.getRegistryInfo();
                SessionInfo previousUpgrade = null;
                String previousPatchId = null;
                List<SessionInfo> previousUpgrades = this.getRegistryHelper().filterSessionInfos(componentInfo.getSortedSessions(), SessionAction.upgrade);
                if (!previousUpgrades.isEmpty()) {
                    previousUpgrade = previousUpgrades.get(previousUpgrades.size() - 1);
                    previousPatchId = previousUpgrade.getOriginatingPatchId();
                }
                componentInfo.setPatchLevel(previousUpgrade != null ? previousUpgrade.getPatchLevel() : null);
                Path componentVersionDir = this._componentHelper.getComponentArchiveDir(this.getPatchHandler().getHome().getMetaDataHome().getGdrMetaDataHomePath(), componentInfo.getName(), componentInfo.getVersion());
                Path componentPatchDir = componentVersionDir.resolve("patches");
                Path mergedCompDefFile = componentPatchDir.resolve(ComponentHelper.getComponentDefFileName());
                Files.deleteIfExists(mergedCompDefFile);
                Path upgradeCompDefFile = ComponentMetaDataPatchHandler.getUpgradeCompDefFile(componentVersionDir, null);
                Files.deleteIfExists(upgradeCompDefFile);
                Files.deleteIfExists(ComponentMetaDataPatchHandler.getUpgradeCompDefFile(componentVersionDir, this.getPatch().getPatchUpi()));
                if (StringUtil.isNullOrEmpty((String)previousPatchId, (boolean)true) || !Files.exists(previousUpgradeCompDefFile = ComponentMetaDataPatchHandler.getUpgradeCompDefFile(componentVersionDir, previousPatchId), new LinkOption[0])) continue;
                NioCopy.copyFile((Path)previousUpgradeCompDefFile, (Path)mergedCompDefFile);
                NioCopy.copyFile((Path)previousUpgradeCompDefFile, (Path)upgradeCompDefFile);
            }
        }
    }

    private static Path getUpgradeCompDefFile(Path componentVersionDir, String patchId) {
        String name = (!StringUtil.isNullOrEmpty((String)patchId, (boolean)true) ? patchId + "-" : "") + "upgrade-" + ComponentHelper.getComponentDefFileName();
        return componentVersionDir.resolve(name);
    }

    public static Map<String, Set<Component>> processComponentUpdatePatches(InternalPatchHandler patchHandler) throws GdrException, IOException, DataHandlerException {
        ComponentHelper componentHelper = ComponentHelper.getInstance(patchHandler.getHome().getClassLoader());
        LinkedHashMap<String, Collection<Component>> notAppliedPatchComponents = new LinkedHashMap<String, Collection<Component>>();
        LinkedHashSet<String> removedPatches = new LinkedHashSet<String>();
        LinkedHashMap<String, Set<Component>> affectedComponents = new LinkedHashMap<String, Set<Component>>();
        Path componentsDir = patchHandler.getHome().getMetaDataHome().getComponentMetaDataHomePath().resolve(componentHelper.getShipHomePath());
        if (Files.exists(componentsDir, new LinkOption[0])) {
            try (DirectoryStream<Path> componentNameDirs = Files.newDirectoryStream(componentsDir, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path entry) throws IOException {
                    return Files.isDirectory(entry, new LinkOption[0]);
                }
            });){
                for (Path componentNameDir : componentNameDirs) {
                    DirectoryStream<Path> componentVersionDirs = Files.newDirectoryStream(componentNameDir, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                        @Override
                        public boolean accept(Path entry) throws IOException {
                            return Files.isDirectory(entry, new LinkOption[0]);
                        }
                    });
                    try {
                        for (Path componentVersionDir : componentVersionDirs) {
                            PatchTrackerService tracker;
                            Path componentPatchDir = componentVersionDir.resolve("patches");
                            if (!Files.exists(componentPatchDir, new LinkOption[0]) || !(tracker = PatchTrackerService.getPatchApplicationTrackerService(componentPatchDir)).statusChanged()) continue;
                            LinkedHashMap<String, PatchTrackerService.PatchStatus> originalPatchStatuses = new LinkedHashMap<String, PatchTrackerService.PatchStatus>(tracker.getPatchStatuses());
                            Path mergedCompDefFile = componentPatchDir.resolve(ComponentHelper.getComponentDefFileName());
                            Path upgradeCompDefFile = ComponentMetaDataPatchHandler.getUpgradeCompDefFile(componentVersionDir, null);
                            Path origCompDefFile = Files.exists(upgradeCompDefFile, new LinkOption[0]) ? upgradeCompDefFile : componentVersionDir.resolve(ComponentHelper.getComponentDefFileName());
                            Component originalCompDef = componentHelper.getRootWrapper(origCompDefFile);
                            tracker.resetStatuses();
                            Files.deleteIfExists(mergedCompDefFile);
                            if (Files.exists(mergedCompDefFile, new LinkOption[0])) {
                                throw new IOException("Unable to delete patched component definition cache xml file " + mergedCompDefFile);
                            }
                            ArrayList<Path> xmlDiffs = new ArrayList<Path>();
                            LinkedHashMap<String, Path> patchCompDefFiles = new LinkedHashMap<String, Path>();
                            Set<String> patchIds = tracker.getPatchIds();
                            for (String patchId : patchIds) {
                                if (!tracker.isPatchRemoved(patchId)) {
                                    Path patchIdDir = tracker.getPatchIdDirPath(patchId);
                                    if (!Files.exists(patchIdDir, new LinkOption[0])) continue;
                                    try (DirectoryStream<Path> xmlDiffFiles = Files.newDirectoryStream(patchIdDir, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                                        @Override
                                        public boolean accept(Path pathname) throws IOException {
                                            return Files.isRegularFile(pathname, new LinkOption[0]) && pathname.getFileName().toString().endsWith(".xdiff");
                                        }
                                    });){
                                        for (Path xmlDiffFile : xmlDiffFiles) {
                                            xmlDiffs.add(xmlDiffFile);
                                        }
                                    }
                                    Path patchCompDef = patchIdDir.resolve(ComponentHelper.getComponentDefFileName());
                                    if (!Files.exists(patchCompDef, new LinkOption[0])) continue;
                                    patchCompDefFiles.put(patchId, patchCompDef);
                                    continue;
                                }
                                removedPatches.add(patchId);
                            }
                            if (!xmlDiffs.isEmpty()) {
                                XmlDiffTree[] xmlDiffTrees = new XmlDiffTree[xmlDiffs.size()];
                                int x = 0;
                                for (Path xmlDiffFile : xmlDiffs) {
                                    InputStream is = Files.newInputStream(xmlDiffFile, new OpenOption[0]);
                                    try {
                                        xmlDiffTrees[x] = XmlDiffTree.load((InputStream)is, (ClassLoader)patchHandler.getHome().getClassLoader());
                                        ++x;
                                    }
                                    finally {
                                        if (is == null) continue;
                                        is.close();
                                    }
                                }
                                try {
                                    XmlDiffTree mergedDiffTree;
                                    XmlDiffTree xmlDiffTree = mergedDiffTree = xmlDiffTrees.length == 1 ? xmlDiffTrees[0] : XmlDiffTree.merge((XmlDiffTree[])xmlDiffTrees);
                                    if (_log.isLoggable(Level.FINEST)) {
                                        _log.finest("Applying merged diff tree to " + originalCompDef + " component : " + mergedDiffTree);
                                    }
                                    XmlDiffTreeFilter xmldiffTreeFilter = null;
                                    try {
                                        xmldiffTreeFilter = componentHelper.getDefaultXmlDiffTreeFilter(null);
                                    }
                                    catch (GdrException e) {
                                        _log.log(Level.WARNING, e.getMessage(), e);
                                    }
                                    XmlDiffApplicator xmlDiff = new XmlDiffApplicator((XmlDiffAspect)originalCompDef.getDataHandler(), mergedDiffTree, xmldiffTreeFilter);
                                    xmlDiff.setTolerateMissingElements(true);
                                    xmlDiff.apply();
                                }
                                catch (XmlDiffException e) {
                                    throw new GdrException("Failed to apply xml diff to component definition " + origCompDefFile, (Throwable)e);
                                }
                                componentHelper.save((IDataHandlerWrapper)originalCompDef, mergedCompDefFile);
                            }
                            Component mergedCompDef = null;
                            if (!patchCompDefFiles.isEmpty()) {
                                ArrayList<FileMap> patchFileMaps = new ArrayList<FileMap>();
                                for (Map.Entry entry : patchCompDefFiles.entrySet()) {
                                    String patchId = (String)entry.getKey();
                                    Path patchCompDefFile = (Path)entry.getValue();
                                    Component patchCompDef = componentHelper.getRootWrapper(patchCompDefFile);
                                    patchFileMaps.addAll(patchCompDef.getFileMaps());
                                    if (!((PatchTrackerService.PatchStatus)((Object)originalPatchStatuses.get(patchId))).isNotApplied()) continue;
                                    ArrayList<Component> components = (ArrayList<Component>)notAppliedPatchComponents.get(patchId);
                                    if (components == null) {
                                        components = new ArrayList<Component>();
                                        notAppliedPatchComponents.put(patchId, components);
                                    }
                                    components.add(patchCompDef);
                                }
                                if (!patchFileMaps.isEmpty()) {
                                    mergedCompDef = Files.exists(mergedCompDefFile, new LinkOption[0]) ? componentHelper.getRootWrapper(mergedCompDefFile) : componentHelper.getRootWrapper(origCompDefFile);
                                    List<FileMap> mergedFileMaps = mergedCompDef.getFileMaps();
                                    mergedFileMaps.addAll(patchFileMaps);
                                    mergedCompDef.setFileMaps(mergedFileMaps);
                                    componentHelper.save((IDataHandlerWrapper)mergedCompDef, mergedCompDefFile);
                                }
                            }
                            for (Map.Entry entry : originalPatchStatuses.entrySet()) {
                                if (((PatchTrackerService.PatchStatus)((Object)entry.getValue())).isApplied()) continue;
                                String patchId = (String)entry.getKey();
                                LinkedHashSet<Component> affected = (LinkedHashSet<Component>)affectedComponents.get(patchId);
                                if (affected == null) {
                                    affected = new LinkedHashSet<Component>();
                                    affectedComponents.put((String)entry.getKey(), (Set<Component>)affected);
                                }
                                if (mergedCompDef != null) {
                                    affected.add(mergedCompDef);
                                    continue;
                                }
                                affected.add(originalCompDef);
                            }
                            tracker.patchesApplied();
                        }
                    }
                    finally {
                        if (componentVersionDirs == null) continue;
                        componentVersionDirs.close();
                    }
                }
            }
        }
        ComponentMetaDataPatchHandler.processReplacementInUsePatches(patchHandler, notAppliedPatchComponents, removedPatches);
        return affectedComponents;
    }

    public static void processReplacementInUsePatches(InternalPatchHandler patchHandler, Map<String, Collection<Component>> appliedPatches, Set<String> removedPatches) throws GdrException, IOException {
        if (appliedPatches != null && !appliedPatches.isEmpty()) {
            for (Map.Entry entry : appliedPatches.entrySet()) {
                String patchId = (String)entry.getKey();
                ArrayList<FileTarget> filesTargets = new ArrayList<FileTarget>();
                for (Component component : (Collection)entry.getValue()) {
                    Collection<ComponentTarget> componentTargets = ComponentMetaDataPatchHandler.getComponentTargets(patchHandler.getHome(), component);
                    if (componentTargets == null) continue;
                    for (ComponentTarget componentTarget : componentTargets) {
                        if (!componentTarget.getComponentFileMap().isPatch() || !componentTarget.getComponentFileMap().getPatch().equals(patchId)) continue;
                        List<FileTarget> fileTargets = componentTarget.getFileTargets();
                        for (FileTarget fileTarget : fileTargets) {
                            Strategy strategy;
                            if (!fileTarget.isFile() || (strategy = Strategy.getStrategy(fileTarget.getAction())) == null || !strategy.isReplacementInUse()) continue;
                            filesTargets.add(fileTarget);
                        }
                    }
                }
                if (filesTargets.isEmpty()) continue;
                PatchScriptHandler patchScriptGenerator = new PatchScriptHandler(patchHandler.getHome().getHome(), patchId);
                patchScriptGenerator.generate(filesTargets);
                patchScriptGenerator.registerApplyScript();
            }
        }
        if (removedPatches != null && !removedPatches.isEmpty()) {
            for (String string : removedPatches) {
                PatchScriptHandler patchScriptGenerator = new PatchScriptHandler(patchHandler.getHome().getHome(), string);
                if (!patchScriptGenerator.getRemoveScript().exists()) continue;
                patchScriptGenerator.registerRemoveScript();
            }
        }
    }

    public static Map<String, Set<Component>> removeComponentUpdatePatch(InternalPatchHandler patchHandler, String patchId) throws GdrException, IOException, DataHandlerException {
        HashSet<String> patchIDs = new HashSet<String>(Arrays.asList(patchId));
        return ComponentMetaDataPatchHandler.removeComponentUpdatePatch(patchHandler, patchIDs, false);
    }

    public static Map<String, Set<Component>> removeComponentUpdatePatch(InternalPatchHandler patchHandler, Set<String> patchIds, boolean backupFiles) throws GdrException, IOException, DataHandlerException {
        if (patchIds == null || patchIds.isEmpty()) {
            GdrException ex = new GdrException("The patch ids specified were null or empty.");
            _log.throwing(PatchHandlerImpl.class.getName(), "removeComponentUpdatePatch", ex);
            throw ex;
        }
        boolean patchRemoved = false;
        Path componentsDir = patchHandler.getHome().getMetaDataHome().getComponentMetaDataHomePath().resolve(ComponentHelper.getInstance(patchHandler.getHome().getClassLoader()).getShipHomePath());
        if (Files.exists(componentsDir, new LinkOption[0])) {
            try (DirectoryStream<Path> componentNameDirs = Files.newDirectoryStream(componentsDir, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path entry) throws IOException {
                    return Files.isDirectory(entry, new LinkOption[0]);
                }
            });){
                for (Path componentNameDir : componentNameDirs) {
                    DirectoryStream<Path> componentVersionDirs = Files.newDirectoryStream(componentNameDir, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                        @Override
                        public boolean accept(Path entry) throws IOException {
                            return Files.isDirectory(entry, new LinkOption[0]);
                        }
                    });
                    try {
                        for (Path componentVersionDir : componentVersionDirs) {
                            Path componentPatchDir = componentVersionDir.resolve("patches");
                            if (!Files.exists(componentPatchDir, new LinkOption[0])) continue;
                            for (String patchId : patchIds) {
                                if (StringUtil.isNullOrEmpty((String)patchId, (boolean)true)) {
                                    GdrException ex = new GdrException("One of the patch ids specified was null or empty.");
                                    _log.throwing(PatchHandlerImpl.class.getName(), "removeComponentUpdatePatch", ex);
                                    throw ex;
                                }
                                Path patchDir = componentPatchDir.resolve(patchId);
                                if (!Files.exists(patchDir, new LinkOption[0])) continue;
                                if (backupFiles) {
                                    try (DirectoryStream<Path> metadataPatchFiles = Files.newDirectoryStream(patchDir, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                                        @Override
                                        public boolean accept(Path entry) throws IOException {
                                            return Files.isRegularFile(entry, new LinkOption[0]);
                                        }
                                    });){
                                        Path rollbackDir = componentVersionDir.resolve("rollback");
                                        for (Path metadataPatchFile : metadataPatchFiles) {
                                            RegenerationHelper.getInstance().backupRollbackPath(metadataPatchFile, rollbackDir);
                                        }
                                    }
                                }
                                NioDelete.delete((Path)patchDir);
                                patchRemoved = true;
                            }
                        }
                    }
                    finally {
                        if (componentVersionDirs == null) continue;
                        componentVersionDirs.close();
                    }
                }
            }
        }
        if (patchRemoved) {
            return ComponentMetaDataPatchHandler.processComponentUpdatePatches(patchHandler);
        }
        return null;
    }

    public static Collection<ComponentTarget> getComponentTargets(Home home, Component component) throws GdrException {
        Collection<DistributionTarget> distributionTargets;
        Collection<ComponentTarget> componentTargets = component.getComponentTargets();
        if (componentTargets == null && (distributionTargets = home.getInstalledDistributions(new ComponentReference(component.getName(), component.getVersion()))) != null && !distributionTargets.isEmpty()) {
            ArrayList<DirectoryMap> directoryMaps = new ArrayList<DirectoryMap>();
            for (DistributionTarget distributionTarget : distributionTargets) {
                directoryMaps.add(distributionTarget.getDirectoryMap());
            }
            DirectoryMap directoryMap = DistributionHelper.getInstance(home.getClassLoader()).mergeDirectoryMaps(directoryMaps);
            componentTargets = FeatureSetHelper.getInstance(home.getClassLoader()).getComponentTargets(Mode.DEINSTALL, component, directoryMap, new ServiceHolder(), null);
            component.setComponentTargets(componentTargets);
        }
        return componentTargets;
    }

    public static List<PatchInventory.Component> getProcessedPatchComponents(Patch patch, PatchCheckResults patchCheckResults, Home home) {
        return ComponentMetaDataPatchHandler.getResultFilteredPatchComponents(Result.PROCESS_COMPONENT, patch, patchCheckResults, home, true);
    }

    public static List<PatchInventory.Component> getResultFilteredPatchComponents(Result resultFilter, Patch patch, PatchCheckResults patchCheckResults, Home home, boolean useInstalledAsBackup) {
        List<PatchInventory.Component> patchComponents;
        block3: {
            block2: {
                patchComponents = null;
                if (patchCheckResults == null) break block2;
                patchComponents = new ArrayList();
                Set processComponents = patchCheckResults.getComponentCheckResults(new Result[]{resultFilter});
                for (ComponentCheckResult result : processComponents) {
                    patchComponents.add(result.getComponent());
                }
                break block3;
            }
            if (!useInstalledAsBackup) break block3;
            patchComponents = patch.getComponents();
            Set<ComponentReference> installedComponents = home.getInstalledComponents();
            Iterator it = patchComponents.iterator();
            while (it.hasNext()) {
                PatchInventory.Component patchComponent = (PatchInventory.Component)it.next();
                if (installedComponents.contains((Object)new ComponentReference(patchComponent.getName(), patchComponent.getVersion()))) continue;
                it.remove();
            }
        }
        return patchComponents != null ? patchComponents : new ArrayList();
    }

    public static boolean applyUpdatePatchRegistryEntries(InternalPatchHandler patchHandler, Patch patch, PatchCheckResults patchCheckResults) throws GdrException {
        boolean registryModified = false;
        List<PatchInventory.Component> patchComponents = ComponentMetaDataPatchHandler.getProcessedPatchComponents(patch, patchCheckResults, patchHandler.getHome());
        if (patchComponents != null && !patchComponents.isEmpty()) {
            registryModified = true;
            RegistryHelper registryHelper = RegistryHelper.getInstance(patchHandler.getHome().getClassLoader());
            ArrayList<ComponentInfo> allComponentInfos = new ArrayList<ComponentInfo>(registryHelper.getComponentInfos(patchHandler.getLockedRegistry().getDistributions()));
            for (PatchInventory.Component patchComponent : patchComponents) {
                List<ComponentInfo> componentInfos = registryHelper.getComponentInfos(allComponentInfos, patchComponent.getName(), patchComponent.getVersion(), false);
                for (ComponentInfo componentInfo : componentInfos) {
                    SessionInfo sessionInfo = patchHandler.getRegistrySession(SessionAction.patch).copy();
                    sessionInfo.addPatchId(patch.getPatchUpi());
                    sessionInfo.setVersion(patchComponent.getVersion());
                    String patchLevel = patchComponent.getPatchLevel();
                    if (!StringUtil.isNullOrEmpty((String)patchLevel, (boolean)true)) {
                        sessionInfo.setPatchLevel(patchLevel);
                    }
                    componentInfo.addSession(sessionInfo, false);
                    List<PatchInfo> pinfos = componentInfo.getPatches();
                    PatchInfo patchInfo = registryHelper.getPatchInfo(pinfos, patch.getPatchId());
                    if (null != patchInfo) continue;
                    patchInfo = new PatchInfo(patchHandler.getHome().getClassLoader(), patch.getPatchId());
                    patchInfo.setStatus(Status.installed);
                    patchInfo.setInstallDate(Calendar.getInstance());
                    patchInfo.addSession(sessionInfo);
                    componentInfo.addPatch(patchInfo);
                }
            }
        }
        return registryModified;
    }

    public static boolean rollbackUpdatePatchRegistryEntries(InternalPatchHandler patchHandler, Patch patch) throws GdrException {
        boolean registryModified = false;
        RegistryHelper registryHelper = RegistryHelper.getInstance(patchHandler.getHome().getClassLoader());
        List<ComponentInfo> patchComponentInfos = registryHelper.getComponentInfosForPatch(patchHandler.getLockedRegistry(), patch.getPatchUpi());
        if (patchComponentInfos != null && !patchComponentInfos.isEmpty()) {
            registryModified = true;
            for (ComponentInfo componentInfo : patchComponentInfos) {
                List<SessionInfo> sessionInfos = componentInfo.getSessions();
                int originalSize = sessionInfos.size();
                Iterator<SessionInfo> it = sessionInfos.iterator();
                while (it.hasNext()) {
                    SessionInfo sessionInfo = it.next();
                    if (sessionInfo.getAction() != SessionAction.patch || !sessionInfo.getPatchIdsSet().contains(patch.getPatchUpi())) continue;
                    it.remove();
                }
                if (originalSize == sessionInfos.size()) continue;
                componentInfo.setSessions(sessionInfos);
            }
        }
        return registryModified;
    }

    public static Map<Reference, Component> loadCurrentComponents(InternalPatchHandler patchHandler, PatchCheckResults patchCheckResults) throws GdrException {
        HashMap<Reference, Component> patchedComponents = new HashMap<Reference, Component>();
        Set processedComponents = patchCheckResults.getComponentCheckResults(new Result[]{Result.PROCESS_COMPONENT});
        if (!processedComponents.isEmpty()) {
            ComponentHelper componentHelper = ComponentHelper.getInstance(patchHandler.getHome().getClassLoader());
            Path metaDataDir = patchHandler.getHome().getMetaDataHome().getGdrMetaDataHomePath();
            for (ComponentCheckResult componentCheckResult : processedComponents) {
                PatchInventory.Component patchComponent = componentCheckResult.getComponent();
                QuickReference quickRef = new QuickReference(patchComponent.getName(), patchComponent.getVersion());
                try {
                    Component component = componentHelper.getComponentArchiveFromShipHome(metaDataDir, (Reference)quickRef);
                    patchedComponents.put(quickRef, component);
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Failed to load component: " + (Object)((Object)quickRef), e);
                }
            }
        }
        return patchedComponents;
    }

    private void performComponentInstallation(Set<Component> components) throws GdrException, DataHandlerException, IOException {
        Set platforms = PlatformInfoHelper.getInstance().getPlatformIds("ALL_PLATFORMS");
        String selectedLocales = System.getProperty("SELECTED_LANGUAGES");
        if (selectedLocales != null && !selectedLocales.isEmpty()) {
            selectedLocales = selectedLocales.substring(1, selectedLocales.length() - 1);
            selectedLocales = selectedLocales + ",en";
        } else {
            selectedLocales = "en";
        }
        HashSet<String> langsSet = new HashSet<String>();
        for (Locale locale : LocaleInfoHelper.getInstance().getLocaleSetFromStr(selectedLocales)) {
            langsSet.add(locale.toString());
        }
        Set<Integer> locales = LocaleInfoHelper.getInstance().getLocaleIds(langsSet).keySet();
        HashMap<String, String> variableMap = new HashMap<String, String>();
        for (Component component : components) {
            if (this.getPatchHandler().getHome().isComponentInstalled(component.getName(), component.getVersion())) {
                ArrayList<ComponentInfo> allComponentInfos = new ArrayList<ComponentInfo>(this.getRegistryHelper().getComponentInfos(this.getPatchHandler().getLockedRegistry().getDistributions()));
                List<ComponentInfo> matchingInfos = this.getMatchingInstalledRegistryInfos(allComponentInfos, component.getName(), component.getVersion().replace(".", "\\."));
                this.applyPatchRegistryInfo(matchingInfos, component.getVersion(), component.getPatchLevel(), true);
                continue;
            }
            MetaDataHome metaDataHome = new MetaDataHome(component.getArchiveLocationPath(), false, true);
            Reference patchMetaDataRef = this._componentRefMap.get(component.getArchiveLocationPath());
            HashSet<Reference> componentRefs = new HashSet<Reference>();
            componentRefs.add(patchMetaDataRef);
            HashMap<FeatureSet, Set<Component>> featureSetMap = new HashMap<FeatureSet, Set<Component>>();
            for (FeatureSet featureSet : this._featureSetMap.keySet()) {
                Set<Component> featureComponents = this._featureSetMap.get(featureSet);
                if (components == null || components.isEmpty()) continue;
                for (Component comp : featureComponents) {
                    if (!comp.getName().equals(component.getName()) || !comp.getVersion().equals(component.getVersion())) continue;
                    featureSetMap.put(featureSet, featureComponents);
                }
            }
            HashSet<Distribution> distributions = new HashSet<Distribution>();
            for (DistributionInfo distInfo : this.getPatchHandler().getLockedRegistry().getDistributions()) {
                if (!distInfo.getStatus().isInstalled()) continue;
                for (FeatureInfo fInfo : distInfo.getFeatures()) {
                    for (FeatureSet fs : featureSetMap.keySet()) {
                        if (!fInfo.getName().equals(fs.getName()) || !fInfo.getVersion().equals(fs.getVersion())) continue;
                        distributions.add(DistributionHelper.getInstance().getDistribution(this.getPatchHandler().getHome().getMetaDataHome(), distInfo.getName(), distInfo.getVersion()));
                    }
                }
            }
            if (distributions.isEmpty()) {
                for (DistributionInfo distInfo : this.getPatchHandler().getLockedRegistry().getDistributions()) {
                    if (!distInfo.getStatus().isInstalled()) continue;
                    distributions.add(DistributionHelper.getInstance().getDistribution(this.getPatchHandler().getHome().getMetaDataHome(), distInfo.getName(), distInfo.getVersion()));
                }
            }
            DirectoryMap directoryMap = DistributionHelper.getInstance().mergeDirectoryMaps(distributions, new DirectoryMap[0]);
            try {
                PatchComponentArchiveInstallationSession installerSession = new PatchComponentArchiveInstallationSession(metaDataHome, this.getPatchHandler().getHome(), componentRefs, directoryMap, platforms, locales, this._componentMap, featureSetMap, distributions);
                PatchComponentArchiveInstaller installer = new PatchComponentArchiveInstaller(installerSession, variableMap, this.getPatchHandler().getLockedRegistry(), this._patchCheckResults.getPatch().getPatchUpi(), this.getPatchHandler().getRegistrySession().copy());
                Reporting.addReporter((Reporter)new LoggingReporter(_log.getLevel() == null ? Level.ALL : _log.getLevel()));
                Reporting.stop((Reporter)Reporting.getDefaultReporter());
                InstallActionFactory.getPatchInstallActionManager(installer).getInstallActionExecutor().execute();
            }
            catch (DependencyException | InstallActionException | IOException e) {
                String message = "Patch ComponentArchive Installation for component: " + componentRefs + " failed.";
                _log.throwing(this.getClass().getName(), "performComponentInstallation(Set<Component>)", (Throwable)e);
                throw new GdrException(message, (Throwable)e);
            }
        }
    }

    private void performComponentDeinstallation(Set<Component> components) throws GdrException, IOException, DataHandlerException {
        for (Component component : components) {
            Reference patchMetaDataRef = this._componentRefMap.get(component.getCompDefLocationPath());
            this.deinstallComponent(patchMetaDataRef);
            ArrayList<ComponentInfo> allComponentInfos = new ArrayList<ComponentInfo>(this.getRegistryHelper().getAllComponentInfos(this.getPatchHandler().getLockedRegistry()));
            List<ComponentInfo> matchingInfos = this.getMatchingInstalledRegistryInfos(allComponentInfos, component.getName(), component.getVersion().replace(".", "\\."));
            this.applyPatchDeinstallRegistryInfo(matchingInfos);
        }
    }

    private void deinstallComponent(Reference componentReference) throws GdrException {
        HashSet<Reference> componentRefs = new HashSet<Reference>();
        componentRefs.add(componentReference);
        try {
            DeInstallationSession deInstallerSession = new DeInstallationSession(this.getPatchHandler().getHome().getHomePath());
            PatchComponentArchiveDeInstaller deinstaller = new PatchComponentArchiveDeInstaller(deInstallerSession, componentRefs, this.getPatchHandler().getLockedRegistry(), this._patchCheckResults.getPatch().getPatchUpi(), this.getPatchHandler().getRegistrySession().copy());
            Map<FeatureSet, Collection<Component>> componentMap = deinstaller.getComponentsMap();
            Set<FeatureSet> selectedFeatures = deinstaller.getSelectedFeatures();
            deinstaller.startDeInstall();
            for (FeatureSet feature : selectedFeatures) {
                Collection<Component> featureComponents = componentMap.get(feature);
                for (Component componentToDeinstall : featureComponents) {
                    if (deinstaller.startComponentDeInstall(componentToDeinstall)) {
                        InstallActionHelper.deInstallComponent(componentToDeinstall, deinstaller, this.getPatchHandler().getHome().getHomePath(), true);
                    }
                    deinstaller.completeComponentDeInstall(componentToDeinstall);
                }
            }
            deinstaller.completeDeInstall();
        }
        catch (DataHandlerException | IOException e) {
            throw new GdrException("Patch ComponentArchive DeInstallation for component: " + componentRefs + " failed.", e);
        }
    }

    private void applyPatchDeinstallRegistryInfo(List<ComponentInfo> matchingInfos) throws GdrException {
        for (ComponentInfo registryInfo : matchingInfos) {
            SessionInfo sessionInfo = null;
            List<SessionInfo> sessionInfos = this.getRegistryHelper().getSessionInfos(registryInfo, SessionAction.deinstall);
            for (SessionInfo sinfo : sessionInfos) {
                String version = sinfo.getVersion();
                String patchLevel = sinfo.getPatchLevel();
                String string = patchLevel = !StringUtil.isNullOrEmpty((String)patchLevel, (boolean)true) ? patchLevel.trim() : null;
                if (version == null || !version.equals(registryInfo.getVersion()) || !Objects.equals(registryInfo.getPatchLevel(), patchLevel)) continue;
                sessionInfo = sinfo;
            }
            if (sessionInfo != null && !sessionInfo.getPatchIdsSet().isEmpty()) {
                sessionInfo.addPatchId(this.getPatch().getPatchUpi());
                continue;
            }
            if (sessionInfo == null) {
                sessionInfo = this.getPatchHandler().getRegistrySession().copy();
                sessionInfo.setVersion(registryInfo.getVersion());
                sessionInfo.setOriginatingPatchId(this.getPatch().getPatchUpi());
                registryInfo.addSession(sessionInfo, false);
                registryInfo.setStatus(Status.notinstalled);
            }
            sessionInfo.setAction(SessionAction.deinstall);
            sessionInfo.addPatchId(this.getPatch().getPatchUpi());
            List<TargetInfo> tinfos = registryInfo.getTargets();
            if (tinfos == null || tinfos.isEmpty()) continue;
            for (TargetInfo tinfo : tinfos) {
                tinfo.setStatus(Status.notinstalled);
                tinfo.addSession(sessionInfo);
            }
        }
    }

    @Override
    protected void performInstallationRollback(ComponentInfo componentInfo) throws GdrException {
        this.deinstallComponent(new Reference(componentInfo.getName(), componentInfo.getVersion()));
        List<PatchInfo> patches = componentInfo.getPatches();
        PatchInfo patchToRemove = null;
        for (PatchInfo patchInfo : patches) {
            if (!patchInfo.getPatchId().equals(this.getPatch().getPatchId())) continue;
            patchToRemove = patchInfo;
        }
        if (patchToRemove != null) {
            patches.remove(patchToRemove);
        }
        componentInfo.setPatches(patches);
        for (TargetInfo target : componentInfo.getTargets()) {
            List<SessionInfo> targetSessionInfos = target.getSessions();
            SessionInfo targetSessionInfo = this.getRegistryHelper().getSessionInfoForPatch(targetSessionInfos, this.getPatch().getPatchUpi(), true);
            targetSessionInfos.remove((Object)targetSessionInfo);
            target.setSessions(targetSessionInfos);
            target.setStatus(Status.notinstalled);
        }
    }

    @Override
    protected void performDeinstallationRollback(ComponentInfo registryInfo) throws GdrException {
        for (TargetInfo target : registryInfo.getTargets()) {
            List<SessionInfo> targetSessionInfos = target.getSessions();
            SessionInfo targetSessionInfo = this.getRegistryHelper().getSessionInfoForPatch(targetSessionInfos, this.getPatch().getPatchUpi(), true);
            targetSessionInfos.remove((Object)targetSessionInfo);
            target.setSessions(targetSessionInfos);
            target.setStatus(Status.installed);
        }
        ReferenceCounter refCounter = ReferenceCounter.getReferenceCounter(this.getPatchHandler().getHome().getHomePath(), ReferenceCounter.RefType.components, registryInfo.getName(), registryInfo.getVersion());
        List<ComponentInfo> allRegistryInfos = this.getRegistryHelper().getAllComponentInfos(this.getPatchHandler().getLockedRegistry());
        List<ComponentInfo> matchingInstalledInfos = this.getMatchingInstalledRegistryInfos(allRegistryInfos, registryInfo.getName(), registryInfo.getVersion());
        if (!matchingInstalledInfos.isEmpty()) {
            for (ComponentInfo cinfo : matchingInstalledInfos) {
                refCounter.increment();
            }
        }
        ReferenceCounter.releaseReferenceCounter(refCounter);
        try {
            MetaDataHome metadataHome = this.getPatchHandler().getHome().getMetaDataHome();
            ComponentReference compRef = new ComponentReference(registryInfo.getName(), registryInfo.getVersion());
            compRef.setPatchLevel(registryInfo.getPatchLevel());
            Component comp = this._componentHelper.getComponent(metadataHome, compRef, Mode.INSTALL);
            HashSet<Component> modifiedComponents = new HashSet<Component>();
            modifiedComponents.add(comp);
            RegenerationHelper.getInstance().addModifiedComponents(modifiedComponents);
        }
        catch (DataHandlerException | IOException e) {
            throw new GdrException(e);
        }
    }

    @Override
    protected void analyzeUpgradePatches() throws GdrException, IOException, DataHandlerException {
        for (Map.Entry<Reference, Component> compEntry : this._componentMap.entrySet()) {
            boolean parentFeatureFound = false;
            FeatureSetMetaDataPatchHandler featurePatchHandler = ((PatchHandlerImpl)this.getPatchHandler()).getFeatureSetMetaDataPatchHandler();
            for (FeatureSet feature : featurePatchHandler.getLoadedFeatureSets()) {
                if (!feature.getComponentReferences().contains((Object)compEntry.getKey())) continue;
                this.addComponentToFeatureSetMap(feature, compEntry.getValue());
                parentFeatureFound = true;
            }
            if (parentFeatureFound) continue;
            Set<FeatureSet> installedFeatureSets = this.getPatchHandler().getHome().getInstalledFeatureSets(new ComponentReference(compEntry.getKey().getName(), compEntry.getKey().getVersion()));
            block2: for (FeatureSet installedFeature : installedFeatureSets) {
                for (FeatureSet patchFeature : featurePatchHandler.getLoadedFeatureSets()) {
                    if (!installedFeature.getName().equals(patchFeature.getName())) continue;
                    this.addComponentToFeatureSetMap(patchFeature, compEntry.getValue());
                    continue block2;
                }
            }
        }
    }

    private void addComponentToFeatureSetMap(FeatureSet feature, Component comp) {
        Set<Component> compSet = this._featureSetMap.get(feature);
        if (compSet == null) {
            compSet = new HashSet<Component>();
            this._featureSetMap.put(feature, compSet);
        }
        compSet.add(comp);
    }

    protected Component getPatchMetaDataComponent(MetaDataHome metaDataHome, Path carbPath) throws GdrException, IOException, DataHandlerException {
        Reference compRef = this._componentRefMap.get(carbPath);
        Component comp = null;
        if (compRef == null) {
            compRef = this.getReference(carbPath.getFileName().toString());
            comp = ComponentHelper.getInstance().getComponentArchiveFromPatch(metaDataHome, compRef, carbPath);
            this._componentRefMap.put(carbPath, compRef);
            this._componentMap.put(compRef, comp);
        } else {
            comp = this._componentMap.get((Object)compRef);
        }
        return comp;
    }

    protected Component getPatchMetaDataComponent(Path compDef) throws IOException, DataHandlerException {
        Reference compRef = this._componentRefMap.get(compDef);
        Component comp = null;
        if (compRef == null) {
            comp = ComponentHelper.getInstance().getRootWrapper(compDef);
            compRef = new QuickReference(comp.getName(), comp.getVersion());
            this._componentRefMap.put(compDef, compRef);
            this._componentMap.put(compRef, comp);
        } else {
            comp = this._componentMap.get((Object)compRef);
        }
        return comp;
    }

    protected Map<FeatureSet, Set<Component>> getFeatureSetMap() {
        return this._featureSetMap;
    }

    private Reference getReference(String fileName) throws GdrException {
        String[] compNameParts = fileName.split("-");
        if (compNameParts.length >= 2) {
            String name = compNameParts[0];
            String version = compNameParts[1];
            int extensionIndex = version.indexOf("carb");
            if (extensionIndex > -1) {
                version = version.substring(0, extensionIndex - 1);
            }
            return new QuickReference(name, version);
        }
        throw new GdrException("CARB name " + fileName + " was not in the expected format.");
    }

    public void setOverwrittenFiles(Map<ComponentReference, Map<Path, Path>> overwrittenFilesMap) {
        this._overwrittenFilesMap = overwrittenFilesMap;
    }

    public void restoreOverwrittenFiles() throws IOException {
        if (this._overwrittenFilesMap != null && !this._overwrittenFilesMap.isEmpty()) {
            for (Map<Path, Path> mapEntry : this._overwrittenFilesMap.values()) {
                for (Map.Entry<Path, Path> fileEntry : mapEntry.entrySet()) {
                    NioCopy.copy((Path)fileEntry.getValue(), (Path)fileEntry.getKey());
                }
            }
        }
    }
}

