/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.patch;

import com.oracle.cie.common.Version;
import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.rgy.BaseInfoReference;
import com.oracle.cie.gdr.dao.rgy.FeatureInfo;
import com.oracle.cie.gdr.dao.rgy.SessionAction;
import com.oracle.cie.gdr.dao.rgy.SessionInfo;
import com.oracle.cie.gdr.helpers.RegistryHelper;
import com.oracle.cie.gdr.patch.InternalPatchHandler;
import com.oracle.cie.gdr.selection.Status;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import oracle.glcm.opatch.common.api.Patch;

public abstract class SharedPatchMetaDataHandler<T extends BaseInfoReference> {
    private InternalPatchHandler _patchHandler;
    private Patch _patch;
    private RegistryHelper _registryHelper;

    public SharedPatchMetaDataHandler(InternalPatchHandler patchHandler, Patch patch) {
        this._patchHandler = patchHandler;
        this._patch = patch;
    }

    protected InternalPatchHandler getPatchHandler() {
        return this._patchHandler;
    }

    protected Patch getPatch() {
        return this._patch;
    }

    protected void setPatch(Patch patch) {
        this._patch = patch;
    }

    protected RegistryHelper getRegistryHelper() {
        if (this._registryHelper == null) {
            this._registryHelper = RegistryHelper.getInstance(this.getPatchHandler().getHome().getClassLoader());
        }
        return this._registryHelper;
    }

    protected abstract void analyzeUpgradePatches() throws GdrException, IOException, DataHandlerException;

    public abstract void applyUpgradePatches() throws GdrException, IOException, DataHandlerException;

    public abstract void rollbackUpgradePatches() throws GdrException, IOException, DataHandlerException;

    protected Map<SessionInfo, T> applyPatchRegistryInfo(List<T> matchingInfos, String patchMetaDataVersion) throws GdrException {
        return this.applyPatchRegistryInfo(matchingInfos, patchMetaDataVersion, null);
    }

    protected Map<SessionInfo, T> applyPatchRegistryInfo(List<T> matchingInfos, String patchMetaDataVersion, String patchMetaDataPatchLevel) throws GdrException {
        return this.applyPatchRegistryInfo(matchingInfos, patchMetaDataVersion, patchMetaDataPatchLevel, false);
    }

    protected Map<SessionInfo, T> applyPatchRegistryInfo(List<T> matchingInfos, String patchMetaDataVersion, String patchMetaDataPatchLevel, boolean updateExistingOnly) throws GdrException {
        HashMap<SessionInfo, BaseInfoReference> updateInfos = new HashMap<SessionInfo, BaseInfoReference>();
        patchMetaDataPatchLevel = !StringUtil.isNullOrEmpty((String)patchMetaDataPatchLevel, (boolean)true) ? patchMetaDataPatchLevel.trim() : null;
        for (BaseInfoReference registryInfo : matchingInfos) {
            SessionInfo sessionInfo = null;
            List<SessionInfo> sessionInfos = this.getRegistryHelper().getSessionInfos(registryInfo, SessionAction.install, SessionAction.upgrade);
            for (SessionInfo sinfo : sessionInfos) {
                String version = sinfo.getVersion();
                String patchLevel = sinfo.getPatchLevel();
                String string = patchLevel = !StringUtil.isNullOrEmpty((String)patchLevel, (boolean)true) ? patchLevel.trim() : null;
                if (version == null || !version.equals(patchMetaDataVersion) || !Objects.equals(patchMetaDataPatchLevel, patchLevel)) continue;
                sessionInfo = sinfo;
            }
            if (sessionInfo != null && sessionInfo.getAction() != SessionAction.upgrade || updateExistingOnly && sessionInfo == null) continue;
            int versionCompare = this.compareVersions(registryInfo, patchMetaDataVersion, patchMetaDataPatchLevel);
            if (versionCompare == 0) {
                if (sessionInfo == null || sessionInfo.getPatchIdsSet().isEmpty()) continue;
                sessionInfo.addPatchId(this.getPatch().getPatchUpi());
                continue;
            }
            if (versionCompare < 0) {
                if (sessionInfo == null) {
                    sessionInfo = this.getPatchHandler().getRegistrySession().copy();
                    sessionInfo.setVersion(patchMetaDataVersion);
                    sessionInfo.setPreviousVersion(registryInfo.getVersion());
                    sessionInfo.setOriginatingPatchId(this.getPatch().getPatchUpi());
                    registryInfo.addSession(sessionInfo, false);
                    if (!registryInfo.getStatus().isUpgraded()) {
                        registryInfo.setStatus(Status.upgraded);
                    }
                    if (!registryInfo.isOriginalVersionSet()) {
                        registryInfo.setOriginalVersion(registryInfo.getVersion());
                    }
                    registryInfo.setVersion(patchMetaDataVersion);
                }
                sessionInfo.addPatchId(this.getPatch().getPatchUpi());
                updateInfos.put(sessionInfo, registryInfo);
                continue;
            }
            if (sessionInfo != null || !registryInfo.getStatus().isUpgraded()) continue;
            sessionInfo = this.getPatchHandler().getRegistrySession().copy();
            sessionInfo.setVersion(registryInfo.getVersion());
            sessionInfo.setPreviousVersion(patchMetaDataVersion);
            sessionInfo.setOriginatingPatchId(this.getPatch().getPatchUpi());
            registryInfo.addSession(sessionInfo, false);
        }
        return updateInfos;
    }

    protected int compareVersions(T registryInfo, String versionB, String patchLevelB) {
        return this.compareVersions(((Reference)((Object)registryInfo)).getVersion(), null, versionB, null);
    }

    protected int compareVersions(String versionA, String patchLevelA, String versionB, String patchLevelB) {
        int versionCompare = new Version(versionA).compareTo(new Version(versionB));
        if (!(versionCompare != 0 || StringUtil.isNullOrEmpty((String)patchLevelA, (boolean)true) && StringUtil.isNullOrEmpty((String)patchLevelB, (boolean)true))) {
            versionCompare = new Version(StringUtil.isNullOrEmpty((String)patchLevelA, (boolean)true) ? "0" : patchLevelA).compareTo(new Version(StringUtil.isNullOrEmpty((String)patchLevelB, (boolean)true) ? "0" : patchLevelB));
        }
        return versionCompare;
    }

    protected List<RolledBackRegistryInfo> rollbackPatchRegistryInfo(List<T> registryInfosForPatch) throws GdrException {
        String uniquePatchId = this.getPatch().getPatchUpi();
        ArrayList<RolledBackRegistryInfo> rolledBack = new ArrayList<RolledBackRegistryInfo>();
        for (BaseInfoReference registryInfo : registryInfosForPatch) {
            List<SessionInfo> sessionInfos = registryInfo.getSortedSessions();
            SessionInfo patchSessionInfo = this.getRegistryHelper().getSessionInfoForPatch(sessionInfos, uniquePatchId, true);
            Set<String> patchIds = patchSessionInfo.getPatchIdsSet();
            if (patchIds.isEmpty() && uniquePatchId.equals(patchSessionInfo.getOriginatingPatchId()) && patchSessionInfo.getAction() == SessionAction.upgrade) {
                sessionInfos.remove((Object)patchSessionInfo);
                registryInfo.setSessions(sessionInfos);
                rolledBack.add(new RolledBackRegistryInfo(this, registryInfo, patchSessionInfo.getPreviousVersion()));
                continue;
            }
            patchIds.remove(uniquePatchId);
            if (!patchIds.isEmpty()) {
                patchSessionInfo.removePatchId(uniquePatchId);
                continue;
            }
            sessionInfos.remove((Object)patchSessionInfo);
            registryInfo.setSessions(sessionInfos);
            if (patchSessionInfo.getAction() == SessionAction.install) {
                if (patchIds.isEmpty()) {
                    this.performInstallationRollback(registryInfo);
                    registryInfo.setStatus(Status.notinstalled);
                }
                rolledBack.add(new RolledBackRegistryInfo(this, registryInfo, registryInfo.getVersion()));
                continue;
            }
            if (patchSessionInfo.getAction() == SessionAction.deinstall) {
                registryInfo.setStatus(Status.installed);
                this.performDeinstallationRollback(registryInfo);
                if (registryInfo instanceof FeatureInfo) continue;
                rolledBack.add(new RolledBackRegistryInfo(this, registryInfo, registryInfo.getVersion()));
                continue;
            }
            rolledBack.add(new RolledBackRegistryInfo(this, registryInfo, registryInfo.getVersion()));
            SessionInfo previousUpgrade = null;
            List<SessionInfo> previousUpgrades = this.getRegistryHelper().filterSessionInfos(registryInfo.getSortedSessions(), SessionAction.upgrade);
            if (!previousUpgrades.isEmpty()) {
                previousUpgrade = previousUpgrades.get(previousUpgrades.size() - 1);
            }
            if (previousUpgrade != null) {
                registryInfo.setVersion(previousUpgrade.getVersion());
                continue;
            }
            registryInfo.setVersion(registryInfo.getOriginalVersion());
            registryInfo.setOriginalVersion(null);
            registryInfo.setStatus(Status.installed);
        }
        return rolledBack;
    }

    protected abstract void performInstallationRollback(T var1) throws GdrException;

    protected abstract void performDeinstallationRollback(T var1) throws GdrException;

    public List<T> getMatchingInstalledRegistryInfos(Collection<T> registryInfos, String name, String versionRegEx) {
        return this.getMatchingRegistryInfos(registryInfos, name, versionRegEx, Status.installed, Status.upgraded);
    }

    public List<T> getMatchingRegistryInfos(Collection<T> registryInfos, String name, String versionRegEx, Status ... statuses) {
        ArrayList<BaseInfoReference> matching = new ArrayList<BaseInfoReference>();
        if (registryInfos != null && !registryInfos.isEmpty() && statuses != null && statuses.length > 0) {
            HashSet<Status> statusSet = new HashSet<Status>(Arrays.asList(statuses));
            for (BaseInfoReference registryInfo : registryInfos) {
                if (!registryInfo.getName().equals(name) || !registryInfo.getVersion().matches(versionRegEx) || !statusSet.contains((Object)registryInfo.getStatus())) continue;
                matching.add(registryInfo);
            }
        }
        return matching;
    }

    protected static class RolledBackRegistryInfo {
        private T _registryInfo;
        private String _previousPatchVersion;
        final /* synthetic */ SharedPatchMetaDataHandler this$0;

        public RolledBackRegistryInfo(T registryInfo, String previousPatchVersion) {
            this.this$0 = this$0;
            this._registryInfo = registryInfo;
            this._previousPatchVersion = previousPatchVersion;
        }

        public T getRegistryInfo() {
            return this._registryInfo;
        }

        public String getPreviousPatchVersion() {
            return this._previousPatchVersion;
        }
    }
}

