/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.selection;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.selection.CommonSelectable;
import com.oracle.cie.gdr.selection.Selectable;
import com.oracle.cie.gdr.selection.SelectableGroup;
import java.util.ArrayList;
import java.util.List;

public class SelectableDistribution
extends CommonSelectable
implements SelectableGroup {
    private Distribution _distribution;
    private List<Selectable> _children = new ArrayList<Selectable>();
    private boolean _selected = true;
    private boolean _selectable = true;

    public SelectableDistribution(Distribution distribution) {
        this._distribution = distribution;
    }

    @Override
    public List<Selectable> getSelectableChildren() {
        return this._children;
    }

    public void setSelectableChildren(List<Selectable> children) {
        this._children = children == null ? new ArrayList<Selectable>() : children;
        for (Selectable child : this._children) {
            if (!child.isDisabled()) continue;
            this.setDisabled(true);
        }
    }

    @Override
    public String getDescription() {
        String description = this._distribution.getLocalizedDescription();
        if (StringUtil.isNullOrEmpty((String)description, (boolean)true)) {
            description = this.getName();
        }
        return description;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public String getName() {
        return this._distribution.getName();
    }

    @Override
    public String getDisplayName() {
        String name = this._distribution.getLocalizedExternalName();
        if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            name = this.getName();
        }
        return name;
    }

    @Override
    public String getVersion() {
        return this._distribution.getVersion();
    }

    @Override
    public void setSelected(boolean selected, boolean selectChildren) {
        this.selectItem(selected, selectChildren, false);
    }

    @Override
    public void setSelectedCheckBox(boolean selected, boolean selectChildren) {
        this.selectItem(selected, selectChildren, true);
    }

    private void selectItem(boolean selected, boolean selectChildren, boolean isCheckBox) {
        List<Selectable> children;
        this._selected = selected;
        if (selectChildren && (children = this.getSelectableChildren()) != null && !children.isEmpty()) {
            for (Selectable child : children) {
                if (isCheckBox) {
                    child.setSelectedCheckBox(selected, selectChildren);
                    continue;
                }
                child.setSelected(selected);
            }
        }
    }

    @Override
    public boolean isSelected() {
        return this._selected;
    }

    @Override
    public boolean isSelectedCheckBox() {
        List<Selectable> children = this.getSelectableChildren();
        for (Selectable child : children) {
            if (!child.isSelectedCheckBox()) {
                this._selected = false;
                break;
            }
            if (this.isDisabled()) continue;
            this._selected = true;
        }
        return this._selected;
    }

    @Override
    public void setSelectable(boolean selectable) {
        this._selectable = selectable;
    }

    @Override
    public boolean isSelectable() {
        return this._selectable;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    public String toString() {
        return this._distribution.toString();
    }
}

