/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.selection;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cmn.QuickReference;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dependency.FeatureSelectionTarget;
import com.oracle.cie.gdr.selection.CommonSelectable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SelectableFeatureSet
extends CommonSelectable {
    private static final Logger _log = Logger.getLogger(SelectableFeatureSet.class.getName());
    private FeatureSet _featureSet;
    private FeatureSelectionTarget _selectionTarget;
    private boolean _selectedCheckBox;
    private QuickReference _parentDistribution;

    public SelectableFeatureSet(FeatureSet featureSet, FeatureSelectionTarget selectionTarget) {
        this._featureSet = featureSet;
        this._selectionTarget = selectionTarget;
        Mode mode = null;
        if (this._selectionTarget == null) {
            this._readOnly = true;
        } else {
            mode = this._selectionTarget.getMode();
        }
        if (mode == null) {
            mode = Mode.INSTALL;
        }
        if (mode.isInstallMode()) {
            this.setDisabled(this.isRequired() || featureSet.getStatus().isInstalled());
        }
    }

    public FeatureSelectionTarget getSelectionTarget() {
        this.checkReadOnly();
        return this._selectionTarget;
    }

    @Override
    public String getName() {
        return this._featureSet.getName();
    }

    @Override
    public String getDisplayName() {
        String name = this._featureSet.getLocalizedDisplayName();
        if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            name = this.getName();
        }
        return name;
    }

    @Override
    public String getDescription() {
        String description = this._featureSet.getLocalizedDescription();
        if (StringUtil.isNullOrEmpty((String)description, (boolean)true)) {
            description = this.getName();
        }
        return description;
    }

    @Override
    public String getVersion() {
        return this._featureSet.getVersion();
    }

    @Override
    public void setSelected(boolean selected, boolean selectChildren) {
        try {
            if (this.getSelectionTarget().getMode().isDeInstallMode()) {
                boolean isSelected = this.isSelected();
                if (!isSelected && selected) {
                    this.getSelectionTarget().unselectWithDependents(this._featureSet);
                } else if (isSelected && !selected) {
                    this.getSelectionTarget().selectWithPrerequisites(this._featureSet);
                }
            } else {
                boolean isSelected = this.isSelected();
                if (!isSelected && selected) {
                    this.getSelectionTarget().selectWithPrerequisites(this._featureSet);
                } else if (isSelected && !selected) {
                    this.getSelectionTarget().unselectWithDependents(this._featureSet);
                }
            }
        }
        catch (DependencyException e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    @Override
    public void setSelectedCheckBox(boolean selected, boolean selectChildren) {
        this.checkReadOnly();
        this._selectedCheckBox = selected;
    }

    @Override
    public boolean isSelected() {
        return this.isReadOnly() || this.getSelectionTarget().getMode().isInstallMode() && this.getSelectionTarget().isSelected(this._featureSet) || (this.getSelectionTarget().getMode().isDeInstallMode() ? !this.getSelectionTarget().isSelected(this._featureSet) : this.getSelectionTarget().isSelected(this._featureSet));
    }

    @Override
    public boolean isSelectedCheckBox() {
        return this._selectedCheckBox;
    }

    @Override
    public void setSelectable(boolean selectable) {
        this.getSelectionTarget().setSelectable(this._featureSet, selectable);
    }

    @Override
    public boolean isSelectable() {
        return this.isReadOnly() || this.getSelectionTarget().isSelectable(this._featureSet);
    }

    @Override
    public boolean isVisible() {
        return this._featureSet.isVisible();
    }

    @Override
    public boolean isRequired() {
        return this._featureSet.isRequired();
    }

    public Reference getReference() {
        return new QuickReference(this.getName(), this.getVersion());
    }

    public void setParentDistribution(QuickReference distributionReference) {
        this._parentDistribution = distributionReference;
    }

    public QuickReference getParentDistribution() {
        return this._parentDistribution;
    }

    public String toString() {
        return this._featureSet.toString();
    }
}

