/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.selection;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.dbd.FeatureSetGroup;
import com.oracle.cie.gdr.selection.CommonSelectable;
import com.oracle.cie.gdr.selection.Selectable;
import com.oracle.cie.gdr.selection.SelectableFeatureSet;
import com.oracle.cie.gdr.selection.SelectableGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SelectableFeatureSetGroup
extends CommonSelectable
implements SelectableGroup {
    private FeatureSetGroup _featureSetGroup;
    private Mode _mode;
    private Map<SelectableFeatureSetGroup, List<SelectableFeatureSet>> _featureSetGroups;
    private List<Selectable> _children = new ArrayList<Selectable>();
    private boolean _selected = true;
    private boolean _selectable = true;
    private boolean _required = false;

    public SelectableFeatureSetGroup(FeatureSetGroup featureSetGroup, Mode mode) {
        this._featureSetGroup = featureSetGroup;
        this._mode = mode != null ? mode : Mode.INSTALL;
    }

    public Map<SelectableFeatureSetGroup, List<SelectableFeatureSet>> getFeatureSetGroups() {
        return this._featureSetGroups;
    }

    public void setFeatureSetGroups(Map<SelectableFeatureSetGroup, List<SelectableFeatureSet>> featureSetGroups) {
        this._featureSetGroups = featureSetGroups;
    }

    public boolean hasFeatureSetGroups() {
        return this._featureSetGroups != null && !this._featureSetGroups.isEmpty();
    }

    @Override
    public List<Selectable> getSelectableChildren() {
        return this._children;
    }

    public void setSelectableChildren(List<Selectable> children) {
        this._children = children == null ? new ArrayList<Selectable>() : children;
        for (Selectable child : this._children) {
            if (this._mode.isInstallMode() && child.isRequired()) {
                this.setRequired(true);
                break;
            }
            if (!child.isDisabled()) continue;
            this.setDisabled(true);
        }
    }

    @Override
    public String getName() {
        return this._featureSetGroup.getName();
    }

    @Override
    public String getDisplayName() {
        String name = this._featureSetGroup.getLocalizedDisplayName();
        if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            name = this.getName();
        }
        return name;
    }

    @Override
    public String getDescription() {
        String description = this._featureSetGroup.getLocalizedDescription();
        if (StringUtil.isNullOrEmpty((String)description, (boolean)true)) {
            description = this.getName();
        }
        return description;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public void setSelected(boolean selected, boolean selectChildren) {
        this.selectItem(selected, selectChildren, false);
    }

    @Override
    public void setSelectedCheckBox(boolean selected, boolean selectChildren) {
        this.selectItem(selected, selectChildren, true);
    }

    private void selectItem(boolean selected, boolean selectChildren, boolean isCheckBox) {
        List<Selectable> children;
        this.checkReadOnly();
        this._selected = selected;
        if (selectChildren && (children = this.getSelectableChildren()) != null && !children.isEmpty()) {
            for (Selectable child : children) {
                if (isCheckBox) {
                    child.setSelectedCheckBox(selected, selectChildren);
                    continue;
                }
                child.setSelected(selected);
            }
        }
    }

    @Override
    public boolean isSelected() {
        List<Selectable> children = this.getSelectableChildren();
        for (Selectable child : children) {
            if (child.isSelected()) {
                this._selected = true;
                break;
            }
            this._selected = false;
        }
        return this._selected;
    }

    @Override
    public boolean isSelectedCheckBox() {
        List<Selectable> children = this.getSelectableChildren();
        for (Selectable child : children) {
            if (!child.isSelectedCheckBox()) {
                this._selected = false;
                break;
            }
            this._selected = true;
        }
        return this._selected;
    }

    @Override
    public void setSelectable(boolean selectable) {
        this.checkReadOnly();
        this._selectable = selectable;
    }

    @Override
    public boolean isSelectable() {
        return this._selectable;
    }

    @Override
    public boolean isVisible() {
        return this._featureSetGroup.isVisible();
    }

    public void setRequired(boolean required) {
        this._required = required;
        this.setDisabled(required);
    }

    @Override
    public boolean isRequired() {
        return this._required;
    }

    public boolean areAllChildrenRequired() {
        boolean required = false;
        List<Selectable> children = this.getSelectableChildren();
        for (Selectable child : children) {
            if (child instanceof SelectableFeatureSetGroup && !((SelectableFeatureSetGroup)child).areAllChildrenRequired() || !child.isRequired()) {
                required = false;
                break;
            }
            required = true;
        }
        return required;
    }

    public boolean hasRequiredChildren() {
        boolean requiredChildren = false;
        List<Selectable> children = this.getSelectableChildren();
        for (Selectable child : children) {
            if (child instanceof SelectableFeatureSetGroup && ((SelectableFeatureSetGroup)child).hasRequiredChildren() || child.isRequired()) {
                requiredChildren = true;
                break;
            }
            requiredChildren = false;
        }
        return requiredChildren;
    }

    public String toString() {
        return this._featureSetGroup.toString();
    }
}

