/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.services;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.HomeHelper;
import com.oracle.cie.gdr.nio.FileSystemType;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.services.ServiceHolder;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.ArtifactType;
import oracle.glcm.opatch.common.api.ArtifactTypeMapping;
import oracle.glcm.opatch.common.api.ArtifactTypeMappingException;

public class ArtifactTypeMappingImpl
implements ArtifactTypeMapping {
    private static final Logger _log = Logger.getLogger(ArtifactTypeMappingImpl.class.getName());
    private String oracleHomePath;
    private Map<String, Object> envMap = new HashMap<String, Object>();

    public ArtifactTypeMappingImpl(String homePath, String fileSystemType) throws ArtifactTypeMappingException {
        this.oracleHomePath = homePath;
        FileSystemType type = null;
        if (fileSystemType == null || fileSystemType.isEmpty()) {
            fileSystemType = FileSystemType.Cas.toString();
        }
        type = FileSystemType.valueOfIgnoreCase((String)fileSystemType);
        try {
            NioHelper.configureDefaultFileSystemHandler((FileSystemType)type);
            this.envMap.put("FILE_SYSTEM_READ_ONLY", "true");
        }
        catch (IllegalArgumentException e) {
            throw new ArtifactTypeMappingException("Invalid file system type: " + fileSystemType, (Throwable)e);
        }
    }

    public ArtifactTypeMappingImpl(String homePath) throws ArtifactTypeMappingException {
        this(homePath, FileSystemType.Cas.toString());
    }

    public ArtifactType getArtifactType(String fileLocation) throws ArtifactTypeMappingException {
        Path homePath = Paths.get(this.oracleHomePath, new String[0]);
        try {
            _log.info("Searching artifact type for " + fileLocation + " from home: " + homePath);
            NioHelper.getInstance().newFileSystem(homePath, this.envMap);
            Path homeDirPath = NioHelper.getInstance().getPath(homePath.toFile());
            Home home = Home.getHome(homeDirPath);
            for (DistributionTarget installedDistribution : home.getInstalledDistributions()) {
                Map<FeatureSet, Collection<Component>> installedComponents = HomeHelper.getInstalledComponents(installedDistribution, new ServiceHolder(), home.getMetaDataHome());
                for (Map.Entry<FeatureSet, Collection<Component>> featuresetComponents : installedComponents.entrySet()) {
                    for (Component component : featuresetComponents.getValue()) {
                        Map<String, ArtifactType> typeMapping = ComponentHelper.getInstance().getFileTypeMapping(component);
                        if (typeMapping.get(fileLocation) == null) continue;
                        ArtifactType artifactType = typeMapping.get(fileLocation);
                        return artifactType;
                    }
                }
            }
        }
        catch (Exception e) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.log(Level.FINEST, StringUtil.getStackTrace((Throwable)e));
            }
            _log.log(Level.SEVERE, "Failed to get artifact type for " + fileLocation + " at " + this.oracleHomePath + ": " + e.getMessage());
            throw new ArtifactTypeMappingException("Failed to get artifact type for " + fileLocation + " at " + this.oracleHomePath + ": " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                FileSystem fileSystem = NioHelper.getInstance().getFileSystem(homePath);
                if (fileSystem != null) {
                    fileSystem.close();
                }
            }
            catch (Exception e) {
                throw new ArtifactTypeMappingException("Failed to close file system handler " + e.getMessage(), (Throwable)e);
            }
        }
        _log.log(Level.WARNING, fileLocation + " was not found in Oracle Home " + this.oracleHomePath);
        return ArtifactType.UNKNOWN;
    }

    public Map<String, ArtifactType> getArtifactTypes() throws ArtifactTypeMappingException {
        HashMap<String, ArtifactType> artifactTypeMapping = new HashMap<String, ArtifactType>();
        Path homePath = Paths.get(this.oracleHomePath, new String[0]);
        try {
            _log.info("Reading artifact types from home: " + homePath);
            NioHelper.getInstance().newFileSystem(homePath, this.envMap);
            Path homeDirPath = NioHelper.getInstance().getPath(homePath.toFile());
            Home home = Home.getHome(homeDirPath);
            ComponentHelper helper = ComponentHelper.getInstance();
            for (DistributionTarget installedDistribution : home.getInstalledDistributions()) {
                Map<FeatureSet, Collection<Component>> installedComponents = HomeHelper.getInstalledComponents(installedDistribution, new ServiceHolder(), home.getMetaDataHome());
                for (Map.Entry<FeatureSet, Collection<Component>> featuresetComponents : installedComponents.entrySet()) {
                    for (Component component : featuresetComponents.getValue()) {
                        artifactTypeMapping.putAll(helper.getFileTypeMapping(component));
                    }
                }
            }
        }
        catch (Exception e) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.log(Level.FINEST, "Failed to get artifact types at " + this.oracleHomePath + ": " + e.getMessage(), e);
                _log.log(Level.FINEST, StringUtil.getStackTrace((Throwable)e));
            } else {
                _log.log(Level.WARNING, "Failed to get artifact types at " + this.oracleHomePath + ": " + e.getMessage());
            }
            throw new ArtifactTypeMappingException("Failed to get artifact types at " + this.oracleHomePath + ": " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                FileSystem fileSystem = NioHelper.getInstance().getFileSystem(homePath);
                if (fileSystem != null) {
                    fileSystem.close();
                }
            }
            catch (Exception e) {
                throw new ArtifactTypeMappingException("Failed to close file system handler" + e.getMessage(), (Throwable)e);
            }
        }
        return artifactTypeMapping;
    }
}

