/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.services;

import com.oracle.cie.common.util.IObjectStore;
import com.oracle.cie.common.util.ObjectStoreManager;
import com.oracle.cie.gdr.dao.cpd.ValueQuery;
import com.oracle.cie.gdr.dao.cpd.Variable;
import com.oracle.cie.gdr.installation.DefaultInstallerWrapper;
import com.oracle.cie.gdr.installation.Installer;
import com.oracle.cie.gdr.installation.InstallerWrapper;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.gdr.variables.VariableQueries;
import com.oracle.cie.gdr.variables.VariableQuery;
import com.oracle.cie.gdr.variables.VariableQueryParam;
import com.oracle.cie.gdr.variables.VariableQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public class VariableResolverService {
    private static VariableResolverService _instance;
    public static String GDR_GLOBAL_NAMESPACE;
    private IObjectStore _globalObjectStore = ObjectStoreManager.getObjectStore((String)GDR_GLOBAL_NAMESPACE);
    private Map<String, VariableQuery> _variableQueries;

    public static VariableResolverService getVariableResolverService() {
        return VariableResolverService.getVariableResolverService(null);
    }

    public static VariableResolverService getVariableResolverService(Map<String, String> variableMap) {
        if (_instance == null) {
            _instance = new VariableResolverService();
        }
        if (variableMap != null && !variableMap.isEmpty()) {
            for (String key : variableMap.keySet()) {
                _instance.set(key, variableMap.get(key));
            }
        }
        return _instance;
    }

    private VariableResolverService() {
    }

    public IObjectStore getGlobalObjectStore() {
        return this._globalObjectStore;
    }

    public IObjectStore getObjectStore(String namespace) {
        return this.getObjectStore(namespace, null);
    }

    public IObjectStore getObjectStore(String namespace, String backingNamespace) {
        if (namespace == null || GDR_GLOBAL_NAMESPACE.equals(namespace)) {
            return this.getGlobalObjectStore();
        }
        return ObjectStoreManager.getObjectStore((String)namespace, (String)(backingNamespace == null ? GDR_GLOBAL_NAMESPACE : backingNamespace));
    }

    public void addVariable(Variable variable) {
        this.addVariable(null, variable);
    }

    public void addVariable(String namespace, Variable variable) {
        this.getObjectStore(namespace).storeObject((Object)variable.getName(), (Object)variable);
    }

    public Variable getVariable(String name) {
        return this.getVariable(null, name);
    }

    public Variable getVariable(String namespace, String name) {
        return (Variable)((Object)this.getObjectStore(namespace).retrieveObject((Object)name));
    }

    public String get(String key) {
        return this.get(null, key);
    }

    public String get(String namespace, String key) {
        return this.getObjectStore(namespace).getString(key);
    }

    public void set(String key, String value) {
        this.set(null, key, value);
    }

    public void set(String namespace, String key, String value) {
        this.getObjectStore(namespace).storeObject((Object)key, (Object)new Variable(key, value));
    }

    public void set(Map<String, String> values) {
        this.set(null, values);
    }

    public void set(String namespace, Map<String, String> values) {
        if (values != null && !values.isEmpty()) {
            for (String key : values.keySet()) {
                this.set(namespace, key, values.get(key));
            }
        }
    }

    public String substitute(String str) {
        return this.substitute(null, str);
    }

    public String substitute(String namespace, String str) {
        return this.substitute(namespace, str, false);
    }

    public String substitute(String namespace, String str, boolean validating) {
        if (str == null) {
            return null;
        }
        IObjectStore objectStore = this.getObjectStore(namespace);
        boolean preserveUnresolved = true;
        if (validating) {
            objectStore.setValidating(true);
            preserveUnresolved = false;
        }
        String s = objectStore.substitute(str, "%", "%", preserveUnresolved);
        s = objectStore.substitute(s, "${", "}", preserveUnresolved);
        if (validating) {
            objectStore.setValidating(false);
        }
        return s;
    }

    public String substitute(String str, String startDelim, String endDelim) {
        return this.substitute(null, str, startDelim, endDelim);
    }

    public String substitute(String namespace, String str, String startDelim, String endDelim) {
        if (str == null) {
            return null;
        }
        return this.getObjectStore(namespace).substitute(str, startDelim, endDelim, true);
    }

    public Object resolveVariableValue(final Variable variable, final Installer installer) throws GdrException {
        Object resolvedValue = null;
        if (variable != null) {
            final ValueQuery valueQuery = variable.getValueQuery();
            if (valueQuery != null) {
                VariableQueryRequest queryRequest = new VariableQueryRequest(){

                    @Override
                    public String getVariableQueryName() {
                        return valueQuery.getName();
                    }

                    @Override
                    public List<? extends VariableQueryParam> getVariableQueryParams() {
                        return valueQuery.getParams();
                    }

                    @Override
                    public Object getDefaultValue() {
                        return variable.getValue();
                    }

                    @Override
                    public InstallerWrapper getInstallerWrapper() {
                        return new DefaultInstallerWrapper(installer);
                    }
                };
                resolvedValue = this.queryVariableValue(queryRequest);
            } else {
                resolvedValue = variable.getValue();
            }
        }
        return resolvedValue;
    }

    public Object queryVariableValue(VariableQueryRequest queryRequest) throws GdrException {
        Object resolvedValue = null;
        if (queryRequest != null) {
            VariableQuery variableQuery = this.getVariableQueries().get(queryRequest.getVariableQueryName());
            if (variableQuery == null) {
                throw new GdrException("Unable to locate variable query with the name:" + queryRequest.getVariableQueryName());
            }
            resolvedValue = variableQuery.query(queryRequest);
        }
        return resolvedValue;
    }

    public Map<String, VariableQuery> getVariableQueries() throws GdrException {
        return this.getVariableQueries(null);
    }

    public Map<String, VariableQuery> getVariableQueries(ClassLoader classLoader) throws GdrException {
        if (this._variableQueries == null) {
            this._variableQueries = this.loadVariableQueries(classLoader);
        }
        return this._variableQueries;
    }

    private Map<String, VariableQuery> loadVariableQueries(ClassLoader classLoader) throws GdrException {
        if (classLoader == null) {
            classLoader = VariableResolverService.class.getClassLoader();
        }
        HashMap<String, VariableQuery> variableQueries = new HashMap<String, VariableQuery>();
        ServiceLoader<VariableQueries> loader = ServiceLoader.load(VariableQueries.class, classLoader);
        for (VariableQueries queries : loader) {
            Set<VariableQuery> querySet = queries.getVariableQueries();
            if (querySet == null) continue;
            for (VariableQuery query : querySet) {
                String name = query.getName();
                if (variableQueries.containsKey(name)) {
                    throw new GdrException("Encountered multiple variable query instances with the name: " + name);
                }
                variableQueries.put(name, query);
            }
        }
        return variableQueries;
    }

    static {
        GDR_GLOBAL_NAMESPACE = "GDR_GLOBAL_NAMESPACE";
    }
}

