/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.utils;

import com.oracle.cie.common.util.StringUtil;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ACLPermissionUtil {
    private static final Logger _log = Logger.getLogger(ACLPermissionUtil.class.getName());
    private static UserPrincipal _name;
    private static AclFileAttributeView _view;
    private static Set<AclEntryPermission> _perms;

    public static boolean setPermissions(Path path, List<String> principals) {
        if (path == null || path.endsWith("")) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("The path you are trying to use is null or empty. Please Verify.");
            }
            return false;
        }
        if (principals == null || principals.isEmpty()) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("The list of principals you are trying to use is null or empty.");
            }
            return false;
        }
        for (String principal : principals) {
            try {
                _name = path.getFileSystem().getUserPrincipalLookupService().lookupPrincipalByName(principal);
                _view = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
                _perms = ACLPermissionUtil.constructACLPermissions(principal);
                AclEntry entry = AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(_name).setPermissions(_perms).build();
                List<AclEntry> acl = _view.getAcl();
                acl.add(0, entry);
                _view.setAcl(acl);
            }
            catch (IOException e) {
                _log.warning("Something went wrong applying the ACL for this file/dir: " + path);
                return false;
            }
        }
        return true;
    }

    public static boolean setPermissions(String path, List<String> principals) {
        return ACLPermissionUtil.setPermissions(Paths.get(path, new String[0]), principals);
    }

    public static boolean setPermissions(Path path, String permissions) {
        try {
            String[] elems = permissions.split(":");
            if (elems.length != 3) {
                return false;
            }
            UserPrincipal name = path.getFileSystem().getUserPrincipalLookupService().lookupPrincipalByName(elems[0]);
            String entries = elems[1];
            String type = elems[2];
            HashSet<AclEntryPermission> perms = new HashSet<AclEntryPermission>();
            for (String entry : entries.split("/")) {
                perms.add(AclEntryPermission.valueOf(entry));
            }
            AclFileAttributeView view = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
            AclEntry entry = AclEntry.newBuilder().setType(AclEntryType.valueOf(type)).setPrincipal(name).setPermissions(perms).build();
            List<AclEntry> aclEntryList = view.getAcl();
            aclEntryList.add(0, entry);
            view.setAcl(aclEntryList);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static Set<AclEntryPermission> constructACLPermissions(String principal) {
        if (StringUtil.isNullOrEmpty((String)principal)) {
            return null;
        }
        HashSet<AclEntryPermission> perms = new HashSet<AclEntryPermission>();
        perms.add(AclEntryPermission.APPEND_DATA);
        perms.add(AclEntryPermission.SYNCHRONIZE);
        perms.add(AclEntryPermission.EXECUTE);
        perms.add(AclEntryPermission.DELETE);
        perms.add(AclEntryPermission.DELETE_CHILD);
        perms.add(AclEntryPermission.READ_ACL);
        perms.add(AclEntryPermission.READ_ATTRIBUTES);
        perms.add(AclEntryPermission.READ_DATA);
        perms.add(AclEntryPermission.READ_NAMED_ATTRS);
        perms.add(AclEntryPermission.WRITE_ACL);
        perms.add(AclEntryPermission.WRITE_ATTRIBUTES);
        perms.add(AclEntryPermission.WRITE_DATA);
        perms.add(AclEntryPermission.WRITE_NAMED_ATTRS);
        perms.add(AclEntryPermission.WRITE_OWNER);
        return perms;
    }

    public static List<AclEntry> getPermissions(Path path) throws IOException {
        AclFileAttributeView view = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
        return view.getAcl();
    }

    public static String getPermissionsForPrincipal(Path path, String principal) throws IOException {
        if (path != null) {
            AclFileAttributeView view = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
            UserPrincipalLookupService userService = path.getFileSystem().getUserPrincipalLookupService();
            UserPrincipal name = null;
            try {
                name = userService.lookupPrincipalByName(principal);
            }
            catch (UserPrincipalNotFoundException userPrincipalNotFoundException) {
                // empty catch block
            }
            if (view != null && name != null) {
                for (AclEntry entry : view.getAcl()) {
                    if (!entry.principal().equals(name)) continue;
                    return entry.toString();
                }
            }
        }
        return "";
    }

    public static boolean isPrincipalFound(String principal) throws IOException {
        UserPrincipalLookupService userService = FileSystems.getDefault().getUserPrincipalLookupService();
        UserPrincipal name = null;
        try {
            name = userService.lookupPrincipalByName(principal);
        }
        catch (UserPrincipalNotFoundException userPrincipalNotFoundException) {
            // empty catch block
        }
        return name != null;
    }

    public static boolean isPermissionsAinPermissionsB(String entryA, String entryB) {
        HashSet<String> permissionsA = new HashSet<String>(Arrays.asList(entryA.split(":")[1].split("/")));
        HashSet<String> permissionsB = new HashSet<String>(Arrays.asList(entryB.split(":")[1].split("/")));
        if (permissionsA.size() > permissionsB.size()) {
            return false;
        }
        for (String per : permissionsA) {
            if (permissionsB.contains(per)) continue;
            return false;
        }
        return true;
    }
}

