/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.utils;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.Delete;
import com.oracle.cie.common.util.DirectoryCopy;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.TempFileHandler;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.ftr.Components;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.utils.ComponentArchiveUtils;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.repository.resolver.RepositoryVersionResolver;
import com.oracle.cie.repository.resolver.RepositoryVersionResolverException;
import com.oracle.cie.rest.RestException;
import com.oracle.cie.rest.RestFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComponentArchiveMerger {
    private static final Logger _log = Logger.getLogger(ComponentArchiveMerger.class.getName());
    private Collection<File> _stageDirs;
    private Collection<Components> _compRefs;
    private RepositoryVersionResolver _versionResolver;
    private File _srchome;
    private File _outputDir;

    public ComponentArchiveMerger(Collection<File> stageDirs, File outputDir) {
        this(stageDirs, null, null, outputDir);
    }

    public ComponentArchiveMerger(Collection<Reference> compRefs, RepositoryVersionResolver versionResolver, File outputDir) {
        this(null, compRefs, false, versionResolver, outputDir);
    }

    public ComponentArchiveMerger(Collection<File> stageDirs, Collection<Reference> compRefs, boolean choice, RepositoryVersionResolver versionResolver, File outputDir) {
        this(stageDirs, ComponentArchiveMerger.createComponents(compRefs, choice), versionResolver, outputDir);
    }

    public ComponentArchiveMerger(Collection<File> stageDirs, Collection<Components> compRefs, RepositoryVersionResolver versionResolver, File outputDir) {
        this(stageDirs, compRefs, versionResolver, null, outputDir);
    }

    public ComponentArchiveMerger(Collection<File> stageDirs, Collection<Components> compRefs, RepositoryVersionResolver versionResolver, File srchome, File outputDir) {
        if ((stageDirs == null || stageDirs.isEmpty()) && (compRefs == null || compRefs.isEmpty())) {
            throw new NullPointerException("No stage directories or component references were specified.");
        }
        if (outputDir == null) {
            throw new NullPointerException("The output directory specified was null.");
        }
        this._stageDirs = stageDirs;
        this._compRefs = compRefs;
        this._versionResolver = versionResolver;
        this._srchome = srchome;
        this._outputDir = outputDir;
    }

    private static Collection<Components> createComponents(Collection<Reference> compRefs, boolean choice) {
        ArrayList<Components> components = new ArrayList<Components>();
        components.add(FeatureSetHelper.getInstance().createFeatureSetComponents(compRefs, choice));
        return components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge() throws RestException, IOException, RepositoryVersionResolverException, GdrException, DataHandlerException {
        File tmpDir = TempFileHandler.getTempFolder((String)"carbmerge-", null);
        try {
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("Using tmp directory " + tmpDir);
            }
            HashMap<Reference, File> components = new HashMap<Reference, File>();
            for (Components comps : this._compRefs) {
                components.putAll(ComponentArchiveUtils.createComponentLocationMap(this._stageDirs, comps.getComponentReferences(), "choice".equals(comps.getConstraint()), this._versionResolver, this._srchome, tmpDir));
            }
            if (components.isEmpty()) {
                throw new GdrException("Failed to locate any components to merge " + this._compRefs);
            }
            for (Reference compRef : components.keySet()) {
                String[] libsLocs;
                File libsXml;
                File stageDir = (File)components.get((Object)compRef);
                if (stageDir == null) {
                    throw new NullPointerException("The stage directory specified was null.");
                }
                if (!stageDir.exists()) {
                    throw new FileNotFoundException("The stage directory specified did not exist: " + stageDir);
                }
                _log.info("Processing component " + (Object)((Object)compRef) + " at stage location " + stageDir);
                final String name = compRef.getName();
                final String version = compRef.getVersion();
                File compDir = new File(stageDir + File.separator + "Components" + File.separator + name + File.separator + version);
                if (!compDir.exists()) {
                    throw new FileNotFoundException("Unable to locate component under stage directory: " + (Object)((Object)compRef) + ":" + stageDir);
                }
                File compDefXml = new File(compDir, "compDef.xml");
                if (!compDefXml.exists()) {
                    throw new FileNotFoundException("Component directory missing component definition: " + compDefXml);
                }
                File outputStage = ComponentHelper.getStageDir(ComponentHelper.getInstallDir(this._outputDir));
                File compOutputDir = new File(outputStage, "Components" + File.separator + name + File.separator + version);
                compOutputDir.mkdirs();
                DirectoryCopy.copy((File)compDir, (File)compOutputDir, (FileFilter)ComponentHelper.getInstance().getGlobalExcludeFileFilter());
                File[] compXmls = stageDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String filename) {
                        return filename.startsWith(name + "." + version.replace(".", "_"));
                    }
                });
                if (compXmls != null && compXmls.length > 0) {
                    for (File compXml : compXmls) {
                        FileCopy.copy((File)compXml, (File)new File(outputStage, compXml.getName()));
                    }
                }
                if ((libsXml = new File(stageDir, "libs.xml")).exists()) {
                    FileCopy.copy((File)libsXml, (File)new File(outputStage, "libs.xml"));
                }
                for (String library : libsLocs = new String[]{"Actions", "Queries", "Dialogs"}) {
                    File dir = new File(stageDir, library);
                    if (!dir.exists()) continue;
                    DirectoryCopy.copy((File)dir, (File)new File(outputStage, library), (FileFilter)ComponentHelper.getInstance().getGlobalExcludeFileFilter());
                }
            }
        }
        finally {
            Delete.delete((File)tmpDir, (boolean)true);
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println(ComponentArchiveMerger.getUsage());
            System.exit(-1);
        }
        ArrayList<File> stageDirs = new ArrayList<File>();
        ArrayList<Artifact> carbArtifacts = new ArrayList<Artifact>();
        for (int x = 0; x < args.length - 1; ++x) {
            File f = new File(args[x]);
            if (f.exists()) {
                if (!f.isDirectory()) continue;
                stageDirs.add(f);
                continue;
            }
            try {
                Artifact carbArtifact = DependencyManagementFactory.getArtifact((String)args[x]);
                if (!carbArtifact.getGroup().startsWith("com.oracle.cie.gdr.carb") || !carbArtifact.getType().equals("carb")) {
                    throw new IllegalArgumentException("A carb coordinate specified did not have the expected group or extension : " + carbArtifact);
                }
                carbArtifacts.add(carbArtifact);
                continue;
            }
            catch (DependencyManagementException e) {
                System.out.println("Specified value was not an existing stage directory or a carb GAV : " + args[x]);
                e.printStackTrace();
                System.exit(1);
            }
        }
        File outputDir = new File(args[args.length - 1]);
        try {
            String localRepo = System.getProperty("LOCAL_REPO");
            if (!StringUtil.isNullOrEmpty((String)localRepo, (boolean)true)) {
                RestFactory.getRestHandlerConfig().setDefaultCacheRepository(new File(localRepo));
            }
            Collection<Reference> compRefs = ComponentArchiveUtils.getComponentReferencesFromArtifacts(carbArtifacts);
            RepositoryVersionResolver versionResolver = ComponentArchiveUtils.getConfiguredVersionResolver(carbArtifacts);
            ComponentArchiveMerger merger = new ComponentArchiveMerger(stageDirs, compRefs, false, versionResolver, outputDir);
            merger.merge();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-2);
        }
    }

    public static String getUsage() {
        return "java " + ComponentArchiveMerger.class.getSimpleName() + " <stage_dir/carb_gav>+ <output_dir>";
    }
}

