/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.core.patch;

import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import dbmodel.patchmodel.GenericSingletonPatch;
import dbmodel.patchmodel.OPatchSingleton;
import dbmodel.patchmodel.PatchPackage;
import dbmodel.patchmodel.PatchType;
import dbmodel.patchmodel.PatchingTool;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbsysmodel.patchsdk.PatchPackageException;
import oracle.dbsysmodel.patchsdk.PatchValidatorAndGenerator;

public class ExapatchPatchValidatorAndGenerator
implements PatchValidatorAndGenerator {
    static Logger logger = Logger.getLogger(ExapatchPatchValidatorAndGenerator.class.getName());

    public boolean isPatchValid(String patchLocation) throws PatchPackageException {
        assert (patchLocation != null);
        return true;
    }

    public boolean isMethodValid(Class className, String method, Class[] parameterTypes) {
        try {
            className.getMethod(method, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    public PatchPackage generate(String patchLocation) throws PatchPackageException {
        assert (patchLocation != null);
        File patchDir = new File(patchLocation);
        if (!patchDir.exists()) {
            throw new PatchPackageException("The given patchLocation " + patchLocation + " does not exist");
        }
        if (!patchDir.isDirectory()) {
            throw new PatchPackageException("The given patchLocation " + patchLocation + " does not represent a directory");
        }
        GenericSingletonPatch patch = new GenericSingletonPatch();
        patch.setPatchType(PatchType.EXALOGIC_ONEOFF);
        patch.setPatchTool(PatchingTool.EXAPATCH.toString());
        patch.setPatchLocation(patchLocation);
        return patch;
    }

    public GenericSingletonPatch generate(String patchLocation, List<String> applicableTargets) throws PatchPackageException {
        GenericSingletonPatch patch = (GenericSingletonPatch)this.generate(patchLocation);
        patch.setApplicableTargets(PatchPlanner.getInstance().getOPlanIntgFactory().getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTargets));
        return patch;
    }

    public GenericSingletonPatch generate(String patchID, String patchLocation, List<String> applicableTargets) throws PatchPackageException {
        GenericSingletonPatch patch = new GenericSingletonPatch();
        patch.setPatchLocation(patchLocation);
        patch.setPatchID(patchID);
        patch.setApplicableTargets(PatchPlanner.getInstance().getOPlanIntgFactory().getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTargets));
        patch.setPatchTool(this.getPatchTool());
        return patch;
    }

    public static GenericSingletonPatch addApplicabilityTargets(OPatchSingleton patch, List<String> applicableTargets) throws PatchPackageException {
        patch.setApplicableTargets(PatchPlanner.getInstance().getOPlanIntgFactory().getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTargets));
        return patch;
    }

    public String getPatchTool() {
        return PatchingTool.EXAPATCH.toString();
    }

    public boolean isPatchValid(Map map) {
        return true;
    }

    public PatchPackage generate(Map map) throws PatchPackageException {
        GenericSingletonPatch patch = new GenericSingletonPatch();
        patch.setPatchType(PatchType.EXALOGIC_ONEOFF);
        patch.setPatchTool(PatchingTool.EXAPATCH.toString());
        return patch;
    }
}

