/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.patchinfostore;

import com.oracle.glcm.patch.auto.db.framework.patchinfostore.PatchingInformation;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class PatchingSessionInfoStore {
    private String patchLocation = null;
    private Map<PatchTarget, Boolean> patchTargetApplicability = null;
    private Map<PatchTarget, Map<PatchTargetProperty, String>> updatedPatchTargetList = null;
    private final Logger _logger = Logger.getLogger(PatchingInformation.class.getName());

    private PatchingSessionInfoStore() {
    }

    public static PatchingSessionInfoStore getInstance() {
        return Loader._handler;
    }

    public void updatePatchTargetStatus(PatchTarget patchTarget, Boolean skipped) {
        if (this.patchTargetApplicability == null) {
            this.patchTargetApplicability = new HashMap<PatchTarget, Boolean>();
        }
        this.patchTargetApplicability.put(patchTarget, skipped);
    }

    public boolean skipPatchTarget(PatchTarget patchTarget) {
        boolean skipPatchTarget = false;
        if (this.patchTargetApplicability != null && this.patchTargetApplicability.containsKey(patchTarget)) {
            skipPatchTarget = this.patchTargetApplicability.get(patchTarget);
        }
        this._logger.info("Target home: " + patchTarget.getHome() + "skipPatchTarget: " + "" + skipPatchTarget);
        return skipPatchTarget;
    }

    public void updatePatchTargetProperty(PatchTarget patchTarget, PatchTargetProperty property, String val) {
        Map<PatchTargetProperty, String> propertyList;
        if (this.updatedPatchTargetList == null) {
            this.updatedPatchTargetList = new HashMap<PatchTarget, Map<PatchTargetProperty, String>>();
        }
        if ((propertyList = this.updatedPatchTargetList.get(patchTarget)) == null) {
            propertyList = new HashMap<PatchTargetProperty, String>();
        }
        propertyList.put(property, val);
        this._logger.info("Updating property " + property.name() + " with value " + val + " for target " + patchTarget.getHome() + ", " + patchTarget.getHost());
        this.updatedPatchTargetList.put(patchTarget, propertyList);
    }

    public String getUpdatedProperty(PatchTarget target, PatchTargetProperty property) {
        Map<PatchTargetProperty, String> propertyList;
        String propertyVal = null;
        if (this.updatedPatchTargetList != null && (propertyList = this.updatedPatchTargetList.get(target)) != null) {
            propertyVal = propertyList.get((Object)property);
        }
        this._logger.info("Retrieving property " + property.name() + " for target " + target.getHome() + ", " + target.getHost() + ":" + propertyVal);
        return propertyVal;
    }

    public void initialize(String sessionID, String patchLocation) {
        this.patchLocation = patchLocation;
    }

    public String getPatchLocation() {
        return this.patchLocation;
    }

    private static class Loader {
        static PatchingSessionInfoStore _handler = new PatchingSessionInfoStore();

        private Loader() {
        }
    }

    public static enum PatchTargetProperty {
        SHARED;

    }
}

