/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator;

import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cookies.SkipTargetCookie;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.User;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patch.ApplicabilityTarget;
import com.oracle.glcm.patch.auto.db.framework.sdk.patch.PatchPackagesBag;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanInternalException;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.VariableResolver;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import dbmodel.patchmodel.Bundle;
import dbmodel.patchmodel.CompositePatch;
import dbmodel.patchmodel.EngineeredSystemPatch;
import dbmodel.patchmodel.GenericPatch;
import dbmodel.patchmodel.OPatchSingleton;
import dbmodel.patchmodel.PatchBundle;
import dbmodel.patchmodel.PatchPackage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.PatchingPhase;
import oracle.opatch.system.db.automation.jaxb.PhaseType;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

public class CommandUtils {
    private static Logger logger = Logger.getLogger(CommandUtils.class.getName());
    private static String osName = System.getProperties().getProperty("os.name");

    public static String bashEscape(String cmd) {
        cmd = cmd.replaceAll("'", "'\\\\''");
        return "'" + cmd + "'";
    }

    public static String dcliCopy(File src, File dst, List<Host> hosts, String user, boolean recursive) {
        String recurse = recursive ? " --scp=-r" : "";
        return "dcli -l " + user + " -c " + VariableResolver.resolveTargetPropertyList(hosts, "hostName") + recurse + " -f " + src.getAbsolutePath() + " -d " + dst.getAbsolutePath();
    }

    public static String dcliPrefix(String cmd, List<Host> hosts, String user) {
        return "dcli -l " + user + " -c " + VariableResolver.resolveTargetPropertyList(hosts, "hostName") + " " + CommandUtils.bashEscape(cmd);
    }

    public static String sshPrefix(String cmd, Host h, String user) {
        return "ssh " + user + "@" + h.getHostName() + " " + CommandUtils.bashEscape(cmd);
    }

    public static ExecutionStep getBasicExecutionStep(ActionType automationAction, CommandContext context, ActionType originalAutomationAction) {
        Logger logger = Logger.getLogger(CommandUtils.class.getName());
        ExecutionStep executionStep = originalAutomationAction != null ? new ExecutionStep(originalAutomationAction) : new ExecutionStep(automationAction);
        executionStep.setStepProperties(context);
        if ("run_on_last_node".equals(automationAction.getTag())) {
            executionStep.setHost(context.getLastTarget(Host.class));
        } else {
            executionStep.setHost(context.getFirstTarget(Host.class));
        }
        if (executionStep.getHost() == null) {
            String value = "no title";
            if (executionStep.getReadme() != null && executionStep.getReadme().getTitle() != null) {
                value = executionStep.getReadme().getTitle().getValue();
            }
            logger.severe("Host is null for exec step:" + value);
        }
        executionStep.setCredentialRequired(automationAction.isCmdRequiresPassword());
        String auto_user = automationAction.getRunAs();
        String resolved_user = VariableResolver.replaceContextProperties(auto_user, context);
        User user = new User();
        user.setValue(resolved_user);
        executionStep.setUser(user);
        return executionStep;
    }

    public static ExecutionStep getStepWithContext(ActionType automationAction, ConfigGraph g, AbstractBaseTarget t, Host host) {
        CommandContext c = PatchPlanner.getInstance().getOPlanIntgFactory().getContextPopulator().populateContext(g, t, host);
        if (automationAction.isActsOnClone()) {
            PatchPlanner.getInstance().getOPlanIntgFactory().getContextPopulator().fixCloneContext(c);
        }
        ExecutionStep step = CommandUtils.getBasicExecutionStep(automationAction, c, null);
        return step;
    }

    public static boolean shouldShutdownRACInstance(PatchingPhase patchingPhase, String home) {
        if (CommandUtils.isRunningOnInPlaceAutomation(patchingPhase)) {
            return CommandUtils.isInstanceShutdownPatch(home);
        }
        return true;
    }

    private static boolean isInstanceShutdownPatch(String home) {
        ArrayList<OPatchPatchInfo> patchList = SessionData.getInstance().getAnalyzedPatchList(home);
        if (patchList != null && !patchList.isEmpty()) {
            for (OPatchPatchInfo individualPatchInfo : patchList) {
                if (!individualPatchInfo.isComposite()) {
                    if (!individualPatchInfo.isInstanceShutDownPatch()) continue;
                    logger.info("InstanceShutDown true for patchid " + individualPatchInfo.getPatchID());
                    return true;
                }
                if (!individualPatchInfo.isInstanceShutDownPatch()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean isRunningOnInPlaceAutomation(PatchingPhase patchingPhase) {
        return !PhaseType.MIGRATE.equals((Object)patchingPhase.getPhaseType()) && !PhaseType.SWITCHBACK.equals((Object)patchingPhase.getPhaseType()) && !PhaseType.POST_MIGRATE.equals((Object)patchingPhase.getPhaseType()) && !PhaseType.POST_SWITCHBACK.equals((Object)patchingPhase.getPhaseType());
    }

    public static List<GenericPatch> sortPatchesById(List<GenericPatch> patches) {
        ArrayList<GenericPatch> sortedPatches = new ArrayList<GenericPatch>();
        try {
            HashMap<Long, GenericPatch> patchMap = new HashMap<Long, GenericPatch>();
            ArrayList<Long> patchIds = new ArrayList<Long>();
            for (GenericPatch patch : patches) {
                patchMap.put(Long.valueOf(patch.getPatchID()), patch);
                patchIds.add(Long.valueOf(patch.getPatchID()));
            }
            Collections.sort(patchIds);
            for (Long patchId : patchIds) {
                sortedPatches.add((GenericPatch)patchMap.get(patchId));
            }
        }
        catch (NumberFormatException e) {
            sortedPatches = new ArrayList();
            HashMap<String, GenericPatch> patchMap = new HashMap<String, GenericPatch>();
            ArrayList<String> patchIds = new ArrayList<String>();
            for (GenericPatch patch : patches) {
                patchMap.put(patch.getPatchID(), patch);
                patchIds.add(patch.getPatchID());
            }
            Collections.sort(patchIds);
            for (String patchId : patchIds) {
                sortedPatches.add((GenericPatch)patchMap.get(patchId));
            }
        }
        return sortedPatches;
    }

    public static String getCustomLogDir(String intgPath, String oracleHomePath) {
        String OH_IDENTIFIER = "$ORACLE_HOME";
        String customLogPath = intgPath;
        if (intgPath.startsWith("$ORACLE_HOME")) {
            String ohPath = oracleHomePath.endsWith(File.separator) ? oracleHomePath : oracleHomePath + File.separator;
            customLogPath = ohPath + intgPath.substring("$ORACLE_HOME".length() + 1);
        }
        return customLogPath;
    }

    public static List<String> getPatchIDs(List<GenericPatch> patches) {
        ArrayList<String> patchIDList = new ArrayList<String>();
        for (GenericPatch patch : patches) {
            patchIDList.add(patch.getPatchID());
        }
        return patchIDList;
    }

    public static void storePatchIDsInContext(CommandContext context, List<GenericPatch> patches) {
        List<String> patchIDList = CommandUtils.getPatchIDs(patches);
        context.addProperty("patchIDs", patchIDList);
    }

    public static boolean isWindows(OracleHome oh) {
        boolean isWindows = false;
        if (oh == null) {
            return isWindows;
        }
        String platform = oh.getPlatform();
        if (platform != null && platform.toLowerCase().contains("win")) {
            isWindows = true;
        } else if (PatchPlanner.getInstance().getOPlanEnv().isTargetOnWindows()) {
            isWindows = true;
        }
        return isWindows;
    }

    public static boolean isWindowsPlatform() {
        return osName.matches("[W|w]indows*.*");
    }

    public static String getFileSeparator(OracleHome oh) {
        String FILE_SEPARATOR = "/";
        if (CommandUtils.isWindows(oh)) {
            FILE_SEPARATOR = "\\";
        }
        return FILE_SEPARATOR;
    }

    public static String getCopyCommand(OracleHome oh) {
        String COPY_COMMAND = "cp";
        if (CommandUtils.isWindows(oh)) {
            COPY_COMMAND = "copy";
        }
        return COPY_COMMAND;
    }

    public static String getGrepCommand(OracleHome oh) {
        String GREP_COMMAND = "grep";
        if (CommandUtils.isWindows(oh)) {
            GREP_COMMAND = "findstr";
        }
        return GREP_COMMAND;
    }

    public static String getOPatchPath(OracleHome oh) {
        String FILE_SEPARATOR = CommandUtils.getFileSeparator(oh);
        String opatchPath = oh.getPath() + FILE_SEPARATOR + "OPatch" + FILE_SEPARATOR + "opatch";
        return opatchPath;
    }

    public static String getOPatchAutoPath(OracleHome oh) {
        String FILE_SEPARATOR = CommandUtils.getFileSeparator(oh);
        String opatchPath = oh.getPath() + FILE_SEPARATOR + "OPatch" + FILE_SEPARATOR + "opatchauto";
        return opatchPath;
    }

    public static String getInvPtrOption(OracleHome oh) {
        String invPtrOption = "";
        if (CommandUtils.isWindows(oh)) {
            return invPtrOption;
        }
        String invPtrPath = PatchPlanner.getInstance().getOPlanEnv().getProperty("invPtrLoc");
        if (invPtrPath == null) {
            String FILE_SEPARATOR = CommandUtils.getFileSeparator(oh);
            invPtrPath = oh.getPath() + FILE_SEPARATOR + "oraInst.loc";
        }
        invPtrOption = invPtrOption + " -invPtrLoc " + invPtrPath;
        return invPtrOption;
    }

    public static String getApplicabilityTargetType(String homeType) {
        ApplicabilityTarget appTarget = PatchPlanner.getInstance().getOPlanIntgFactory().getApplicabilityTarget();
        return appTarget.valueof(homeType);
    }

    public static boolean shouldIncludeTargetCosDependantsNotSkipped(Command command, ConfigGraph g, AbstractBaseTarget abt, List<? extends AbstractBaseTarget> dependants) {
        if (dependants == null || dependants.isEmpty()) {
            logger.log(Level.FINER, "There are no dependants hence returning true.");
            return true;
        }
        logger.log(Level.FINER, "Checking for dependants: " + dependants + " of: " + abt + " to see if they are being skipped");
        for (AbstractBaseTarget abstractBaseTarget : dependants) {
            if (CommandUtils.isSkipTargetCookieSet(command, abstractBaseTarget)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSkipTargetCookieSet(Command command, AbstractBaseTarget abt) {
        SkipTargetCookie stc = (SkipTargetCookie)abt.getProperty(SkipTargetCookie.class);
        if (stc == null) {
            logger.log(Level.FINEST, "Target: " + abt + " does not have a SkipTargetCookie. Returning false");
            return false;
        }
        if (stc.getApplicablePhaseTypes() != null && stc.getApplicablePhaseTypes().isEmpty()) {
            logger.log(Level.FINEST, "Target: " + abt + " has a SkipTargetCookie applicable to all phases. Current phase type: " + command.getPatchingPhase().getPhaseType() + ". Returning true");
            return true;
        }
        if (stc.getApplicablePhaseTypes() != null && !stc.getApplicablePhaseTypes().isEmpty() && stc.getApplicablePhaseTypes().contains(command.getPatchingPhase().getPhaseType())) {
            logger.log(Level.FINEST, "Target: " + abt + " has a SkipTargetCookie applicable to phases: " + stc.getApplicablePhaseTypes() + " current phase type: " + command.getPatchingPhase().getPhaseType() + " matches. Returning true");
            return true;
        }
        if (stc.getApplicableActionTag() != null && !stc.getApplicableActionTag().isEmpty() && stc.getApplicableActionTag().contains(command.getAutomationAction().getTag())) {
            logger.log(Level.FINEST, "Target: " + abt + " has a SkipTargetCookie applicable to action " + stc.getApplicableActionTag() + " current Action type: " + command.getAutomationAction().getType() + " matches. Returning true");
            return true;
        }
        logger.log(Level.FINEST, "Target: " + abt + " has a SkipTargetCookie applicable to phases: " + stc.getApplicablePhaseTypes() + " current phase type: " + command.getPatchingPhase().getPhaseType() + " does not match matches. Returning false");
        return false;
    }

    public static String getPatchLocationByOHOwner(PatchPackage patchPackage, OracleHome oh) {
        Map<String, Map<String, String>> userPatchLocationMapForPatchID;
        PatchPackagesBag bag = PatchPlanner.getInstance().getOPlanEnv().getPatchesBag();
        if (patchPackage.getPatchLocation() == null || patchPackage.getPatchLocation().equals("")) {
            userPatchLocationMapForPatchID = bag.getUserPatchLocationMapForPatchID();
            logger.info("Fetching patch location for patch " + patchPackage.getPatchID());
            if (userPatchLocationMapForPatchID.containsKey(patchPackage.getPatchID())) {
                logger.info("Exist patch location Map for patch " + patchPackage.getPatchID() + ". Now need to get patch stage location with user" + oh.getOwner());
                Map<String, String> userPatchLocationMap = userPatchLocationMapForPatchID.get(patchPackage.getPatchID());
                if (userPatchLocationMap.containsKey(oh.getOwner())) {
                    if (patchPackage instanceof Bundle) {
                        logger.info("Current patch is a Bundle patch need to check if it have a top lever dir");
                        Bundle bundlePatch = (Bundle)patchPackage;
                        if (bundlePatch.getBundleXmlLoc() != null && bundlePatch.getBundleXmlLoc().indexOf("/") != -1) {
                            logger.info("this is a bundle patch with bundle xml " + bundlePatch.getBundleXmlLoc());
                            return userPatchLocationMap.get(oh.getOwner()) + CommandUtils.getFileSeparator(oh) + patchPackage.getPatchID();
                        }
                        return userPatchLocationMap.get(oh.getOwner());
                    }
                    return userPatchLocationMap.get(oh.getOwner()) + CommandUtils.getFileSeparator(oh) + patchPackage.getPatchID();
                }
            }
        } else {
            return patchPackage.getPatchLocation();
        }
        logger.info("userPatchLocationMapForPatchID is " + userPatchLocationMapForPatchID);
        throw new PatchPlanInternalException("Can not find patchlocation for patch " + patchPackage.getPatchID() + " for user " + oh.getOwner());
    }

    public static List<GenericPatch> getPatchesByOHOwnerForEM(OracleHome oh) {
        assert (oh != null);
        String target = PatchPlanner.getInstance().getOPlanIntgFactory().getApplicabilityTarget().valueof(oh.getHomeType());
        ArrayList<GenericPatch> patches = new ArrayList<GenericPatch>();
        patches.addAll(CommandUtils.getApplicablePatchesFromBundlePatches(target, oh));
        patches.addAll(CommandUtils.getApplicablePatchesFromEsystemPatches(target, oh));
        patches.addAll(CommandUtils.getApplicablePatchesFromGenericPatches(target, oh));
        StringBuffer patchLocations = new StringBuffer();
        for (GenericPatch patch : patches) {
            patchLocations.append(patch.getPatchLocation());
        }
        return patches;
    }

    private static List<GenericPatch> getApplicablePatchesFromBundlePatches(String target, OracleHome oh) {
        ArrayList<GenericPatch> patches = new ArrayList<GenericPatch>();
        List<PatchBundle> bundlePatches = PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getBundlePatches();
        for (PatchBundle bundlePatch : bundlePatches) {
            for (GenericPatch p : bundlePatch.getSubPatches()) {
                if (!CommandUtils.isPatchApplicableForTarget(p, target) || patches.contains(p)) continue;
                GenericPatch patch = CommandUtils.clonePatch(p);
                if (CommandUtils.shouldReplacePatchLocation((PatchPackage)bundlePatch)) {
                    patch.setPatchLocation(CommandUtils.getPatchLocationByOHOwner((PatchPackage)bundlePatch, oh) + p.getPatchLocation());
                }
                patches.add(patch);
            }
        }
        return patches;
    }

    private static List<GenericPatch> getApplicablePatchesFromEsystemPatches(String target, OracleHome oh) {
        ArrayList<GenericPatch> patches = new ArrayList<GenericPatch>();
        List<EngineeredSystemPatch> esysPatches = PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getEngineeredSystemPatches();
        for (EngineeredSystemPatch esysPatch : esysPatches) {
            for (GenericPatch p : esysPatch.getSubPatches()) {
                if (!CommandUtils.isPatchApplicableForTarget(p, target) || patches.contains(p)) continue;
                GenericPatch patch = CommandUtils.clonePatch(p);
                if (CommandUtils.shouldReplacePatchLocation((PatchPackage)esysPatch)) {
                    patch.setPatchLocation(CommandUtils.getPatchLocationByOHOwner((PatchPackage)esysPatch, oh) + p.getPatchLocation());
                }
                patches.add(patch);
            }
        }
        return patches;
    }

    private static List<GenericPatch> getApplicablePatchesFromGenericPatches(String target, OracleHome oh) {
        ArrayList<GenericPatch> patches = new ArrayList<GenericPatch>();
        List<GenericPatch> genericPatches = PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getGenericPatches();
        for (GenericPatch genericPatch : genericPatches) {
            if (!CommandUtils.isPatchApplicableForTarget(genericPatch, target) || patches.contains(genericPatch)) continue;
            GenericPatch patch = CommandUtils.clonePatch(genericPatch);
            if (CommandUtils.shouldReplacePatchLocation((PatchPackage)genericPatch)) {
                patch.setPatchLocation(CommandUtils.getPatchLocationByOHOwner((PatchPackage)genericPatch, oh));
            }
            patches.add(patch);
        }
        return patches;
    }

    private static boolean shouldReplacePatchLocation(PatchPackage patchPackage) {
        return patchPackage.getPatchLocation() == null || patchPackage.getPatchLocation().equals("");
    }

    private static GenericPatch clonePatch(GenericPatch patch) {
        OPatchSingleton clonePatch;
        if (patch instanceof OPatchSingleton) {
            clonePatch = new OPatchSingleton();
        } else if (patch instanceof CompositePatch) {
            clonePatch = new CompositePatch();
            ((CompositePatch)clonePatch).setPatchIdOfRollbackPatch(((CompositePatch)patch).getPatchIdOfRollbackPatch());
        } else {
            clonePatch = new GenericPatch();
        }
        clonePatch.setPatchLocation(patch.getPatchLocation());
        clonePatch.setPatchTool(patch.getPatchTool());
        clonePatch.setPatchID(patch.getPatchID());
        clonePatch.setApplicableTargets(patch.getApplicableTargets());
        return clonePatch;
    }

    private static boolean isPatchApplicableForTarget(GenericPatch patch, String target) {
        for (String at : patch.getApplicableTargets()) {
            if (!target.equalsIgnoreCase(at)) continue;
            return true;
        }
        return false;
    }
}

