/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner;

import com.oracle.cie.common.util.ObjectStoreManager;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.core.oplan.IOUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.PatchPlanException;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandFactory;
import com.oracle.glcm.patch.auto.db.framework.sdk.cookies.MakeCloneHome;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.intg.PatchPlanIntgFactory;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.LogInfo;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanEnv;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanUserException;
import com.oracle.glcm.patch.auto.db.product.DBPatchVersionSelection;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;
import dbmodel.SystemInstance;
import dbmodel.common.Host;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import oracle.dbsysmodel.driver.sdk.productdriver.DummyProductDriver;
import oracle.dbsysmodel.driver.sdk.productdriver.LocalInfo;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriver;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriverException;

public class PatchPlanner {
    Logger logger = Logger.getLogger(PatchPlanner.class.getName());
    boolean runningStandalone = true;
    private Level intgConsoleLogLevel = null;
    private static PatchPlanner oplan;
    private String primaryPatchVersion;
    private PatchPlanLogger logs = new PatchPlanLogger();
    private boolean logsSetup = false;
    private PatchPlanEnv env = new PatchPlanEnv();
    private LogInfo logInfo = null;
    private ProductDriver productDriver;
    private CommandFactory cmdFactory = new CommandFactory();
    private boolean analyzeFailed = false;
    MakeCloneHome cloneHomes;
    SystemInstance systemInstance;
    String systemInstanceFilePath = null;
    ConfigGraph configGraph;
    PatchPlanIntgFactory oplanIntgFactory = null;
    private LocalInfo localInfo = null;
    private boolean isEngSysPatch;

    private PatchPlanner() {
    }

    public static PatchPlanner getInstance() {
        if (oplan == null) {
            oplan = new PatchPlanner();
        }
        return oplan;
    }

    public void cleanup() {
        this.primaryPatchVersion = null;
        this.env = null;
        oplan = null;
        Logger rootLogger = Logger.getLogger("");
        for (Handler h : rootLogger.getHandlers()) {
            rootLogger.removeHandler(h);
        }
        this.intgConsoleLogLevel = null;
        this.logs.resetIntegrationLog();
    }

    public PatchPlanLogger getLogger() {
        return this.logs;
    }

    public LogInfo getLogInfo() {
        return this.logInfo;
    }

    public PatchPlanEnv getOPlanEnv() {
        return this.env;
    }

    public boolean isAnalyzeFailed() {
        return this.analyzeFailed;
    }

    public void setAnalyzeFailed(boolean analyzeFailed) {
        this.analyzeFailed = analyzeFailed;
    }

    public CommandFactory getCommandFactory() {
        PatchPlanIntgFactory oplanIntgFactory = this.getOPlanIntgFactory();
        this.cmdFactory = oplanIntgFactory.getCommandFactory();
        return this.cmdFactory;
    }

    public ProductDriver getProductDriver() {
        if (null == this.productDriver) {
            if (this.env.hasConfigurationSnapshot()) {
                DummyProductDriver dummyProductDriver = this.getOPlanIntgFactory().getDummyProductDriver();
                dummyProductDriver.setDummyConfigFile(this.env.getConfigurationSnapshot());
                this.productDriver = dummyProductDriver;
                return dummyProductDriver;
            }
            this.productDriver = this.getOPlanIntgFactory().getProductDriver();
        }
        return this.productDriver;
    }

    public void setProductDriver(ProductDriver pd) {
        this.productDriver = pd;
    }

    public MakeCloneHome getMakeCloneHome() {
        if (this.cloneHomes == null) {
            this.cloneHomes = this.getOPlanIntgFactory().getMakeCloneHome(this.getConfigGraph(), this.getLocalInfo());
        }
        return this.cloneHomes;
    }

    public void tryWriteConfig(SystemInstance si, File configFile) {
        try {
            si.writeFile(configFile);
        }
        catch (FileNotFoundException e) {
            this.logger.log(Level.SEVERE, "Failed to write system configuration file", e);
        }
    }

    public void makeConfigSnapshot(File snapshotFile) {
        this.logs.setupLogs();
        if (this.env.hasConfigurationSnapshot()) {
            DummyProductDriver dummyProductDriver = this.getOPlanIntgFactory().getDummyProductDriver();
            dummyProductDriver.setDummyConfigFile(this.env.getConfigurationSnapshot());
            this.productDriver = dummyProductDriver;
        } else {
            this.productDriver = this.getOPlanIntgFactory().getProductDriver();
        }
        SystemInstance si = this.productDriver.constructSystemInstance();
        this.tryWriteConfig(si, snapshotFile);
        this.logs.resetIntegrationLog();
    }

    public void setSystemInstance(SystemInstance si) {
        this.systemInstance = si;
        if (this.configGraph != null) {
            this.setConfigGraph(null);
        }
    }

    public boolean haveInitIntgFactory() {
        return this.oplanIntgFactory != null;
    }

    public SystemInstance getSystemInstance() {
        if (this.systemInstance == null) {
            this.productDriver = this.getProductDriver();
            try {
                this.systemInstance = this.productDriver.constructSystemInstance();
                if (this.configGraph != null) {
                    this.setConfigGraph(null);
                }
            }
            catch (PatchPlanUserException e) {
                throw e;
            }
            catch (ProductDriverException e) {
                e.printStackTrace();
                throw this.getResolvedProductDriverException(e);
            }
            catch (Exception e) {
                throw new PatchPlanUserException(e, "COULD_NOT_COLLECT_PRODUCT_INFO", e.getLocalizedMessage(), this.getLogInfo().getLogFile().getAbsolutePath());
            }
        }
        return this.systemInstance;
    }

    public void setSystemInstanceFilePath(String systemInstanceFilePath) {
        this.systemInstanceFilePath = systemInstanceFilePath;
    }

    public String getSystemInstanceFilePath() {
        return this.systemInstanceFilePath;
    }

    public void setConfigGraph(ConfigGraph cg) {
        this.configGraph = cg;
    }

    public ConfigGraph getConfigGraph(SystemInstance si) {
        if (this.configGraph == null) {
            this.logger.info("ConfigGraph is null, get config graph from system instance");
            assert (si != null);
            if (si == null) {
                throw new IllegalArgumentException("SystemInstance cannot be null");
            }
            Host localhost = null;
            if (this.localInfo != null) {
                localhost = this.localInfo.getLocalHost();
                this.logger.info("get localhost " + localhost != null ? localhost.getHostName() : "null");
            } else if (this.productDriver != null) {
                this.localInfo = this.productDriver.getLocalInfo();
                if (this.productDriver.getLocalInfo() != null) {
                    localhost = this.productDriver.getLocalInfo().getLocalHost();
                    this.logger.info("get localhost from product driver " + localhost != null ? localhost.getHostName() : "null");
                }
            }
            this.configGraph = this.getOPlanIntgFactory().getConfigGraph(si, localhost);
        }
        return this.configGraph;
    }

    public ConfigGraph getConfigGraph() {
        return this.getConfigGraph(this.getSystemInstance());
    }

    public void setDBPlanInstgFactory(PatchPlanIntgFactory oplanIntgFactory) {
        this.oplanIntgFactory = oplanIntgFactory;
    }

    public void loadOPlanIntgFactory(String intgClass) {
        try {
            this.oplanIntgFactory = (PatchPlanIntgFactory)Class.forName(intgClass).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new PatchPlanException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new PatchPlanException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new PatchPlanException(e.getMessage(), e);
        }
    }

    public PatchPlanIntgFactory getOPlanIntgFactory() {
        if (this.oplanIntgFactory != null) {
            return this.oplanIntgFactory;
        }
        if (this.env.getProperty("IntgFactoryClass") != null) {
            this.loadOPlanIntgFactory(this.env.getProperty("IntgFactoryClass"));
            return this.oplanIntgFactory;
        }
        throw new PatchPlanException("Have not init OPlanIntgFactory object");
    }

    public void setLocalInfo(LocalInfo localInfo) {
        this.localInfo = localInfo;
    }

    public LocalInfo getLocalInfo() {
        if (this.localInfo != null) {
            return this.localInfo;
        }
        if (this.getProductDriver() != null) {
            this.logger.finest("The product driver is not null, so get local info from product driver.");
            this.localInfo = this.getProductDriver().getLocalInfo();
        }
        return this.localInfo;
    }

    protected void printFileLocations() {
        this.logger.finest("Starting: printing plan summary");
        try {
            this.getLogInfo().printLogSummary();
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Could not print summary", e);
        }
        this.logger.finest("End: printing plan summary");
    }

    public boolean isEngSysPatch() {
        if (this.primaryPatchVersion == null) {
            DBPatchVersionSelection patchVersionSelection = new DBPatchVersionSelection();
            this.primaryPatchVersion = patchVersionSelection.getPrimaryPatchVersion();
            this.isEngSysPatch = patchVersionSelection.isEngSysPatch();
        }
        return this.isEngSysPatch;
    }

    public void setEngSysPatch(boolean isEngSysPatch) {
        this.isEngSysPatch = isEngSysPatch;
    }

    public String getPrimaryPatchVersion() {
        if (this.primaryPatchVersion == null) {
            DBPatchVersionSelection patchVersionSelection = new DBPatchVersionSelection();
            this.primaryPatchVersion = patchVersionSelection.getPrimaryPatchVersion();
            this.isEngSysPatch = patchVersionSelection.isEngSysPatch();
        }
        return this.primaryPatchVersion;
    }

    public void setPrimaryPatchVersion(String primaryPatchVersion) {
        this.primaryPatchVersion = primaryPatchVersion;
    }

    protected static void addDefaultProperties(Properties planProps) {
        planProps.put("OracleHome", System.getenv("ORACLE_HOME"));
    }

    public RuntimeException getResolvedProductDriverException(ProductDriverException e) {
        switch (e.getType()) {
            case IncompatibleProductVersion: {
                return new PatchPlanUserException(e, "IncompatibleProductVersion-PD-Exception", e.getMessage());
            }
            case ConfigurationNotSupported: {
                return new PatchPlanUserException(e, "ConfigurationNotSupported-PD-Exception", e.getMessage());
            }
        }
        return new PatchPlanUserException(e, "COULD_NOT_COLLECT_PRODUCT_INFO", e.getMessage(), this.getLogInfo().getLogFile().getAbsolutePath());
    }

    public boolean isRunningStandalone() {
        return this.runningStandalone;
    }

    public void setRunningStandalone(boolean runningStandalone) {
        this.runningStandalone = runningStandalone;
    }

    public static void print2Console(String message) {
        System.out.println(message);
    }

    public class PatchPlanLogger {
        public void setupLogs(String logDir) {
            PatchPlanner.this.env.setProperty("logDir", logDir);
            this.setupLogs();
        }

        public void resetIntegrationLog() {
            Logger rootLogger;
            if (PatchPlanner.this.intgConsoleLogLevel != null && (rootLogger = Logger.getLogger("")).getHandlers().length >= 1 && rootLogger.getHandlers()[0] instanceof ConsoleHandler) {
                rootLogger.getHandlers()[0].setLevel(PatchPlanner.this.intgConsoleLogLevel);
                PatchPlanner.this.intgConsoleLogLevel = null;
            }
        }

        public void setupLogs() {
            Logger rootLogger = Logger.getLogger("");
            if (rootLogger.getHandlers().length >= 1 && rootLogger.getHandlers()[0] instanceof ConsoleHandler) {
                PatchPlanner.this.intgConsoleLogLevel = rootLogger.getHandlers()[0].getLevel();
                rootLogger.getHandlers()[0].setLevel(PatchPlanner.this.env.getConsoleLogLevel());
            }
            if (PatchPlanner.this.logsSetup) {
                return;
            }
            Logger oplanLogger = Logger.getLogger("oracle.oplan");
            Logger osysLogger = Logger.getLogger("oracle.osysmodel");
            Logger modelLogger = Logger.getLogger("model");
            oplanLogger.setLevel(Level.ALL);
            osysLogger.setLevel(Level.ALL);
            modelLogger.setLevel(Level.ALL);
            try {
                File logDir = PatchPlanner.this.env.getLogDir();
                if (logDir.equals(PatchPlanner.this.env.getTargetHomeLogDir())) {
                    boolean created;
                    if (!logDir.exists() && !(created = logDir.mkdirs())) {
                        throw new PatchPlanUserException("DIRECTORY_CREATION_FAILED", logDir.getAbsolutePath());
                    }
                    IOUtils.chmodTo775(logDir, this.getPassword());
                } else {
                    if (!logDir.exists()) {
                        logDir.mkdirs();
                    }
                    IOUtils.chmodTo775(logDir, this.getPassword());
                }
                if (this.checkAndRemoveLogHandles(oplanLogger, osysLogger, modelLogger)) {
                    PatchPlanner.this.logInfo = new LogInfo(logDir);
                    File logFile = PatchPlanner.this.logInfo.getLogFile().getAbsoluteFile();
                    FileHandler fh = new FileHandler(logFile.getAbsolutePath());
                    fh.setFormatter(new SimpleFormatter());
                    fh.setLevel(PatchPlanner.this.env.getLogFileLevel());
                    oplanLogger.addHandler(fh);
                    osysLogger.addHandler(fh);
                    modelLogger.addHandler(fh);
                }
            }
            catch (Exception e) {
                throw new PatchPlanUserException(e, "UNABLE_TO_CREATE_LOGS", e.getMessage());
            }
            PatchPlanner.this.logsSetup = true;
        }

        private byte[] getPassword() throws UnknownHostException {
            Logger logger = Logger.getLogger(IOUtils.class.getName());
            MutablePatchSession patchSession = (MutablePatchSession)ObjectStoreManager.getObjectStore((String)"opatchauto").retrieveObject((Object)"patch.session");
            byte[] passWd = null;
            String hostName = InetAddress.getLocalHost().getHostName();
            if (hostName != null) {
                if (hostName.indexOf(".") != -1) {
                    hostName = hostName.substring(0, hostName.indexOf("."));
                }
                CredentialManager credentialMgr = patchSession.getCredentialManager();
                try {
                    Credential credential = credentialMgr.getCredential(hostName);
                    if (credential != null) {
                        passWd = new String(credential.getPassword()).getBytes();
                    }
                }
                catch (OPatchAutoException e) {
                    logger.severe("No credential available for host " + hostName);
                }
            }
            return passWd;
        }

        private boolean checkAndRemoveLogHandles(Logger oplanLogger, Logger osysLogger, Logger modelLogger) {
            boolean haveRemovedHandle = false;
            if (!PatchPlanner.this.logsSetup || oplanLogger.getHandlers().length == 0 || osysLogger.getHandlers().length == 0 || modelLogger.getHandlers().length == 0) {
                this.removeLogHandles(oplanLogger);
                this.removeLogHandles(osysLogger);
                this.removeLogHandles(modelLogger);
                haveRemovedHandle = true;
            }
            return haveRemovedHandle;
        }

        private void removeLogHandles(Logger logger) {
            Handler[] handles = logger.getHandlers();
            for (int i = 0; i < handles.length; ++i) {
                logger.removeHandler(handles[i]);
            }
        }
    }
}

