/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner;

import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanInternalException;
import dbmodel.BaseClass;
import dbmodel.common.AbstractBaseTarget;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SystemModelUtils {
    static Logger logger = Logger.getLogger(SystemModelUtils.class.getName());

    public static Object getTargetProperty(BaseClass b, String propName) {
        logger.log(Level.INFO, "Base Class: " + b.getClass() + " PropertyName: " + propName + " Value: " + b.getAttributes().get(propName));
        return b.getAttributes().get(propName);
    }

    public static Class<? extends AbstractBaseTarget> getClassForType(String type) {
        String[] packages;
        for (String pack : packages = new String[]{"dbmodel.common", "dbmodel.sample", "dbmodel.db_crs", "dbmodel.idm", "dbmodel.exadata", "dbmodel.exalogic", "dbmodel.exalytics", "dbmodel.siebel"}) {
            try {
                return Class.forName(pack + "." + type).asSubclass(AbstractBaseTarget.class);
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new PatchPlanInternalException("Could not find target model class of type " + type);
    }
}

