/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.cie.common.util.FileUtils;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.PatchLevelQuery;
import com.oracle.glcm.patch.auto.db.product.patchlevel.OracleHomePatchLevel;
import com.oracle.glcm.patch.auto.db.product.patchlevel.OracleHomePatchLevelReporter;
import com.oracle.glcm.patch.auto.session.PatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Host;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

public class OOPPatchLevelUpdater {
    public void persistPatchInformation(PatchSession patchSession, PatchTarget patchTarget, List<OPatchPatchInfo> patchInfoList) throws OPatchAutoException {
        OOPSessionInfoHandler instance = OOPSessionInfoHandler.getInstance();
        String cloneHomePath = FileUtils.getFile((String)patchTarget.getHomeClone().getLocation()).getPath();
        if (patchTarget.getHome(true).isSharedHome()) {
            this.updateOOPSessionInfoForLocalHome(patchTarget, patchInfoList, instance, cloneHomePath);
            for (Home home : patchTarget.getHome(true).getSharedHomeList()) {
                OOPSessionInfo oopSessionInfo = instance.getOOPSessionInfo(home.getHost().getHost());
                if (oopSessionInfo == null) continue;
                oopSessionInfo.getPatchLevelOnNodes().addOracleHomePatchLevel(cloneHomePath, patchInfoList);
            }
        } else {
            this.updateOOPSessionInfoForLocalHome(patchTarget, patchInfoList, instance, cloneHomePath);
        }
        if (!patchSession.isAnalyze()) {
            String oopSessionFilePath = instance.getSessionFilePath();
            instance.saveOOPSessionCookie(oopSessionFilePath);
        }
    }

    private void updateOOPSessionInfoForLocalHome(PatchTarget patchTarget, List<OPatchPatchInfo> patchInfoList, OOPSessionInfoHandler instance, String cloneHomePath) {
        OOPSessionInfo oopSessionInfo = instance.getOOPSessionInfo(patchTarget.getHome(true).getHost().getHost());
        if (oopSessionInfo != null) {
            oopSessionInfo.getPatchLevelOnNodes().addOracleHomePatchLevel(cloneHomePath, patchInfoList);
        }
    }

    public List<OPatchPatchInfo> getPatchList(PatchTarget patchTarget) throws OPatchAutoException {
        Iterator<List<OPatchPatchInfo>> iterator;
        OracleHomePatchLevelReporter patchLevelReporter = new OracleHomePatchLevelReporter();
        PatchLevelQuery reportingListener = new PatchLevelQuery(true);
        ArrayList<Host> hosts = new ArrayList<Host>();
        Host hostClone = patchTarget.getHost().getShallowCopy();
        hostClone.addHome(patchTarget.getHomeClone());
        hosts.add(hostClone);
        patchLevelReporter.report(hosts, reportingListener);
        if (!StringUtil.isNullOrEmpty((String)reportingListener.getFailureMessage(), (boolean)true)) {
            throw new OPatchAutoException(reportingListener.getFailureMessage(), new Object[0]);
        }
        OracleHomePatchLevel oracleHomePatchLevel = reportingListener.getPatchInfoList(patchTarget.getHost());
        if (oracleHomePatchLevel != null && (iterator = oracleHomePatchLevel.getOracleHomePatchLevel().values().iterator()).hasNext()) {
            return iterator.next();
        }
        return new ArrayList<OPatchPatchInfo>();
    }
}

