/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.cie.remote.RemoteConnectionHost;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.utils.BootstrapUtil;
import com.oracle.glcm.patch.auto.lifecycle.FinalizePhase;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RemoteDeleteAction
extends DBCommonPatchAction {
    public RemoteDeleteAction() {
        super(new Goal[]{FinalizePhase.Goal.finalize});
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        return targetList;
    }

    @Override
    public boolean isRemoteExecutionHandled(PatchTarget patchTarget) throws OPatchAutoException {
        return true;
    }

    public boolean isAnalyzeSupported() {
        return true;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (isActionRequired) {
            try {
                isActionRequired = BootstrapUtil.isPerlPatch() && patchTarget.isRemote();
            }
            catch (OPatchAutoException oPatchAutoException) {
                // empty catch block
            }
        }
        return isActionRequired;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ExecutionStep executionStep = new ExecutionStep();
        ArrayList<ExecutionStep> executionList = new ArrayList<ExecutionStep>();
        executionList.add(executionStep);
        return executionList;
    }

    @Override
    protected PatchActionResult executeSteps(List<ExecutionStep> executionSteps, PatchTarget patchTarget) throws OPatchAutoException {
        PatchActionResult result = new PatchActionResult();
        this._logger.info("Executing steps for deleting perl folder on host " + patchTarget.getHost());
        if (BootstrapUtil.isPerlPatch() && patchTarget.isRemote()) {
            RemoteConnectionHandler handler = null;
            try {
                handler = OPatchAutoHelper.getRemoteConnectionManager().getRemoteConnectionHandler((RemoteConnectionHost)patchTarget.getHost());
                String tmpPerlLocation = patchTarget.getHome().getLocation() + DBCommonPatchingConstants.PERL_COPIED_PATH;
                String perlLocation = tmpPerlLocation.replace("$HOST_NAME", patchTarget.getHost().getHost());
                if (!handler.exists(perlLocation)) {
                    String opatchAutoDBTmpFolder = patchTarget.getHome().getLocation() + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP;
                    String dbTmpFolders = handler.exec("ls " + opatchAutoDBTmpFolder);
                    if (!StringUtil.isNullOrEmpty((String)dbTmpFolders)) {
                        String[] folders;
                        dbTmpFolders = dbTmpFolders.trim();
                        for (String folder : folders = dbTmpFolders.split("\n")) {
                            if (!folder.contains("bootstrap_")) continue;
                            perlLocation = opatchAutoDBTmpFolder + folder.trim() + File.separator + "perl";
                        }
                    }
                }
                if (handler.exists(perlLocation)) {
                    this._logger.fine("Deleting perl folder " + perlLocation + " on host " + patchTarget.getHost());
                    handler.deleteOnClose(perlLocation);
                }
            }
            catch (RemoteConnectionException e) {
                throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72157), (Object[])new Object[]{patchTarget.getHome().getLocation(), patchTarget.getHost().getHost()}), new Object[0]);
            }
            finally {
                if (null != handler) {
                    handler.close();
                }
            }
        }
        return result;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        return "";
    }
}

