/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.crs;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.OnlineAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OnlinePhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;

public class RACOnlineAction
extends OnlineAction {
    public RACOnlineAction() {
        super((Goal)OnlinePhase.Goal.product_patching);
    }

    @Override
    protected boolean isPatchApplicabilityCheckRequired(PatchTarget patchTarget) {
        return !patchTarget.getHome().isSharedHome();
    }

    @Override
    public List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        boolean isTwelveVersion = DBPatchingUtil.isDBVersionTweleveOrLater(primarypatchVersion);
        ArrayList<ExecutionStep> generatedSteps = new ArrayList<ExecutionStep>();
        List<ExecutionStep> steps = null;
        if (isTwelveVersion) {
            steps = this.getStartRedoApplyCommandExecutionSteps(configGraph, patchTarget, null, "RACDatabase");
            generatedSteps.addAll(steps);
        }
        boolean actsOnClone = patchTarget.isUsingHomeClone();
        if (isTwelveVersion) {
            boolean isSQLPatchInUpgradeMode = DBCommandUtils.isSQLPatchUpgradeMode();
            if (isSQLPatchInUpgradeMode) {
                steps = this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchDisableCluster.toString(), "RACDatabase", "SQL-Disable-Cluster-Step-Title", actsOnClone);
                generatedSteps.addAll(steps);
                if (this.isSQLUpgrdeModeCommandRequired(steps)) {
                    steps = this.getStopStartOracleHomeCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.stopOnAllHost.toString(), "rac", ServiceStatus.DOWN, "OracleHome", "Stop-Home-Title", "Stop-Home-Message");
                    generatedSteps.addAll(steps);
                }
                steps = this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchStartupUpgradeMode.toString(), "RACDatabase", "SQL-Startup-Upgrade-Mode-Step-Title", actsOnClone);
                generatedSteps.addAll(steps);
                if (this.isSQLUpgrdeModeCommandRequired(steps)) {
                    steps = this.getUpgradePDBStateCommandExecutionSteps(configGraph, patchTarget, "RACDBInstance");
                    generatedSteps.addAll(steps);
                }
            }
            if (this.getPatchSession().isRollback()) {
                if (DBPatchingHelper.isOOPSwitchPatchingSession(this.getPatchSession().getOptions())) {
                    steps = this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchSwitchback.toString(), "RACDatabase", actsOnClone);
                    generatedSteps.addAll(steps);
                }
                steps = this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchRollback.toString(), "RACDatabase", actsOnClone);
                generatedSteps.addAll(steps);
            } else {
                steps = this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchApply.toString(), "RACDatabase", actsOnClone);
                generatedSteps.addAll(steps);
            }
            if (isSQLPatchInUpgradeMode) {
                steps = this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchEnableCluster.toString(), "RACDatabase", "SQL-Startup-Enable-Cluster-Step-Title", actsOnClone);
                generatedSteps.addAll(steps);
                if (this.isSQLUpgrdeModeCommandRequired(steps)) {
                    steps = this.getStopStartOracleHomeCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.startOnAllHost.toString(), "rac", ServiceStatus.UP, "OracleHome", "Start-Home-Title", "Start-Home-Message");
                    generatedSteps.addAll(steps);
                    steps = this.getStartPDBStateCommandExecutionSteps(configGraph, patchTarget, "RACDBInstance");
                    generatedSteps.addAll(steps);
                }
            }
        }
        return generatedSteps;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        return targetList;
    }
}

