/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.crs;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBShutDownStartupAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.CommandFailureException;
import com.oracle.glcm.patch.auto.db.product.executor.ExecutionResult;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.lifecycle.ShutdownPhase;
import com.oracle.glcm.patch.auto.plan.PatchPlanManager;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.HomeImpl;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;

public class RACShutDownAction
extends DBShutDownStartupAction {
    public RACShutDownAction() {
        super(new Goal[]{ShutdownPhase.Goal.shutdown, OfflinePhase.Goal.finalize_binary_patching});
    }

    public int getOrderingWeight(Goal goal) {
        if (goal.equals(OfflinePhase.Goal.finalize_binary_patching)) {
            return 40;
        }
        return super.getOrderingWeight(goal);
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isRequired = super.isActionRequired(patchTarget);
        if (!isRequired) {
            return isRequired;
        }
        if (((HomeImpl)patchTarget.getHome()).isGIMRHome()) {
            return false;
        }
        boolean oopPatchingSession = DBPatchingHelper.isOOPPatchingSession(this.getPatchSession().getOptions());
        PatchPlanManager patchPlanManager = this.getPatchSession().getPatchPlanManager();
        Set patchTargetList = patchPlanManager.getPatchTargets();
        boolean hasCRSPatching = DBPatchingHelper.hasCRSPatching(patchTargetList);
        boolean isRHPPatching = DBPatchingHelper.hasRHPPatching(patchTargetList, this.getPatchSession());
        boolean isCRSPatchingSkipped = DBPatchingHelper.isCRSPatchingSkipped(patchTargetList, isRHPPatching);
        String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        boolean isNonRollingMode = DBPatchingHelper.isNonRollingMode(this.getPatchSession().getOptions());
        isRequired = isNonRollingMode || patchTarget.getType().equals(DBProductTypes.PRODUCT_TYPE_RAC_SHARED.getValue()) || !DBPatchingHelper.areAllRacOneDatabase(patchTarget) && (oopPatchingSession || !this.isGIPatchingRequestedForTwelveDB(primarypatchVersion, isCRSPatchingSkipped));
        boolean bl = isRequired = isRequired && ClusterInformationLoader.getInstance().isStackRunning();
        if (!hasCRSPatching && oopPatchingSession) {
            isRequired = false;
        }
        return isRequired;
    }

    @Override
    protected ExecutionResult runCommand(PatchTarget patchTarget, ExecutionStep executionStep) throws CommandFailureException {
        ExecutionResult status = super.runCommand(patchTarget, executionStep);
        if (status != null && status.isSuccessful()) {
            for (ExecutionStep.Command command : executionStep.getCommand()) {
                if (command.getValue().indexOf("srvctl") == -1) continue;
                String listOfDBStopped = this.listOfDatabasesStopped(command.getValue());
                if (listOfDBStopped == null || listOfDBStopped.length() <= 0) break;
                Reporting.report((String)this.getLocalizedString("ShutdownAction.racdatabase.down.message", listOfDBStopped));
                break;
            }
        }
        return status;
    }

    @Override
    public List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        List<ExecutionStep> generatedSteps = super.generateSteps(patchTarget);
        List<ExecutionStep> steps = this.getStopOracleHomeCommandExecutionSteps(this.configGraph, patchTarget, "rac", "OracleHome");
        generatedSteps.addAll(steps);
        this._logger.fine("steps1 " + steps.size());
        this._logger.fine("steps2 " + steps.toString());
        return generatedSteps;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC_SHARED.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC_NONSHARED.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        return targetList;
    }
}

