/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.oop;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.CommandDetailsGenerator;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandParameters;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.session.MutablePatchTarget;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.Home;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.PatchingPhase;
import oracle.opatch.system.db.automation.jaxb.PhaseType;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;
import oracle.opatch.system.db.automation.jaxb.Strategy;
import oracle.opatch.system.db.automation.jaxb.Stripe;

public class CopyHomePatchAction
extends DBCommonPatchAction {
    public CopyHomePatchAction() {
        super(new Goal[]{OfflinePhase.Goal.prepare});
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        return DBPatchingHelper.isOOPPreparePatchingSession(this.getPatchSession().getOptions()) || DBPatchingHelper.isSingleOOPPatchingSession(this.getPatchSession().getOptions());
    }

    public boolean isLocalParallelExecutionSupported() {
        return true;
    }

    public boolean isRemoteParallelExecutionSupported() {
        return true;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    public int getOrderingWeight(Goal goal) {
        return 10;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        List<ExecutionStep> steps = null;
        if (patchTarget.getHome().isSharedHome() && !OOPSessionInfoHandler.getInstance().isFirstNode(patchTarget)) {
            steps = new ArrayList<ExecutionStep>();
        } else {
            ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
            byte[] pass = this.getPassword(patchTarget);
            boolean isRSync = false;
            GISystemCall.ExecReturn ret = GISystemCall.process("which rsync", null, pass);
            isRSync = ret.isOK();
            this._logger.fine("Found rsync command:" + isRSync);
            steps = this.getCopyHomeCommandExecutionSteps(configGraph, patchTarget, isRSync);
        }
        return steps;
    }

    private List<ExecutionStep> getCopyHomeCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget, boolean isRSync) throws OPatchAutoException {
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        if (isRSync) {
            argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, DBCommandActionType.RSyncDBHome.toString());
        } else {
            argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, DBCommandActionType.CopyDBHome.toString());
        }
        argList.put(CommandDetailsGenerator.ActionTypeParams.RUN_AS, DBCommandParameters.GLOBAL_ROOT_USER.getValue());
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Copy-Oh-Title");
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_MSG_KEY, "Copy-Oh-Message");
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.COMMAND_ACTION, argList);
        actionType.setActsOn("OracleHome");
        Stripe stripe = CommandDetailsGenerator.getStripe(DBPatchingHelper.getStripeName(patchTarget), DBPatchingHelper.getTargetHomeFromProductType(patchTarget), null);
        actionType.setStripe(stripe);
        PatchingPhase phase = CommandDetailsGenerator.generatePatchingPhase(PhaseType.APPLY, ServiceStatus.UP);
        Command stopStartDBConsoleCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        List<ExecutionStep> steps = this.getsteps(configGraph, patchTarget, actionType, stopStartDBConsoleCommand);
        return steps;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("CopyHomePatchAction.start.message", patchTarget.toReportingString());
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("CopyHomePatchAction.success.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("CopyHomePatchAction.failure.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }

    @Override
    public void postExecute(PatchTarget patchTarget, PatchActionResult patchActionResult) throws OPatchAutoException {
        super.postExecute(patchTarget, patchActionResult);
        if (patchActionResult.isFailure()) {
            return;
        }
        if (this.getPatchSession().getPatchTracking() != null) {
            OracleHome cloneHome = null;
            ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
            List<OracleHome> oracleHomes = configGraph.getTargets(OracleHome.class);
            for (OracleHome oh : oracleHomes) {
                if (!oh.getPath().equalsIgnoreCase(patchTarget.getHome().getLocation())) continue;
                cloneHome = PatchPlanner.getInstance().getMakeCloneHome().getHomeClone(oh).get(0);
                break;
            }
            Home clonePatchTarget = patchTarget.getHome().getShallowCopy();
            clonePatchTarget.setLocation(cloneHome.getPath());
            ((MutablePatchTarget)patchTarget).setHomeClone(clonePatchTarget);
            Reporting.report((String)("Clone of oracle home " + patchTarget.getHome(true).getLocation() + " is " + cloneHome.getPath() + " on host " + patchTarget.getHost().getHost()));
        }
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIHA.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        return targetList;
    }
}

