/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.oop;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.User;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.helper.util.HelperUtility;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.db_crs.CRSCluster;
import dbmodel.db_crs.HAS;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.Readme;
import oracle.opatch.system.db.automation.jaxb.UserMessage;

public class CopyOBHPatchAction
extends DBCommonPatchAction {
    private String old_OBH;
    private String new_OBH;

    public CopyOBHPatchAction() {
        super(new Goal[]{OfflinePhase.Goal.prepare});
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            this._logger.fine("Action is not required for this target");
            return isActionRequired;
        }
        if (DBPatchingHelper.isOOPPreparePatchingSession(this.getPatchSession().getOptions()) || DBPatchingHelper.isSingleOOPPatchingSession(this.getPatchSession().getOptions())) {
            this.old_OBH = HelperUtility.detectOraBaseHome((String)patchTarget.getHome().getLocation());
            this._logger.fine("OBH of the original home is " + this.old_OBH);
            this.new_OBH = HelperUtility.detectOraBaseHome((String)patchTarget.getHomeClone().getLocation());
            this._logger.fine("OBH for the cloned home is " + this.new_OBH);
            if (!OUIDriver.areLocationsSame((String)this.old_OBH, (String)this.new_OBH)) {
                if (!OUIDriver.areLocationsSame((String)patchTarget.getHome().getLocation(), (String)this.old_OBH)) {
                    return true;
                }
                this._logger.fine("Action will be skipped as the old OBH is same as the home.");
            } else {
                this._logger.fine("Action will be skipped as the OBH location has not changed.");
            }
        } else {
            this._logger.fine("Action wil be skipped as there is no prepare phase required");
        }
        this._logger.fine("Status will be set to skipped.");
        return false;
    }

    public boolean isLocalParallelExecutionSupported() {
        return true;
    }

    public boolean isRemoteParallelExecutionSupported() {
        return true;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    public int getOrderingWeight(Goal goal) {
        return 45;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ArrayList<ExecutionStep> executionList = new ArrayList<ExecutionStep>();
        if (patchTarget.getHome().isSharedHome() && !OOPSessionInfoHandler.getInstance().isFirstNode(patchTarget)) {
            this._logger.fine("No command to be executed on this node of the shared home");
            return executionList;
        }
        byte[] pass = this.getPassword(patchTarget);
        boolean isRSync = false;
        GISystemCall.ExecReturn ret = GISystemCall.process("which rsync", null, pass);
        isRSync = ret.isOK();
        this._logger.fine("Found rsync command: " + isRSync);
        String cmd = this.getCopyOBHCommand(patchTarget, isRSync);
        if (!StringUtil.isNullOrEmpty((String)cmd, (boolean)true)) {
            this._logger.fine("Command generated ::" + cmd);
            ActionType actionType = new ActionType();
            UserMessage titleKey = new UserMessage();
            titleKey.setPropertyKey("Copy-OBH-Title");
            UserMessage msgKey = new UserMessage();
            msgKey.setPropertyKey("Copy-OBH-Message");
            Readme readMe = new Readme();
            readMe.setTitle(titleKey);
            readMe.setMessage(msgKey);
            actionType.setReadme(readMe);
            ExecutionStep executionStep = new ExecutionStep(actionType);
            executionStep.getCommand().add(new ExecutionStep.Command(cmd));
            String ohOwner = null;
            ohOwner = !DBPatchingHelper.isStaticConfiguration(this.getPatchSession().getOptions()) ? OUIDriver.checkFileOwner((File)new File(patchTarget.getHome(true).getLocation(), "oraInst.loc")) : System.getProperty("user.name");
            User user = new User();
            user.setValue(ohOwner);
            executionStep.setUser(user);
            Host host = new Host();
            host.setDisplayName(patchTarget.getHost().getHost());
            host.setName(patchTarget.getHost().getHost());
            executionStep.setHost(host);
            executionList.add(executionStep);
        } else {
            this._logger.fine("Skipping action to copy contents to the new OBH.");
        }
        return executionList;
    }

    private String getCopyOBHCommand(PatchTarget patchTarget, boolean isRSync) throws OPatchAutoException {
        StringBuilder copyOBHCmd = new StringBuilder();
        AbstractBaseTarget root = PatchPlanner.getInstance().getConfigGraph().getRootVertex();
        boolean isSidbPatching = !(root instanceof CRSCluster) && !(root instanceof HAS);
        this.old_OBH = HelperUtility.detectOraBaseHome((String)patchTarget.getHome().getLocation());
        if (!this.old_OBH.endsWith(File.separator)) {
            this.old_OBH = this.old_OBH + File.separator;
        }
        if (DBPatchingHelper.isGenerateStepCommand(this.getPatchSession().getOptions())) {
            this.new_OBH = "$NEW_ORACLEBASE_HOME";
        } else {
            this.new_OBH = HelperUtility.detectOraBaseHome((String)patchTarget.getHomeClone().getLocation());
            if (!this.new_OBH.endsWith(File.separator)) {
                this.new_OBH = this.new_OBH + File.separator;
            }
        }
        this._logger.fine("Destination OBH is " + this.new_OBH);
        File newOBHDir = new File(this.new_OBH);
        if (!newOBHDir.exists()) {
            copyOBHCmd.append("mkdir -p " + this.new_OBH + " ; ");
            this._logger.info("Creating OBH directory " + this.new_OBH);
        }
        this._logger.fine("Source OBH is " + this.old_OBH);
        if (isRSync) {
            copyOBHCmd.append("rsync -a --exclude 'cfgtoollogs' " + this.old_OBH + " " + this.new_OBH);
        } else {
            copyOBHCmd.append("cd " + this.old_OBH + "; cp -pR `ls -A | grep -v cfgtoollogs` " + this.new_OBH);
        }
        return copyOBHCmd.toString();
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("CopyOBHPatchAction.start.message", patchTarget.toReportingString());
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("CopyOBHPatchAction.success.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("CopyOBHPatchAction.failure.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIHA.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        return targetList;
    }
}

