/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.sdb;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.topology.DBHomeImpl;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PatchActionUtil;
import com.oracle.glcm.patch.auto.db.integration.controller.action.sdb.SDBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductSupport;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.shard.ShardDBProductTypes;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.ExecutionResult;
import com.oracle.glcm.patch.auto.db.product.summary.DBPatchingSummaryCreator;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryID;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.InitPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.SystemInstance;
import dbmodel.db_crs.SIDatabase;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DGOGGPatchAction
extends SDBCommonPatchAction {
    public DGOGGPatchAction() {
        super(new Goal[]{InitPhase.Goal.init});
    }

    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        try {
            String dgOption = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.DG.getValue()).getValue();
            String shdGrpOption = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.SHARD_GROUP.getValue()).getValue();
            String shdSpcOption = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.SHARD_SPACE.getValue()).getValue();
            String parentIdOption = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.PARENTID.getValue()).getValue();
            return (dgOption != null || shdGrpOption != null || shdSpcOption != null) && parentIdOption != null;
        }
        catch (Exception e) {
            throw new PatchActionException("Exception : " + e.getMessage(), new Object[0]);
        }
    }

    @Override
    protected String createSteps(PatchTarget patchTarget) throws OPatchAutoException {
        return this.createOhSteps(patchTarget);
    }

    @Override
    public void prepareRemoteActionExecutionHost(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws RemoteConnectionException, PatchActionException {
        super.prepareRemoteActionExecutionHost(handler, container);
        SystemInstance sysInst = PatchPlanner.getInstance().getSystemInstance();
        DBHomeImpl homeImpl = (DBHomeImpl)((PatchTarget)container.getPatchTargets().iterator().next()).getHome();
        String dbName = homeImpl.getTargetName();
        String dbType = homeImpl.getTargetType();
        if (null != dbType && dbType.equalsIgnoreCase("sidb_only")) {
            container.addPatchActionParameter("DBTYPE", (Object)dbType);
            this.writeSysInstValueForSIDBToContainer(container, this.getDBTmpLocation(), dbName, sysInst);
        }
    }

    protected void writeSysInstValueForSIDBToContainer(PatchActionExecutorContainer container, String dbTmpLocation, String dbName, SystemInstance sysInst) {
        if (sysInst != null) {
            List siDatabases = sysInst.getTargetsOfType(SIDatabase.class);
            for (SIDatabase sidb : siDatabases) {
                if (!sidb.getName().equalsIgnoreCase(dbName)) continue;
                String remoteInstanceDir = dbTmpLocation + "instance" + File.separator;
                container.addPatchActionParameter("topology", (Object)remoteInstanceDir);
            }
        }
    }

    @Override
    protected ExecutionResult.CommandExecutionResult executeScript(PatchTarget patchTarget, String executionStep) throws OPatchAutoException {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(PatchActionUtil.getBashCmd());
        cmds.add("-c");
        cmds.add(executionStep);
        String sessionId = this.getPatchSession().getProductSupportManager().getOptions().getOption("session").getValue();
        if (executionStep.contains(this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.REPORT_ANALYZE_FAILURE.getValue()).getArg())) {
            this.reportAnalyzeFailure = true;
        }
        ExecutionResult.CommandExecutionResult result = PatchActionUtil.execute(cmds, sessionId, patchTarget, this.reportAnalyzeFailure, this.getPatchSession().getCredentialManager());
        return result;
    }

    public void postExecute(PatchTarget patchTarget, PatchActionResult patchActionResult) throws OPatchAutoException {
        if (patchActionResult != null) {
            this._logger.info("IS RESUMED : " + this.getPatchSession().getCommand().isResumed());
            DBPatchingSummaryCreator summaryCreator = ((DBProductSupport)this.getPatchSession().getProductSupportManager().getProductSupport("db")).getDBPatchingSummaryCreator(this.getPatchSession().getCommand());
            StringBuilder summary = new StringBuilder();
            if (patchActionResult.getDetailsList() != null && !patchActionResult.getDetailsList().isEmpty() && this.getPatchSession().getPatchTracking() != null) {
                if (this.reportAnalyzeFailure) {
                    this.helper.prepSummaryForReportAnalyzeFailure(patchTarget, patchActionResult, summaryCreator, summary, this.getPatchSession().getCredentialManager());
                }
                if (StringUtil.isNullOrEmpty((String)summary.toString())) {
                    for (String tmp : patchActionResult.getDetailsList()) {
                        StringBuilder summaryOutput;
                        if (patchActionResult.isFailure()) {
                            if (tmp.contains("reason :")) {
                                summary.append(tmp);
                                continue;
                            }
                            summaryOutput = this.processCommandFailure(patchTarget, tmp);
                            summary.append((CharSequence)summaryOutput);
                            continue;
                        }
                        summaryOutput = this.processOHCommandOutput(summaryCreator, patchTarget, tmp, false);
                        summary.append((CharSequence)summaryOutput);
                    }
                }
                if (this.getPatchSession().getCommand().isResumed()) {
                    summaryCreator.storePatchingSummary(2, SummaryID.shard_patching, patchTarget, summary.toString());
                } else if (patchActionResult.isFailure() && !this.getPatchSession().isAnalyze()) {
                    summary.append(this.getLocalizedString("PatchAction.command.failure.resume", new Object[0]));
                    summaryCreator.storePatchingSummary(0, SummaryID.shard_patching, patchTarget, summary.toString());
                } else {
                    summaryCreator.storePatchingSummary(0, SummaryID.shard_patching, patchTarget, summary.toString());
                }
            }
        }
    }

    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        DBHomeImpl home = (DBHomeImpl)patchTarget.getHome();
        String operation = "";
        if (this.getPatchSession().getCommand().isApply()) {
            operation = "apply";
        } else if (this.getPatchSession().getCommand().isRollback()) {
            operation = "rollback";
        }
        if (this.getPatchSession().isAnalyze()) {
            operation = operation + " [analyze]";
        }
        String dbName = home.getTargetName();
        switch (status) {
            case incomplete: {
                if (home.isOgg() || !StringUtil.isNullOrEmpty((String)home.getShardGroupName()) || !StringUtil.isNullOrEmpty((String)home.getShardSpaceName())) {
                    statusMsg = this.getLocalizedString("DGOGGPatchAction.start.message", operation, "", dbName, patchTarget.getHost().getHost(), home.getLocation());
                    break;
                }
                if (home.isPrimary()) {
                    statusMsg = this.getLocalizedString("DGOGGPatchAction.start.message", operation, "primary", dbName, patchTarget.getHost().getHost(), home.getLocation());
                    break;
                }
                statusMsg = this.getLocalizedString("DGOGGPatchAction.start.message", operation, "standby", dbName, patchTarget.getHost().getHost(), home.getLocation());
                break;
            }
            case failure: {
                if (home.isOgg() || !StringUtil.isNullOrEmpty((String)home.getShardGroupName()) || !StringUtil.isNullOrEmpty((String)home.getShardSpaceName())) {
                    statusMsg = this.getLocalizedString("DGOGGPatchAction.failure.message", operation, "", dbName, patchTarget.getHost().getHost(), home.getLocation());
                    break;
                }
                if (home.isPrimary()) {
                    statusMsg = this.getLocalizedString("DGOGGPatchAction.failure.message", operation, "primary", dbName, patchTarget.getHost().getHost(), home.getLocation());
                    break;
                }
                statusMsg = this.getLocalizedString("DGOGGPatchAction.failure.message", operation, "standby", dbName, patchTarget.getHost().getHost(), home.getLocation());
                break;
            }
            case warning: {
                if (home.isOgg() || !StringUtil.isNullOrEmpty((String)home.getShardGroupName()) || !StringUtil.isNullOrEmpty((String)home.getShardSpaceName())) {
                    statusMsg = this.getLocalizedString("DGOGGPatchAction.warning.message", operation, "", dbName, patchTarget.getHost().getHost(), home.getLocation());
                    break;
                }
                if (home.isPrimary()) {
                    statusMsg = this.getLocalizedString("DGOGGPatchAction.warning.message", operation, "primary", dbName, patchTarget.getHost().getHost(), home.getLocation());
                    break;
                }
                statusMsg = this.getLocalizedString("DGOGGPatchAction.warning.message", operation, "standby", dbName, patchTarget.getHost().getHost(), home.getLocation());
                break;
            }
            case success: {
                if (home.isOgg() || !StringUtil.isNullOrEmpty((String)home.getShardGroupName()) || !StringUtil.isNullOrEmpty((String)home.getShardSpaceName())) {
                    statusMsg = this.getLocalizedString("DGOGGPatchAction.success.message", operation, "", dbName, patchTarget.getHost().getHost(), home.getLocation());
                    break;
                }
                if (home.isPrimary()) {
                    statusMsg = this.getLocalizedString("DGOGGPatchAction.success.message", operation, "primary", dbName, patchTarget.getHost().getHost(), home.getLocation());
                    break;
                }
                statusMsg = this.getLocalizedString("DGOGGPatchAction.success.message", operation, "standby", dbName, patchTarget.getHost().getHost(), home.getLocation());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        statusMsg = this.addTag(statusMsg);
        return statusMsg;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(ShardDBProductTypes.PRODUCT_TYPE_PRIMARY.getValue());
        targetList.add(ShardDBProductTypes.PRODUCT_TYPE_STANDBY.getValue());
        targetList.add(ShardDBProductTypes.PRODUCT_TYPE_DATABASE.getValue());
        return targetList;
    }

    @Override
    protected String createOhSteps(PatchTarget patchTarget) throws OPatchAutoException {
        String cmd = super.createOhSteps(patchTarget);
        if (!cmd.contains(DBCommonPatchingConstants.OPATCHAUTO_SCRIPT + " " + OPatchAutoCommand.resume + " ")) {
            String deployOnlyOption = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.DEPLOY_ONLY.getValue()).getValue();
            String reportAnalyzeFailOption = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.REPORT_ANALYZE_FAILURE.getValue()).getValue();
            if (!StringUtil.isNullOrEmpty((String)deployOnlyOption)) {
                cmd = cmd + " " + this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.DEPLOY_ONLY.getValue()).getArg();
            } else {
                cmd = cmd + " " + this.getPatchSession().getProductSupportManager().getOptions().getOption("analyze").getArg();
                if (!StringUtil.isNullOrEmpty((String)reportAnalyzeFailOption)) {
                    cmd = cmd + " " + this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.REPORT_ANALYZE_FAILURE.getValue()).getArg();
                }
            }
            DBHomeImpl homeImpl = (DBHomeImpl)patchTarget.getHome();
            String dbType = homeImpl.getTargetType();
            if (!StringUtil.isNullOrEmpty((String)dbType) && dbType.equalsIgnoreCase("sidb_only")) {
                String localInstanceDir = OPatchAutoHelper.getOPatchAutoHome() + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_SDB_INSTANCE;
                String topologyKey = this.getPatchSession().getProductSupportManager().getOptions().getOption("topology").getArg();
                String topologyFile = topologyKey + " " + localInstanceDir + "opatch_sidb_" + homeImpl.getTargetName() + "_config.xml ";
                cmd = cmd + " " + topologyFile + " " + " -sidbonly ";
            }
            if (!homeImpl.getOwner().equals(System.getProperty("user.name"))) {
                cmd = PatchActionUtil.runAsOwner(cmd, patchTarget, homeImpl.getOwner(), this.getPatchSession().getCredentialManager());
            }
            this._logger.info("WARNING: This command must not be executed manually in the command line : " + PatchActionUtil.replacePwdFrmCmd(cmd));
        }
        return cmd;
    }
}

