/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.sdb;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.topology.DBHomeImpl;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PatchActionUtil;
import com.oracle.glcm.patch.auto.db.integration.controller.action.sdb.SDBPatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.sdb.helper.SDBPatchActionHelper;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductSupport;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.shard.ShardDBProductTypes;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.summary.DBPatchingSummaryCreator;
import com.oracle.glcm.patch.auto.lifecycle.InitPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.util.HashSet;
import java.util.Set;

public class SDBGIPatchAction
extends SDBPatchAction {
    @Override
    protected StringBuilder processCommandFailure(PatchTarget target, String outputMsg) {
        StringBuilder outputBuff = new StringBuilder();
        this.helper = new SDBPatchActionHelper();
        outputBuff.append((CharSequence)super.processCommandFailure(target, outputMsg));
        outputBuff.append((CharSequence)this.helper.logOutput(target, outputMsg));
        outputBuff.append("\n");
        return outputBuff;
    }

    protected StringBuilder processFailureOutput(DBPatchingSummaryCreator summaryCreator, PatchTarget target) throws OPatchAutoException {
        StringBuilder outputBuff = new StringBuilder();
        String summaryFileName = "patchingsummary";
        this.populateFailureSummary(summaryCreator, target, outputBuff, summaryFileName);
        return outputBuff;
    }

    public void postExecute(PatchTarget patchTarget, PatchActionResult patchActionResult) throws OPatchAutoException {
        this.helper = new SDBPatchActionHelper();
        if (patchActionResult != null) {
            this._logger.info("IS RESUMED : " + this.getPatchSession().getCommand().isResumed());
            DBPatchingSummaryCreator summaryCreator = ((DBProductSupport)this.getPatchSession().getProductSupportManager().getProductSupport("db")).getDBPatchingSummaryCreator(this.getPatchSession().getCommand());
            StringBuilder summary = new StringBuilder();
            if (patchActionResult.getDetailsList() != null && !patchActionResult.getDetailsList().isEmpty() && this.getPatchSession().getPatchTracking() != null) {
                if (this.reportAnalyzeFailure) {
                    this.helper.prepSummaryForReportAnalyzeFailure(patchTarget, patchActionResult, summaryCreator, summary, this.getPatchSession().getCredentialManager());
                }
                if (StringUtil.isNullOrEmpty((String)summary.toString())) {
                    for (String tmp : patchActionResult.getDetailsList()) {
                        StringBuilder summaryOutput = new StringBuilder();
                        if (patchActionResult.isFailure()) {
                            if (!tmp.contains(this.getLocalizedString("PatchAction.patch.summaryfor.message", new Object[0]))) {
                                summary.append((CharSequence)this.helper.getSummarySubHeader(patchTarget, true, this.getPatchSession()));
                            }
                            if (tmp.contains("reason :")) {
                                summary.append(tmp);
                                continue;
                            }
                            summaryOutput = this.processFailureOutput(summaryCreator, patchTarget);
                            summary.append((CharSequence)summaryOutput);
                            summary.append(tmp);
                            continue;
                        }
                        summaryOutput = this.processOHCommandOutput(summaryCreator, patchTarget, tmp, true);
                        summary.append((CharSequence)summaryOutput);
                    }
                }
                super.postExecute(patchTarget, patchActionResult, summary);
            }
        }
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        DBHomeImpl homeImpl = (DBHomeImpl)patchTarget.getHome();
        String execStartTime = PatchActionUtil.getCurrentDate();
        String execEndTime = PatchActionUtil.getCurrentDate();
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("SDBPatchAction.start.grid.message", homeImpl.getLocation(), execStartTime);
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("SDBPatchAction.failure.grid.message", homeImpl.getLocation(), execEndTime);
                break;
            }
            case warning: {
                statusMsg = this.getLocalizedString("SDBPatchAction.warning.grid.message", homeImpl.getLocation(), execEndTime);
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("SDBPatchAction.success.grid.message", homeImpl.getLocation(), execEndTime);
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(ShardDBProductTypes.PRODUCT_TYPE_SIHA_SDB.getValue());
        targetList.add(ShardDBProductTypes.PRODUCT_TYPE_CRS_SDB.getValue());
        return targetList;
    }

    @Override
    protected String createSteps(PatchTarget patchTarget) throws OPatchAutoException {
        String cmd = super.createOhSteps(patchTarget);
        if (!cmd.contains(DBCommonPatchingConstants.OPATCHAUTO_SCRIPT + " " + OPatchAutoCommand.resume + " ")) {
            DBHomeImpl homeImpl;
            if (this.getPatchSession().getCurrentGoal().equals(InitPhase.Goal.init)) {
                cmd = cmd + " " + this.getPatchSession().getProductSupportManager().getOptions().getOption("analyze").getArg();
                if (!this.getPatchSession().isAnalyze()) {
                    cmd = cmd + " " + this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.REPORT_ANALYZE_FAILURE.getValue()).getArg();
                }
            } else {
                cmd = cmd + " " + this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.DEPLOY_ONLY.getValue()).getArg();
            }
            if (!(homeImpl = (DBHomeImpl)patchTarget.getHome()).getOwner().equals(System.getProperty("user.name"))) {
                cmd = PatchActionUtil.runAsOwner(cmd, patchTarget, homeImpl.getOwner(), this.getPatchSession().getCredentialManager());
            }
            this._logger.info("WARNING: This command must not be executed manually in the command line : " + PatchActionUtil.replacePwdFrmCmd(cmd));
        }
        return cmd;
    }
}

