/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.sdb.helper;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.credential.ValueHolder;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.topology.DBHomeImpl;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PatchActionUtil;
import com.oracle.glcm.patch.auto.db.integration.controller.action.sdb.RemoteAnalysisStatusRetriever;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.shard.ShardDBProductTypes;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.summary.DBPatchingSummaryCreator;
import com.oracle.glcm.patch.auto.db.product.summary.Summary;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryID;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryTarget;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryTargetList;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.InitPhase;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;
import com.oracle.glcm.patch.auto.session.PatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.HostImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;

public class SDBPatchActionHelper {
    protected final Logger _logger = Logger.getLogger(this.getClass().getName());

    public StringBuilder logOutput(PatchTarget target, String outputMsg) {
        StringBuilder outputBuff = new StringBuilder();
        String logFile = this.getLogFileFrmConsole(outputMsg);
        String fileMsg = "";
        if (logFile != null) {
            DBHomeImpl home = (DBHomeImpl)target.getHome();
            if (home.isDg()) {
                fileMsg = "\n\n" + this.getLocalizedString("PatchAction.dg.log.summary.host", target.getHost().getHost(), logFile);
            } else if (!StringUtil.isNullOrEmpty((String)home.getShardGroupName())) {
                fileMsg = "\n\n" + this.getLocalizedString("PatchAction.shardgroup.log.summary.host", target.getHost().getHost(), logFile);
            } else if (!StringUtil.isNullOrEmpty((String)home.getShardSpaceName())) {
                fileMsg = "\n\n" + this.getLocalizedString("PatchAction.shardspace.log.summary.host", target.getHost().getHost(), logFile);
            }
        }
        outputBuff.append(fileMsg);
        outputBuff.append("\n");
        return outputBuff;
    }

    public String getLogFileFrmConsole(String outputMsg) {
        String logFile = null;
        if (outputMsg != null && outputMsg.indexOf(this.getLocalizedString("PatchAction.sessionlog.summary", new Object[0])) != -1) {
            int sessionIndex = 19 + outputMsg.indexOf(this.getLocalizedString("PatchAction.sessionlog.summary", new Object[0]));
            String modOutput = outputMsg.substring(sessionIndex);
            logFile = modOutput.substring(0, 4 + modOutput.indexOf(".log"));
        }
        return logFile;
    }

    private String getLocalizedString(String name, Object ... messageFormatting) {
        return OPatchAutoHelper.getLocalizedString((String)name, (Object[])messageFormatting);
    }

    public StringBuilder createTargetSummary(PatchTarget target, String host) {
        StringBuilder outputBuff = new StringBuilder();
        DBHomeImpl homeImpl = (DBHomeImpl)target.getHome();
        String type = target.getProductType().getType();
        outputBuff.append("\n");
        if (type.equalsIgnoreCase(ShardDBProductTypes.PRODUCT_TYPE_CRS_SDB.getValue())) {
            outputBuff.append("\n" + DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        } else if (type.equalsIgnoreCase(ShardDBProductTypes.PRODUCT_TYPE_SIHA_SDB.getValue())) {
            outputBuff.append("\n" + DBProductTypes.PRODUCT_TYPE_SIHA.getValue());
        } else if (type.equalsIgnoreCase(ShardDBProductTypes.PRODUCT_TYPE_DATABASE.getValue()) || type.equalsIgnoreCase(ShardDBProductTypes.PRODUCT_TYPE_OGG_DATABASE.getValue())) {
            outputBuff.append("\ndatabase");
        } else {
            outputBuff.append("\n" + type.toString() + " database");
        }
        outputBuff.append(" name : " + homeImpl.getTargetName());
        if (host != null) {
            outputBuff.append("\nhost : " + host);
        } else {
            outputBuff.append("\nhost : " + target.getHost().getHost());
        }
        outputBuff.append("\nhome : " + homeImpl.getLocation());
        return outputBuff;
    }

    public String copySummaryFileFromTmp(String summaryFileName, RemoteConnectionHandler handler, String remoteLoc, HostImpl host) throws OPatchAutoException {
        String localXmlPath = OPatchAutoHelper.getOPatchAutoHome() + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_SDB_INSTANCE;
        String localXmlFile = localXmlPath + summaryFileName + "_" + host.getHost() + ".xml";
        this._logger.fine("remoteLoc : " + remoteLoc);
        this._logger.fine("localXmlFile : " + localXmlFile);
        try {
            String owner = FileUtility.checkFileOwner((File)new File(OPatchAutoHelper.getOPatchAutoHome(), DBCommonPatchingConstants.OPATCHAUTO_DB_SCRIPT));
            boolean ok = DBPatchingUtil.mkdirs(localXmlPath, owner, null);
            if (!ok) {
                throw new OPatchAutoException("Unable to create the dir : " + localXmlPath, new Object[0]);
            }
            DBPatchingUtil.createNewFile(localXmlFile, owner, null);
        }
        catch (OPatchAutoException e2) {
            this._logger.throwing("Detailed Exception while trying to get the localhome : ", e2.getMessage(), e2);
            throw new OPatchAutoException("Exception while trying to get the localhome : " + e2.getMessage(), new Object[0]);
        }
        try {
            if (handler.exists(remoteLoc)) {
                handler.get(remoteLoc, new File(localXmlFile));
            }
        }
        catch (RemoteConnectionException e) {
            this._logger.throwing("Detailed Exception while getting remote xml path : ", e.getMessage(), e);
        }
        String summaryFile = localXmlFile;
        new File(localXmlFile).deleteOnExit();
        return summaryFile;
    }

    public void deleteCopiedSummaryFile(PatchTarget target, String summaryFileName, RemoteConnectionHandler handler, String remoteLoc) throws OPatchAutoException {
        if (target.isRemote()) {
            this._logger.info("Deleting remote summary file : " + remoteLoc + " on host " + target.getHost().getHost());
            String command = "rm -rf " + remoteLoc;
            try {
                if (handler.exists(remoteLoc)) {
                    handler.exec(command);
                }
            }
            catch (RemoteConnectionException e) {
                this._logger.throwing("Detailed Exception while deleting remote xml path : ", e.getMessage(), e);
            }
        } else {
            String localXmlFile = OPatchAutoHelper.getOPatchAutoHome() + DBCommonPatchingConstants.OPATCH_AUTO_DBSESSIONINFO + summaryFileName + ".xml";
            this._logger.info("Deleting local summary file : " + localXmlFile + " on host " + target.getHost().getHost());
            if (new File(localXmlFile).exists()) {
                new File(localXmlFile).delete();
            }
        }
    }

    public StringBuilder createSummary(DBPatchingSummaryCreator summaryCreator, PatchTarget target, String summaryFile, boolean isFailure, boolean isSdbPass) {
        StringBuilder buff = new StringBuilder();
        try {
            Set<SummaryID> summaryIDSet = summaryCreator.getSummaryIDList(summaryFile);
            if (summaryIDSet != null) {
                for (SummaryID id : summaryIDSet) {
                    SummaryTargetList targetList = summaryCreator.getSummary(summaryFile, id);
                    if (targetList == null) continue;
                    for (Map.Entry<SummaryTarget, Summary> summaryEntry : targetList.getSummaryList().entrySet()) {
                        if (isSdbPass || isFailure) {
                            buff.append("\n" + summaryEntry.getValue().getSummaryDetails());
                            continue;
                        }
                        buff.append((CharSequence)this.createTargetSummary(target, summaryEntry.getKey().getHost()));
                        buff.append("\nstatus : " + summaryEntry.getValue().getSummaryDetails());
                    }
                }
            }
            Set<SummaryID> genSummaryIDSet = summaryCreator.getGeneralSummaryIDList(summaryFile);
            if (summaryIDSet != null) {
                for (SummaryID id : genSummaryIDSet) {
                    List<String> genSummaryLst = summaryCreator.getGeneralSummary(summaryFile, id);
                    if (genSummaryLst == null) continue;
                    buff.append("\n\n");
                    for (String summary : genSummaryLst) {
                        buff.append(summary);
                    }
                }
            }
        }
        catch (Exception e) {
            this._logger.throwing("Detailed Exception while reading summary : ", e.getMessage(), e);
        }
        return buff;
    }

    public StringBuilder getSummarySubHeader(PatchTarget target, boolean issdb, PatchSession patchSession) {
        StringBuilder buff = new StringBuilder();
        DBHomeImpl homeImpl = (DBHomeImpl)target.getHome();
        String type = target.getProductType().getType();
        try {
            String shardGroupOption = patchSession.getProductSupportManager().getOptions().getOption(DBProductParameterConstants.SHARD_GROUP.getValue()).getValue();
            String shardSpaceOption = patchSession.getProductSupportManager().getOptions().getOption(DBProductParameterConstants.SHARD_SPACE.getValue()).getValue();
            String dgOption = patchSession.getProductSupportManager().getOptions().getOption(DBProductParameterConstants.DG.getValue()).getValue();
            if (issdb) {
                if (type.equalsIgnoreCase(ShardDBProductTypes.PRODUCT_TYPE_CRS_SDB.getValue()) || type.equalsIgnoreCase(ShardDBProductTypes.PRODUCT_TYPE_SIHA_SDB.getValue())) {
                    buff.append(this.getLocalizedString("PatchAction.patch.summary.message", homeImpl.getTargetName()));
                } else if (!StringUtil.isNullOrEmpty((String)dgOption)) {
                    buff.append(this.getLocalizedString("PatchAction.patch.summary.drset.message", homeImpl.getDrsetNumber()));
                } else if (!StringUtil.isNullOrEmpty((String)shardGroupOption)) {
                    buff.append(this.getLocalizedString("PatchAction.patch.summary.shardgroup.message", homeImpl.getShardGroupName()));
                } else if (!StringUtil.isNullOrEmpty((String)shardSpaceOption)) {
                    if (homeImpl.isOgg()) {
                        buff.append(this.getLocalizedString("PatchAction.patch.summary.shardspace.message", homeImpl.getShardSpaceName()));
                    } else {
                        buff.append(this.getLocalizedString("PatchAction.patch.summary.drset.message", homeImpl.getDrsetNumber()));
                    }
                } else if (homeImpl.isOgg()) {
                    if (homeImpl.getShardingType().equalsIgnoreCase("user-defined")) {
                        buff.append(this.getLocalizedString("PatchAction.patch.summary.shardspace.message", homeImpl.getShardSpaceName()));
                    } else {
                        buff.append(this.getLocalizedString("PatchAction.patch.summary.shardgroup.message", homeImpl.getShardGroupName()));
                    }
                } else {
                    buff.append(this.getLocalizedString("PatchAction.patch.summary.drset.message", homeImpl.getDrsetNumber()));
                }
                buff.append("\n------------------------------------------------------");
            }
        }
        catch (OPatchAutoException e) {
            this._logger.warning("Unable to display the correct sub header \n" + (Object)((Object)e));
        }
        return buff;
    }

    public boolean isPatchBaseDir(String patchBaseDir) {
        boolean isPatchbaseDir = false;
        if (!StringUtil.isNullOrEmpty((String)patchBaseDir)) {
            isPatchbaseDir = true;
        }
        return isPatchbaseDir;
    }

    public String readParentSessionId(String dbname, String hostName) throws OPatchAutoException {
        String rootId = null;
        try {
            BufferedReader inputFile = new BufferedReader(new FileReader(SessionData.getConfigDir() + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR + "sessioninfo.txt"));
            String line = inputFile.readLine();
            if (StringUtil.isNullOrEmpty((String)line)) {
                inputFile.close();
                throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72091), (Object[])new Object[]{dbname, hostName}), new Object[0]);
            }
            rootId = line.toString();
            inputFile.close();
        }
        catch (Exception ex) {
            this._logger.throwing("Detailed Execption while reading parent session id file : ", ex.getMessage(), ex);
            throw new OPatchAutoException("Exception in reading parent session id file : \n" + ex.getMessage(), new Object[0]);
        }
        return rootId;
    }

    public void populateSummary(DBPatchingSummaryCreator summaryCreator, PatchTarget target, StringBuilder outputBuff, String summaryFileName) throws OPatchAutoException {
        String summaryFile = "/tmp/" + summaryFileName + ".xml";
        RemoteConnectionHandler handler = null;
        String remoteLoc = "";
        if (target.isRemote()) {
            HostImpl host = (HostImpl)target.getHome().getHost();
            handler = PatchActionUtil.getHandler(host);
            remoteLoc = target.getHome().getLocation() + DBCommonPatchingConstants.OPATCH_AUTO_DBSESSIONINFO + summaryFileName + ".xml";
            summaryFile = this.copySummaryFileFromTmp(summaryFileName, handler, remoteLoc, host);
        }
        outputBuff.append((CharSequence)this.createSummary(summaryCreator, target, summaryFile, false, false));
        this.deleteCopiedSummaryFile(target, summaryFileName, handler, remoteLoc);
    }

    public StringBuilder makeFailureOutput(PatchTarget target, String errorOutput, PatchSession patchSession) {
        StringBuilder outputBuff1 = new StringBuilder();
        outputBuff1.append((CharSequence)this.createTargetSummary(target, target.getHost().getHost()));
        if (patchSession.isAnalyze()) {
            outputBuff1.append("\nstatus : " + this.getLocalizedString("PatchAction.log.failure.analyze.summary", new Object[0]));
        } else if (patchSession.isRollback()) {
            outputBuff1.append("\nstatus : " + this.getLocalizedString("PatchAction.log.failure.rollback.summary", new Object[0]));
        } else {
            outputBuff1.append("\nstatus : " + this.getLocalizedString("PatchAction.log.failure.apply.summary", new Object[0]));
        }
        outputBuff1.append("\nreason : " + errorOutput.trim());
        outputBuff1.append("\n");
        return outputBuff1;
    }

    public void setupRemoteActionExecutionEnvironment(MutablePatchSession patchSession, PatchActionExecutorContainer container) throws PatchActionException {
        String patchId = null;
        if (patchSession.isRollback()) {
            patchId = (String)container.getPatchActionParameterValue("id");
        }
        try {
            if (!StringUtil.isNullOrEmpty(patchId, (boolean)true)) {
                patchSession.setPatchInfo(null, null, patchId);
            } else {
                String zipLocation = (String)container.getPatchActionParameterValue(DBProductParameterConstants.PATCH_ZIP_FILE_LOC.getValue());
                System.setProperty(DBProductParameterConstants.PATCH_ZIP_FILE_LOC.getValue(), zipLocation);
                patchSession.setPatchInfo((String)container.getPatchActionParameterValue("patch.location"), (String)container.getPatchActionParameterValue("patch.base.directory"), null);
                String family = (String)container.getPatchActionParameterValue(DBProductParameterConstants.FAMILY.getValue());
                String shardGroupOption = (String)container.getPatchActionParameterValue(DBProductParameterConstants.SHARD_GROUP.getValue());
                String shardSpaceOption = (String)container.getPatchActionParameterValue(DBProductParameterConstants.SHARD_SPACE.getValue());
                String dgOption = (String)container.getPatchActionParameterValue(DBProductParameterConstants.DG.getValue());
                String sessionId = (String)container.getPatchActionParameterValue("session");
                String inPlaceOption = (String)container.getPatchActionParameterValue(DBProductParameterConstants.IN_PLACE_KEY.getValue());
                String deployOnlyOption = (String)container.getPatchActionParameterValue(DBProductParameterConstants.DEPLOY_ONLY.getValue());
                String reportAnalyzeFailOption = (String)container.getPatchActionParameterValue(DBProductParameterConstants.REPORT_ANALYZE_FAILURE.getValue());
                if (!StringUtil.isNullOrEmpty((String)family)) {
                    patchSession.getProductSupportManager().getOptions().getOption(DBProductParameterConstants.FAMILY.getValue()).setValue(family);
                }
                if (!StringUtil.isNullOrEmpty((String)shardGroupOption)) {
                    patchSession.getProductSupportManager().getOptions().getOption(DBProductParameterConstants.SHARD_GROUP.getValue()).setValue(shardGroupOption);
                }
                if (!StringUtil.isNullOrEmpty((String)shardSpaceOption)) {
                    patchSession.getProductSupportManager().getOptions().getOption(DBProductParameterConstants.SHARD_SPACE.getValue()).setValue(shardSpaceOption);
                }
                if (!StringUtil.isNullOrEmpty((String)dgOption)) {
                    patchSession.getProductSupportManager().getOptions().getOption(DBProductParameterConstants.DG.getValue()).setValue(dgOption);
                }
                if (null != sessionId) {
                    patchSession.getProductSupportManager().getOptions().getOption("session").setValue(sessionId);
                }
                if (!StringUtil.isNullOrEmpty((String)inPlaceOption)) {
                    patchSession.getProductSupportManager().getOptions().getOption(DBProductParameterConstants.IN_PLACE_KEY.getValue()).setValue(inPlaceOption);
                }
                if (!StringUtil.isNullOrEmpty((String)deployOnlyOption)) {
                    patchSession.getProductSupportManager().getOptions().getOption(DBProductParameterConstants.DEPLOY_ONLY.getValue()).setValue(deployOnlyOption);
                }
                if (!StringUtil.isNullOrEmpty((String)reportAnalyzeFailOption)) {
                    patchSession.getProductSupportManager().getOptions().getOption(DBProductParameterConstants.REPORT_ANALYZE_FAILURE.getValue()).setValue(reportAnalyzeFailOption);
                }
            }
        }
        catch (OPatchAutoException e) {
            throw new PatchActionException((Throwable)e);
        }
        this.readWalletFromContainer(patchSession, container);
        if (((Boolean)container.getPatchActionParameterValue(OPatchAutoCommand.resume.toString())).booleanValue()) {
            patchSession.getCommand().setResumed(true);
        }
    }

    private void readWalletFromContainer(MutablePatchSession patchSession, PatchActionExecutorContainer container) throws PatchActionException {
        CredentialManager credentialManager = new CredentialManager();
        String wallet = (String)container.getPatchActionParameterValue("wallet");
        if (!StringUtil.isNullOrEmpty((String)wallet, (boolean)true)) {
            try {
                ValueHolder valueHolder = (ValueHolder)container.getPatchActionParameterValue("value.holder");
                credentialManager.setWallet(new File(wallet), valueHolder != null ? valueHolder.getValue() : null);
            }
            catch (OPatchAutoException e) {
                throw new PatchActionException("Unable to configure wallet in credential manager.", (Throwable)e, new Object[0]);
            }
        }
        patchSession.setCredentialManager(credentialManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isChildSessionPresent(String oh, String sessionId, boolean isDGOGGSession, Goal goal) throws IOException {
        String searchText;
        boolean isPresent = false;
        File rootSessionFile = new File(SessionData.getConfigDir() + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR + "rootSessionInfoFile.txt");
        if (goal.equals(InitPhase.Goal.init)) {
            if (!isDGOGGSession) return false;
            searchText = "ANALYZE:" + sessionId + ":";
        } else {
            searchText = "DEPLOY:" + sessionId + ":";
        }
        if (!rootSessionFile.exists() || StringUtil.isNullOrEmpty((String)searchText)) return isPresent;
        BufferedReader br = null;
        try {
            String currentLine;
            br = new BufferedReader(new FileReader(rootSessionFile.getAbsolutePath()));
            while ((currentLine = br.readLine()) != null) {
                if (!currentLine.startsWith(searchText)) continue;
                isPresent = true;
            }
            return isPresent;
        }
        finally {
            if (null != br) {
                br.close();
            }
        }
    }

    public void prepSummaryForReportAnalyzeFailure(PatchTarget patchTarget, PatchActionResult patchActionResult, DBPatchingSummaryCreator summaryCreator, StringBuilder summary, CredentialManager credentialManager) throws OPatchAutoException {
        boolean hasAnalyzeFailed = RemoteAnalysisStatusRetriever.getInstance().retrieveRemoteAnalyzeStatus(patchTarget, credentialManager);
        if (hasAnalyzeFailed) {
            String summaryFileName = "patchingsummary";
            StringBuilder outputBuff = new StringBuilder();
            this.populateSummary(summaryCreator, patchTarget, outputBuff, summaryFileName);
            summary.append((CharSequence)outputBuff);
            if (!StringUtil.isNullOrEmpty((String)summary.toString())) {
                for (String tmp : patchActionResult.getDetailsList()) {
                    summary.append(tmp);
                }
            }
        }
    }
}

