/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.core.oplan.IOUtils;
import com.oracle.glcm.patch.auto.db.framework.topology.DBHomeImpl;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PatchActionUtil;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.TopologyBuilder;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.sdb.PseudoSDBTopoBuilder;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.summary.DBPatchingSummaryCreator;
import com.oracle.glcm.patch.auto.db.utils.SDBRemoteFileHandler;
import com.oracle.glcm.patch.auto.db.utils.helper.SDBRemoteFileHandlerHelper;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.topology.Topology;
import com.oracle.helper.util.HelperUtility;
import dbmodel.SystemInstance;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.dbsysmodel.driver.sdk.productdriver.constants.ProductDriverConstants;
import oracle.dbsysmodel.driver.sdk.util.OsysUtility;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProductSupportHelper {
    private static final Logger _log = Logger.getLogger(ProductSupportHelper.class.getName());

    protected void prepareLocalAndRemoteFiles(OPatchAutoOptions options, CredentialManager credentialManager, TopologyBuilder _topologyBuilder, OPatchAutoCommand command) throws OPatchAutoException {
        try {
            Map<Host, PatchActionResult> results;
            SDBRemoteFileHandler remoteFileHandler = null;
            LinkedList<Thread> threads = new LinkedList<Thread>();
            for (Host host : _topologyBuilder.getTopology().getHosts()) {
                remoteFileHandler = new SDBRemoteFileHandler(host, credentialManager, options, command);
                Thread thread = new Thread(remoteFileHandler);
                threads.add(thread);
                thread.start();
            }
            for (Thread thread : threads) {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {}
            }
            if (remoteFileHandler != null && (results = remoteFileHandler.getResults()) != null) {
                for (Host host : _topologyBuilder.getTopology().getHosts()) {
                    PatchActionResult result = results.get(host);
                    if (result == null || !result.hasException()) continue;
                    throw new PatchActionException(result.getException());
                }
            }
        }
        catch (Exception ex) {
            _log.throwing("Detailed Exception while preparing Local And Remote files : ", PatchActionUtil.replacePwdFrmCmd(ex.getMessage()), ex);
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72099), (Object[])new Object[]{PatchActionUtil.replacePwdFrmCmd(ex.getMessage())}), new Object[0]);
        }
    }

    public static void changeLogFolderPermission() {
        try {
            if ("root".equalsIgnoreCase(System.getProperty("user.name"))) {
                String user = OUIDriver.checkFileOwner((File)new File(OPatchAutoHelper.getOPatchAutoHome() + DBCommonPatchingConstants.OPATCHAUTO_DB_SCRIPT));
                String group = OiixEnvironmentOps.ssgetCurrentGroupOfUserux((String)user);
                byte[] pwd = null;
                String cfgtoollogs = HelperUtility.detectOraBaseHome() + File.separator + "cfgtoollogs";
                GISystemCall.process(" chown -R " + user + ":" + group + " " + cfgtoollogs + File.separator + "opatchauto", "root", pwd);
                GISystemCall.process(" chown -R " + user + ":" + group + " " + cfgtoollogs + File.separator + "opatchautodb", "root", pwd);
                GISystemCall.process(" chown -R " + user + ":" + group + " " + cfgtoollogs + File.separator + "oplan", "root", pwd);
            }
        }
        catch (OPatchAutoException e) {
            _log.warning("Unable to chown opatchauto,oplan logs folder \n" + (Object)((Object)e));
        }
    }

    public static void changeSummaryFileDest() {
        File summaryFile = new File("/tmp/shardpatchingsummary.xml");
        String destLoc = "";
        try {
            if (summaryFile.exists()) {
                destLoc = OPatchAutoHelper.getOPatchAutoHome() + DBCommonPatchingConstants.OPATCH_AUTO_DBSESSIONINFO;
                File file = new File(OPatchAutoHelper.getOPatchAutoHome(), DBCommonPatchingConstants.OPATCHAUTO_DB_SCRIPT);
                String ohOwner = OUIDriver.checkFileOwner((File)file);
                DBPatchingUtil.copyFileToDestLoc(summaryFile, destLoc, ohOwner, null, true);
                if (new File(destLoc + "shardpatchingsummary.xml").exists()) {
                    IOUtils.chmodTo775(new File(destLoc + "shardpatchingsummary.xml"), null);
                }
            }
        }
        catch (OPatchAutoException e) {
            _log.warning("Unable to copy file " + summaryFile + " to destination " + destLoc);
        }
    }

    public static void verifyPatching(TopologyBuilder _topologyBuilder, DBPatchingSummaryCreator _summaryCreator, boolean isSdb, boolean isOgg) {
        if (_topologyBuilder != null && _topologyBuilder.getTopology() != null) {
            Set targethomes = _topologyBuilder.getTopology().getHomes();
            ArrayList<String> failedHomeList = new ArrayList<String>();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                File file = null;
                file = isSdb ? new File("/tmp/sdbpatchingsummary.xml") : new File("/tmp/shardpatchingsummary.xml");
                if (file.length() > 0L) {
                    Document doc = db.parse(file);
                    doc.getDocumentElement().normalize();
                    NodeList nodeList = doc.getElementsByTagName("summary-details");
                    if (nodeList != null && nodeList.getLength() > 0) {
                        for (Home home : targethomes) {
                            DBHomeImpl homeImpl = (DBHomeImpl)home;
                            boolean isPresent = false;
                            for (int j = 0; j < nodeList.getLength(); ++j) {
                                Element el = (Element)nodeList.item(j);
                                if (!el.getTextContent().contains("name : " + homeImpl.getTargetName())) continue;
                                isPresent = true;
                            }
                            if (isPresent) continue;
                            ProductSupportHelper.populateFailedHomeList(isSdb, isOgg, failedHomeList, homeImpl);
                        }
                    }
                } else {
                    for (Home home : targethomes) {
                        DBHomeImpl homeImpl = (DBHomeImpl)home;
                        ProductSupportHelper.populateFailedHomeList(isSdb, isOgg, failedHomeList, homeImpl);
                    }
                }
                if (failedHomeList != null && failedHomeList.size() > 0 && isSdb) {
                    Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"ProductSupport.database.failedlist.message", (Object[])new Object[]{failedHomeList}));
                }
            }
            catch (Exception e) {
                _log.throwing("Error: Unable to verify patching status : ", e.getMessage(), e);
            }
        }
    }

    private static void populateFailedHomeList(boolean isSdb, boolean isOgg, ArrayList<String> homeList, DBHomeImpl homeImpl) {
        if (isSdb) {
            if (isOgg) {
                if (!StringUtil.isNullOrEmpty((String)homeImpl.getShardGroupName())) {
                    homeList.add(homeImpl.getTargetName() + " in shard group " + homeImpl.getShardGroupName());
                } else if (!StringUtil.isNullOrEmpty((String)homeImpl.getShardSpaceName())) {
                    homeList.add(homeImpl.getTargetName() + " in shard space " + homeImpl.getShardSpaceName());
                }
            } else {
                homeList.add(homeImpl.getTargetName() + " with DR-set number " + homeImpl.getDrsetNumber());
            }
        } else {
            homeList.add(homeImpl.getTargetName());
        }
    }

    public void prepareSessionInfoFiles(SystemInstance sysInst, OPatchAutoOptions options) throws OPatchAutoException {
        Map<Host, PatchActionResult> results;
        CredentialManager credentialManager = new CredentialManager();
        char[] pwd = null;
        OPatchAutoOption walletOption = options.getOption("wallet");
        credentialManager.setWallet(new File(walletOption.getValue()), pwd);
        String localHomePath = OPatchAutoHelper.getOPatchAutoHome();
        String rootSessionInfoLocation = SessionData.getConfigDir() + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR + "rootSessionInfoFile.txt";
        File rootSessionInfoFile = new File(rootSessionInfoLocation);
        String currentHostName = OPatchAutoHelper.getOPatchAutoHost();
        try {
            DBPatchingUtil.writeContent(rootSessionInfoFile, options.getOption("session").getValue(), false, false);
            DBPatchingUtil.writeContent(rootSessionInfoFile, currentHostName, true, true);
            DBPatchingUtil.writeContent(rootSessionInfoFile, localHomePath, true, true);
        }
        catch (IOException e1) {
            throw new OPatchAutoException((Throwable)e1);
        }
        _log.info("Local SessionInfo Location : " + rootSessionInfoLocation + " exists: " + new File(rootSessionInfoLocation).exists());
        LinkedList<Thread> threads = new LinkedList<Thread>();
        SDBRemoteFileHandler remoteFileHandler = null;
        PseudoSDBTopoBuilder pseudoSDBTopoBuilder = new PseudoSDBTopoBuilder();
        Topology tempTopology = pseudoSDBTopoBuilder.createPseudoTopology(options, credentialManager);
        for (Host host : tempTopology.getHosts()) {
            remoteFileHandler = new SDBRemoteFileHandler(host, credentialManager, true, rootSessionInfoFile);
            Thread thread = new Thread(remoteFileHandler);
            threads.add(thread);
            thread.start();
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {}
        }
        if (remoteFileHandler != null && (results = remoteFileHandler.getResults()) != null) {
            for (Host host : tempTopology.getHosts()) {
                PatchActionResult result = results.get(host);
                if (result == null || !result.hasException()) continue;
                _log.throwing("Detailed Exception while preparing session info files : ", PatchActionUtil.replacePwdFrmCmd(result.getException().getMessage()), result.getException());
                throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72099), (Object[])new Object[]{PatchActionUtil.replacePwdFrmCmd(result.getException().getMessage())}), new Object[0]);
            }
        }
        rootSessionInfoFile.deleteOnExit();
    }

    public void deleteRemoteFiles() {
        SDBRemoteFileHandlerHelper sdbRemoteFileHandlerHelper = new SDBRemoteFileHandlerHelper();
        Map<RemoteConnectionHandler, Map<String, String>> filesTobeDeleted = sdbRemoteFileHandlerHelper.getFilesToBeDeleted();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        if (null != filesTobeDeleted) {
            for (RemoteConnectionHandler handler : filesTobeDeleted.keySet()) {
                if (null == handler) continue;
                SDBRemoteFileHandler remoteFileHandler = new SDBRemoteFileHandler(handler, sdbRemoteFileHandlerHelper.getFilesToBeDeleted().get(handler), true);
                Thread thread = new Thread(remoteFileHandler);
                threads.add(thread);
                thread.start();
            }
            for (Thread thread : threads) {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {}
            }
        }
    }

    public void handleRootSessionInfoFile(OPatchAutoOptions options) throws OPatchAutoException {
        File rootSessionFile = new File(SessionData.getConfigDir() + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR + "rootSessionInfoFile.txt");
        OPatchAutoOption parentId = options.getOption(DBProductParameterConstants.PARENTID.getValue());
        OPatchAutoOption sessionId = options.getOption("session");
        OPatchAutoOption analyzeOption = options.getOption("analyze");
        OPatchAutoOption deployOnlyOption = options.getOption(DBProductParameterConstants.DEPLOY_ONLY.getValue());
        OPatchAutoOption dgOption = options.getOption(DBProductParameterConstants.DG.getValue());
        OPatchAutoOption shdGrpOption = options.getOption(DBProductParameterConstants.SHARD_GROUP.getValue());
        OPatchAutoOption shdSpcOption = options.getOption(DBProductParameterConstants.SHARD_SPACE.getValue());
        boolean isDGOGGSession = false;
        if (!(StringUtil.isNullOrEmpty((String)dgOption.getValue()) && StringUtil.isNullOrEmpty((String)shdGrpOption.getValue()) && StringUtil.isNullOrEmpty((String)shdSpcOption.getValue()))) {
            isDGOGGSession = true;
        }
        if (rootSessionFile.exists()) {
            if (parentId != null && parentId.getValue() != null) {
                if (analyzeOption.isSwitchEnabled() && isDGOGGSession || !analyzeOption.isSwitchEnabled() && deployOnlyOption.isSwitchEnabled()) {
                    try {
                        String currentLine;
                        String parentChildEntry = deployOnlyOption.isSwitchEnabled() ? "DEPLOY:" + parentId.getValue() + ":" : "ANALYZE:" + parentId.getValue() + ":";
                        boolean isPresent = false;
                        BufferedReader br = new BufferedReader(new FileReader(rootSessionFile.getAbsolutePath()));
                        while ((currentLine = br.readLine()) != null) {
                            if (!currentLine.startsWith(parentChildEntry) && !currentLine.startsWith("DEPLOY:")) continue;
                            isPresent = true;
                        }
                        if (isPresent) {
                            parentChildEntry = "DEPLOY:" + parentId.getValue() + ":";
                        }
                        br.close();
                        DBPatchingUtil.writeContent(rootSessionFile, parentChildEntry + sessionId.getValue(), true, true);
                    }
                    catch (IOException e) {
                        throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72069), (Object[])new Object[]{OPatchAutoHelper.getOPatchAutoHost(), OPatchAutoHelper.getOPatchAutoHome()}), new Object[0]);
                    }
                }
            } else {
                rootSessionFile.delete();
            }
        }
    }

    public static boolean isGIValidationRequired() {
        String crsHome = SessionData.getInstance().getCrsHome();
        if (StringUtil.isNullOrEmpty((String)crsHome)) {
            return false;
        }
        ClusterInformationLoader.CrsType crsType = SessionData.getInstance().getCrsType();
        return crsType != null && !crsType.equals((Object)ClusterInformationLoader.CrsType.SOFTWARE_INSTALLATION_ONLY);
    }

    public String getCrsInitFilePath(String crsHome) {
        String hostname = OUIDriver.extractHostName((String)OsysUtility.getHostname());
        String filePath = crsHome + ProductDriverConstants.OPATCH_AUTO_CRS_SESSION_INIT + hostname;
        return filePath;
    }

    public void createSessionInitFile() {
        String crsHome = SessionData.getInstance().getCrsHome();
        String filePath = this.getCrsInitFilePath(crsHome);
        File file = new File(filePath);
        String currentUser = System.getProperty("user.name");
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            if (currentUser.equalsIgnoreCase("root")) {
                DBPatchingHelper.changeOwner(crsHome, null, file);
            }
        }
        catch (Exception e) {
            _log.warning("Unable to create the CRS session state file");
        }
    }

    public void deleteSessionInitFile(boolean isRemoteSession, String walletLoc, char[] walletPwd) {
        String crsHome = SessionData.getInstance().getCrsHome();
        String filePath = this.getCrsInitFilePath(crsHome);
        ArrayList<String> remoteList = SessionData.getInstance().getRemoteList();
        String[] initiatedHosts = SessionData.getInstance().getInitiatedHosts();
        if (isRemoteSession || remoteList.size() == initiatedHosts.length) {
            _log.info("All nodes of the cluster have been patched. Session state file will now be deleted.");
            File file = new File(filePath);
            if (file.exists()) {
                file.delete();
            }
            if (!isRemoteSession && initiatedHosts.length > 0) {
                _log.info("Session state files will now be deleted from remote nodes.");
                String[] deletedNodes = DBPatchingHelper.deleteRemoteStateFiles(crsHome, initiatedHosts, crsHome, walletLoc, walletPwd);
                _log.info("State Files have been successfully deleted from these remote nodes" + deletedNodes.toString());
            }
        }
    }
}

