/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport.helper;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.core.oplan.IOUtils;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class ProductSupportAgent {
    private static final Logger _log = Logger.getLogger(ProductSupportAgent.class.getName());

    public void copySummaryFileToDBSessionInfo() {
        File summaryFile = new File("/tmp/patchingsummary.xml");
        String destLoc = "";
        try {
            if (summaryFile.exists()) {
                destLoc = SessionData.getConfigDir() + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR;
                DBPatchingUtil.copyFileToDestLoc(summaryFile, destLoc, System.getProperty("user.name"), null, true);
                if (new File(destLoc + "patchingsummary.xml").exists()) {
                    IOUtils.chmodTo775(new File(destLoc + "patchingsummary.xml"), null);
                }
            }
        }
        catch (OPatchAutoException e) {
            _log.warning("Unable to copy file " + summaryFile + " to destination " + destLoc);
        }
    }

    public void saveAnalyzeStatus(boolean isAnalyzeFailed) {
        File analyzeStatusFile = null;
        try {
            String oracleHome = OPatchAutoHelper.getOPatchAutoHome();
            analyzeStatusFile = new File(oracleHome + DBCommonPatchingConstants.OPATCH_AUTO_DBSESSIONINFO + "report_analyze_failure.txt");
            if (analyzeStatusFile.exists()) {
                analyzeStatusFile.delete();
            }
            if (isAnalyzeFailed) {
                DBPatchingUtil.createNewFile(analyzeStatusFile.getAbsolutePath(), System.getProperty("user.name"), null);
                DBPatchingUtil.writeContent(analyzeStatusFile, "ANALYZE_FAILED_STATUS:" + isAnalyzeFailed, false, false);
                IOUtils.chmodTo775(analyzeStatusFile, null);
            }
        }
        catch (OPatchAutoException e) {
            _log.warning("Unable to get opatchauto home or host : " + e.getMessage());
        }
        catch (IOException e) {
            _log.warning("Unable to write analyze status to file : " + analyzeStatusFile.getAbsolutePath() + " due to " + e.getMessage());
        }
    }
}

