/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology;

import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.DBToOhConvertor;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.driver.crs.CRSDummyProductDriver;
import com.oracle.glcm.patch.auto.db.product.driver.crs.CrsProductDriver;
import com.oracle.glcm.patch.auto.db.product.driver.sidb.OUISIDBProductDriver;
import com.oracle.glcm.patch.auto.db.product.summary.AdminPolicyManagedHomeDetails;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationController;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationPhase;
import dbmodel.SystemInstance;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriverException;

public class TopologyCreator {
    Logger logger = Logger.getLogger(TopologyCreator.class.getName());
    private static final String HOME_KEY = "-oh";
    private static final String LOG_LEVEL = "-logLevel";
    private static final String CUSTOM_LOG_DIR = "-customLogDir";
    private static final String CUSTOM_CONFIG_DIR = "-customConfigDir";
    private static final String DATABASE_KEY = "-database";
    private static final String INV_PTR_LOC_KEY = "-invPtrLoc";
    private static final String ANALYZE_KEY = "-analyze";
    private static final String VERSION_KEY = "-version";
    private static final String HELP_KEY = "-help";
    private static final String NON_ROLLING_KEY = "-nonrolling";
    private static final String PREPARE_CLONE_KEY = "-prepare-clone";
    private static final String SWITCH_CLONE_KEY = "-switch-clone";
    private static final String OOP_SINGLE_SESSION_KEY = "-outofplace";
    private static final String DEPLOY_ONLY = "-deployonly";
    private static final String OPATCH_AUTO_DB_NAMESPACE = "opatchautodb";
    private static final String SYSTEM_CONFIG_LOG = "systemconfig";
    private static final String LOG_FILENAME_DATE_FORMAT = "yyyy-MM-dd_hh-mm-ssa";
    private static final String DEFAULT_LOG_DIR = "cfgtoollogs";
    private static final String GENERATE_STEPS_KEY = "-generatesteps";
    private static final String SIDB_ONLY_KEY = "-sidbonly";
    private static String logLevel = Level.INFO.getName();
    private static String customConfigDir;
    private ArrayList<String> argsList;

    public static void main(String[] args) {
        int result;
        block2: {
            result = 0;
            String oracleHome = System.getProperty("OPatch.ORACLE_HOME");
            TopologyCreator creator = new TopologyCreator();
            try {
                creator.initalize(args, oracleHome);
                creator.process(args, oracleHome);
            }
            catch (OPatchAutoException e) {
                result = e.getMessageID();
                if (result == 243 || result == 247) break block2;
                Reporting.report((String)e.getMessage());
            }
        }
        System.exit(result);
    }

    private void initalize(String[] args, String oracleHome) throws OPatchAutoException {
        File autodbDir;
        this.argsList = new ArrayList();
        if (args != null) {
            this.argsList.addAll(Arrays.asList(args));
        }
        int invPtrLoc = this.argsList.indexOf(INV_PTR_LOC_KEY);
        String invPtrStr = null;
        if (invPtrLoc != -1) {
            int valIndex = invPtrLoc + 1;
            if (!(this.indexExists(valIndex) && new File(this.argsList.get(valIndex)).exists() && new File(this.argsList.get(valIndex)).isFile())) {
                throw new OPatchAutoException(Integer.toString(72039, 245), new Object[0]);
            }
            invPtrStr = this.argsList.get(valIndex);
        }
        this.loadResourceBundle();
        int logDirIndex = this.argsList.indexOf(CUSTOM_LOG_DIR);
        String logDir = this.argsList.get(logDirIndex + 1);
        this.initLogFactory(logDir);
        int configDirIndex = this.argsList.indexOf(CUSTOM_CONFIG_DIR);
        customConfigDir = this.argsList.get(configDirIndex + 1);
        DBPatchingHelper.setupEnvironment(oracleHome, invPtrStr);
        if (this.argsList.indexOf("-sidb") == -1) {
            String giHome = ClusterInformationLoader.getInstance().getGridHome();
            System.setProperty("ORACLE_HOME", giHome);
        }
        if ((autodbDir = new File(TopologyCreator.getDefaultLogDirectoryLocation(logDir))).exists()) {
            String Owner = OUIDriver.checkFileOwner((File)new File(oracleHome, "oraInst.loc"));
            DBPatchingUtil.setDirPerm(TopologyCreator.getDefaultLogDirectoryLocation(logDir), Owner, null, "775");
        }
    }

    private void process(String[] args, String oracleHome) throws OPatchAutoException {
        if (this.argsList.indexOf("-sidb") == -1 && !this.validate()) {
            throw new OPatchAutoException("Validation failed", 243);
        }
        this.createSystemInstance(oracleHome);
    }

    private void loadResourceBundle() throws OPatchAutoException {
        Set<String> resourceBundles = DBPatchingHelper.getDBResourceBundles();
        if (resourceBundles != null) {
            for (String resourceBundle : resourceBundles) {
                ResourceBundleManager.manageBundle((String)"opatchauto", (String)resourceBundle, (ClassLoader)OPatchAutoHelper.getPluginClassLoader());
            }
        }
    }

    private void createSystemInstance(String oracleHome) throws OPatchAutoException {
        int valIndex;
        String walletLoc = null;
        char[] walletCharPwd = null;
        int walletIndex = this.argsList.indexOf("-wallet");
        if (walletIndex != -1) {
            String walletPass;
            walletLoc = this.argsList.get(walletIndex + 1);
            int walletPassIndex = this.argsList.indexOf("-wallet.password");
            if (walletPassIndex != -1 && (walletPass = this.argsList.get(walletPassIndex + 1)) != null) {
                walletCharPwd = walletPass.toCharArray();
            }
        }
        SystemInstance systemInstance = null;
        int containsOHOptIndex = this.argsList.indexOf(HOME_KEY);
        int containsDBOptIndex = this.argsList.indexOf(DATABASE_KEY);
        List<Object> oracleHomes = new ArrayList();
        if (containsOHOptIndex != -1) {
            valIndex = containsOHOptIndex + 1;
            oracleHomes = this.getOracleHomeList(valIndex);
        } else if (containsDBOptIndex != -1) {
            valIndex = containsDBOptIndex + 1;
            oracleHomes = this.updateOhWithDatabase(valIndex);
        }
        File nonrollingSystemInstFile = new File(oracleHome + DBCommonPatchingConstants.OOP_NONROLLING_TOPOLOGY_FILE_PATH);
        this.logger.log(Level.FINEST, "Creating system instance file from non rolling file :: " + nonrollingSystemInstFile.exists() + "\n");
        boolean nonRollingIndex = this.argsList.indexOf(NON_ROLLING_KEY) != -1;
        boolean oopSession = this.isOOPSession();
        this.logger.log(Level.FINEST, "Is OOP Session :: " + oopSession + "\n");
        try {
            if (nonRollingIndex && oopSession && nonrollingSystemInstFile.exists()) {
                CRSDummyProductDriver crsPD = new CRSDummyProductDriver();
                crsPD.setDummyConfigFile(nonrollingSystemInstFile);
                systemInstance = crsPD.constructSystemInstance();
                if (!this.isNonPatchingOperation()) {
                    nonrollingSystemInstFile.delete();
                }
                this.logger.log(Level.FINEST, "Creating system instance file from non rolling file :: " + nonrollingSystemInstFile.getAbsolutePath() + "\n");
            } else if (this.argsList.indexOf("-sidb") == -1) {
                CrsProductDriver crsPD = null;
                crsPD = !StringUtil.isNullOrEmpty((String)walletLoc) ? CrsProductDriver.getCrsProductDriverForNonRootAccess(walletLoc, walletCharPwd) : CrsProductDriver.getCrsProductDriverForRootAccess();
                systemInstance = oracleHomes.isEmpty() ? crsPD.buildSystemInstance() : crsPD.buildSystemInstance(oracleHomes);
                if (systemInstance == null) {
                    throw new OPatchAutoException(Integer.toString(72050, 245), new Object[0]);
                }
                this.writeAdminPolicyManagedSkippedDBDetails(crsPD.getDBForSkipping());
            } else {
                int sidIndex = this.argsList.indexOf("-sid");
                int portIndex = this.argsList.indexOf("-port");
                String sid = null;
                String port = null;
                String homePath = null;
                if (sidIndex != -1 && this.indexExists(sidIndex + 1)) {
                    sid = this.argsList.get(sidIndex + 1);
                }
                if (portIndex != -1 && this.indexExists(portIndex + 1)) {
                    port = this.argsList.get(portIndex + 1);
                }
                homePath = !oracleHomes.isEmpty() ? (String)oracleHomes.get(0) : (System.getenv("ORACLE_HOME") != null ? System.getenv("ORACLE_HOME") : OPatchAutoHelper.getOPatchAutoHome());
                OUISIDBProductDriver productDriver = new OUISIDBProductDriver(homePath, sid, port);
                systemInstance = productDriver.buildSystemInstance();
            }
            systemInstance.writeFile(this.createSystemInstanceXML());
        }
        catch (FileNotFoundException e) {
            this.logger.log(Level.SEVERE, "Not able to write system instance details ");
            throw new OPatchAutoException(Integer.toString(72035), 245);
        }
        catch (Exception e) {
            String result = e.toString() + "\n";
            StackTraceElement[] trace = e.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                result = result + trace[i].toString() + "\n";
            }
            this.logger.log(Level.SEVERE, "Stacktrace :: " + result + "\n");
            this.logger.log(Level.SEVERE, "Not able to retrieve system instance details :: " + e.getMessage() + "\n", e);
            this.logger.log(Level.SEVERE, "Failure reason::" + e.getCause());
            if (e instanceof ProductDriverException && ((ProductDriverException)((Object)e)).getType() == ProductDriverException.Type.WrongOpatchInstallation) {
                Reporting.report((String)e.getLocalizedMessage());
                throw new OPatchAutoException(Integer.toString(72139), 245);
            }
            if (e instanceof ProductDriverException && ((ProductDriverException)((Object)e)).getType() == ProductDriverException.Type.SoftwareOnlyHomeConfiguration) {
                throw new OPatchAutoException(Integer.toString(72160), 245);
            }
            throw new OPatchAutoException(Integer.toString(72050), 245, (Throwable)e);
        }
    }

    private boolean isOOPSession() {
        return this.argsList.indexOf(OOP_SINGLE_SESSION_KEY) != -1 || this.argsList.indexOf(PREPARE_CLONE_KEY) != -1 || this.argsList.indexOf(SWITCH_CLONE_KEY) != -1;
    }

    private void writeAdminPolicyManagedSkippedDBDetails(Map<String, String> dbList) {
        if (dbList != null && !dbList.isEmpty()) {
            AdminPolicyManagedHomeDetails dbDetails = new AdminPolicyManagedHomeDetails();
            dbDetails.addSkippedHomeToList(dbList);
            dbDetails.storeInformation();
        }
    }

    private List<String> updateOhWithDatabase(int containsDBOptIndex) {
        String database;
        List<String> homeList = new ArrayList<String>();
        if (containsDBOptIndex != -1 && (database = this.argsList.get(containsDBOptIndex)) != null) {
            DBToOhConvertor dbtoohConvertor = new DBToOhConvertor();
            try {
                homeList = dbtoohConvertor.getHomeFromDatabase(database);
            }
            catch (OPatchAutoException e) {
                new OPatchAutoException(e.getMessage(), 246);
            }
        }
        return homeList;
    }

    private File createSystemInstanceXML() {
        String oracleHome = PatchPlanner.getInstance().getOPlanEnv().getOracleHome();
        String crsOwner = OUIDriver.checkFileOwner((File)new File(oracleHome, "oraInst.loc"));
        String filePath = "/tmp/opatch_gi_" + this.argsList.get(0) + "_config.xml";
        DBPatchingUtil.createNewFile(filePath, crsOwner, null);
        File configXML = new File(filePath);
        return configXML;
    }

    private boolean validate() throws OPatchAutoException {
        int deployOnlyIndex = this.argsList.indexOf(DEPLOY_ONLY);
        if (deployOnlyIndex != -1) {
            return true;
        }
        List<String> oracleHomes = new ArrayList<String>();
        ValidationParam params = new ValidationParam();
        int nonRollingIndex = this.argsList.indexOf(NON_ROLLING_KEY);
        params.set(ValidationParamKey.NONROLLING_OPTION.ordinal(), new Boolean(nonRollingIndex != -1));
        params.set(ValidationParamKey.OOP_ENABLED.ordinal(), this.isOOPSession());
        int ohOptionIndex = this.argsList.indexOf(HOME_KEY);
        int databaseKeyIndex = this.argsList.indexOf(DATABASE_KEY);
        if (ohOptionIndex != -1 && databaseKeyIndex != -1) {
            Reporting.report((String)OPatchAutoHelper.getPublishedMessage((String)"68024", (Object[])new Object[]{"[-oh, -database]"}));
            throw new OPatchAutoException("Validation failed", 247);
        }
        if (ohOptionIndex != -1) {
            int valIndex = ohOptionIndex + 1;
            if (!this.indexExists(valIndex)) {
                Reporting.report((String)OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72037), (Object[])new Object[0]));
                return false;
            }
            oracleHomes = this.getOracleHomeList(valIndex);
            params.set(ValidationParamKey.HOME_KEY_OPTION.ordinal(), new Boolean(true));
        } else {
            String oracleHome = PatchPlanner.getInstance().getOPlanEnv().getOracleHome();
            if (StringUtil.isNullOrEmpty((String)oracleHome)) {
                Reporting.report((String)OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72038), (Object[])new Object[0]));
                return false;
            }
            oracleHomes.add(oracleHome);
            params.set(ValidationParamKey.HOME_KEY_OPTION.ordinal(), new Boolean(false));
        }
        int invPtrLoc = this.argsList.indexOf(INV_PTR_LOC_KEY);
        if (invPtrLoc != -1) {
            int valIndex = invPtrLoc + 1;
            if (!(this.indexExists(valIndex) && new File(this.argsList.get(valIndex)).exists() && new File(this.argsList.get(valIndex)).isFile())) {
                Reporting.report((String)OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72039), (Object[])new Object[0]));
                return false;
            }
            params.set(ValidationParamKey.INV_PTR_LOC.ordinal(), this.argsList.get(valIndex));
        }
        params.set(ValidationParamKey.OPERATION.ordinal(), this.argsList.get(0));
        int sidbOnlyIndex = this.argsList.indexOf(SIDB_ONLY_KEY);
        params.set(ValidationParamKey.SIDB_ONLY.ordinal(), new Boolean(sidbOnlyIndex != -1));
        ArrayList<String> databaseNames = new ArrayList<String>();
        if (databaseKeyIndex != -1) {
            int valIndex = databaseKeyIndex + 1;
            if (!this.indexExists(valIndex)) {
                Reporting.report((String)OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72040), (Object[])new Object[0]));
                return false;
            }
            String databaseValue = this.argsList.get(valIndex);
            String[] databaseList = databaseValue.split(",");
            if (databaseList.length < 1) {
                Reporting.report((String)OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72045), (Object[])new Object[0]));
                return false;
            }
            databaseNames.addAll(Arrays.asList(databaseList));
            params.set(ValidationParamKey.DATABASE_KEY_OPTION.ordinal(), new Boolean(true));
            params.set(ValidationParamKey.DATABASE.ordinal(), databaseNames);
        } else {
            params.set(ValidationParamKey.DATABASE_KEY_OPTION.ordinal(), new Boolean(false));
        }
        params.set(ValidationParamKey.ANALYZE_OPTION.ordinal(), this.argsList.indexOf(ANALYZE_KEY) != -1);
        params.set(ValidationParamKey.HELP_OPTION.ordinal(), this.argsList.indexOf(HELP_KEY) != -1);
        params.set(ValidationParamKey.VERSION_OPTION.ordinal(), this.argsList.indexOf(VERSION_KEY) != -1);
        params.set(ValidationParamKey.ORACLE_HOMES.ordinal(), oracleHomes);
        params.set(ValidationParamKey.VALIDATION_PHASE.ordinal(), (Object)ValidationPhase.PRODUCT_INITIALISATION);
        DBValidationController validationController = new DBValidationController();
        List<ValidationResult> failedValidations = validationController.invoke(params);
        boolean status = true;
        if (!failedValidations.isEmpty()) {
            status = false;
            for (ValidationResult result : failedValidations) {
                if (result.getFailureReason() == DBValidationFailureReason.WRONG_OH_ARGUMENT) {
                    String invalidOHList = (String)result.getPayload();
                    Reporting.report((String)OPatchAutoHelper.getPublishedMessage((String)Integer.toString(result.getFailureReason().getErrorCode()), (Object[])new Object[]{invalidOHList, HOME_KEY}));
                } else if (result.getErrorMessage() != null) {
                    Reporting.report((String)result.getErrorMessage());
                } else {
                    Reporting.report((String)OPatchAutoHelper.getPublishedMessage((String)Integer.toString(result.getFailureReason().getErrorCode()), (Object[])new Object[0]));
                }
                Reporting.report((String)"\n");
            }
        }
        return status;
    }

    private List<String> getOracleHomeList(int valIndex) {
        ArrayList<String> oracleHomes = new ArrayList<String>();
        String ohValue = this.argsList.get(valIndex);
        String[] ohList = ohValue.split(",");
        oracleHomes.addAll(Arrays.asList(ohList));
        return oracleHomes;
    }

    private boolean indexExists(int index) {
        return index >= 0 && index < this.argsList.size();
    }

    private boolean isNonPatchingOperation() {
        return this.argsList.indexOf(ANALYZE_KEY) != -1 || this.argsList.indexOf(GENERATE_STEPS_KEY) != -1;
    }

    private void initLogFactory(String logDir) {
        String log = TopologyCreator.getDefaultLogFileLocation(logDir);
        int logLevelIndex = this.argsList.indexOf(LOG_LEVEL);
        if (logLevelIndex != -1) {
            logLevel = this.argsList.get(logLevelIndex + 1);
        }
        LogFactory logFactory = LogFactory.getFactory();
        logFactory.setupLogging(log, logLevel, true, new String[0]);
        Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"PatchInfoInitializer.bootstrapping.logfile.name", (Object[])new Object[]{log}));
    }

    private static String getDefaultLogFileLocation(String logDir) {
        return TopologyCreator.getDefaultLogDirectoryLocation(logDir) + File.separator + SYSTEM_CONFIG_LOG + OPatchAutoHelper.getCurrentDateTimeStamp((String)LOG_FILENAME_DATE_FORMAT) + ".log";
    }

    private static String getDefaultLogDirectoryLocation(String logDir) {
        return logDir.trim() + File.separator + OPATCH_AUTO_DB_NAMESPACE;
    }

    public static String getCustomConfigDir() {
        return customConfigDir;
    }

    static {
        OPatchAutoHelper.manageResourceBundles();
    }
}

