/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.sdb;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.driver.sdb.SDBProductDriver;
import dbmodel.SystemInstance;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SDBSysInstComposer {
    OPatchAutoOptions options = null;
    File systemInstanceFile = null;
    private Logger logger = Logger.getLogger(SDBSysInstComposer.class.getName());

    public SDBSysInstComposer(OPatchAutoOptions options, File systemInstanceFile) {
        this.options = options;
        this.systemInstanceFile = systemInstanceFile;
    }

    public void createShardedSystemInstance() throws OPatchAutoException {
        OPatchAutoOption sidOption = this.options.getOption(DBProductParameterConstants.SID.getValue());
        OPatchAutoOption serviceOption = this.options.getOption(DBProductParameterConstants.SERVICE.getValue());
        OPatchAutoOption portOption = this.options.getOption(DBProductParameterConstants.PORT.getValue());
        OPatchAutoOption hostOption = this.options.getOption("host");
        OPatchAutoOption walletOption = this.options.getOption("wallet");
        try {
            String catalogDbHost = null;
            if (hostOption != null && hostOption.getValue() != null) {
                catalogDbHost = hostOption.getValue();
            } else {
                catalogDbHost = DBPatchingHelper.getLocalHost();
                this.options.getOption("host").setValue(catalogDbHost);
            }
            String sid = null;
            String service = null;
            if (sidOption != null && sidOption.getValue() != null) {
                sid = sidOption.getValue();
            } else if (serviceOption != null && serviceOption.getValue() != null) {
                service = serviceOption.getValue();
            } else {
                sid = System.getenv("ORACLE_SID");
                this.options.getOption(DBProductParameterConstants.SID.getValue()).setValue(sid);
            }
            String port = null;
            if (portOption != null && portOption.getValue() != null) {
                port = portOption.getValue();
            } else {
                port = "1521";
                this.options.getOption(DBProductParameterConstants.PORT.getValue()).setValue(port);
            }
            String walletFile = null;
            if (walletOption != null && walletOption.getValue() != null) {
                walletFile = walletOption.getValue();
            }
            if (null == walletFile) {
                this.logger.log(Level.WARNING, "Wallet File not provided.");
                throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)"68081", (Object[])new Object[0]), new Object[0]);
            }
            CredentialManager credentialManager = new CredentialManager();
            char[] pwd = null;
            credentialManager.setWallet(new File(walletFile), pwd);
            Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"TopologyBuilder.executing.start.message", (Object[])new Object[0]));
            SDBProductDriver sdbPD = new SDBProductDriver(catalogDbHost, sid, service, port, credentialManager);
            SystemInstance sdbSystemInstance = new SystemInstance();
            sdbSystemInstance = sdbPD.buildSystemInstance();
            if (sdbSystemInstance == null) {
                throw new OPatchAutoException(Integer.toString(72050, 245), new Object[0]);
            }
            sdbSystemInstance.writeFile(this.systemInstanceFile);
            PatchPlanner.getInstance().setSystemInstance(sdbSystemInstance);
            this.logger.info("System instance file is : " + this.systemInstanceFile);
            Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"TopologyBuilder.executing.completed.message", (Object[])new Object[0]));
        }
        catch (FileNotFoundException e) {
            this.logger.throwing("Detailed Execption in execute steps : ", e.getMessage(), e);
            this.logger.log(Level.WARNING, "File not found : " + e.getMessage());
            throw new OPatchAutoException(Integer.toString(72035), new Object[]{245 + e.getMessage()});
        }
        catch (Exception e) {
            this.logger.throwing("Detailed Execption in execute steps : ", e.getMessage(), e);
            this.logger.log(Level.WARNING, "Not able to retrieve system instance details : " + e.getMessage());
            throw new OPatchAutoException(Integer.toString(72050), new Object[]{245 + e.getMessage()});
        }
    }
}

