/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator;

import com.oracle.glcm.patch.auto.db.framework.sdk.PatchPlanException;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.cookies.SkipTargetCookie;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanInternalException;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandParameters;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.product.patch.CRSApplicabilityTarget;
import com.oracle.helper.util.HelperUtility;
import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.BasePatch;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.CRSCluster;
import dbmodel.db_crs.DB;
import dbmodel.db_crs.HAS;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import dbmodel.patchmodel.Bundle;
import dbmodel.patchmodel.CompositePatch;
import dbmodel.patchmodel.GenericPatch;
import dbmodel.patchmodel.GenericSingletonPatch;
import dbmodel.patchmodel.OPatchSingleton;
import dbmodel.patchmodel.PatchPackage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.DeploymentSubType;

public class DBCommandUtils {
    private static Logger logger = Logger.getLogger(DBCommandUtils.class.getName());
    private static String restoreType = "restore";
    private static String sqlPatchRestoreType = "SqlPatchRestore";

    public static boolean isDataGuardConfig(AbstractBaseTarget abt) {
        String dataguardStatus = null;
        DB db = null;
        if (abt instanceof RACDatabase) {
            RACDatabase racDatabase = (RACDatabase)abt;
            dataguardStatus = racDatabase.getDataguardStatus();
            db = racDatabase.getDBsystemInterface();
        } else if (abt instanceof SIDatabase) {
            SIDatabase siDatabase = (SIDatabase)abt;
            dataguardStatus = siDatabase.getDataguardStatus();
            db = siDatabase.getDBsystemInterface();
        }
        if (dataguardStatus != null) {
            List secondarys;
            if (dataguardStatus.toLowerCase().contains("standby")) {
                return true;
            }
            if (dataguardStatus.toLowerCase().equals("primary") && (secondarys = db.getSecondary()) != null && secondarys.size() > 0) {
                return true;
            }
        }
        return false;
    }

    public static boolean isUsingBroker(AbstractBaseTarget abt) {
        DB db = null;
        String dbName = null;
        if (abt instanceof RACDatabase) {
            RACDatabase racDatabase = (RACDatabase)abt;
            db = racDatabase.getDBsystemInterface();
            dbName = racDatabase.getDatabaseName();
        } else if (abt instanceof SIDatabase) {
            SIDatabase siDatabase = (SIDatabase)abt;
            db = siDatabase.getDBsystemInterface();
            dbName = siDatabase.getDatabaseName();
        }
        if (db != null && db.getUsingDataGuardBroker()) {
            logger.info("Database" + dbName + " si using dataguard broker");
            return true;
        }
        return false;
    }

    public static DB getPrimaryDB(AbstractBaseTarget abt) {
        DB primaryDB = null;
        if (abt instanceof RACDatabase) {
            RACDatabase rac = (RACDatabase)abt;
            if (rac.getDataguardStatus() != null && rac.getDataguardStatus().toLowerCase().contains("standby")) {
                primaryDB = rac.getDBsystemInterface().getPrimary();
            } else if (rac.getDataguardStatus() != null && rac.getDataguardStatus().toLowerCase().equals("primary")) {
                primaryDB = rac.getDBsystemInterface();
            }
        } else if (abt instanceof SIDatabase) {
            SIDatabase sidb = (SIDatabase)abt;
            if (sidb.getDataguardStatus() != null && sidb.getDataguardStatus().toLowerCase().contains("standby")) {
                primaryDB = sidb.getDBsystemInterface().getPrimary();
            } else if (sidb.getDataguardStatus() != null && sidb.getDataguardStatus().toLowerCase().equals("primary")) {
                primaryDB = sidb.getDBsystemInterface();
            }
        }
        return primaryDB;
    }

    public static boolean shouldExecuteSqlCommand(AbstractBaseTarget abt, List<GenericPatch> patches, ActionType actionType) {
        if (restoreType.equals(actionType.getType()) || sqlPatchRestoreType.equals(actionType.getType())) {
            return !DBCommandUtils.isPhysicalStandbyDatabase(abt);
        }
        DB primaryDB = DBCommandUtils.getPrimaryDB(abt);
        if (DBCommandUtils.isPrimaryAndStandbyONSameCluster(abt)) {
            return !DBCommandUtils.isPhysicalStandbyDatabase(abt);
        }
        String dbName = null;
        if (abt instanceof RACDatabase) {
            RACDatabase racDB = (RACDatabase)abt;
            dbName = racDB.getDatabaseName();
        } else if (abt instanceof SIDatabase) {
            SIDatabase sidb = (SIDatabase)abt;
            dbName = sidb.getDatabaseName();
        }
        if (primaryDB != null && primaryDB.getSecondary() != null && primaryDB.getSecondary().size() > 0) {
            List secondaryDBs = primaryDB.getSecondary();
            for (DB secondary : secondaryDBs) {
                String secondaryDBName = DBCommandUtils.getDBName(secondary);
                if (DBCommandUtils.isPhysicalStandbyDatabase(abt) && dbName.equals(secondaryDBName) || DBCommandUtils.allPatchesAppliedONHome(patches, DBCommandUtils.getDBOracleHomeObject(secondary))) continue;
                return false;
            }
            if (DBCommandUtils.isPhysicalStandbyDatabase(abt) && !DBCommandUtils.allPatchesAppliedONHome(patches, DBCommandUtils.getDBOracleHomeObject(primaryDB))) {
                return false;
            }
        }
        return true;
    }

    private static boolean allStandbyInSameCluster(DB primaryDB, CRSCluster crs) {
        List racList = crs.getDbRAC();
        List siList = crs.getDbSI();
        if (primaryDB != null && primaryDB.getSecondary() != null && primaryDB.getSecondary().size() > 0) {
            List secondaryDBs = primaryDB.getSecondary();
            for (DB secondary : secondaryDBs) {
                if (secondary.getSI() != null) {
                    SIDatabase si = secondary.getSI();
                    if (siList == null || siList.contains(si)) continue;
                    return false;
                }
                if (secondary.getRAC() == null) continue;
                RACDatabase rac = secondary.getRAC();
                if (racList == null || racList.contains(rac)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isPrimaryAndStandbyONSameCluster(AbstractBaseTarget abt) {
        ConfigGraph configgraph;
        AbstractBaseTarget root;
        DB primaryDB = DBCommandUtils.getPrimaryDB(abt);
        if (primaryDB != null && (root = (configgraph = PatchPlanner.getInstance().getConfigGraph()).getRootVertex()) instanceof CRSCluster) {
            CRSCluster crs = (CRSCluster)root;
            List racList = crs.getDbRAC();
            List siList = crs.getDbSI();
            if (primaryDB.getRAC() != null) {
                RACDatabase primaryRac = primaryDB.getRAC();
                if (racList != null && racList.contains(primaryRac) && DBCommandUtils.allStandbyInSameCluster(primaryDB, crs)) {
                    return true;
                }
            } else if (primaryDB.getSI() != null) {
                SIDatabase primarySi = primaryDB.getSI();
                if (siList != null && siList.contains(primarySi) && DBCommandUtils.allStandbyInSameCluster(primaryDB, crs)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static OracleHome getDBOracleHomeObject(DB db) {
        if (db.getRAC() != null) {
            return ((RACDBInstance)db.getRAC().getDbInstances().get(0)).getRuns_from();
        }
        if (db.getSI() != null) {
            return db.getSI().getRuns_from();
        }
        return null;
    }

    private static String getDBName(DB db) {
        if (db != null) {
            if (db.getRAC() != null) {
                return db.getRAC().getDatabaseName();
            }
            if (db.getSI() != null) {
                return db.getSI().getDatabaseName();
            }
        }
        return null;
    }

    private static boolean allPatchesAppliedONHome(List<GenericPatch> patches, OracleHome oh) {
        List standbyPatches = oh.getPatches();
        boolean isApplied = false;
        for (GenericPatch patch : patches) {
            logger.info("Check if the patch " + patch.getPatchID() + " has been applied on oracle home of standby db " + oh.getName());
            isApplied = false;
            if (standbyPatches != null && standbyPatches.size() > 0) {
                for (BasePatch basePatch : standbyPatches) {
                    if (!basePatch.getPatchID().equals(patch.getPatchID())) continue;
                    logger.info("patch " + patch.getPatchID() + " has been applied on standby database");
                    isApplied = true;
                    break;
                }
                if (isApplied) continue;
                logger.severe("Patch " + patch.getPatchID() + " has not been patched on oracle home " + oh.getPath());
                return false;
            }
            logger.info("No patch in oracle home " + oh.getName());
            return false;
        }
        return true;
    }

    public static boolean isPhysicalStandbyDatabase(AbstractBaseTarget db) {
        String dataGuardStatus = null;
        if (db instanceof RACDatabase) {
            RACDatabase database = (RACDatabase)db;
            dataGuardStatus = database.getDataguardStatus();
        } else if (db instanceof SIDatabase) {
            SIDatabase database = (SIDatabase)db;
            dataGuardStatus = database.getDataguardStatus();
        }
        return dataGuardStatus != null && dataGuardStatus.toLowerCase().contains("physical standby");
    }

    public static boolean isPhysicalStandbyRACDatabase(RACDatabase racDatabase) {
        String dataGuardStatus = racDatabase.getDataguardStatus();
        return dataGuardStatus != null && dataGuardStatus.toLowerCase().contains("physical standby");
    }

    public static OracleHome getPrimaryOHForStandbyRACDatabase(RACDatabase database) {
        RACDatabase primaryRAC;
        List racInsts;
        DB db = database.getDBsystemInterface();
        DB primaryDB = db.getPrimary();
        if (primaryDB.getRAC() != null && (racInsts = (primaryRAC = primaryDB.getRAC()).getDbInstances()) != null && racInsts.size() > 0) {
            return ((RACDBInstance)racInsts.get(0)).getRuns_from();
        }
        if (primaryDB.getSI() != null) {
            SIDatabase primarySI = primaryDB.getSI();
            return primarySI.getRuns_from();
        }
        throw new PatchPlanInternalException("Can not found the primary host information for standby database " + database.getName());
    }

    public static Host getPrimaryHostForStandbyRACDatabase(RACDatabase database) {
        RACDatabase primaryRAC;
        List racInsts;
        DB db = database.getDBsystemInterface();
        DB primaryDB = db.getPrimary();
        if (primaryDB.getRAC() != null && (racInsts = (primaryRAC = primaryDB.getRAC()).getDbInstances()) != null && racInsts.size() > 0) {
            return ((RACDBInstance)racInsts.get(0)).getHost();
        }
        if (primaryDB.getSI() != null) {
            SIDatabase primarySI = primaryDB.getSI();
            return primarySI.getHost();
        }
        throw new PatchPlanInternalException("Can not found the primary host information for standby database " + database.getName());
    }

    public static CommandContext resetContext(AbstractBaseTarget db) {
        if (db instanceof RACDatabase) {
            return DBCommandUtils.resetContextByRACDatabase((RACDatabase)db);
        }
        if (db instanceof SIDatabase) {
            return DBCommandUtils.resetContextBySIDatabase((SIDatabase)db);
        }
        return null;
    }

    public static CommandContext resetContextBySIDatabase(SIDatabase sidb) {
        CommandContext context = new CommandContext();
        ArrayList<Host> hosts = new ArrayList<Host>();
        ArrayList<OracleHome> oracleHomeList = new ArrayList<OracleHome>();
        oracleHomeList.add(sidb.getRuns_from());
        hosts.add(sidb.getHost());
        context.setPrimaryTarget((AbstractBaseTarget)sidb);
        context.putTargets(hosts);
        context.putTargets(oracleHomeList);
        return context;
    }

    public static CommandContext resetContextByRACDatabase(RACDatabase racDB) {
        CommandContext context = new CommandContext();
        ArrayList<RACDBInstance> instances = new ArrayList<RACDBInstance>();
        ArrayList<Host> hosts = new ArrayList<Host>();
        ArrayList<OracleHome> oracleHomeList = new ArrayList<OracleHome>();
        for (RACDBInstance inst : racDB.getDbInstances()) {
            instances.add(inst);
            hosts.add(inst.getHost());
            oracleHomeList.add(inst.getRuns_from());
        }
        context.setPrimaryTarget((AbstractBaseTarget)racDB);
        context.putTargets(instances);
        context.putTargets(hosts);
        context.putTargets(oracleHomeList);
        return context;
    }

    public static CommandContext resetContextForStandbyDB(AbstractBaseTarget primaryTarget) {
        DB primaryDB = null;
        CommandContext context = null;
        if (primaryTarget instanceof RACDatabase) {
            RACDatabase rac = (RACDatabase)primaryTarget;
            primaryDB = rac.getDBsystemInterface().getPrimary();
        } else if (primaryTarget instanceof SIDatabase) {
            SIDatabase si = (SIDatabase)primaryTarget;
            primaryDB = si.getDBsystemInterface().getPrimary();
        }
        if (primaryDB != null && primaryDB.getRAC() != null) {
            context = DBCommandUtils.resetContextByRACDatabase(primaryDB.getRAC());
        } else if (primaryDB != null && primaryDB.getSI() != null) {
            context = DBCommandUtils.resetContextBySIDatabase(primaryDB.getSI());
        }
        return context;
    }

    public static boolean isRemoteDB(AbstractBaseTarget target) {
        block3: {
            SystemInstance si;
            block2: {
                si = PatchPlanner.getInstance().getSystemInstance();
                if (!(target instanceof RACDatabase)) break block2;
                RACDatabase rac = (RACDatabase)target;
                List racList = si.getTargetsOfType(RACDatabase.class);
                for (RACDatabase entity : racList) {
                    if (!entity.equals(rac)) continue;
                    return false;
                }
                break block3;
            }
            if (!(target instanceof SIDatabase)) break block3;
            SIDatabase sidb = (SIDatabase)target;
            List sidbList = si.getTargetsOfType(SIDatabase.class);
            for (SIDatabase entity : sidbList) {
                if (!entity.equals(sidb)) continue;
                return false;
            }
        }
        return true;
    }

    public static String getOracleSID(ExecutionStep executionStep, AbstractBaseTarget primaryTarget) {
        if (primaryTarget instanceof RACDBInstance) {
            RACDBInstance instance = (RACDBInstance)primaryTarget;
            return instance.getInstanceName();
        }
        if (primaryTarget instanceof RACDatabase) {
            RACDatabase racDB = (RACDatabase)primaryTarget;
            for (RACDBInstance rdbi : racDB.getDbInstances()) {
                if (!executionStep.getHost().getHostName().equals(rdbi.getHost().getHostName())) continue;
                return rdbi.getInstanceName();
            }
            throw new PatchPlanException("There is no RAC DB Instance running on" + executionStep.getHost().getHostName());
        }
        if (primaryTarget instanceof SIDatabase) {
            SIDatabase siDB = (SIDatabase)primaryTarget;
            return siDB.getInstanceName();
        }
        throw new PatchPlanException("Can not get OracleSID from " + primaryTarget.getClass().getName());
    }

    public static String getRACDBVersionForCurrentHome(OracleHome oh) {
        String dbVersion = null;
        RACDatabase racDB = null;
        OracleHome oracleHome = oh;
        if (oh.getOriginalOracleHome() != null) {
            oracleHome = oh.getOriginalOracleHome();
        }
        block0: for (BaseClass bc : PatchPlanner.getInstance().getConfigGraph().getSystemInstance().getEntities()) {
            if (!(bc instanceof RACDatabase)) continue;
            racDB = (RACDatabase)bc;
            for (RACDBInstance racDBInst : racDB.getDbInstances()) {
                if (!racDBInst.getRuns_from().getPath().equals(oracleHome.getPath())) continue;
                dbVersion = racDB.getVersion();
                continue block0;
            }
        }
        return dbVersion;
    }

    public static boolean isGIPatchingRequested() {
        boolean isGIPatchingRequested = false;
        OracleHome oh = null;
        for (BaseClass bc : PatchPlanner.getInstance().getConfigGraph().getSystemInstance().getEntities()) {
            if (!(bc instanceof OracleHome)) continue;
            oh = (OracleHome)bc;
            if (!CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.crs.toString().equals(oh.getHomeType()) || PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType(CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.crs.toString())).isEmpty() || PatchPlanner.getInstance().getOPlanEnv().getSkippedTargetMap().get(CRSCluster.class) != null || DBCommandUtils.isGIMarkedForSkip()) continue;
            isGIPatchingRequested = true;
            break;
        }
        logger.fine("Is GI Patching requested::" + isGIPatchingRequested);
        return isGIPatchingRequested;
    }

    public static boolean isGIMarkedForSkip() {
        boolean isGIMarkedForSkip = false;
        List crss = PatchPlanner.getInstance().getConfigGraph().getSystemInstance().getTargetsOfType(CRSCluster.class);
        CRSCluster crs = (CRSCluster)crss.get(0);
        logger.fine("Checking CRSCluster: " + crs);
        if (crs.getProperty(SkipTargetCookie.class) != null) {
            isGIMarkedForSkip = true;
        }
        return isGIMarkedForSkip;
    }

    public static boolean isSIHAMarkedForSkip() {
        boolean isSIHAMarkedForSkip = false;
        List hasList = PatchPlanner.getInstance().getConfigGraph().getSystemInstance().getTargetsOfType(HAS.class);
        HAS has = (HAS)hasList.get(0);
        logger.fine("Checking HAS: " + has);
        if (has.getProperty(SkipTargetCookie.class) != null) {
            isSIHAMarkedForSkip = true;
        }
        return isSIHAMarkedForSkip;
    }

    public static boolean isGIAndRACPatchingRequested() {
        boolean isGIAndRACPatchingRequested = false;
        boolean isGIRequested = false;
        boolean isRACRequested = false;
        OracleHome oh = null;
        for (BaseClass bc : PatchPlanner.getInstance().getConfigGraph().getSystemInstance().getEntities()) {
            if (!(bc instanceof OracleHome)) continue;
            oh = (OracleHome)bc;
            if (!isGIRequested && CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.crs.toString().equals(oh.getHomeType()) && !PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType(CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.crs.toString())).isEmpty() && PatchPlanner.getInstance().getOPlanEnv().getSkippedTargetMap().get(CRSCluster.class) == null && !DBCommandUtils.isGIMarkedForSkip()) {
                isGIRequested = true;
            }
            if (!(isRACRequested || !CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.toString().equals(oh.getHomeType()) || PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType(CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.toString())).isEmpty() || PatchPlanner.getInstance().getOPlanEnv().getSkippedTargetMap().get(RACDatabase.class) != null && PatchPlanner.getInstance().getOPlanEnv().getSkippedTargetMap().get(RACDatabase.class).contains(oh.getName()) || oh.getProperty(SkipTargetCookie.class) != null)) {
                isRACRequested = true;
            }
            if (!isGIRequested || !isRACRequested) continue;
            isGIAndRACPatchingRequested = true;
            break;
        }
        return isGIAndRACPatchingRequested;
    }

    public static boolean isSQLPatchUpgradeMode() {
        boolean isSQLPatchUpgradeMode = false;
        OOPSessionInfo oopSessionInfo = OOPSessionInfoHandler.getInstance().getOOPSessionInfo();
        if (oopSessionInfo != null) {
            isSQLPatchUpgradeMode = oopSessionInfo.getPatchInfo().isSQLPatchInUpgradeMode();
            return isSQLPatchUpgradeMode;
        }
        PatchPackage patch = PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getPrimaryPatchPackage();
        if (patch instanceof Bundle) {
            OPatchSingleton subpatch;
            GenericPatch subPatch;
            List subPatches = ((Bundle)patch).getSubPatches();
            Iterator iterator = subPatches.iterator();
            while (!(!iterator.hasNext() || (subPatch = (GenericPatch)iterator.next()) instanceof OPatchSingleton && (isSQLPatchUpgradeMode = null != (subpatch = (OPatchSingleton)subPatch).getSqlPatchUpgradeMode() ? subpatch.getSqlPatchUpgradeMode() : false))) {
            }
        } else if (patch instanceof OPatchSingleton) {
            isSQLPatchUpgradeMode = null != ((OPatchSingleton)patch).getSqlPatchUpgradeMode() ? ((OPatchSingleton)patch).getSqlPatchUpgradeMode() : false;
        } else if (patch instanceof CompositePatch) {
            OPatchSingleton subpatch;
            GenericSingletonPatch singlePatch;
            List subPatches = ((CompositePatch)patch).getSubPatches();
            Iterator iterator = subPatches.iterator();
            while (!(!iterator.hasNext() || (singlePatch = (GenericSingletonPatch)iterator.next()) instanceof OPatchSingleton && (isSQLPatchUpgradeMode = null != (subpatch = (OPatchSingleton)singlePatch).getSqlPatchUpgradeMode() ? subpatch.getSqlPatchUpgradeMode() : false))) {
            }
        }
        if (isSQLPatchUpgradeMode) {
            logger.info("This patching session performs sql patching in upgrade mode.");
        }
        return isSQLPatchUpgradeMode;
    }

    public static String getTemPatchLocForRemoteNode(String mainPatchLoc, String patchLoc) {
        int mainPatchLocIndex = patchLoc.indexOf(mainPatchLoc);
        if (mainPatchLocIndex != -1) {
            int index = mainPatchLocIndex + mainPatchLoc.length();
            String subPatch = patchLoc.substring(index);
            patchLoc = DBCommandParameters.TEMP_PATCH_LOC.getValue() + subPatch;
        }
        return patchLoc;
    }

    public static String getTokenValueFromCommand(String cmd, String token) {
        String retVal = null;
        StringTokenizer st = new StringTokenizer(cmd);
        while (st.hasMoreTokens()) {
            String param = st.nextToken();
            if (!param.equals(token)) continue;
            retVal = st.nextToken();
            break;
        }
        return retVal;
    }

    public static boolean isNonRollingDeploymentMode() {
        String runtimeDeploymentSubType = PatchPlanner.getInstance().getOPlanEnv().getProperty("runtimeDeploymentSubType");
        String autoDeploymentSubType = PatchPlanner.getInstance().getOPlanEnv().getProperty("autoDeploymentSubType");
        return runtimeDeploymentSubType != null ? DeploymentSubType.NON_ROLLING_UPGRADE.toString().equalsIgnoreCase(runtimeDeploymentSubType) : DeploymentSubType.NON_ROLLING_UPGRADE.toString().equalsIgnoreCase(autoDeploymentSubType);
    }

    public static String getSerializationLocationForRelocateServices(String home, String hostName) {
        return HelperUtility.detectOraBaseConfig((String)home) + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_DBTMP_DIR + "relocationServicesInfo_" + hostName;
    }
}

