/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.ExecutionMode;
import com.oracle.glcm.patch.auto.db.framework.sdk.PatchPlanException;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patch.PatchPackagesBag;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.SystemModelUtils;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandParameters;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import com.oracle.glcm.patch.auto.db.product.engine.CRSContextPopulator;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import dbmodel.patchmodel.CompositePatch;
import dbmodel.patchmodel.GenericPatch;
import dbmodel.patchmodel.GenericSingletonPatch;
import dbmodel.patchmodel.OPatchSingleton;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.Command;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.PhaseType;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class SqlPatchCommand
extends com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command {
    private static final String ohOption = "-oh";
    CommandAction automationAction;
    Logger logger = Logger.getLogger(SqlPatchCommand.class.getName());

    public SqlPatchCommand(CommandAction automationAction) {
        super((ActionType)automationAction);
        this.automationAction = automationAction;
    }

    @Override
    protected List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            ExecutionStep executionStep;
            CommandContext context = contextPopulator.populateContext(g, abstractBaseTarget, this.getHost());
            if (this.automationAction.isActsOnClone()) {
                contextPopulator.fixCloneContext(context);
            }
            if ((executionStep = this.getExecutionStep(context)) == null) continue;
            steps.add(executionStep);
        }
        return steps;
    }

    private ExecutionStep getExecutionStep(CommandContext context) {
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        AbstractBaseTarget db = context.getPrimaryTarget();
        if (DBCommandUtils.isPhysicalStandbyDatabase(db)) {
            context = DBCommandUtils.resetContextForStandbyDB(db);
            oh = context.getFirstTarget(OracleHome.class);
            db = context.getPrimaryTarget();
        }
        if (!this.isSqlpatchAvailable()) {
            return null;
        }
        ExecutionStep executionStep = CommandUtils.getBasicExecutionStep((ActionType)this.automationAction, context, null);
        if (this.automationAction.isActsOnClone() && DBCommandUtils.isRemoteDB(db)) {
            this.logger.info("Current step is running on remote db " + db.getDisplayName() + ". Set acts_on_clone property to null");
            executionStep.getAutomationAction().setActsOnClone(null);
        }
        ArrayList<String> cmds = new ArrayList<String>();
        StringBuilder copySqlpatchCmd = new StringBuilder();
        StringBuilder cmd = new StringBuilder();
        String OracleSid = this.getOracleSIDForActiveInstance(executionStep, db);
        boolean isPrereqPhase = this.getPatchingPhase().getPhaseType().equals((Object)PhaseType.PRE_REQ);
        if (db instanceof SIDatabase || db instanceof RACDatabase) {
            if (db instanceof RACDatabase) {
                boolean isSQLPatchUpgradeMode = DBCommandUtils.isSQLPatchUpgradeMode();
                if (isPrereqPhase && isSQLPatchUpgradeMode) {
                    return null;
                }
            }
            if (isPrereqPhase) {
                cmd.append("cd " + oh.getPath() + "; ORACLE_HOME=" + oh.getPath() + " ORACLE_SID=" + OracleSid + " " + oh.getPath() + "/OPatch/datapatch " + DBCommandParameters.PREREQ.getValue() + " " + DBCommandParameters.VERBOSE.getValue());
            } else {
                if (this.automationAction.getType().equals(DBCommandActionType.SqlPatchSwitchback.toString())) {
                    copySqlpatchCmd.append(oh.getOriginalOracleHome().getPath() + "/perl/bin/perl " + oh.getOriginalOracleHome().getPath() + "/sqlpatch/copy_sqlpatch_files.pl" + " -src_home " + oh.getOriginalOracleHome().getPath() + " -dest_home " + oh.getPath());
                }
                cmd.append("cd " + oh.getPath() + ";ORACLE_HOME=" + oh.getPath() + " ORACLE_SID=" + OracleSid + " " + oh.getPath() + "/OPatch/datapatch " + DBCommandParameters.VERBOSE.getValue());
            }
        }
        if (this.automationAction.getType().equals(DBCommandActionType.SqlPatchSwitchback.toString())) {
            File copySqlpatchScript = new File(oh.getOriginalOracleHome().getPath() + "/sqlpatch/copy_sqlpatch_files.pl");
            if (copySqlpatchScript.exists()) {
                cmds.add(copySqlpatchCmd.toString());
            } else {
                this.logger.info("Script for copying sqlpatch is not available.");
            }
        }
        List automationCommands = this.automationAction.getCommand();
        for (Command c : automationCommands) {
            for (String param : c.getParameter()) {
                if (!ohOption.equalsIgnoreCase(param) || DBCommandUtils.isRemoteDB(context.getPrimaryTarget())) continue;
                cmd.append(" ").append(ohOption).append(" ").append(oh.getOriginalOracleHome().getPath());
            }
        }
        cmds.add(cmd.toString());
        for (String s : cmds) {
            executionStep.getCommand().add(new ExecutionStep.Command(s));
        }
        return executionStep;
    }

    private boolean isSqlpatchAvailable() {
        boolean isSqlPatch;
        block9: {
            isSqlPatch = false;
            PatchPackagesBag patchbag = null;
            try {
                patchbag = PatchPlanner.getInstance().getOPlanEnv().getPatchesBag();
                if (patchbag == null) break block9;
                List<GenericPatch> genericPatchList = patchbag.getAllPatches();
                for (GenericPatch patch : genericPatchList) {
                    if (patch instanceof OPatchSingleton && this.parseBoolean(((OPatchSingleton)patch).getSqlPatch())) {
                        isSqlPatch = true;
                    } else if (patch instanceof CompositePatch) {
                        if (this.parseBoolean(((CompositePatch)patch).getSqlPatch())) {
                            isSqlPatch = true;
                        } else {
                            List subpatchList = ((CompositePatch)patch).getSubPatches();
                            for (GenericSingletonPatch subPatch : subpatchList) {
                                if (!(subPatch instanceof OPatchSingleton) || !this.parseBoolean(((OPatchSingleton)subPatch).getSqlPatch())) continue;
                                isSqlPatch = true;
                                break;
                            }
                        }
                    }
                    if (!isSqlPatch) continue;
                    break;
                }
            }
            catch (Exception e) {
                this.logger.warning("Exception while getting patch bag:" + e.getLocalizedMessage());
                isSqlPatch = true;
            }
        }
        this.logger.info("Is SQL patch available=" + isSqlPatch);
        return isSqlPatch;
    }

    private boolean parseBoolean(Boolean val) {
        return val != null && val != false;
    }

    private String getOracleSIDForActiveInstance(ExecutionStep executionStep, AbstractBaseTarget primaryTarget) {
        if (primaryTarget instanceof RACDBInstance) {
            RACDBInstance instance = (RACDBInstance)primaryTarget;
            return instance.getInstanceName();
        }
        if (primaryTarget instanceof RACDatabase) {
            RACDatabase racDB = (RACDatabase)primaryTarget;
            ExecutionMode exeMode = PatchPlanner.getInstance().getOPlanEnv().getExecutionMode();
            if (ExecutionMode.OPATCH.toString().equalsIgnoreCase(exeMode.toString())) {
                return DBCommandUtils.getOracleSID(executionStep, primaryTarget);
            }
            for (RACDBInstance rdbi : racDB.getDbInstances()) {
                if (rdbi.getIsRunning() != null) {
                    if (!"yes".equals(rdbi.getIsRunning())) continue;
                    executionStep.setHost(rdbi.getHost());
                    return rdbi.getInstanceName();
                }
                return DBCommandUtils.getOracleSID(executionStep, primaryTarget);
            }
            throw new PatchPlanException("There is no RAC DB Instance running on" + executionStep.getHost().getHostName());
        }
        if (primaryTarget instanceof SIDatabase) {
            SIDatabase siDB = (SIDatabase)primaryTarget;
            return siDB.getInstanceName();
        }
        throw new PatchPlanException("Can not get OracleSID from " + primaryTarget.getClass().getName());
    }

    @Override
    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        Class<? extends AbstractBaseTarget> type = SystemModelUtils.getClassForType(this.automationAction.getActsOn());
        return g.getTargets(type, this.automationAction.getStripe());
    }

    public static class Builder
    implements CommandBuilder<SqlPatchCommand> {
        @Override
        public SqlPatchCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction && (a.getType().equals(DBCommandActionType.SqlPatch.toString()) || a.getType().equals(DBCommandActionType.SqlPatchApply.toString()) || a.getType().equals(DBCommandActionType.SqlPatchRollback.toString()) || a.getType().equals(DBCommandActionType.SqlPatchSwitchback.toString()) || a.getType().equals(DBCommandActionType.SqlPatchRestore.toString())))) {
                return null;
            }
            return new SqlPatchCommand((CommandAction)a);
        }
    }
}

