/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.SimpleShellCommand;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class StopHasCommand
extends SimpleShellCommand {
    Logger logger = Logger.getLogger(StopHasCommand.class.getName());
    CommandAction automationAction;

    public StopHasCommand(CommandAction automationAction) {
        super((ActionType)automationAction);
        this.automationAction = automationAction;
    }

    @Override
    public List<ExecutionStep> generateExecutionSteps(ConfigGraph configGraph, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        List<ExecutionStep> executionSteps = new ArrayList<ExecutionStep>();
        if (DBCommandUtils.isNonRollingDeploymentMode()) {
            executionSteps = super.generateExecutionSteps(configGraph, actsOnlyOnTargets);
        }
        return executionSteps;
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        this.logger.log(Level.FINE, "Generating stophas command.");
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        String crsHome = oh.getPath();
        this.logger.log(Level.FINE, "OracleHome path = " + crsHome);
        String cmd = crsHome + "/bin/crsctl stop HAS";
        return Collections.singletonList(cmd);
    }

    public static class Builder
    implements CommandBuilder<StopHasCommand> {
        @Override
        public StopHasCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals(DBCommandActionType.StopHAS.toString())) {
                return null;
            }
            StopHasCommand com = new StopHasCommand((CommandAction)a);
            return com;
        }
    }
}

