/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.driver.sdb;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.integration.controller.RemoteContentTransferHandler;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PatchActionUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.driver.jdbc.util.SDBCatalogConnection;
import com.oracle.glcm.patch.auto.db.product.driver.sdb.CRSHASSystemInstBuilder;
import com.oracle.glcm.patch.auto.db.product.driver.sdb.DGSystemInstBuilder;
import com.oracle.glcm.patch.auto.db.product.driver.sdb.OGGSystemInstBuilder;
import com.oracle.glcm.patch.auto.db.product.driver.sdb.SDBSystemInstBuilder;
import com.oracle.glcm.patch.auto.db.product.driver.sdb.ShardGroupSystemInstBuilder;
import com.oracle.glcm.patch.auto.db.product.driver.sdb.ShardSpaceSystemInstBuilder;
import com.oracle.glcm.patch.auto.db.product.driver.sdb.ShardSystemInstBuilder;
import com.oracle.glcm.patch.auto.topology.HostImpl;
import dbmodel.SystemInstance;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.ShardProperty;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.LocalInfo;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriver;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriverException;

public class SDBProductDriver
extends ProductDriver {
    Logger logger = Logger.getLogger(SDBProductDriver.class.getName());
    protected SDBCatalogConnection sdbCatalogConnection = null;
    protected List<ShardProperty> shardPropertyList = null;
    protected List<OracleHome> homes = new ArrayList<OracleHome>();
    private String host = null;
    private String port = null;
    private String dbname = null;
    private String servicename = null;
    protected CredentialManager credentialManager = null;
    protected boolean isOgg = false;
    protected int shardingType = 0;

    public SDBProductDriver() {
    }

    public SDBProductDriver(String host, String dbname, String servicename, String port, CredentialManager credentialManager) {
        this.host = host;
        this.port = port;
        this.dbname = dbname;
        this.servicename = servicename;
        this.credentialManager = credentialManager;
    }

    public SystemInstance buildSystemInstance() throws ProductDriverException {
        if (null != this.ti) {
            return this.ti;
        }
        this.logger.finest("Started building the SystemInstance for SDB");
        String userID = "";
        String password = "";
        try {
            String key = this.credentialManager.getCredentialKey(!StringUtil.isNullOrEmpty((String)this.dbname) ? this.dbname : this.servicename, "jdbc");
            Credential credential = this.credentialManager.getCredentialByKey(key);
            userID = credential.getUsername();
            password = new String(credential.getPassword());
            this.executeQueries(this.host, this.dbname, this.servicename, this.port, userID, password);
            this.ti = new SystemInstance();
            SDBSystemInstBuilder sdbSystemInstBuilder = new SDBSystemInstBuilder(this.isOgg, this.shardingType, this.ti);
            this.ti = sdbSystemInstBuilder.createSystemInstance();
            ShardSystemInstBuilder shardSystemInstBuilder = new ShardSystemInstBuilder(this.shardPropertyList, this.ti, this.credentialManager);
            this.ti = shardSystemInstBuilder.createSystemInstance();
            ShardGroupSystemInstBuilder shdGrpSystemInstBuilder = new ShardGroupSystemInstBuilder(this.shardPropertyList, this.ti);
            this.ti = shdGrpSystemInstBuilder.createSystemInstance();
            ShardSpaceSystemInstBuilder shdSpcSystemInstBuilder = new ShardSpaceSystemInstBuilder(this.shardPropertyList, this.ti);
            this.ti = shdSpcSystemInstBuilder.createSystemInstance();
            CRSHASSystemInstBuilder crshasSystemInstBuilder = new CRSHASSystemInstBuilder(this.credentialManager, this.ti);
            this.ti = crshasSystemInstBuilder.createSystemInstance();
            OGGSystemInstBuilder oggSystemInstBuilder = new OGGSystemInstBuilder(this.isOgg, this.ti, this.credentialManager);
            this.ti = oggSystemInstBuilder.createSystemInstance();
            DGSystemInstBuilder dgSystemInstBuilder = new DGSystemInstBuilder(this.isOgg, this.ti);
            this.ti = dgSystemInstBuilder.createSystemInstance();
        }
        catch (OPatchAutoException e) {
            this.logger.throwing("Failed to create topology :: Unable to access catalog DB credentials : ", e.getMessage(), e);
            throw new ProductDriverException("Failed to create topology :: Unable to access catalog DB credentials : \n" + (Object)((Object)e));
        }
        this.logger.finest("Completed building SystemInstance for SDB");
        return this.ti;
    }

    private void executeQueries(String host, String dbname, String serviceName, String port, String userID, String password) throws ProductDriverException {
        this.logger.info("Going to collect shard details from catalog");
        this.sdbCatalogConnection = SDBCatalogConnection.getInstance();
        this.sdbCatalogConnection.init(host, port, dbname, serviceName, userID, password);
        try {
            int replType = this.sdbCatalogConnection.getReplicationType();
            this.isOgg = replType == 1;
            this.shardingType = this.sdbCatalogConnection.getShardingType();
            this.shardPropertyList = this.sdbCatalogConnection.getAllShardDBDetails(this.isOgg);
        }
        catch (SQLException e) {
            this.logger.throwing("Unable to retrieve data from catalog database : ", e.getMessage(), e);
            throw new ProductDriverException(OPatchAutoHelper.getLocalizedString((String)"SDBCatalogConnection.dbdata.retrieve.failure", (Object[])new Object[]{!StringUtil.isNullOrEmpty((String)dbname) ? dbname : serviceName, e}));
        }
        this.logger.finest("Finished collecting data from catalog");
    }

    protected String getHomeOwner(String hostname, String ohPath, boolean isOggHome, CredentialManager credentialManager, String oggHomePath) {
        String owner = null;
        try {
            HostImpl hostImpl = PatchActionUtil.createHostImpl(credentialManager, hostname, ohPath);
            RemoteConnectionHandler handler = PatchActionUtil.getHandler(hostImpl);
            RemoteContentTransferHandler contentHandler = RemoteContentTransferHandler.getInstance();
            owner = isOggHome ? contentHandler.findRemoteHomeOwner(ohPath, oggHomePath + "/ggsci", handler) : contentHandler.findRemoteHomeOwner(ohPath, ohPath + File.separator + DBCommonPatchingConstants.OPATCHAUTO_SCRIPT, handler);
            this.logger.fine("Home owner of home " + ohPath + " on host " + hostname + " : " + owner);
        }
        catch (RemoteConnectionException ex) {
            this.logger.throwing("Detailed Exception while determing home owner : ", ex.getMessage(), ex);
            Reporting.report((String)OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72077), (Object[])new Object[]{ohPath, hostname}));
            throw new ProductDriverException((Throwable)ex);
        }
        return owner;
    }

    public LocalInfo getLocalInfo() {
        return null;
    }
}

