/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.driver.sidb;

import com.oracle.cie.common.util.FileUtils;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.product.driver.crs.AbstractCrsProductDriver;
import com.oracle.helper.util.HelperUtility;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.common.OUIComponent;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.SIDatabase;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriverException;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;
import oracle.dbsysmodel.driver.sdk.util.OsysUtility;

public class OUISIDBProductDriver
extends AbstractCrsProductDriver {
    private String ohPath;
    private String sid;
    private String port;

    public OUISIDBProductDriver(String homePath, String sid, String port) {
        this.sid = sid == null ? System.getenv("ORACLE_SID") : sid;
        this.port = port == null ? System.getenv("ORACLE_PORT") : port;
        this.ohPath = homePath;
    }

    public SystemInstance buildSystemInstance() {
        if (StringUtil.isNullOrEmpty((String)this.sid, (boolean)true)) {
            Reporting.report((String)"Please set ORACLE_SID property to proceed");
            throw new ProductDriverException("Please set ORACLE_SID property to proceed");
        }
        String dbName = this.getDbname();
        this.ti = new SystemInstance();
        SIDatabase sidb = this.createSIDB(dbName);
        String owner = FileUtility.checkFileOwner((File)new File(this.ohPath, "oraInst.loc"));
        sidb.setOwner(owner);
        this.extractOracleHome(this.ohPath, owner, sidb);
        this.ti.getEntities().add(sidb);
        return this.ti;
    }

    private SIDatabase createSIDB(String dbName) {
        SIDatabase sidb = new SIDatabase();
        sidb.setSID(this.sid);
        sidb.setInstanceName(this.sid);
        sidb.setPort(this.port);
        sidb.setDatabaseName(dbName);
        return sidb;
    }

    private String getDbname() {
        String dbname = null;
        String oraFilePath = this.ohPath + File.separator + "dbs" + File.separator + "spfile" + this.sid + ".ora";
        try {
            String ohbaseConfig;
            if (!(new File(oraFilePath).exists() || new File(oraFilePath = this.ohPath + File.separator + "dbs" + File.separator + "init" + this.sid + ".ora").exists() || new File(oraFilePath = (ohbaseConfig = HelperUtility.detectOraBaseConfig((String)this.ohPath)) + File.separator + "dbs" + File.separator + "spfile" + this.sid + ".ora").exists() || new File(oraFilePath = ohbaseConfig + File.separator + "dbs" + File.separator + "init" + this.sid + ".ora").exists())) {
                Reporting.report((String)("Failed to connect to database with supplied SID:" + this.sid));
                throw new ProductDriverException("Failed to connect to database with supplied SID:" + this.sid);
            }
            Properties properties = new Properties();
            properties.load(new FileInputStream(oraFilePath));
            String key = "db_name";
            if (!properties.containsKey("db_name")) {
                key = "*.db_name";
            }
            dbname = properties.getProperty(key);
            dbname = this.removeQuotes(dbname, "'");
            dbname = this.removeQuotes(dbname, "\"");
        }
        catch (IOException e) {
            Reporting.report((String)("Failed to read file:" + oraFilePath));
            throw new ProductDriverException("Failed to read file:" + oraFilePath);
        }
        return dbname;
    }

    private String removeQuotes(String refSid, String quoteStr) {
        if (refSid.endsWith(quoteStr) && refSid.startsWith(quoteStr)) {
            refSid = refSid.replaceFirst(quoteStr, "");
            refSid = refSid.substring(0, refSid.lastIndexOf(quoteStr));
        }
        return refSid;
    }

    private void extractOracleHome(String ohPath, String owner, SIDatabase sidb) {
        List ohList = OUIDriver.getLocalInfo();
        Host host = new Host();
        host.setDisplayName(this.cutDomainName(OsysUtility.getHostname()).toLowerCase());
        host.setId("ID_" + UUID.randomUUID().toString());
        host.setHostName(this.cutDomainName(OsysUtility.getHostname().toLowerCase()));
        host.setName(this.cutDomainName(OsysUtility.getHostname()).toLowerCase());
        ArrayList homeList = new ArrayList();
        host.setOracleHomes(homeList);
        ArrayList<Host> hostList = new ArrayList<Host>();
        hostList.add(host);
        this.ti.getEntities().add(host);
        for (OracleHome home : ohList) {
            if (!FileUtils.getFile((String)ohPath).equals(FileUtils.getFile((String)home.getPath()))) continue;
            home.setHomeType("sidb");
            home.setDescription("A " + home.getType());
            String ver = ((OUIComponent)home.getTopLevelOUI().get(0)).getVersion();
            home.setVersion(ver);
            home.setName(home.getHomeName());
            try {
                File inventoryFile = new File(home.getPath(), "oraInst.loc");
                String invPtrLoc = OUIDriver.readCentralInventoryLocation((File)inventoryFile);
                home.setCentralInvPtr(invPtrLoc);
                String oracleBase = OUIDriver.checkOracleBase((String)home.getPath());
                home.setOracleBaseLocation(oracleBase);
                home.setOwner(owner);
            }
            catch (Exception e) {
                throw new ProductDriverException("Exception while creating oracle home : " + e.getMessage());
            }
            home.setInstalledSWComponents(new ArrayList());
            this.ti.getEntities().add(home);
            home.getInstalledSWComponents().add(sidb);
            home.setHostName(host.getHostName());
            home.setHosts(hostList);
            sidb.setVersion(home.getVersion());
            sidb.setName(this.stripPrefixSuffix(home.getId(), "ora.", ".db"));
            sidb.setRuns_from(home);
            sidb.setOracleHome(home.getPath());
            sidb.setHost(host);
            sidb.setDisplayName(sidb.getName());
            sidb.setId("ID_" + UUID.randomUUID().toString());
            sidb.setType(sidb.getClass().getName());
            host.getOracleHomes().add(home);
            this.ti.setTop((AbstractBaseTarget)home);
            break;
        }
    }

    private String cutDomainName(String nodeName) {
        return this.extractHostName(nodeName);
    }

    String stripPrefixSuffix(String name, String prefix, String suffix) {
        if (name.startsWith(prefix) && name.endsWith(suffix)) {
            return name.substring(prefix.length(), name.length() - suffix.length());
        }
        return name;
    }
}

