/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.executor;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.CommandFailureException;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.GILogger;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.ExecutionResult;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.session.PatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.ApplySqlAction;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.OpatchAction;

public class PatchingStepExecutor {
    private static PatchingStepExecutor _stepExecutor;
    private static final Logger _log;

    private PatchingStepExecutor() {
    }

    public static PatchingStepExecutor getInstance() {
        if (_stepExecutor == null) {
            _stepExecutor = new PatchingStepExecutor();
        }
        return _stepExecutor;
    }

    public ExecutionResult processSteps(ExecutionStep step, PatchSession session, Credential credential, PatchTarget patchTarget) throws CommandFailureException {
        ExecutionResult result = null;
        result = this.runGenericShellCommands(step, session.isAnalyze(), credential, patchTarget);
        return result;
    }

    private ExecutionResult runGenericShellCommands(ExecutionStep step, boolean isAnalyzeMode, Credential credential, PatchTarget patchTarget) throws CommandFailureException {
        ExecutionResult.ExecutionStatus status = ExecutionResult.ExecutionStatus.SUCCESS;
        String command = "";
        String owner = DBPatchingHelper.getStepOwner(step);
        ActionType automationAction = step.getAutomationAction();
        ExecutionResult result = new ExecutionResult(new ArrayList<ExecutionResult.CommandExecutionResult>());
        ArrayList commands = (ArrayList)step.getCommand();
        for (ExecutionStep.Command cmd : commands) {
            String mode;
            command = cmd.getValue();
            command = this.formatCommand(command, automationAction);
            _log.info(OPatchAutoHelper.getLocalizedString((String)"StepExecutor.command.info", (Object[])new Object[]{owner, command}));
            _log.info("COMMAND Looks like this: " + command);
            ExecutionResult.CommandExecutionResult commandResult = this.runCommand(step, command, owner, credential, result, patchTarget);
            result.addCommandResult(commandResult);
            status = commandResult.getStatus();
            String string = mode = isAnalyzeMode ? OPatchAutoHelper.getLocalizedString((String)"analyzed.session.value", (Object[])new Object[0]) : OPatchAutoHelper.getLocalizedString((String)"executed.value", (Object[])new Object[0]);
            if (status == ExecutionResult.ExecutionStatus.SUCCESS) {
                _log.info(OPatchAutoHelper.getLocalizedString((String)"StepExecutor.command.execute.success", (Object[])new Object[]{mode}));
                continue;
            }
            if (status == ExecutionResult.ExecutionStatus.WARNING) {
                _log.info(OPatchAutoHelper.getLocalizedString((String)"StepExecutor.command.execute.warning", (Object[])new Object[]{mode}));
                continue;
            }
            if (isAnalyzeMode) {
                Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"StepExecutor.command.analyze.failure", (Object[])new Object[]{command}));
                continue;
            }
            _log.info("\nFailure in command execution:\n" + command);
            CommandFailureException e = new CommandFailureException(command, commandResult.getMessage(), commandResult.getErrorMessage());
            throw e;
        }
        return result;
    }

    private String formatCommand(String command, ActionType automationAction) {
        if (command.startsWith("ORACLE_HOME=") || command.startsWith("ORACLE_UNQNAME=") || automationAction instanceof CommandAction && (automationAction.getType().startsWith("SqlPatch") || automationAction.getType().equals(DBCommandActionType.SPFilePreReqForUpgradeMode.toString())) || automationAction instanceof ApplySqlAction && !command.startsWith("echo") || command.startsWith("echo")) {
            command = GISystemCall.formatSHCommand(command, true);
        }
        return command;
    }

    private ExecutionResult.CommandExecutionResult runCommand(ExecutionStep step, String command, String owner, Credential credential, ExecutionResult result, PatchTarget patchTarget) throws CommandFailureException {
        ActionType actionType = step.getAutomationAction();
        StringBuffer errorBuff = new StringBuffer();
        GISystemCall.ExecReturn er = new GISystemCall.ExecReturn(new String[]{command});
        int status = 0;
        boolean isWarning = false;
        boolean testRebootPatching = false;
        try {
            if ((command.indexOf("rootcrs.pl") != -1 || command.indexOf("roothas.pl") != -1) && command.indexOf("-postpatch") != -1 && System.getProperty("OPatchauto.TEST_REBOOT_PATCHING").equals("true")) {
                testRebootPatching = true;
            }
            if (testRebootPatching) {
                status = 1;
            } else {
                _log.log(Level.FINE, "Starting command execution...\n" + command);
                er = GISystemCall.process(command, owner, credential, this.getTestEnv());
                status = er.getReturnCode();
                _log.log(Level.INFO, "status: " + status);
            }
            if (command.indexOf("clone.pl") != -1 && status == 6 && DBPatchingUtil.isVersionEqalOrlater(patchTarget.getHome().getVersion(), "12.2.0.2.0")) {
                status = 0;
            }
            if (command.indexOf("runInstaller") != -1 && command.indexOf("oracle.install.option=INSTALL_DB_SWONLY") != -1 && status == 6 && DBPatchingUtil.isVersionEqalOrlater(patchTarget.getHome().getVersion(), "20.0.0.0.0")) {
                status = 0;
            }
            if (command.indexOf("gridSetup.sh") != -1 && command.indexOf("oracle.install.option=CRS_SWONLY") != -1 && status == 6 && DBPatchingUtil.isVersionEqalOrlater(patchTarget.getHome().getVersion(), "20.0.0.0.0")) {
                status = 0;
            }
            if (status == 0) {
                String outputMsg = er.getNormalMessage();
                if (actionType instanceof OpatchAction && command.indexOf("echo") < 0) {
                    if (outputMsg.lastIndexOf("failed") != -1) {
                        _log.info("\nOPATCH COMMAND FAILURE :\n" + outputMsg);
                        status = 1;
                    }
                    if (!StringUtil.isNullOrEmpty((String)er.getErrorMessage())) {
                        isWarning = true;
                    }
                }
                _log.log(Level.INFO, "Successfully executed the above command.\n");
                _log.log(Level.INFO, "Output from the command:");
                _log.log(Level.INFO, outputMsg);
            } else {
                String normalMsg = er.getNormalMessage();
                String errorMsg = er.getErrorMessage();
                if (testRebootPatching || normalMsg.contains("CLSRSC-400: A system reboot is required to continue installing.")) {
                    if (testRebootPatching) {
                        Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"StepExecutor.test.reboot.message", (Object[])new Object[0]));
                    }
                } else {
                    _log.log(Level.INFO, "\nCOMMAND EXECUTION FAILURE :\n" + normalMsg + "\nERROR:\n" + errorMsg);
                }
            }
        }
        catch (Exception e) {
            GILogger.printStackTrace(e);
            _log.log(Level.WARNING, "\nEXCEPTION CAUGHT:\n" + e.getMessage());
            _log.log(Level.FINE, "Failed to run this command :\n" + command);
            errorBuff = new StringBuffer("Failed to run the command :\n" + command + "\n");
            if (e.getMessage() != null && !e.getMessage().equals("")) {
                errorBuff.append(e.getMessage() + "\n");
            }
            throw new CommandFailureException(command, null, errorBuff.toString(), e);
        }
        ExecutionResult.ExecutionStatus executionStatus = ExecutionResult.ExecutionStatus.FAILURE;
        if (status == 0) {
            executionStatus = isWarning ? ExecutionResult.ExecutionStatus.WARNING : ExecutionResult.ExecutionStatus.SUCCESS;
        }
        ExecutionResult executionResult = result;
        executionResult.getClass();
        ExecutionResult.CommandExecutionResult commandResult = new ExecutionResult.CommandExecutionResult(executionResult, executionStatus, er.getNormalMessage(), er.getErrorMessage(), command);
        return commandResult;
    }

    private Map<String, String> getTestEnv() {
        HashMap<String, String> envMap = null;
        try {
            File testEnvPropertiesFile = new File(OPatchAutoHelper.getOPatchAutoHome() + DBCommonPatchingConstants.TEST_ENV_PROP_FILE_PATH);
            if (testEnvPropertiesFile.exists()) {
                envMap = new HashMap<String, String>();
                Properties properties = new Properties();
                properties.load(new FileInputStream(testEnvPropertiesFile));
                Set<String> keySet = properties.stringPropertyNames();
                for (String key : keySet) {
                    String value = properties.getProperty(key);
                    envMap.put(key, value);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "\nFailed to read test enviroment file.EXCEPTION CAUGHT:\n" + e.getMessage());
        }
        return envMap;
    }

    static {
        _log = Logger.getLogger(PatchingStepExecutor.class.getName());
    }
}

