/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.oop.sessioninfo;

import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPHomeInfo;
import com.oracle.glcm.patch.auto.db.product.patchlevel.OracleHomePatchLevel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class OOPSessionInfo
implements Serializable {
    private List<OOPHomeInfo> homeInfoList = new ArrayList<OOPHomeInfo>();
    private String user;
    private String host;
    private String systemInstanceFilePath;
    private OracleHomePatchLevel patchLevelOnNodes;
    private PatchInfo patchInfo;
    private static final long serialVersionUID = 1L;

    public OOPSessionInfo() {
    }

    public OOPSessionInfo(String host, String user) {
        this();
        this.host = host;
        this.user = user;
    }

    public PatchInfo getPatchInfo() {
        return this.patchInfo;
    }

    public void setPatchInfo(PatchInfo patchInfo) {
        this.patchInfo = patchInfo;
    }

    public OracleHomePatchLevel getPatchLevelOnNodes() {
        return this.patchLevelOnNodes;
    }

    public void setPatchLevelOnNodes(OracleHomePatchLevel patchLevelOnNodes) {
        this.patchLevelOnNodes = patchLevelOnNodes;
    }

    public String getUser() {
        return this.user;
    }

    public String getSystemInstanceFilePath() {
        return this.systemInstanceFilePath;
    }

    public void setSystemInstanceFilePath(String systemInstanceFilePath) {
        this.systemInstanceFilePath = systemInstanceFilePath;
    }

    public String getHost() {
        return this.host;
    }

    public List<OOPHomeInfo> getHomeInfoList() {
        return this.homeInfoList;
    }

    public boolean isHomesSwitch() {
        boolean isHomesSwitch = true;
        for (OOPHomeInfo homeInfo : this.homeInfoList) {
            if (homeInfo.getHomeOperationType().equals((Object)OOPHomeInfo.HomeOperationType.SWITCH)) continue;
            isHomesSwitch = false;
            break;
        }
        return isHomesSwitch;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nuser: " + this.user);
        sb.append("\nhost: " + this.host);
        sb.append("\nsystemInstanceFilePath: " + this.systemInstanceFilePath);
        if (this.patchLevelOnNodes != null) {
            sb.append("\n" + this.patchLevelOnNodes.toString());
        }
        if (this.patchInfo != null) {
            sb.append("\nPatchInfo");
            sb.append("\nPatchDirName: " + this.patchInfo.getPatchDirName());
            sb.append("\nPrimaryPatchVersion: " + this.patchInfo.getPrimaryPatchVersion());
            sb.append("\nPatchType: " + (Object)((Object)this.patchInfo.getPatchType()));
        }
        if (this.homeInfoList != null) {
            sb.append("\nOOPHomeInfo");
            for (OOPHomeInfo homeInfo : this.homeInfoList) {
                sb.append("\nOriginalHome: " + homeInfo.getOriginalHome());
                sb.append("\nClonedHome: " + homeInfo.getCloneHome());
                sb.append("\nOperationType: " + homeInfo.getHomeOperationType().name());
                sb.append("\nOperationSessionCompleted: " + homeInfo.isSessionCompleted());
            }
        }
        return sb.toString();
    }

    public static enum PatchType {
        ENGG_SYS_PATCH,
        OTHERS;


        public boolean isENGSystemPatch() {
            return this == ENGG_SYS_PATCH;
        }
    }

    public class PatchInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String primaryPatchVersion;
        private final PatchType patchType;
        private final String patchDirName;
        private final boolean isSQLPatchInUpgradeMode;

        public PatchInfo(String primaryPatchVersion, PatchType patchType, String patchDirName, boolean isSQLPatchInUpgradeMode) {
            this.primaryPatchVersion = primaryPatchVersion;
            this.patchType = patchType;
            this.patchDirName = patchDirName;
            this.isSQLPatchInUpgradeMode = isSQLPatchInUpgradeMode;
        }

        public PatchType getPatchType() {
            return this.patchType;
        }

        public String getPrimaryPatchVersion() {
            return this.primaryPatchVersion;
        }

        public String getPatchDirName() {
            return this.patchDirName;
        }

        public boolean isSQLPatchInUpgradeMode() {
            return this.isSQLPatchInUpgradeMode;
        }
    }
}

