/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.oop.sessioninfo;

import com.oracle.cie.common.util.FileUtils;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.oop.CloneHomePathFinder;
import com.oracle.glcm.patch.auto.db.product.oop.OOPSessionCookieTransferHandler;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPHomeInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionCookie;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHelper;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.PatchLevelQuery;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.validators.OOPSessionCookieCreator;
import com.oracle.glcm.patch.auto.db.product.patchlevel.OracleHomePatchLevel;
import com.oracle.glcm.patch.auto.db.product.patchlevel.OracleHomePatchLevelReporter;
import com.oracle.glcm.patch.auto.db.product.patchlevel.PatchLevelReportingListener;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.db.product.validation.validators.CloneHomeSpaceValidator;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.topology.Topology;
import com.oracle.glcm.patch.auto.topology.TopologyFactory;
import com.oracle.glcm.patch.auto.topology.TopologyImpl;
import dbmodel.common.OracleHome;
import dbmodel.patchmodel.EngineeredSystemPatch;
import dbmodel.patchmodel.PatchPackage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

public class OOPSessionInfoHandler {
    private static OOPSessionInfoHandler _instance;
    private static final Logger logger;
    private OOPSessionCookie cookie;
    private OOPSessionInfo oopSessionInfo;
    private CredentialManager credentialManager;

    private OOPSessionInfoHandler() {
    }

    public static OOPSessionInfoHandler getInstance() {
        if (_instance == null) {
            _instance = new OOPSessionInfoHandler();
        }
        return _instance;
    }

    public void initializeSessionInfo(String systemInstanceFilePath, String patchDirName, Topology topology, OOPSessionCookie.OOPOperationType operationType, String cloneHomePathPropertiesFile, boolean isRemotePatchingRequested, String patchLocation, String sessionId) throws OPatchAutoException {
        logger.finest("Initializing OOP Session");
        List<String> requestedHomeList = this.getRequestHomeList(topology);
        OOPSessionCookieCreator creator = new OOPSessionCookieCreator();
        this.cookie = creator.create(operationType, requestedHomeList, this.credentialManager.getCredential(DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost())), isRemotePatchingRequested);
        Map<String, String> cloneHomeMap = null;
        if (this.cookie == null) {
            this.cookie = new OOPSessionCookie();
            CloneHomePathFinder pathFinder = new CloneHomePathFinder();
            if (cloneHomePathPropertiesFile == null) {
                Reporting.report((String)"Please press ENTER button to accept system generated default clone path. ");
                cloneHomeMap = pathFinder.findNFillClonePath(requestedHomeList, this.credentialManager.getCredential(DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost())));
            } else {
                cloneHomeMap = pathFinder.findNFillClonePath(requestedHomeList, this.loadCloneProperties(cloneHomePathPropertiesFile, requestedHomeList, operationType), this.credentialManager.getCredential(DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost())));
            }
            this.validateSpaceForCloneHome(cloneHomeMap, patchLocation);
        } else {
            cloneHomeMap = this.fillCloneHomePathMap();
        }
        this.createOOPSessionInfo(systemInstanceFilePath, patchDirName, topology, operationType, cloneHomeMap);
        this.cookie.setOperationType(operationType);
        this.cookie.setRemotePatching(isRemotePatchingRequested);
        logger.fine(this.cookie.toString());
    }

    public void validateSpaceForCloneHome(Map<String, String> cloneHomeMap, String patchLocation) throws OPatchAutoException {
        ValidationParam params = new ValidationParam();
        params.set(ValidationParamKey.CONFIG_GRAPH.ordinal(), PatchPlanner.getInstance().getConfigGraph());
        params.set(ValidationParamKey.CLONE_HOME_MAP.ordinal(), cloneHomeMap);
        params.set(ValidationParamKey.PATCH_LOC.ordinal(), patchLocation);
        CloneHomeSpaceValidator validator = new CloneHomeSpaceValidator();
        List<Object> validationResultList = new ArrayList();
        MultipleValidationResult result = validator.validate(params);
        validationResultList = result.getValidationResultList();
        for (ValidationResult validationResult : validationResultList) {
            if (!validationResult.getStatus().equals((Object)ValidationResult.ValidationStatus.FAILED)) continue;
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(validationResult.getFailureReason().getErrorCode()), (Object[])new Object[0]), new Object[0]);
        }
    }

    private Map<String, String> loadCloneProperties(String clonePropertiesFilePath, List<String> requestedHomeList, OOPSessionCookie.OOPOperationType operationType) throws OPatchAutoException {
        HashMap<String, String> cloneHomePathMap;
        block5: {
            logger.fine("clonePropertiesFilePath : " + clonePropertiesFilePath);
            cloneHomePathMap = new HashMap<String, String>();
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(clonePropertiesFilePath));
                Set<String> keySet = properties.stringPropertyNames();
                List<String> keyList = this.getUpdatedFilePathList(new ArrayList<String>(keySet));
                ArrayList<String> tempRequestedHomeList = new ArrayList<String>(requestedHomeList);
                Collections.sort(keyList);
                Collections.sort(tempRequestedHomeList);
                if (requestedHomeList.size() >= keySet.size()) {
                    tempRequestedHomeList.removeAll(keyList);
                    if (tempRequestedHomeList.isEmpty()) {
                        for (String key : keySet) {
                            String value = properties.getProperty(key);
                            cloneHomePathMap.put(key, value);
                        }
                        break block5;
                    }
                    throw new OPatchAutoException(Integer.toString(72136), new Object[]{operationType.name().toLowerCase(), clonePropertiesFilePath, Arrays.toString(tempRequestedHomeList.toArray())});
                }
                keyList.removeAll(tempRequestedHomeList);
                throw new OPatchAutoException(Integer.toString(72128), new Object[]{operationType.name().toLowerCase(), clonePropertiesFilePath, Arrays.toString(keyList.toArray())});
            }
            catch (IOException e) {
                logger.fine("Failed to load " + clonePropertiesFilePath + " file :: " + e.getMessage());
                throw new OPatchAutoException(Integer.toString(72127), new Object[]{operationType.name().toLowerCase(), clonePropertiesFilePath});
            }
        }
        return cloneHomePathMap;
    }

    private List<String> getUpdatedFilePathList(List<String> filePathList) {
        ArrayList<String> tmpFilePathList = new ArrayList<String>();
        for (String filePath : filePathList) {
            tmpFilePathList.add(FileUtils.getFile((String)filePath).getPath());
        }
        return tmpFilePathList;
    }

    public void initializeSwitchSession(String systemInstanceFilePath, Topology topology, OOPSessionCookie.OOPOperationType operationType, boolean isRemotePatchingRequested) throws OPatchAutoException {
        this.cookie.setOperationType(operationType);
        this.cookie.sessionActive();
        OOPSessionCookieCreator creator = new OOPSessionCookieCreator();
        List<String> requestedHomeList = this.getRequestHomeList(topology);
        Iterator hostList = topology.getHosts().iterator();
        while (hostList.hasNext()) {
            OOPSessionInfo info = this.cookie.getOOPSessionInfo(((Host)hostList.next()).getHost());
            List<OOPHomeInfo> homeInfoList = info.getHomeInfoList();
            if (operationType.equals((Object)OOPSessionCookie.OOPOperationType.ROLLBACK)) {
                this.reverseHomeInfo(homeInfoList, requestedHomeList);
            }
            for (OOPHomeInfo homeInfo : homeInfoList) {
                if (!requestedHomeList.contains(FileUtils.getFile((String)homeInfo.getOriginalHome()).getPath())) continue;
                homeInfo.setHomeOperationType(OOPSessionInfoHelper.getHomeOperationType(operationType));
            }
        }
        creator.merge(operationType, this.cookie, requestedHomeList, this.credentialManager.getCredential(DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost())), isRemotePatchingRequested);
        this.validatePatchApplicability(topology);
        if (!StringUtil.isNullOrEmpty((String)systemInstanceFilePath)) {
            this.getOOPSessionInfo().setSystemInstanceFilePath(systemInstanceFilePath);
        }
    }

    private void validatePatchApplicability(Topology topology) throws OPatchAutoException {
        TopologyImpl cloneTopology = new TopologyImpl();
        ArrayList<Object> topologyList = new ArrayList<Object>();
        topologyList.add(topology);
        HashSet<Host> hostSet = new HashSet<Host>();
        for (Host host : topology.getHosts()) {
            Host cloneHost = host.getShallowCopy();
            for (Home home : host.getHomes()) {
                Home cloneHome = home.getShallowCopy();
                cloneHome.setLocation(this.getCloneHomePath(home.getLocation()));
                cloneHost.addHome(cloneHome);
            }
            hostSet.add(cloneHost);
        }
        cloneTopology.setHosts(hostSet);
        topologyList.add(cloneTopology);
        Topology mergedTopology = TopologyFactory.mergeTopologies(topologyList);
        OracleHomePatchLevelReporter patchLevelReporter = new OracleHomePatchLevelReporter();
        patchLevelReporter.report(new ArrayList<Host>(mergedTopology.getHosts()), new PatchLevelReportingListener(){

            @Override
            public void notifyResult(int resultID, int messageID, String message, Object payload) {
                if (resultID == 0) {
                    Map hostOHMap = (Map)payload;
                    for (Map.Entry entry : hostOHMap.entrySet()) {
                        OOPSessionInfo tmpSessionInfo = OOPSessionInfoHandler.this.getOOPSessionInfo(((Host)entry.getKey()).getHost());
                        OracleHomePatchLevel oracleHomePatchLevel = tmpSessionInfo.getPatchLevelOnNodes();
                        if (oracleHomePatchLevel.equals(entry.getValue())) continue;
                        Reporting.report((String)OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72137), (Object[])new Object[]{OOPSessionInfoHandler.this.cookie.getOperationType().toString().toLowerCase()}));
                        Reporting.report((String)("\nHost :: " + ((Host)entry.getKey()).getHost()));
                        Reporting.report((String)("\nOriginal Patch Level ::" + OOPSessionInfoHandler.this.getFormattedPatchInfo(oracleHomePatchLevel.getOracleHomePatchLevel()) + "\n"));
                        Reporting.report((String)("\nCurrent Patch Level ::" + OOPSessionInfoHandler.this.getFormattedPatchInfo(((OracleHomePatchLevel)entry.getValue()).getOracleHomePatchLevel()) + "\n"));
                        System.exit(106);
                    }
                } else {
                    this.handlePatchQueryFailure(messageID, message);
                }
            }

            private void handlePatchQueryFailure(int messageID, String message) {
                int dbmessageID = PatchLevelQuery.getDBMessageID(messageID);
                Reporting.report((String)OPatchAutoHelper.getPublishedMessage((String)Integer.toString(dbmessageID), (Object[])new Object[]{message}));
                System.exit(messageID);
            }
        });
    }

    public String getFormattedPatchInfo(Map<String, List<OPatchPatchInfo>> oracleHomePatchLevel) {
        StringBuilder builder = new StringBuilder();
        for (String oh : oracleHomePatchLevel.keySet()) {
            List<OPatchPatchInfo> patchInfos = oracleHomePatchLevel.get(oh);
            builder.append("\n Oracle Home " + oh + ": ");
            for (OPatchPatchInfo info : patchInfos) {
                builder.append(" Patch ID: " + info.getPatchID());
            }
        }
        Reporting.report((String)"\n==============================================");
        return builder.toString();
    }

    private void reverseHomeInfo(List<OOPHomeInfo> homeInfoList, List<String> requestedHomeList) {
        for (OOPHomeInfo homeInfo : homeInfoList) {
            if (!requestedHomeList.contains(FileUtils.getFile((String)homeInfo.getCloneHome()).getPath())) continue;
            homeInfo.reverseRole();
        }
    }

    private List<String> getRequestHomeList(Topology topology) throws OPatchAutoException {
        ArrayList<String> requestedHomeList = new ArrayList<String>();
        for (Home localHome : topology.getHomes()) {
            if (localHome.getHost().isRemote()) continue;
            requestedHomeList.add(FileUtils.getFile((String)localHome.getLocation()).getPath());
        }
        return requestedHomeList;
    }

    private void createOOPSessionInfo(String systemInstanceFilePath, String patchDirName, Topology topology, OOPSessionCookie.OOPOperationType operationType, Map<String, String> cloneHomeMap) throws OPatchAutoException {
        for (Host host : topology.getHosts()) {
            OOPSessionInfo info = new OOPSessionInfo(host.getHost(), System.getProperty("user.name"));
            Iterator homeItr = host.getHomes().iterator();
            ArrayList<OOPHomeInfo> homeInfos = new ArrayList<OOPHomeInfo>();
            while (homeItr.hasNext()) {
                String originalHome = ((Home)homeItr.next()).getLocation();
                String cloneHome = cloneHomeMap.get(originalHome);
                OOPHomeInfo homeInfo = new OOPHomeInfo(originalHome, cloneHome);
                homeInfo.setHomeOperationType(OOPSessionInfoHelper.getHomeOperationType(operationType));
                homeInfos.add(homeInfo);
            }
            info.getHomeInfoList().addAll(homeInfos);
            info.setSystemInstanceFilePath(systemInstanceFilePath);
            String primaryPatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
            PatchPackage patch = PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getPrimaryPatchPackage();
            if (patch instanceof EngineeredSystemPatch) {
                OOPSessionInfo oOPSessionInfo = info;
                oOPSessionInfo.getClass();
                info.setPatchInfo(oOPSessionInfo.new OOPSessionInfo.PatchInfo(primaryPatchVersion, OOPSessionInfo.PatchType.ENGG_SYS_PATCH, patchDirName, DBCommandUtils.isSQLPatchUpgradeMode()));
            } else {
                OOPSessionInfo oOPSessionInfo = info;
                oOPSessionInfo.getClass();
                info.setPatchInfo(oOPSessionInfo.new OOPSessionInfo.PatchInfo(primaryPatchVersion, OOPSessionInfo.PatchType.OTHERS, patchDirName, DBCommandUtils.isSQLPatchUpgradeMode()));
            }
            this.cookie.addSessionInfo(host.getHost(), info);
            if (!DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost()).equalsIgnoreCase(DBPatchingHelper.getHostNameWithoutDomain(host.getHost()))) continue;
            this.oopSessionInfo = info;
        }
        this.cookie.setOperationType(operationType);
        OracleHomePatchLevelReporter patchLevelReporter = new OracleHomePatchLevelReporter();
        PatchLevelQuery reportingListener = new PatchLevelQuery();
        patchLevelReporter.report(new ArrayList<Host>(topology.getHosts()), reportingListener);
        if (!StringUtil.isNullOrEmpty((String)reportingListener.getFailureMessage(), (boolean)true)) {
            throw new OPatchAutoException(reportingListener.getFailureMessage(), new Object[0]);
        }
        PatchPlanner.getInstance().getMakeCloneHome();
    }

    public OOPSessionInfo getOOPSessionInfo() {
        if (this.cookie == null) {
            return null;
        }
        return this.cookie.getOOPSessionInfo(DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost()));
    }

    public OOPSessionInfo getOOPSessionInfo(String host) {
        return this.cookie.getOOPSessionInfo(host);
    }

    public Map<String, String> fillCloneHomePathMap() {
        HashMap<String, String> cloneHomeMap = new HashMap<String, String>();
        Set<Map.Entry<String, OOPSessionInfo>> oopSessionInfoEntrySet = this.cookie.getOOPSessionInfoList();
        Map.Entry<String, OOPSessionInfo> hostOOPSessionInfoEntry = oopSessionInfoEntrySet.iterator().next();
        OOPSessionInfo oopSessionInfo = hostOOPSessionInfoEntry.getValue();
        for (OOPHomeInfo oopHomeInfo : oopSessionInfo.getHomeInfoList()) {
            if (cloneHomeMap.containsKey(oopHomeInfo.getOriginalHome())) continue;
            cloneHomeMap.put(oopHomeInfo.getOriginalHome(), oopHomeInfo.getCloneHome());
        }
        return cloneHomeMap;
    }

    public void updatePatchLevelInSessionInfo(Host host, OracleHomePatchLevel homePatchLevel) {
        OOPSessionInfo oopSessionInfo = this.cookie.getOOPSessionInfo(host.getHost());
        OracleHomePatchLevel updatePatchLevel = this.initializeCloneHomePatchLevel(homePatchLevel);
        oopSessionInfo.setPatchLevelOnNodes(updatePatchLevel);
    }

    private OracleHomePatchLevel initializeCloneHomePatchLevel(OracleHomePatchLevel patchLevel) {
        OracleHomePatchLevel newPatchLevel = new OracleHomePatchLevel();
        List<OracleHome> ohList = PatchPlanner.getInstance().getConfigGraph().getTargets(OracleHome.class);
        Set<Map.Entry<String, List<OPatchPatchInfo>>> entrySet = patchLevel.getOracleHomePatchLevel().entrySet();
        String originalHome = null;
        for (Map.Entry<String, List<OPatchPatchInfo>> entry : entrySet) {
            originalHome = FileUtils.getFile((String)entry.getKey()).getPath();
            String clonePath = this.getCloneHomePath(originalHome);
            List<OPatchPatchInfo> patchList = entry.getValue();
            List<OPatchPatchInfo> tmpPatchList = null;
            String localhost = DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost());
            for (OracleHome oh : ohList) {
                String ohPath = FileUtils.getFile((String)oh.getPath()).getPath();
                if (!ohPath.equals(originalHome)) continue;
                if (oh.getIsShared()) {
                    for (dbmodel.common.Host modelhost : oh.getHosts()) {
                        if (localhost.equalsIgnoreCase(modelhost.getHostName())) continue;
                        OOPSessionInfo oopSessionInfo2 = this.cookie.getOOPSessionInfo(modelhost.getHostName());
                        if (oopSessionInfo2 != null) {
                            OracleHomePatchLevel patchLevelOnNodes = oopSessionInfo2.getPatchLevelOnNodes();
                            if (patchLevelOnNodes == null) {
                                patchLevelOnNodes = new OracleHomePatchLevel();
                                oopSessionInfo2.setPatchLevelOnNodes(patchLevelOnNodes);
                            }
                            tmpPatchList = patchLevelOnNodes.getOracleHomePatchLevel().get(clonePath);
                            break;
                        }
                        logger.fine("Host session data is not available : " + modelhost.getHostName());
                    }
                }
                if (tmpPatchList == null || tmpPatchList.isEmpty()) break;
                patchList = tmpPatchList;
                break;
            }
            if (clonePath != null) {
                patchList = patchList == null || patchList.isEmpty() ? new ArrayList<OPatchPatchInfo>() : new ArrayList<OPatchPatchInfo>(patchList);
                newPatchLevel.addOracleHomePatchLevel(clonePath, patchList);
            }
            if (patchList == null) {
                newPatchLevel.getOracleHomePatchLevel().put(entry.getKey(), new ArrayList());
                continue;
            }
            newPatchLevel.addOracleHomePatchLevel(entry.getKey(), entry.getValue());
        }
        logger.fine("Current patch level: " + newPatchLevel);
        return newPatchLevel;
    }

    public OOPSessionCookie getOOPSessionCookie(File oopSessionCookieFile) throws OPatchAutoException {
        logger.fine("Deserialize oopSessionCookieFile: " + oopSessionCookieFile.getAbsolutePath());
        OOPSessionCookie cookie = null;
        FileInputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            inputStream = new FileInputStream(oopSessionCookieFile);
            objectInputStream = new ObjectInputStream(inputStream);
            cookie = (OOPSessionCookie)objectInputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new OPatchAutoException((Throwable)e);
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new OPatchAutoException((Throwable)e);
            }
        }
        logger.fine(cookie.toString());
        return cookie;
    }

    public OOPSessionCookie initializeCookie(File oopSessionCookieFile) throws OPatchAutoException {
        this.cookie = this.getOOPSessionCookie(oopSessionCookieFile);
        this.oopSessionInfo = this.cookie.getOOPSessionInfo(DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost()));
        return this.cookie;
    }

    public synchronized void saveOOPSessionCookie(String oopSessionFilePath) throws OPatchAutoException {
        logger.finest("Saving cookie oopSessionFilePath: " + oopSessionFilePath);
        logger.finest(this.cookie.toString());
        Credential credential = null;
        if (this.credentialManager != null) {
            credential = this.credentialManager.getCredential(DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
        }
        OOPSessionInfoHelper.serializeFile(oopSessionFilePath, this.cookie, DBPatchingHelper.getHomeOwner(OPatchAutoHelper.getOPatchAutoHome()), credential);
        DBPatchingHelper.changeOwner(OPatchAutoHelper.getOPatchAutoHome(), credential, new File(oopSessionFilePath));
    }

    public void distributeSessionFile(boolean nonrollingMode) throws OPatchAutoException {
        if (this.cookie != null) {
            OOPSessionCookieTransferHandler transferHandler = new OOPSessionCookieTransferHandler();
            transferHandler.distribute(this.cookie, this.credentialManager.getCredential(DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost())));
            if (nonrollingMode && !this.cookie.isRemotePatching()) {
                transferHandler.distributeSystemInfo(this.cookie, this.credentialManager.getCredential(DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost())));
            }
        }
    }

    public void updateCloneHomePath(PatchTarget patchTarget) {
        OOPHomeInfo info = this.getOOPHomeInfo(patchTarget);
        if (info != null) {
            info.setCloneHome(patchTarget.getHomeClone().getLocation());
        }
    }

    public String getSessionFilePath() throws OPatchAutoException {
        String sessionInfoFile = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE;
        sessionInfoFile = sessionInfoFile.replace("$HOST_NAME", DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
        sessionInfoFile = OPatchAutoHelper.getOPatchAutoHome() + sessionInfoFile;
        return sessionInfoFile;
    }

    private OOPHomeInfo getOOPHomeInfo(PatchTarget patchTarget) {
        OOPHomeInfo info = null;
        Host host = patchTarget.getHost();
        OOPSessionInfo sessionInfo = this.cookie.getOOPSessionInfo(host.getHost());
        for (OOPHomeInfo tmpHomeInfo : sessionInfo.getHomeInfoList()) {
            if (!FileUtils.getFile((String)tmpHomeInfo.getOriginalHome()).equals(FileUtils.getFile((String)patchTarget.getHome(true).getLocation()))) continue;
            info = tmpHomeInfo;
            break;
        }
        return info;
    }

    public boolean isSessionCompletedOnAllNode() {
        if (this.cookie.isRemotePatching()) {
            return true;
        }
        boolean isSessionCompletedOnAllNode = false;
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<dbmodel.common.Host> dbModelHostList = configGraph.getTargets(dbmodel.common.Host.class);
        logger.fine("dbModelHostListSize: " + dbModelHostList.size());
        logger.fine("cookieSize: " + this.cookie.getCookieSize());
        List<OOPHomeInfo> homeInfos = this.oopSessionInfo.getHomeInfoList();
        List<dbmodel.common.Host> tmpHostList = OOPSessionInfoHelper.getHostListForRequestedHome(homeInfos.get(0).getOriginalHome());
        for (OOPHomeInfo homeInfo : homeInfos) {
            String oh = homeInfo.getOriginalHome();
            List<dbmodel.common.Host> hostListForOH = OOPSessionInfoHelper.getHostListForRequestedHome(oh);
            if (hostListForOH.size() <= tmpHostList.size()) continue;
            tmpHostList = hostListForOH;
        }
        if (tmpHostList.size() < dbModelHostList.size()) {
            dbModelHostList = tmpHostList;
        }
        if (dbModelHostList.size() == this.cookie.getCookieSize()) {
            logger.fine("cookieSession: " + this.cookie.isSessionCompleted());
            logger.fine("cookieOperation: " + this.cookie.getOperationType().name());
            if (!this.cookie.isSessionCompleted() && (this.cookie.getOperationType().equals((Object)OOPSessionCookie.OOPOperationType.SWITCH) || this.cookie.getOperationType().equals((Object)OOPSessionCookie.OOPOperationType.ROLLBACK))) {
                boolean bl = isSessionCompletedOnAllNode = dbModelHostList.size() == 1;
                if (!isSessionCompletedOnAllNode) {
                    block1: for (dbmodel.common.Host host : dbModelHostList) {
                        logger.fine("hostName: " + host.getHostName());
                        if (host.getHostName().equalsIgnoreCase(DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost()))) continue;
                        OOPSessionInfo sessionInfo = this.cookie.getOOPSessionInfo(host.getHostName());
                        List<OOPHomeInfo> homeInfoList = sessionInfo.getHomeInfoList();
                        for (OOPHomeInfo homeInfo : homeInfoList) {
                            logger.fine("homeInfoSession: " + homeInfo.isSessionCompleted());
                            logger.fine("homeInfoOperation: " + homeInfo.getHomeOperationType().name());
                            if ((homeInfo.getHomeOperationType().equals((Object)OOPHomeInfo.HomeOperationType.SWITCH) || homeInfo.getHomeOperationType().equals((Object)OOPHomeInfo.HomeOperationType.ROLLBACK)) && homeInfo.isSessionCompleted()) {
                                isSessionCompletedOnAllNode = true;
                                continue;
                            }
                            isSessionCompletedOnAllNode = false;
                            continue block1;
                        }
                    }
                }
            } else {
                isSessionCompletedOnAllNode = true;
            }
        }
        logger.info("isSessionCompletedOnAllNode: " + isSessionCompletedOnAllNode);
        return isSessionCompletedOnAllNode;
    }

    public void setSessionCompleted() {
        logger.info("Cookie session marked completed");
        this.cookie.sessionCompleted();
    }

    public void updateHomeSessionStatus(PatchTarget patchTarget, boolean isCompleted) {
        logger.fine("location: " + patchTarget.getHome(true).getLocation());
        logger.fine("isCompleted: " + isCompleted);
        OOPHomeInfo info = this.getOOPHomeInfo(patchTarget);
        if (info != null) {
            info.setSessionCompleted(isCompleted);
        }
    }

    public boolean isFirstNode(PatchTarget patchTarget) {
        return this.isFirstNode(patchTarget.getHost().getHost());
    }

    public boolean isFirstNode(String hostName) {
        boolean isFirstNode = false;
        if (this.cookie != null) {
            if (this.cookie.isRemotePatching()) {
                if (DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost()).equalsIgnoreCase(DBPatchingHelper.getHostNameWithoutDomain(hostName))) {
                    isFirstNode = true;
                }
            } else {
                isFirstNode = this.cookie.getCookieSize() == 1;
            }
        } else {
            isFirstNode = true;
        }
        return isFirstNode;
    }

    public String getCloneHomePath(String homePath) {
        String cloneHomePath = null;
        List<OOPHomeInfo> homeInfoList = this.getOOPSessionInfo().getHomeInfoList();
        for (OOPHomeInfo homeInfo : homeInfoList) {
            if (!DBPatchingHelper.compareFilePath(homeInfo.getOriginalHome(), homePath)) continue;
            cloneHomePath = homeInfo.getCloneHome();
            cloneHomePath = FileUtils.getFile((String)cloneHomePath).getPath();
            break;
        }
        logger.fine("Supplied Home Path : " + homePath);
        logger.fine("Clone Home Path : " + cloneHomePath);
        return cloneHomePath;
    }

    public void setCredentialManager(CredentialManager credentialManager) {
        this.credentialManager = credentialManager;
    }

    public OOPSessionCookie.OOPOperationType getCurrentOperationType() {
        if (this.cookie != null) {
            return this.cookie.getOperationType();
        }
        return null;
    }

    static {
        logger = Logger.getLogger(OOPSessionInfoHandler.class.getName());
    }
}

