/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.oop.sessioninfo;

import com.oracle.cie.common.util.FileUtils;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPHomeInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionCookie;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.dbsysmodel.driver.sdk.productdriver.constants.ProductDriverConstants;

public class OOPSessionInfoHelper {
    private static final Logger logger = Logger.getLogger(OOPSessionInfoHelper.class.getName());

    public static void serializeFile(String filePath, Object obj, String owner, Credential credential) throws OPatchAutoException {
        OOPSessionInfoHelper.createFile(filePath, owner, credential);
        FileOutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            outputStream = new FileOutputStream(filePath);
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(obj);
        }
        catch (IOException e) {
            throw new OPatchAutoException((Throwable)e);
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.flush();
                    objectOutputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                throw new OPatchAutoException((Throwable)e);
            }
        }
    }

    private static void createFile(String filePath, String owner, Credential credential) throws OPatchAutoException {
        if (new File(filePath).exists()) {
            return;
        }
        File hostDirectory = new File(filePath).getParentFile();
        if (!hostDirectory.exists()) {
            File patchStorageDirectory = hostDirectory.getParentFile();
            DBPatchingHelper.createPatchDirectory(patchStorageDirectory.getParent(), patchStorageDirectory.getAbsolutePath(), credential, "750");
            DBPatchingHelper.createPatchDirectory(patchStorageDirectory.getParent(), hostDirectory.getAbsolutePath(), credential, "750");
        }
        DBPatchingUtil.createNewFile(filePath, owner, credential);
    }

    public static OOPHomeInfo.HomeOperationType getHomeOperationType(OOPSessionCookie.OOPOperationType operationType) {
        OOPHomeInfo.HomeOperationType type = null;
        switch (operationType) {
            case PREPARE: {
                type = OOPHomeInfo.HomeOperationType.PREPARE;
                break;
            }
            case SWITCH: {
                type = OOPHomeInfo.HomeOperationType.SWITCH;
                break;
            }
            case APPLY: {
                type = OOPHomeInfo.HomeOperationType.APPLY;
                break;
            }
            case ROLLBACK: {
                type = OOPHomeInfo.HomeOperationType.ROLLBACK;
                break;
            }
        }
        return type;
    }

    public static boolean canExecuteDBSteps(PatchTarget patchTarget, boolean isRemotePatching) {
        boolean canExecuteAction = true;
        if (isRemotePatching) {
            try {
                if (patchTarget.isRemote()) {
                    canExecuteAction = false;
                }
            }
            catch (OPatchAutoException e) {
                canExecuteAction = false;
            }
            logger.fine("canExecuteAction: " + canExecuteAction);
            return canExecuteAction;
        }
        String requestedHome = patchTarget.getHome(true).getLocation();
        boolean is_shared_rac = patchTarget.getHome(true).isSharedHome();
        boolean no_crs = OOPSessionInfoHelper.no_crs(requestedHome);
        List<Host> hostList = OOPSessionInfoHelper.getHostListForRequestedHome(requestedHome);
        if (!hostList.isEmpty()) {
            if (is_shared_rac && no_crs) {
                canExecuteAction = OOPSessionInfoHandler.getInstance().isFirstNode(patchTarget);
            } else {
                block2: for (Host host : hostList) {
                    String hostName = host.getHostName();
                    logger.fine("hostName: " + hostName);
                    if (hostName.equalsIgnoreCase(DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost()))) continue;
                    OOPSessionInfo oopSessionInfo = OOPSessionInfoHandler.getInstance().getOOPSessionInfo(hostName);
                    if (oopSessionInfo != null) {
                        List<OOPHomeInfo> homeInfoList = oopSessionInfo.getHomeInfoList();
                        for (OOPHomeInfo homeInfo : homeInfoList) {
                            logger.fine("homeInfo.getOriginalHome(): " + homeInfo.getOriginalHome());
                            if (!DBPatchingHelper.compareFilePath(requestedHome, homeInfo.getOriginalHome())) continue;
                            logger.fine("homeInfo.isSessionCompleted(): " + homeInfo.isSessionCompleted());
                            if ((homeInfo.getHomeOperationType().equals((Object)OOPHomeInfo.HomeOperationType.SWITCH) || homeInfo.getHomeOperationType().equals((Object)OOPHomeInfo.HomeOperationType.APPLY) || homeInfo.getHomeOperationType().equals((Object)OOPHomeInfo.HomeOperationType.ROLLBACK)) && homeInfo.isSessionCompleted() && canExecuteAction) {
                                canExecuteAction = true;
                                continue;
                            }
                            canExecuteAction = false;
                            continue block2;
                        }
                        continue;
                    }
                    canExecuteAction = false;
                }
            }
        }
        logger.fine("canExecuteAction: " + canExecuteAction);
        return canExecuteAction;
    }

    public static boolean no_crs(String requestedHome) {
        logger.fine("requestedHome for checking no crs : " + requestedHome);
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<OracleHome> ohList = configGraph.getTargets(OracleHome.class);
        for (OracleHome oh : ohList) {
            if (!oh.getHomeType().equals("crs") && !oh.getHomeType().equals("siha")) continue;
            return false;
        }
        return true;
    }

    public static String getRemoteCommand(String homePath, String objLoc, String responseLoc) {
        StringBuilder perlPath = new StringBuilder();
        perlPath.append(homePath).append(File.separator).append(ProductDriverConstants.PERL_PATH);
        StringBuilder remoteCommand = new StringBuilder();
        remoteCommand.append((CharSequence)perlPath);
        remoteCommand.append(homePath);
        remoteCommand.append(ProductDriverConstants.OPATCHAUTO_BIN);
        remoteCommand.append("RemoteHostExecutor.pl ");
        remoteCommand.append(" -OBJECTLOC=").append(objLoc);
        remoteCommand.append(" -RESPONSEOBJECTLOC=").append(responseLoc);
        remoteCommand.append(" -JVM_HANDLER=com.oracle.helper.remote.exec.RemoteRequestHandler ");
        logger.fine("remote command: " + remoteCommand.toString());
        return remoteCommand.toString();
    }

    public static List<Host> getHostListForRequestedHome(String requestedHome) {
        logger.fine("requestedHome: " + requestedHome);
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        ArrayList<Host> hostList = new ArrayList<Host>();
        ArrayList<String> identifiedHosts = new ArrayList<String>();
        List<OracleHome> ohList = configGraph.getTargets(OracleHome.class);
        for (OracleHome oh : ohList) {
            if (!DBPatchingHelper.compareFilePath(requestedHome, oh.getPath()) || !oh.getHomeType().equals("crs") && !oh.getHomeType().equals("siha")) continue;
            hostList.addAll(configGraph.getTargets(Host.class));
            break;
        }
        if (hostList.isEmpty()) {
            List<RACDatabase> racDBs = configGraph.getTargets(RACDatabase.class);
            for (RACDatabase racDB : racDBs) {
                Database sdb;
                String dbname = racDB.getDatabaseName();
                logger.fine("oh: " + racDB.getOracleHome());
                if (!DBPatchingHelper.compareFilePath(requestedHome, racDB.getOracleHome())) continue;
                try {
                    DatabaseFactory fact = DatabaseFactory.getInstance();
                    try {
                        sdb = fact.getDatabase(dbname);
                        logger.fine("hostlist as per srvctl  API is:" + sdb.nodes());
                    }
                    catch (Exception e) {
                        logger.info("exception in sdb");
                    }
                }
                catch (Exception e) {
                    logger.info("exception in gettingg db fact");
                }
                List instances = racDB.getDbInstances();
                for (RACDBInstance instance : instances) {
                    if (OOPSessionInfoHelper.hostSelected(instance.getHost(), identifiedHosts)) continue;
                    hostList.add(instance.getHost());
                    identifiedHosts.add(instance.getHost().getHostName());
                }
                try {
                    DatabaseFactory fact = DatabaseFactory.getInstance();
                    try {
                        sdb = fact.getDatabase(dbname);
                        if (hostList.size() != 1 || OOPSessionInfoHelper.isAdminManagedDB(sdb)) continue;
                        logger.info("Selecting all hosts from ConfigGraph");
                        hostList.removeAll(hostList);
                        hostList.addAll(configGraph.getTargets(Host.class));
                    }
                    catch (Exception e) {
                        logger.info("Exception in sdb");
                    }
                }
                catch (Exception e) {
                    logger.info("Exception in gettingg db fact");
                }
            }
        }
        if (hostList.isEmpty()) {
            List<SIDatabase> sidbs = configGraph.getTargets(SIDatabase.class);
            for (SIDatabase sidb : sidbs) {
                logger.fine("oh: " + sidb.getOracleHome());
                if (!DBPatchingHelper.compareFilePath(requestedHome, sidb.getOracleHome())) continue;
                hostList.add(sidb.getHost());
                break;
            }
        }
        if (hostList.isEmpty()) {
            try {
                String gimrHome = DBPatchingHelper.getGIMRHomePath();
                if (null != gimrHome && gimrHome.length() > 0) {
                    logger.fine("gimrHome: " + gimrHome);
                    hostList.addAll(configGraph.getTargets(Host.class));
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        logger.fine("Host list size: " + hostList.size());
        return hostList;
    }

    private static boolean hostSelected(Host host, ArrayList<String> list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (String fromList : list) {
            if (!host.getHostName().equalsIgnoreCase(fromList)) continue;
            return true;
        }
        return false;
    }

    public static boolean isClonePathExists(List<String> requestedHomeList, OOPSessionCookie cookie) throws OPatchAutoException {
        Map.Entry<String, OOPSessionInfo> oopSessionInfoEntry = cookie.getOOPSessionInfoList().iterator().next();
        OOPSessionInfo oopSessionInfo = oopSessionInfoEntry.getValue();
        for (OOPHomeInfo oopHomeInfo : oopSessionInfo.getHomeInfoList()) {
            if (!requestedHomeList.contains(FileUtils.getFile((String)oopHomeInfo.getCloneHome()).getPath()) || !new File(oopHomeInfo.getCloneHome()).exists()) continue;
            throw new OPatchAutoException(Integer.toString(72124), new Object[]{cookie.getOperationType().name().toLowerCase(), oopHomeInfo.getCloneHome()});
        }
        return true;
    }

    private static boolean isAdminManagedDB(Database sdb) throws ServerGroupException {
        boolean isAdminManaged = false;
        List serverGrp = sdb.serverGroups();
        if (serverGrp.size() == 1 && !((ServerGroup)serverGrp.get(0)).isServerPool()) {
            isAdminManaged = true;
        }
        logger.fine("isAdminManaged: " + isAdminManaged);
        return isAdminManaged;
    }
}

