/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.validators;

import com.oracle.cie.common.util.FileUtils;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPHomeInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionCookie;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHelper;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.validators.CommonSessionCookieCreator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class PrepareSessionCookieCreator
extends CommonSessionCookieCreator {
    private static final Logger logger = Logger.getLogger(PrepareSessionCookieCreator.class.getName());

    @Override
    protected void validateAndMerge(boolean isRemotePatching) throws OPatchAutoException {
        Map<String, List<OOPSessionCookie>> remoteCookies = this.getRemoteNodeCookies(this.requestedHomeList);
        this.validateLocalSession(this.requestedHomeList, remoteCookies, isRemotePatching);
        this.cookie = this.validateRemoteSessionsAndMerge(this.requestedHomeList, remoteCookies, isRemotePatching);
        if (this.cookie != null) {
            OOPSessionInfoHelper.isClonePathExists(this.requestedHomeList, this.cookie);
        }
    }

    private void validateLocalSession(List<String> requestedHomeList, Map<String, List<OOPSessionCookie>> remoteCookies, boolean isRemotePatching) throws OPatchAutoException {
        ArrayList<String> localCookieFiles = new ArrayList<String>();
        for (String homePath : requestedHomeList) {
            String sessionInfoFile = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE;
            sessionInfoFile = sessionInfoFile.replace("$HOST_NAME", DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
            localCookieFiles.add(homePath + sessionInfoFile);
        }
        boolean isFirstNode = isRemotePatching ? true : remoteCookies.isEmpty();
        for (String localCookie : localCookieFiles) {
            File cookieFile = new File(localCookie);
            if (!cookieFile.exists()) continue;
            logger.finest("Found local cookie file: " + localCookie);
            OOPSessionCookie cookie = OOPSessionInfoHandler.getInstance().getOOPSessionCookie(cookieFile);
            this.verifyCookieInfo(cookie, requestedHomeList, DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()), isFirstNode, true, isRemotePatching);
        }
    }

    private OOPSessionCookie validateRemoteSessionsAndMerge(List<String> requestedHomeList, Map<String, List<OOPSessionCookie>> remoteCookies, boolean isRemotePatching) throws OPatchAutoException {
        OOPSessionCookie cookie = null;
        Set<String> remoteHostList = remoteCookies.keySet();
        boolean isFirstNode = isRemotePatching;
        for (String remoteHost : remoteHostList) {
            List<OOPSessionCookie> cookieList = remoteCookies.get(remoteHost);
            for (OOPSessionCookie remoteCookie : cookieList) {
                this.verifyCookieInfo(remoteCookie, requestedHomeList, remoteHost, isFirstNode, false, isRemotePatching);
            }
            if (cookieList.isEmpty() || isRemotePatching) continue;
            OOPSessionCookie tempCookie = cookieList.get(0);
            if (cookie == null) {
                cookie = tempCookie;
                continue;
            }
            cookie.addSessionInfo(remoteHost, tempCookie.getOOPSessionInfo(remoteHost));
        }
        return cookie;
    }

    private void verifyCookieInfo(OOPSessionCookie cookie, List<String> requestedHomeList, String host, boolean isFirstNode, boolean isLocalCookie, boolean isRemotePatching) throws OPatchAutoException {
        ArrayList<String> previousSessionHomeList = new ArrayList<String>();
        if (cookie.isSessionCompleted()) {
            return;
        }
        if (!cookie.isSessionCompleted()) {
            if (isRemotePatching) {
                if (isLocalCookie) {
                    logger.finest("Found Active session in current node");
                    throw new OPatchAutoException(Integer.toString(72129), new Object[]{OOPSessionCookie.OOPOperationType.PREPARE.name().toLowerCase(), cookie.getOperationType().name().toLowerCase(), host});
                }
                logger.finest("Found Active session in " + host);
                throw new OPatchAutoException(Integer.toString(72130), new Object[]{OOPSessionCookie.OOPOperationType.PREPARE.name().toLowerCase(), cookie.getOperationType().name().toLowerCase(), host});
            }
            if (cookie.getOperationType().equals((Object)OOPSessionCookie.OOPOperationType.PREPARE)) {
                if (!isFirstNode && isLocalCookie) {
                    logger.finest("Found Active session in current node");
                    throw new OPatchAutoException(Integer.toString(72115), new Object[]{OOPSessionCookie.OOPOperationType.PREPARE.name().toLowerCase(), cookie.getOperationType().name().toLowerCase(), host});
                }
                logger.finest("Found Active session");
                OOPSessionInfo sessioninfo = cookie.getOOPSessionInfo(host);
                List<OOPHomeInfo> homeInfoList = sessioninfo.getHomeInfoList();
                for (OOPHomeInfo homeInfo : homeInfoList) {
                    previousSessionHomeList.add(FileUtils.getFile((String)homeInfo.getOriginalHome()).getPath());
                }
                if (!previousSessionHomeList.isEmpty()) {
                    Collections.sort(previousSessionHomeList);
                    Collections.sort(requestedHomeList);
                    logger.finest("previousSessionHomeList: " + previousSessionHomeList);
                    logger.finest("requestedHomeList: " + requestedHomeList);
                    if (!previousSessionHomeList.equals(requestedHomeList)) {
                        throw new OPatchAutoException(Integer.toString(72116), new Object[]{cookie.getOperationType().name().toLowerCase(), host, ((Object)previousSessionHomeList).toString()});
                    }
                }
            } else {
                throw new OPatchAutoException(Integer.toString(72117), new Object[]{OOPSessionCookie.OOPOperationType.PREPARE.name().toLowerCase(), host, cookie.getOperationType().name().toLowerCase()});
            }
        }
    }
}

