/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.validators;

import com.oracle.cie.common.util.FileUtils;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPHomeInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionCookie;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.validators.CommonSessionCookieCreator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class RollbackSessionCookieCreator
extends CommonSessionCookieCreator {
    static final Logger logger = Logger.getLogger(RollbackSessionCookieCreator.class.getName());

    @Override
    protected void validateAndMerge(boolean isRemotePatching) throws OPatchAutoException {
        if (!isRemotePatching) {
            this.cleanSessionData(this.cookie);
        }
        this.validateLocalSession(this.requestedHomeList);
        this.validateRemoteSessionsAndMerge(this.requestedHomeList, isRemotePatching);
    }

    private void validateLocalSession(List<String> requestedHomeList) throws OPatchAutoException {
        for (String homePath : requestedHomeList) {
            String sessionInfoFile = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE;
            sessionInfoFile = sessionInfoFile.replace("$HOST_NAME", DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
            String localCookie = homePath + sessionInfoFile;
            File cookieFile = new File(localCookie);
            if (cookieFile.exists()) {
                logger.finest("Found local cookie file: " + localCookie);
                OOPSessionCookie cookie = OOPSessionInfoHandler.getInstance().getOOPSessionCookie(cookieFile);
                this.verifyCookieInfo(cookie, requestedHomeList, homePath);
                continue;
            }
            throw new OPatchAutoException(Integer.toString(72121), new Object[]{homePath});
        }
    }

    private void verifyCookieInfo(OOPSessionCookie cookie, List<String> requestedHomeList, String home) throws OPatchAutoException {
        logger.fine("isSessionCompleted(): " + cookie.isSessionCompleted());
        logger.fine("operationType: " + cookie.getOperationType().name());
        if (cookie.isSessionCompleted()) {
            if (!this.isRollbackCookieExist(home)) {
                throw new OPatchAutoException(Integer.toString(72121), new Object[]{home});
            }
            if (cookie.getOperationType().equals((Object)OOPSessionCookie.OOPOperationType.SWITCH) || cookie.getOperationType().equals((Object)OOPSessionCookie.OOPOperationType.APPLY)) {
                this.compareRequestedHomes(cookie, requestedHomeList);
            } else {
                String sbSessionInfoFile = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE_SWITCHBACK;
                sbSessionInfoFile = sbSessionInfoFile.replace("$HOST_NAME", DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
                String rollbackCookieLoc = home + sbSessionInfoFile;
                File rollbackCookieFile = new File(rollbackCookieLoc);
                OOPSessionCookie rollbackCookie = OOPSessionInfoHandler.getInstance().getOOPSessionCookie(rollbackCookieFile);
                this.compareRequestedHomes(rollbackCookie, requestedHomeList);
            }
        } else {
            throw new OPatchAutoException(Integer.toString(72123), new Object[]{home, cookie.getOperationType().name().toLowerCase()});
        }
    }

    private boolean isRollbackCookieExist(String home) {
        String sbSessionInfoFile = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE_SWITCHBACK;
        sbSessionInfoFile = sbSessionInfoFile.replace("$HOST_NAME", DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
        String rollbackCookieLoc = home + sbSessionInfoFile;
        File rollbackCookieFile = new File(rollbackCookieLoc);
        return rollbackCookieFile.exists();
    }

    private void compareRequestedHomes(OOPSessionCookie cookie, List<String> requestedHomeList) throws OPatchAutoException {
        ArrayList<String> previousSessionHomeList = new ArrayList<String>();
        String host = DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost());
        OOPSessionInfo sessioninfo = cookie.getOOPSessionInfo(host);
        List<OOPHomeInfo> homeInfoList = sessioninfo.getHomeInfoList();
        for (OOPHomeInfo homeInfo : homeInfoList) {
            if (!homeInfo.getHomeOperationType().equals((Object)OOPHomeInfo.HomeOperationType.SWITCH) && !homeInfo.getHomeOperationType().equals((Object)OOPHomeInfo.HomeOperationType.APPLY)) continue;
            homeInfo.reverseRole();
            previousSessionHomeList.add(FileUtils.getFile((String)homeInfo.getOriginalHome()).getPath());
        }
        ArrayList<String> tmpList = new ArrayList<String>(requestedHomeList);
        if (!previousSessionHomeList.isEmpty()) {
            logger.finest("previousSessionHomeList: " + previousSessionHomeList);
            logger.finest("requestedHomeList: " + tmpList);
            Collections.sort(previousSessionHomeList);
            Collections.sort(tmpList);
            if (!previousSessionHomeList.equals(tmpList)) {
                throw new OPatchAutoException(Integer.toString(72122), new Object[]{cookie.getOperationType().name().toLowerCase()});
            }
        }
    }

    private OOPSessionCookie validateRemoteSessionsAndMerge(List<String> requestedHomeList, boolean isRemotePatching) throws OPatchAutoException {
        Map<String, List<OOPSessionCookie>> remoteCookies = this.getRemoteNodeCookies(requestedHomeList);
        Set<String> remoteHostList = remoteCookies.keySet();
        logger.info("Verifying cookie on remote node ");
        for (String remoteHost : remoteHostList) {
            List<OOPSessionCookie> cookieList = remoteCookies.get(remoteHost);
            for (OOPSessionCookie remoteCookie : cookieList) {
                this.verifyRemoteCookieInfo(remoteCookie, requestedHomeList, remoteHost);
                if (isRemotePatching) continue;
                OOPSessionInfo oopSessionInfo = remoteCookie.getOOPSessionInfo(remoteHost);
                logger.fine("Checking for host::" + remoteHost);
                if (!remoteCookie.getOperationType().equals((Object)OOPSessionCookie.OOPOperationType.ROLLBACK) || !this.isRollbackCompleted(oopSessionInfo)) continue;
                logger.fine("Rollback is completed in host ::" + remoteHost);
                this.cookie.addSessionInfo(remoteHost, oopSessionInfo);
            }
        }
        return this.cookie;
    }

    private boolean isRollbackCompleted(OOPSessionInfo oopSessionInfo) {
        boolean rollbackCompleted = false;
        for (OOPHomeInfo oopHomeInfo : oopSessionInfo.getHomeInfoList()) {
            if (oopHomeInfo.getHomeOperationType().equals((Object)OOPHomeInfo.HomeOperationType.ROLLBACK)) {
                rollbackCompleted = true;
                continue;
            }
            rollbackCompleted = false;
            break;
        }
        return rollbackCompleted;
    }

    private void verifyRemoteCookieInfo(OOPSessionCookie cookie, List<String> requestedHomeList, String host) throws OPatchAutoException {
        if (cookie.isSessionCompleted() && (cookie.getOperationType().equals((Object)OOPSessionCookie.OOPOperationType.SWITCH) || cookie.getOperationType().equals((Object)OOPSessionCookie.OOPOperationType.APPLY))) {
            return;
        }
        if (!cookie.isSessionCompleted() && cookie.getOperationType().equals((Object)OOPSessionCookie.OOPOperationType.ROLLBACK)) {
            ArrayList<String> previousSessionHomeList = new ArrayList<String>();
            OOPSessionInfo sessioninfo = cookie.getOOPSessionInfo(host);
            List<OOPHomeInfo> homeInfoList = sessioninfo.getHomeInfoList();
            for (OOPHomeInfo homeInfo : homeInfoList) {
                if (!homeInfo.getHomeOperationType().equals((Object)OOPHomeInfo.HomeOperationType.ROLLBACK)) continue;
                previousSessionHomeList.add(FileUtils.getFile((String)homeInfo.getOriginalHome()).getPath());
            }
            if (!previousSessionHomeList.isEmpty()) {
                Collections.sort(previousSessionHomeList);
                Collections.sort(requestedHomeList);
                logger.finest("previousSessionHomeList: " + previousSessionHomeList);
                logger.finest("requestedHomeList: " + requestedHomeList);
                if (!previousSessionHomeList.equals(requestedHomeList)) {
                    throw new OPatchAutoException(Integer.toString(72116), new Object[]{cookie.getOperationType().name().toLowerCase(), host, ((Object)previousSessionHomeList).toString()});
                }
            }
        } else {
            throw new OPatchAutoException(Integer.toString(72117), new Object[]{OOPSessionCookie.OOPOperationType.ROLLBACK.name().toLowerCase(), host, cookie.getOperationType().name().toLowerCase()});
        }
    }
}

