/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.patchlevel;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

public class OracleHomePatchLevel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, List<OPatchPatchInfo>> oracleHomePatchLevel = new ConcurrentHashMap<String, List<OPatchPatchInfo>>();

    public void addOracleHomePatchLevel(String oracleHome, List<OPatchPatchInfo> patchBeans) {
        this.oracleHomePatchLevel.put(oracleHome, patchBeans);
    }

    public Map<String, List<OPatchPatchInfo>> getOracleHomePatchLevel() {
        return this.oracleHomePatchLevel;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String oh : this.oracleHomePatchLevel.keySet()) {
            builder.append("\nFor Oracle Home: " + oh);
            builder.append(" following are the patch levels: ");
            builder.append(" \n=========================================================================");
            List<OPatchPatchInfo> patchInfos = this.oracleHomePatchLevel.get(oh);
            for (OPatchPatchInfo info : patchInfos) {
                builder.append("\nPatch ID: " + info.getPatchID());
                builder.append("\nUnique Patch ID: " + info.getUniquePatchID());
                builder.append("\nSQL Patch: " + info.isSQLPatch());
            }
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        OracleHomePatchLevel oracleHomePatchLevel = (OracleHomePatchLevel)obj;
        Set<Map.Entry<String, List<OPatchPatchInfo>>> entrySet = oracleHomePatchLevel.getOracleHomePatchLevel().entrySet();
        for (Map.Entry<String, List<OPatchPatchInfo>> entry : entrySet) {
            List<OPatchPatchInfo> patchInfoList = this.oracleHomePatchLevel.get(entry.getKey());
            if (patchInfoList.size() == entry.getValue().size()) {
                if (patchInfoList.containsAll((Collection)entry.getValue())) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

