/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.summary;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.db.product.summary.ISummaryGenerator;
import com.oracle.glcm.patch.auto.db.product.summary.PatchingSummary;
import com.oracle.glcm.patch.auto.db.product.summary.Summary;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryID;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryTarget;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryTargetList;
import com.oracle.glcm.patch.auto.db.product.summary.generator.AnalyzeSummaryGenerator;
import com.oracle.glcm.patch.auto.db.product.summary.generator.GenerateStepSummaryGenerator;
import com.oracle.glcm.patch.auto.db.product.summary.generator.OOPPatcingSummaryGenerator;
import com.oracle.glcm.patch.auto.db.product.summary.generator.PatchingActionSummaryGenerator;
import com.oracle.glcm.patch.auto.db.product.summary.generator.PatchingWarningSummaryGenerator;
import com.oracle.glcm.patch.auto.db.product.summary.generator.SDBPatchingActionSummaryGenerator;
import com.oracle.glcm.patch.auto.db.product.summary.generator.ShardingPatchingActionSummaryGenerator;
import com.oracle.glcm.patch.auto.db.product.summary.generator.SkippedHomePatchSummaryGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PatchingSummaryGenerator {
    List<ISummaryGenerator> generators;

    PatchingSummaryGenerator() {
        this.getSummaryGenearator();
    }

    void generatePatchingSummary(PatchingSummary patchingSummary, OPatchAutoCommand command) {
        Reporting.report((String)"\n--------------------------------Summary--------------------------------");
        this.generateConfigSummary(patchingSummary, command);
        this.generateTargetSpecificSummary(patchingSummary, command);
        this.generateGeneralSummary(patchingSummary, command);
    }

    private void generateTargetSpecificSummary(PatchingSummary patchingSummary, OPatchAutoCommand command) {
        Set<SummaryID> summaryIDList = patchingSummary.getTargetSummaryIDList();
        for (SummaryID id : summaryIDList) {
            Map<SummaryTarget, Summary> summaryTargetList;
            SummaryTargetList summaryTargetListObj = patchingSummary.getTargetSummaryList(id);
            if (summaryTargetListObj == null || (summaryTargetList = summaryTargetListObj.getSummaryList()) == null) continue;
            this.generateSummary(id, summaryTargetList, null, command);
        }
    }

    private void generateGeneralSummary(PatchingSummary patchingSummary, OPatchAutoCommand command) {
        Set<SummaryID> summaryIDList = patchingSummary.getGeneralSummaryIDList();
        for (SummaryID id : summaryIDList) {
            List<String> summaryList = patchingSummary.getGeneralSummaryList(id);
            if (summaryList == null) continue;
            this.generateSummary(id, null, summaryList, command);
        }
    }

    private void generateConfigSummary(PatchingSummary patchingSummary, OPatchAutoCommand command) {
        Set<SummaryID> summaryIDList = patchingSummary.getConfigSummaryIDList();
        for (SummaryID id : summaryIDList) {
            List<String> summaryList = patchingSummary.getConfigSummaryList(id);
            if (summaryList == null) continue;
            this.generateSummary(id, null, summaryList, command);
        }
    }

    private void generateSummary(SummaryID id, Map<SummaryTarget, Summary> summaryTargetList, List<String> summaryList, OPatchAutoCommand command) {
        for (ISummaryGenerator generator : this.generators) {
            generator.generateSummary(id, summaryTargetList, summaryList, command);
        }
    }

    private List<ISummaryGenerator> getSummaryGenearator() {
        this.generators = new ArrayList<ISummaryGenerator>();
        this.generators.add(new OOPPatcingSummaryGenerator());
        this.generators.add(new PatchingActionSummaryGenerator());
        this.generators.add(new AnalyzeSummaryGenerator());
        this.generators.add(new GenerateStepSummaryGenerator());
        this.generators.add(new SkippedHomePatchSummaryGenerator());
        this.generators.add(new SDBPatchingActionSummaryGenerator());
        this.generators.add(new ShardingPatchingActionSummaryGenerator());
        this.generators.add(new PatchingWarningSummaryGenerator());
        return this.generators;
    }
}

