/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationUtil;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.db_crs.RACDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CRSLogicalStandbyNotUsedValidator
implements IValidator {
    Logger logger = Logger.getLogger(CRSLogicalStandbyNotUsedValidator.class.getName());

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        this.logger.log(Level.FINE, "Invoking rule to ensure that the logical standby database is not used.");
        SystemInstance systemInst = (SystemInstance)params.get(ValidationParamKey.SYSTEM_INST.ordinal());
        List racDatabases = systemInst.getTargetsOfType(RACDatabase.class);
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        String message = null;
        ArrayList<BaseClass> logicalStandbyDBs = new ArrayList<BaseClass>();
        if (racDatabases != null && !racDatabases.isEmpty()) {
            for (RACDatabase rac : racDatabases) {
                if (rac.getDataguardStatus() == null || !rac.getDataguardStatus().equalsIgnoreCase("logical standby")) continue;
                this.logger.log(Level.FINEST, "Found logical standby rac database " + rac.getDatabaseName());
                logicalStandbyDBs.add((BaseClass)rac);
            }
        }
        if (!logicalStandbyDBs.isEmpty()) {
            message = BundleUtils.getMessage(CRSLogicalStandbyNotUsedValidator.class, "LOGICAL_STANDBY", BundleUtils.makeStringOutOfList(logicalStandbyDBs));
            String formattedMsg = ValidationUtil.getFormattedMessage(logicalStandbyDBs, message);
            this.logger.log(Level.INFO, formattedMsg);
            Reporting.report((String)message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.LOGICAL_STANDBY, logicalStandbyDBs));
        }
        if (!multipleValidationResult.isEmpty()) {
            return multipleValidationResult;
        }
        message = "Ensures Logical Standby Database is not used.";
        this.logger.log(Level.FINE, message);
        multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
        return multipleValidationResult;
    }
}

