/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.product.driver.jdbc.util.SDBCatalogConnection;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import java.io.File;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CatalogHomeConnectionValidator
implements IValidator {
    private Logger logger = Logger.getLogger(CatalogHomeConnectionValidator.class.getName());
    private static final String SID = "SID";
    private static final String SERVICE = "SERVICE";

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        String message;
        this.logger.log(Level.FINE, "Invoking catalog home validation to check whether supplied catalog details are correct or not.");
        String catalogDBHost = (String)params.get(ValidationParamKey.CATALOG_DB_HOST.ordinal());
        String sid = (String)params.get(ValidationParamKey.SID.ordinal());
        String service = (String)params.get(ValidationParamKey.SERVICE.ordinal());
        String port = (String)params.get(ValidationParamKey.PORT.ordinal());
        String walletLoc = (String)params.get(ValidationParamKey.WALLET_LOC.ordinal());
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        String userID = "";
        String password = "";
        if (StringUtil.isNullOrEmpty((String)walletLoc)) {
            String message2 = BundleUtils.getMessage(CatalogHomeConnectionValidator.class, "NO_WALLET_FILE", new Object[0]);
            Reporting.report((String)message2);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.NO_WALLET_FILE, null));
            return multipleValidationResult;
        }
        try {
            CredentialManager credentialManager = new CredentialManager();
            char[] pwd = null;
            credentialManager.setWallet(new File(walletLoc), pwd);
            String key = credentialManager.getCredentialKey(!StringUtil.isNullOrEmpty((String)sid) ? sid : service, "jdbc");
            Credential credential = credentialManager.getCredentialByKey(key);
            userID = credential.getUsername();
            password = new String(credential.getPassword());
        }
        catch (OPatchAutoException e) {
            this.logger.throwing("Detailed OPatchAutoException : ", e.getMessage(), e);
            String message3 = BundleUtils.getMessage(CatalogHomeConnectionValidator.class, "INVALID_CATALOG_CREDENTIAL", !StringUtil.isNullOrEmpty((String)sid) ? SID : SERVICE, !StringUtil.isNullOrEmpty((String)sid) ? sid : service);
            Reporting.report((String)message3);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.INVALID_CATALOG_CREDENTIALS, !StringUtil.isNullOrEmpty((String)sid) ? sid : service));
            return multipleValidationResult;
        }
        catch (Exception e) {
            this.logger.throwing("Detailed Exception : ", e.getMessage(), e);
            String message4 = BundleUtils.getMessage(CatalogHomeConnectionValidator.class, "INVALID_CATALOG_CREDENTIAL", !StringUtil.isNullOrEmpty((String)sid) ? SID : SERVICE, !StringUtil.isNullOrEmpty((String)sid) ? sid : service);
            Reporting.report((String)message4);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.INVALID_CATALOG_CREDENTIALS, !StringUtil.isNullOrEmpty((String)sid) ? sid : service));
            return multipleValidationResult;
        }
        SDBCatalogConnection sdbCatalogConnection = null;
        try {
            this.logger.info("Going to verify connection to database : " + sid);
            sdbCatalogConnection = SDBCatalogConnection.getInstance();
            if (null != sdbCatalogConnection) {
                sdbCatalogConnection.init(catalogDBHost, port, sid, service, userID, password);
                sdbCatalogConnection.connectToCatalogDB();
            }
        }
        catch (Exception e) {
            this.logger.throwing("Detailed Exception : ", e.getMessage(), e);
            try {
                sdbCatalogConnection.closeConnection();
            }
            catch (SQLException se) {
                this.logger.throwing("Detailed SQLException : ", e.getMessage(), e);
            }
            message = BundleUtils.getMessage(CatalogHomeConnectionValidator.class, "CATALOG_CONNECT_ERROR", !StringUtil.isNullOrEmpty((String)sid) ? SID : SERVICE, !StringUtil.isNullOrEmpty((String)sid) ? sid : service, catalogDBHost, port);
            Reporting.report((String)message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.INVALID_CATALOG_DETAILS, !StringUtil.isNullOrEmpty((String)sid) ? sid : service));
            return multipleValidationResult;
        }
        if (null == sdbCatalogConnection) {
            this.logger.warning("Catalog database connection is null");
            String message5 = BundleUtils.getMessage(CatalogHomeConnectionValidator.class, "CATALOG_CONNECT_ERROR", !StringUtil.isNullOrEmpty((String)sid) ? SID : SERVICE, !StringUtil.isNullOrEmpty((String)sid) ? sid : service, catalogDBHost, port);
            Reporting.report((String)message5);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.INVALID_CATALOG_DETAILS, !StringUtil.isNullOrEmpty((String)sid) ? sid : service));
            return multipleValidationResult;
        }
        int noOfRows = 0;
        try {
            noOfRows = sdbCatalogConnection.getShardViewDesc();
            if (noOfRows == 0) {
                message = BundleUtils.getMessage(CatalogHomeConnectionValidator.class, "EMPTY_CATALOG_DB_VIEW", new Object[0]);
                Reporting.report((String)message);
                multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.EMPTY_CATALOG_DB_VIEW, !StringUtil.isNullOrEmpty((String)sid) ? sid : service));
            } else {
                multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
            }
        }
        catch (Exception e) {
            this.logger.throwing("Detailed Exception : ", e.getMessage(), e);
            try {
                sdbCatalogConnection.closeConnection();
            }
            catch (SQLException se) {
                this.logger.throwing("Detailed SQLException : ", e.getMessage(), e);
            }
            String message6 = BundleUtils.getMessage(CatalogHomeConnectionValidator.class, "INCORRECT_CATALOG_DB", !StringUtil.isNullOrEmpty((String)sid) ? SID : SERVICE, !StringUtil.isNullOrEmpty((String)sid) ? sid : service);
            Reporting.report((String)message6);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.INCORRECT_CATALOG_DB, !StringUtil.isNullOrEmpty((String)sid) ? sid : service));
        }
        return multipleValidationResult;
    }
}

