/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.validation.validators.DiskSpaceCheckResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;
import oracle.dbsysmodel.driver.sdk.util.OsysUtility;

public class DiskSpaceVerifier {
    private static final long ONE_GB_BUFFER = 0x40000000L;
    private static final int FILE_IO_ERROR = 2;
    static Logger logger;

    public static void main(String[] args) {
        ArrayList<String> argsList = new ArrayList<String>();
        if (args != null) {
            argsList.addAll(Arrays.asList(args));
        }
        String patchSize = null;
        String objlocation = null;
        ArrayList<String> cloneHomePaths = null;
        for (int i = 0; i < argsList.size(); ++i) {
            if (((String)argsList.get(i)).equalsIgnoreCase("-PATCHSIZE")) {
                patchSize = (String)argsList.get(++i);
                continue;
            }
            if (((String)argsList.get(i)).equalsIgnoreCase("-OBJECTLOC")) {
                objlocation = (String)argsList.get(++i);
                continue;
            }
            if (!((String)argsList.get(i)).equalsIgnoreCase("-CLONEHOMEMAP")) continue;
            String cloneHomeStr = (String)argsList.get(++i);
            cloneHomePaths = new ArrayList<String>(Arrays.asList(cloneHomeStr.split(",")));
        }
        logger.info("patchSize: " + patchSize);
        logger.info("objlocation: " + objlocation);
        logger.info("cloneHomePaths: " + cloneHomePaths);
        HashMap<String, String> cloneHomeMap = new HashMap<String, String>();
        for (String clone : cloneHomePaths) {
            String[] s = clone.split("#");
            cloneHomeMap.put(s[0], s[1]);
        }
        logger.info("DiskSpaceVerifier.main()cloneHomeMap: " + cloneHomeMap);
        DiskSpaceCheckResult result = DiskSpaceVerifier.checkSpaceforCloning(Long.valueOf(patchSize), cloneHomeMap);
        try {
            FileUtility.persistDataObj((String)objlocation, (Object)result, (boolean)true);
        }
        catch (IOException e) {
            System.exit(2);
        }
    }

    public static final DiskSpaceCheckResult checkSpaceforCloning(long patchSize, Map<String, String> cloneHomeMap) {
        HashMap<String, List<String>> homeResult = new HashMap<String, List<String>>();
        String homePath = cloneHomeMap.keySet().iterator().next();
        logger.info("homePath: " + homePath);
        System.setProperty("ORACLE_HOME", homePath);
        String configFile = homePath + DBCommonPatchingConstants.OPATCHAUTO_DB_PROPERTIES;
        File opatchautoConfig = new File(configFile);
        long buffer = 0x40000000L;
        int noOfTimesThePatch = 2;
        if (opatchautoConfig.exists()) {
            Properties properties = new Properties();
            try {
                int tmpTimes;
                long tmpBuf;
                properties.load(new FileInputStream(configFile));
                if (properties.containsKey("DISK_SPACE_BUFFER") && (tmpBuf = Long.valueOf(properties.getProperty("DISK_SPACE_BUFFER")).longValue()) > 0L) {
                    buffer = tmpBuf;
                }
                if (properties.containsKey("NO_OF_TIMES_PATCH_SIZE_BUFFER") && (tmpTimes = Integer.valueOf(properties.getProperty("NO_OF_TIMES_PATCH_SIZE_BUFFER")).intValue()) > 0) {
                    noOfTimesThePatch = tmpTimes;
                }
            }
            catch (Exception e) {
                logger.info("Unable to find the opatchauto.properties file " + e.getMessage());
            }
        }
        long totalSize = buffer;
        logger.info("Size of patch directory " + patchSize);
        long totalPatchSize = (long)noOfTimesThePatch * patchSize;
        logger.info("Total size " + (totalSize += totalPatchSize));
        Map oracleHomeSize = OUIDriver.getOracleHomeSize(cloneHomeMap.keySet());
        long totalSizeForCloning = 0L;
        Set homePathFromMap = oracleHomeSize.keySet();
        Iterator pathItr = homePathFromMap.iterator();
        String cloneHomePath = null;
        while (pathItr.hasNext()) {
            String path = (String)pathItr.next();
            logger.info("path: " + path);
            cloneHomePath = cloneHomeMap.get(path);
            logger.info("cloneHomePath: " + cloneHomePath);
            long homeSize = (Long)oracleHomeSize.get(path);
            totalSizeForCloning += homeSize;
            logger.info("homeSize " + homeSize);
            boolean isSpaceAvailable = OUIDriver.isSpaceAvailable((long)(totalSize + homeSize), (String)cloneHomePath);
            logger.info("isSpaceAvailable " + isSpaceAvailable);
            ArrayList<String> spaceCheckResult = new ArrayList<String>();
            spaceCheckResult.add(String.valueOf(isSpaceAvailable));
            if (!isSpaceAvailable) {
                spaceCheckResult.add("Insufficient disk space for creating a clone home " + path + " of size " + (totalSize + homeSize) / 0x100000L + "MB on " + OsysUtility.getHostname());
            } else {
                spaceCheckResult.add("Space Available");
            }
            homeResult.put(cloneHomePath, spaceCheckResult);
        }
        boolean isSpaceAvailableForAllHomes = OUIDriver.isSpaceAvailable((long)(totalSizeForCloning + totalSize), cloneHomePath);
        logger.info("isSpaceAvailableForAllHomes: " + isSpaceAvailableForAllHomes);
        ArrayList<String> spaceCheckResult = new ArrayList<String>();
        spaceCheckResult.add(String.valueOf(isSpaceAvailableForAllHomes));
        if (isSpaceAvailableForAllHomes) {
            spaceCheckResult.add("Space Available");
        } else {
            spaceCheckResult.add("Insufficient disk space for creating all clone home(s) " + (totalSizeForCloning + totalSize) / 0x100000L + "MB on " + OsysUtility.getHostname());
        }
        homeResult.put("ALL_HOMES", spaceCheckResult);
        DiskSpaceCheckResult result = new DiskSpaceCheckResult(0, DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()), homeResult);
        result.setResultMessage("Success");
        return result;
    }

    static {
        ResourceBundleManager.manageBundle((String)"opatchauto", (String)"resources/opatchautodb/messages");
        ResourceBundleManager.manageBundle((String)"opatchauto", (String)"resources/opatchautodb/opatchauto-db");
        ResourceBundleManager.setPrefix((String)"opatchauto", (String)"OPATCHAUTO");
        logger = Logger.getLogger(DiskSpaceVerifier.class.getName());
    }
}

