/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.sdk.util.PatchPlanUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.PatchTargetFilter;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.HomeImpl;
import com.oracle.glcm.patch.auto.topology.HostImpl;
import com.oracle.glcm.patch.auto.topology.Topology;
import dbmodel.SystemInstance;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;

public class OPatchVersionValidator
implements IValidator {
    private static final String OPATCH_DEBUG = "OPATCH_DEBUG";
    private static final String VERSION = "version";
    private static final String OPATCH = "opatch";
    private static final String SSH = "ssh";
    private static final String OPATCH_FOLDER = "OPatch";
    private Map<String, String> opatchOutPutMap = new ConcurrentHashMap<String, String>();
    private MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
    private Logger logger = Logger.getLogger(OPatchVersionValidator.class.getName());
    private Map<String, List<Home>> versionToHomeMap = null;
    private CredentialManager credManager;
    private SystemInstance systemInstance = null;

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        boolean isGenerateStep = (Boolean)params.get(ValidationParamKey.GENERATE_STEP_OPTION.ordinal());
        boolean isShard = false;
        if (params.get(ValidationParamKey.SHARD.ordinal()) != null) {
            isShard = (Boolean)params.get(ValidationParamKey.SHARD.ordinal());
        }
        if (isGenerateStep || isShard) {
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "Validation not required"));
            return this.multipleValidationResult;
        }
        ConfigGraph configGraph = (ConfigGraph)params.get(ValidationParamKey.CONFIG_GRAPH.ordinal());
        Topology topology = (Topology)params.get(ValidationParamKey.TOPOLOGY.ordinal());
        if (topology.getHomes() != null && topology.getHomes().size() == 1) {
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "Validation not required"));
            return this.multipleValidationResult;
        }
        PatchTargetFilter patchTargetFilter = new PatchTargetFilter();
        this.versionToHomeMap = patchTargetFilter.filter(topology, configGraph);
        if (this.versionToHomeMap.isEmpty()) {
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "Validation not required"));
            return this.multipleValidationResult;
        }
        char[] pwd = null;
        String wallet = (String)params.get(ValidationParamKey.WALLET_LOC.ordinal());
        if (!StringUtil.isNullOrEmpty((String)wallet, (boolean)true)) {
            this.credManager = new CredentialManager();
            this.logger.fine("Using wallet file from " + wallet);
            try {
                this.credManager.setWallet(new File(wallet), pwd);
            }
            catch (OPatchAutoException e) {
                this.credManager = null;
            }
        }
        ArrayList<String> topoHomeList = new ArrayList<String>();
        Set hosts = topology.getHosts();
        for (com.oracle.glcm.patch.auto.topology.Host host : hosts) {
            Iterator HomeItr = host.getHomes().iterator();
            if (!HomeItr.hasNext()) continue;
            while (HomeItr.hasNext()) {
                Home home = (Home)HomeItr.next();
                this.logger.fine(" home location : " + home.getLocation() + " in host:" + host.getHost());
                topoHomeList.add(home.getLocation());
            }
        }
        SystemInstance systemInstance = PatchPlanner.getInstance().getSystemInstance();
        List OHList = systemInstance.getTargetsOfType(OracleHome.class);
        ArrayList<String> sysInstHostList = new ArrayList<String>();
        this.logger.info(" System Instance OHList size " + OHList.size());
        if (OHList != null && !OHList.isEmpty()) {
            for (int i = 0; i < OHList.size(); ++i) {
                OracleHome OH = (OracleHome)OHList.get(i);
                for (Host sysInstHost : OH.getHosts()) {
                    this.logger.info(" OH  hostname " + sysInstHost.getHostName());
                    String hostName = sysInstHost.getHostName();
                    sysInstHostList.add(sysInstHost.getHostName());
                    this.logger.log(Level.INFO, "OH path " + OH.getPath());
                    String ohLocation = OH.getPath();
                    HostImpl topoHost = new HostImpl();
                    if (StringUtil.isNullOrEmpty((String)hostName, (boolean)true) || !topoHomeList.contains(OH.getPath())) continue;
                    this.logger.info(" OH  hostname  OH.getPath() " + OH.getPath());
                    topoHost.setHost(hostName);
                    HomeImpl home = new HomeImpl();
                    String homeOwner = FileUtility.checkFileOwner((File)new File(ohLocation, "oraInst.loc"));
                    home.setLocation(ohLocation);
                    home.setHost((com.oracle.glcm.patch.auto.topology.Host)topoHost);
                    home.setOwner(homeOwner);
                    this.logger.fine("checking opatch version for home: " + ohLocation + " in host:" + hostName);
                    this.findOpatchVersionOnAllHost(hostName, ohLocation, homeOwner);
                }
            }
        }
        if (!this.multipleValidationResult.isEmpty()) {
            List<ValidationResult> resultList = this.multipleValidationResult.getValidationResultList();
            for (ValidationResult result : resultList) {
                if (result.getStatus() != ValidationResult.ValidationStatus.FAILED) continue;
                return this.multipleValidationResult;
            }
        }
        String CurrentOpatchHostHome = this.findCurrentOpatchHostHome(topology);
        this.verifyOpatchVersions(CurrentOpatchHostHome);
        return this.multipleValidationResult;
    }

    private void verifyOpatchVersions(String CurrentOpatchHostHome) {
        if (this.opatchOutPutMap.isEmpty()) {
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "No target to verify"));
        } else {
            if (CurrentOpatchHostHome.isEmpty()) {
                this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "No target to verify"));
                return;
            }
            Set<String> hostHomeList = this.opatchOutPutMap.keySet();
            ArrayList<String> failedHostHomes = new ArrayList<String>();
            String versionToCompare = this.opatchOutPutMap.get(CurrentOpatchHostHome);
            for (String hostHome : hostHomeList) {
                String opatchVersion = this.opatchOutPutMap.get(hostHome);
                if (this.compareString(versionToCompare, opatchVersion)) continue;
                this.logger.warning("OPatch Version Check failed for Home " + hostHome.split(":")[1] + " on host " + hostHome.split(":")[0]);
                failedHostHomes.add(hostHome);
            }
            if (failedHostHomes.isEmpty()) {
                this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "All opatch version verified successfully"));
            } else {
                Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"OPatchVersionValidator.execution.failed", (Object[])new Object[0]));
                for (String hostHome : failedHostHomes) {
                    Reporting.report((String)("Host:" + hostHome.split(":")[0] + ", Home:" + hostHome.split(":")[1] + "\n"));
                }
                ValidationResult validationResult = new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.OPATCH_VERSION_CHECK_FAILED, "Different opatch version");
                this.multipleValidationResult.addValidationResult(validationResult);
            }
        }
    }

    private boolean compareString(String baseString, String stringToCompare) {
        boolean isSame = true;
        this.logger.finest("Base Version for comparing: " + baseString);
        this.logger.finest("Home OPatch Version: " + stringToCompare);
        if (!StringUtil.isNullOrEmpty((String)baseString) && !StringUtil.isNullOrEmpty((String)stringToCompare)) {
            String[] stringListToCompare;
            String[] baseStringList = baseString.split("[\\r\\n]+");
            if (baseStringList.length == (stringListToCompare = stringToCompare.split("[\\r\\n]+")).length) {
                for (int i = 0; i < baseStringList.length; ++i) {
                    if (baseStringList[i].equals(stringListToCompare[i])) continue;
                    isSame = false;
                    break;
                }
            } else {
                isSame = false;
            }
        }
        return isSame;
    }

    private String findCurrentOpatchHostHome(Topology topology) {
        String currentOpatchHostHome = null;
        String currentHome = null;
        String currentHostName = OPatchAutoHelper.getOPatchAutoHost();
        if (currentHostName != null && currentHostName.indexOf(".") != -1) {
            currentHostName = currentHostName.substring(0, currentHostName.indexOf("."));
        }
        try {
            currentHome = PatchPlanUtils.removeFileSeperatorAtEnd(OPatchAutoHelper.getOPatchAutoHome());
        }
        catch (OPatchAutoException e) {
            return currentOpatchHostHome;
        }
        Set homeList = topology.getHomes();
        for (Home tmp : homeList) {
            File homePath = new File(tmp.getLocation());
            try {
                if (!PatchPlanUtils.removeFileSeperatorAtEnd(homePath.getCanonicalPath()).equals(currentHome) || !tmp.getHost().getHost().equalsIgnoreCase(currentHostName)) continue;
                currentOpatchHostHome = currentHostName + ":" + homePath.getAbsolutePath();
            }
            catch (Exception e) {
                return currentOpatchHostHome;
            }
        }
        return currentOpatchHostHome;
    }

    private String getCommandToExecute(String hostname, String homePath) {
        String OH_Path = homePath;
        String sshCommand = "";
        if (!hostname.equalsIgnoreCase(DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost()))) {
            sshCommand = "ssh " + hostname + " ";
        }
        String command = sshCommand + OH_Path + File.separator + OPATCH_FOLDER + File.separator + OPATCH + " " + VERSION;
        return command;
    }

    private void findOpatchVersionOnAllHost(String hostName, String homePath, String Owner) {
        GISystemCall.ExecReturn ret = this.executeCommand(hostName, homePath, Owner);
        if (!ret.isOK()) {
            Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"OPatchVersionValidator.version.command.execution.failed", (Object[])new Object[]{hostName, homePath, ret.getErrorMessage()}));
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.OPATCH_VERSION_COMMAND_EXECUTION_FAILED, "Not able to retrieve version"));
        } else {
            this.logger.finest("OPatch version for home: " + homePath + ":" + ret.getNormalMessage());
            this.opatchOutPutMap.put(hostName + ":" + homePath, this.extractOPatchVersion(ret.getNormalMessage()));
        }
    }

    private String extractOPatchVersion(String output) {
        String[] lines = output.split("\\r?\\n");
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].indexOf("OPatch Version:") == -1) continue;
            return lines[i];
        }
        return output;
    }

    private GISystemCall.ExecReturn executeCommand(String hostName, String homePath, String Owner) {
        String commandToExecute = this.getCommandToExecute(hostName, homePath);
        Credential credential = DBPatchingHelper.getOwnerOrCurrentUserCred(hostName, Owner, this.credManager);
        GISystemCall.ExecReturn ret = GISystemCall.process(commandToExecute, Owner, credential);
        return ret;
    }

    private Map<String, String> getEnvVariable() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put(OPATCH_DEBUG, "false");
        return env;
    }

    private boolean isHomeNeedsToValidated(Home home) {
        boolean isRequired = false;
        Set<String> versionList = this.versionToHomeMap.keySet();
        for (String version : versionList) {
            List<Home> homeList = this.versionToHomeMap.get(version);
            this.logger.finest("home list size for version " + version + ":" + homeList.size());
            if (!homeList.contains(home) || homeList.size() <= 1) continue;
            isRequired = true;
            break;
        }
        this.logger.fine("Is home needs to be validated: " + home.toString() + "," + home.getHost().toString() + "=" + isRequired);
        return isRequired;
    }
}

