/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.dao;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.xmldiff.XmlDiffAspect;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class CachingDataHandler
implements IDataHandler {
    protected Map<String, Object> _attributeCache = new HashMap<String, Object>();
    protected Map<String, Object> _simpleValueCache = new HashMap<String, Object>();
    protected Map<String, IDataHandler[]> _complexValueCache = new HashMap<String, IDataHandler[]>();

    public void clearCaches() {
        this._attributeCache.clear();
        this._simpleValueCache.clear();
        this._complexValueCache.clear();
    }

    @Override
    public Object getAttributeValue(String name) {
        Object value;
        if (!this._attributeCache.containsKey(name)) {
            value = this.getAttributeValueInternal(name);
            if (this.hasAttributeName(name)) {
                this._attributeCache.put(name, value);
            }
        } else {
            value = this._attributeCache.get(name);
        }
        return value;
    }

    protected abstract Object getAttributeValueInternal(String var1);

    @Override
    public void setAttributeValue(String name, Object value) {
        this.setAttributeValueInternal(name, value);
        if (this.hasAttributeName(name)) {
            this._attributeCache.put(name, value);
        }
    }

    protected abstract void setAttributeValueInternal(String var1, Object var2);

    @Override
    public Object getSimpleValue(String name) {
        Object value;
        if (!this._simpleValueCache.containsKey(name)) {
            value = this.getSimpleValueInternal(name);
            if (this.hasSimpleName(name)) {
                this._simpleValueCache.put(name, value);
            }
        } else {
            value = this._simpleValueCache.get(name);
        }
        return value;
    }

    protected abstract Object getSimpleValueInternal(String var1);

    @Override
    public void setSimpleValue(String name, Object value) {
        this.setSimpleValueInternal(name, value);
        if (this.hasSimpleName(name)) {
            this._simpleValueCache.put(name, value);
        }
    }

    protected abstract void setSimpleValueInternal(String var1, Object var2);

    @Override
    public IDataHandler[] getComplexValue(String name) {
        IDataHandler[] value;
        if (!this._complexValueCache.containsKey(name)) {
            value = this.getComplexValueInternal(name);
            if (this.hasComplexName(name)) {
                this._complexValueCache.put(name, value);
            }
        } else {
            value = this._complexValueCache.get(name);
        }
        return value;
    }

    protected abstract IDataHandler[] getComplexValueInternal(String var1);

    @Override
    public void setComplexValue(String name, IDataHandler[] value) {
        this.validateClassLoaders(value);
        this.setComplexValueInternal(name, value);
        if (this.hasComplexName(name)) {
            this._complexValueCache.put(name, value);
        }
    }

    public void setComplexValue(String name, XmlDiffAspect[] value) {
        IDataHandler[] dataHandlers;
        IDataHandler[] iDataHandlerArray = dataHandlers = value != null ? new IDataHandler[value.length] : null;
        if (value != null) {
            for (int x = 0; x < value.length; ++x) {
                dataHandlers[x] = (IDataHandler)value[x];
            }
        }
        this.setComplexValue(name, dataHandlers);
    }

    protected abstract void setComplexValueInternal(String var1, IDataHandler[] var2);

    @Override
    public void setComplexValue(String name, IDataHandler value) {
        this.validateClassLoaders(value);
        this.setComplexValueInternal(name, value);
        if (this.hasComplexName(name)) {
            IDataHandler[] iDataHandlerArray;
            if (value == null) {
                iDataHandlerArray = null;
            } else {
                IDataHandler[] iDataHandlerArray2 = new IDataHandler[1];
                iDataHandlerArray = iDataHandlerArray2;
                iDataHandlerArray2[0] = value;
            }
            this._complexValueCache.put(name, iDataHandlerArray);
        }
    }

    protected abstract void setComplexValueInternal(String var1, IDataHandler var2);

    @Override
    public IDataHandler addComplexValue(String name) {
        if (this.hasComplexName(name)) {
            this._complexValueCache.remove(name);
        }
        return this.addComplexValueInternal(name);
    }

    protected abstract IDataHandler addComplexValueInternal(String var1);

    @Override
    public void addComplexValue(String name, IDataHandler dataHandler) {
        if (this.hasComplexName(name)) {
            this._complexValueCache.remove(name);
        }
        this.validateClassLoaders(dataHandler);
        this.addComplexValueInternal(name, dataHandler);
    }

    protected abstract void addComplexValueInternal(String var1, IDataHandler var2);

    @Override
    public void saveJson(File file) throws DataHandlerException {
        throw new DataHandlerException("Saving JSON not supported by this handler.");
    }

    @Override
    public void saveJson(OutputStream os) throws DataHandlerException {
        throw new DataHandlerException("Saving JSON not supported by this handler.");
    }

    private void validateClassLoaders(IDataHandler ... dataHandlers) {
        if (dataHandlers != null && dataHandlers.length > 0) {
            ClassLoader thisClassLoader = this.getObject().getClass().getClassLoader();
            for (IDataHandler dataHandler : dataHandlers) {
                Object obj;
                if (dataHandler == null || (obj = dataHandler.getObject()) == null) continue;
                ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
                for (ClassLoader objClassLoader = obj.getClass().getClassLoader(); objClassLoader != null; objClassLoader = objClassLoader.getParent()) {
                    classLoaders.add(objClassLoader);
                }
                if (classLoaders.contains(thisClassLoader)) continue;
                throw new IllegalStateException("The classloader used by the current data handler object is not the same classloader or a parent classloader of the data handler object provided.");
            }
        }
    }
}

