/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.dao;

import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataHandlerHelper {
    private static final Logger _log = Logger.getLogger(DataHandlerHelper.class.getName());

    public static <T extends IDataHandlerWrapper> List<T> getWrapperList(IDataHandler dataHandler, String complexName, Class<T> wrapperClass) {
        IDataHandler[] childArray;
        if (!IDataHandlerWrapper.class.isAssignableFrom(wrapperClass)) {
            throw new IllegalArgumentException("Wrapper class object did not implement IDataHandlerWrapper interface.");
        }
        ArrayList<T> wrapperList = new ArrayList<T>();
        if (dataHandler != null && (childArray = dataHandler.getComplexValue(complexName)) != null && childArray.length > 0) {
            try {
                Constructor<T> constructor = wrapperClass.getConstructor(IDataHandler.class);
                for (IDataHandler child : childArray) {
                    wrapperList.add(constructor.newInstance(child));
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return wrapperList;
    }

    public static <T extends IDataHandlerWrapper> void setWrapperList(IDataHandler dataHandler, String complexName, List<T> wrappers) {
        IDataHandler[] handlerArray = null;
        if (wrappers != null && wrappers.size() > 0) {
            handlerArray = new IDataHandler[wrappers.size()];
            for (int x = 0; x < wrappers.size(); ++x) {
                handlerArray[x] = ((IDataHandlerWrapper)wrappers.get(x)).getDataHandler();
            }
        }
        dataHandler.setComplexValue(complexName, handlerArray);
    }

    public static boolean getBooleanValue(Object value, boolean defaultValue) {
        if (value != null) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            String stringValue = value.toString();
            return defaultValue && !"false".equalsIgnoreCase(stringValue) || Boolean.valueOf(stringValue) != false;
        }
        return defaultValue;
    }
}

