/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.tree;

import com.oracle.cie.common.tree.DepthFirstTreeIterator;
import com.oracle.cie.common.tree.PrePostTreeVisitor;
import com.oracle.cie.common.tree.Tree;
import com.oracle.cie.common.tree.TreeFilter;
import com.oracle.cie.common.tree.TreeVisitor;
import com.oracle.cie.common.tree.XMLTreeData;
import java.awt.Component;
import java.util.LinkedList;
import java.util.Properties;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;

public class TreeHelper {
    public static void depthFirstTraversal(Tree t, TreeVisitor visitor) {
        TreeHelper.depthFirstTraversal(t, visitor, null);
    }

    public static void depthFirstTraversal(Tree t, TreeVisitor visitor, TreeFilter filter) {
        visitor.visitTree(t, filter);
        DepthFirstTreeIterator it = t.depthIterator(filter);
        while (it.hasNext()) {
            Tree subtree = (Tree)it.next();
            visitor.visitTree(subtree, filter);
        }
    }

    public static void depthFirstTraversal(Tree t, PrePostTreeVisitor prePostVisitor) {
        TreeHelper.depthFirstTraversal(t, prePostVisitor, null);
    }

    public static void depthFirstTraversal(Tree t, PrePostTreeVisitor prePostVisitor, TreeFilter filter) {
        prePostVisitor.preVisitTree(t, filter);
        prePostVisitor.visitTree(t, filter);
        int childCount = filter == null ? t.getChildCount() : filter.getChildCount(t);
        for (int i = 0; i < childCount; ++i) {
            Tree child = filter == null ? t.getChild(i) : filter.getChild(t, i);
            TreeHelper.depthFirstTraversal(child, prePostVisitor, filter);
        }
        prePostVisitor.postVisitTree(t, filter);
    }

    public static void breadthFirstTraversal(Tree t, TreeVisitor visitor) {
        TreeHelper.breadthFirstTraversal(t, visitor, null);
    }

    public static void breadthFirstTraversal(Tree t, TreeVisitor visitor, TreeFilter filter) {
        LinkedList<Tree> queue = new LinkedList<Tree>();
        if (filter == null && !t.isLeaf() || filter != null && filter.isLeaf(t)) {
            queue.addLast(t);
        }
        while (!queue.isEmpty()) {
            Tree head = (Tree)queue.removeFirst();
            visitor.visitTree(head, filter);
            int childCount = filter == null ? head.getChildCount() : filter.getChildCount(t);
            for (int i = 0; i < childCount; ++i) {
                Tree child = filter == null ? head.getChild(i) : filter.getChild(head, i);
                queue.addLast(child);
            }
        }
    }

    public static JTree wrapTree(Tree tree) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(tree);
        TreeHelper.treeAsNode(tree, rootNode);
        JTree jtree = new JTree(rootNode);
        ToolTipManager.sharedInstance().registerComponent(jtree);
        if (tree.getData() instanceof XMLTreeData) {
            jtree.setCellRenderer(new XMLTreeDataJTreeCellRenderer());
        } else {
            jtree.setCellRenderer(new TreeDataJTreeCellRenderer());
        }
        return jtree;
    }

    private static MutableTreeNode treeAsNode(Tree tree, MutableTreeNode node) {
        for (int i = 0; i < tree.getChildCount(); ++i) {
            Tree childTree = tree.getChild(i);
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(childTree);
            node.insert(childNode, i);
            if (childTree.isLeaf()) continue;
            TreeHelper.treeAsNode(childTree, childNode);
        }
        return node;
    }

    private static class TreeDataJTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private TreeDataJTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Tree t = (Tree)((DefaultMutableTreeNode)value).getUserObject();
            this.setText(t.getId());
            this.setToolTipText(t.getData().toString());
            return this;
        }
    }

    private static class XMLTreeDataJTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private XMLTreeDataJTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Tree t = (Tree)((DefaultMutableTreeNode)value).getUserObject();
            XMLTreeData data = (XMLTreeData)t.getData();
            this.setText(t.getId() + " " + data.getText());
            StringBuffer sb = new StringBuffer();
            Properties attributes = data.getAttributes();
            for (Object o : attributes.keySet()) {
                String key = (String)o;
                sb.append(key).append("=").append(attributes.getProperty(key)).append(" ");
            }
            this.setToolTipText(sb.toString());
            return this;
        }
    }
}

