/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.tree;

import com.oracle.cie.common.tree.BasicTree;
import com.oracle.cie.common.tree.Tree;
import com.oracle.cie.common.tree.XMLTreeData;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XMLTreeDataHandler
extends DefaultHandler
implements LexicalHandler {
    private Tree _root = null;
    private Tree _parent = null;
    private Tree _currTree = null;

    public Tree getRoot() {
        return this._root;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        XMLTreeData treeData = new XMLTreeData();
        for (int i = 0; i < attributes.getLength(); ++i) {
            treeData.setAttribute(attributes.getQName(i), attributes.getValue(i));
        }
        this._currTree = new BasicTree(qName, treeData);
        if (this._parent != null) {
            this._parent.addChild(this._currTree);
        } else {
            this._root = this._currTree;
        }
        this._parent = this._currTree;
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this._parent = this._parent.getParent();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length).trim();
        if (s.length() != 0) {
            ((XMLTreeData)this._currTree.getData()).appendText(s);
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this._parent != null) {
            String s = new String(ch, start, length);
            ((XMLTreeData)this._parent.getData()).addComment(s);
        }
    }
}

