/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.util;

import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporter;
import com.oracle.cie.common.util.reporting.ReporterType;
import com.oracle.cie.common.util.reporting.ReporterTypes;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.common.util.reporting.ReportingException;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.ValueHolder;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.util.BootstrapController;
import com.oracle.glcm.patch.auto.db.util.BootstrapHelper;
import com.oracle.glcm.patch.auto.db.util.BootstrapOptionValidator;
import com.oracle.glcm.patch.auto.db.util.BootstrapParams;
import com.oracle.glcm.patch.auto.db.util.BootstrapResult;
import com.oracle.glcm.patch.auto.db.util.PatchReaderUtil;
import com.oracle.glcm.patch.auto.db.utils.BootstrapConstants;
import com.oracle.glcm.patch.auto.db.utils.BootstrapUtil;
import com.oracle.glcm.patch.auto.session.PatchInfo;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;

public class BootstrapHandler {
    private static final Logger _log = Logger.getLogger(BootstrapHandler.class.getName());
    private static final String IS_HELP_SESSION = "IS_HELP_SESSION";
    private static final String HOME_LIST = "HOME_LIST";
    private static final String GRID_HOME_VERSION = "GRID_HOME_VERSION";
    private static final String WALLET = "-wallet";
    private static final String WALLET_PASS = "-walletPassword";
    private List<String> mainArgList = new ArrayList<String>();

    public static void main(String[] args) {
        ArrayList<String> argsList = new ArrayList<String>();
        if (args != null) {
            argsList.addAll(Arrays.asList(args));
        }
        try {
            boolean ifNeedPerformBootstrapping;
            BootstrapHandler bootstrapHandler = new BootstrapHandler();
            BootstrapParams bootstrapParams = bootstrapHandler.initializeCommonParameters(argsList);
            if (!(bootstrapParams.isBinaryPatching() || bootstrapParams.isShardSidbPatching() || (ifNeedPerformBootstrapping = bootstrapHandler.ifNeedBootstrapping(bootstrapParams)))) {
                _log.info("Exiting as bootstrapping is not required");
                System.exit(0);
            }
            bootstrapHandler.processInputParameters(bootstrapParams);
            bootstrapHandler.performBootstrapping(bootstrapParams);
        }
        catch (OPatchAutoException e) {
            if (e.getMessageID() == 72153) {
                System.exit(153);
            }
            Reporting.report((String)e.getMessage());
            _log.severe(e.getMessage());
            if (_log.isLoggable(Level.FINEST)) {
                e.printStackTrace();
            }
            System.exit(-1);
        }
        catch (Exception e) {
            Reporting.report((String)OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72083), (Object[])new Object[]{e.getMessage()}));
            _log.severe(e.getMessage());
            if (_log.isLoggable(Level.FINEST)) {
                e.printStackTrace();
            }
            System.exit(-1);
        }
    }

    private BootstrapParams initializeCommonParameters(List<String> argsList) throws ReportingException, OPatchAutoException {
        BootstrapParams bootstrapParams = new BootstrapParams();
        for (int x = 0; x < argsList.size(); ++x) {
            String value;
            String tempArg;
            if (argsList.get(x).startsWith("-isActionSession")) {
                tempArg = argsList.get(x);
                value = tempArg.substring(tempArg.indexOf(61) + 1, tempArg.length());
                if (value.trim().equals("1")) {
                    bootstrapParams.setRemotePatching(true);
                    continue;
                }
                bootstrapParams.setRemotePatching(false);
                continue;
            }
            if (argsList.get(x).startsWith("-operationType")) {
                tempArg = argsList.get(x);
                String operationType = tempArg.substring(tempArg.indexOf(61) + 1, tempArg.length());
                if (StringUtil.isNullOrEmpty((String)operationType)) continue;
                bootstrapParams.setOperationType(operationType.toUpperCase());
                continue;
            }
            if (argsList.get(x).startsWith("-DEBUGVAL")) {
                tempArg = argsList.get(x);
                value = tempArg.substring(tempArg.indexOf(61) + 1, tempArg.length());
                if (value.trim().equals("true")) {
                    bootstrapParams.setEnableDebugging(true);
                    continue;
                }
                bootstrapParams.setEnableDebugging(false);
                continue;
            }
            if (!argsList.get(x).startsWith("-ARGS")) continue;
            this.mainArgList = argsList.subList(x + 1, argsList.size());
            this.mainArgList = Arrays.asList(this.mainArgList.get(0).split(" "));
            String baseLocation = System.getProperty("OPatch.ORACLE_HOME");
            bootstrapParams.setBaseLocation(baseLocation);
            String logDir = BootstrapHelper.getValue(this.mainArgList, "-customLogDir");
            if (logDir == null) {
                logDir = BootstrapHelper.getDefaultLogDir(baseLocation);
            }
            bootstrapParams.setCustomLogDir(logDir);
            String logLevel = Level.INFO.getName();
            int logIndex = this.mainArgList.indexOf("-logLevel");
            if (logIndex != -1) {
                logLevel = BootstrapHelper.getValue(this.mainArgList, "-logLevel");
            }
            BootstrapHelper.initLogFactory(logDir, logLevel);
            this.prepareLogDirs(baseLocation, logDir);
            String configDir = BootstrapHelper.getValue(this.mainArgList, "-customConfigDir");
            bootstrapParams.setCustomConfigDir(configDir);
            this.prepareConfigDir(baseLocation, configDir);
            if (bootstrapParams.isRemotePatching()) {
                Reporter reporter = Reporting.addReporter((ReporterType)ReporterTypes.jackson, (OutputStream)System.out);
                reporter.setMessageIndicator(OPatchAutoHelper.OPATCHAUTO_REMOTE_MESSAGE_INDICATOR);
            }
            _log.info("Processing common bootstrap parameters.");
            int invPtrLocIndex = this.mainArgList.indexOf("-invPtrLoc");
            if (invPtrLocIndex != -1) {
                String invPtrLoc = BootstrapHelper.getValue(this.mainArgList, "-invPtrLoc");
                bootstrapParams.setInvPtrLocation(invPtrLoc);
                if (!StringUtil.isNullOrEmpty((String)invPtrLoc)) {
                    System.setProperty("oracle.installer.invPtrLoc", invPtrLoc);
                }
            }
            if (this.mainArgList.contains("-binary")) {
                bootstrapParams.setBinaryPatching(true);
            } else if (this.mainArgList.contains("-sidbonly")) {
                bootstrapParams.setShardSidbPatching(true);
            } else if (this.mainArgList.contains("-sidb")) {
                bootstrapParams.setStandaloneSidbPatching(true);
            }
            this.setPatchingInfoProperty(bootstrapParams);
        }
        return bootstrapParams;
    }

    private void prepareConfigDir(String baseLocation, String configDir) throws OPatchAutoException {
        Credential credential = this.getCredential();
        String parent = new File(configDir).getParent().toString();
        BootstrapHelper.createDirectory(baseLocation, parent, credential, "775");
        BootstrapHelper.createDirectory(baseLocation, configDir, credential, "775");
        String dbTmp = new File(configDir, "dbtmp").toString();
        BootstrapHelper.createDirectory(baseLocation, dbTmp, credential, "775");
        String sessioninfo = new File(configDir, "sessioninfo").toString();
        BootstrapHelper.createDirectory(baseLocation, sessioninfo, credential, "775");
        String oop = new File(configDir, "oop").toString();
        BootstrapHelper.createDirectory(baseLocation, oop, credential, "775");
    }

    private void prepareLogDirs(String baseLocation, String logDir) throws OPatchAutoException {
        Credential credential = this.getCredential();
        BootstrapHelper.createDirectory(baseLocation, logDir, credential, "775");
        String opatchautodb = new File(logDir, "opatchautodb").toString();
        BootstrapHelper.createDirectory(baseLocation, opatchautodb, credential, "775");
        String opatchauto = new File(logDir, "opatchauto").toString();
        BootstrapHelper.createDirectory(baseLocation, opatchauto, credential, "775");
    }

    private Credential getCredential() throws OPatchAutoException {
        Credential credential = null;
        if (!BootstrapHelper.ignoreWallet(this.mainArgList)) {
            String walletLocation = BootstrapHelper.getValue(this.mainArgList, WALLET);
            if (walletLocation == null) {
                return null;
            }
            String walletPassword = BootstrapHelper.getValue(this.mainArgList, WALLET_PASS);
            char[] pwd = null;
            if (walletPassword != null) {
                pwd = walletPassword.toCharArray();
            }
            credential = BootstrapHelper.getWalletInformation(new File(walletLocation), pwd);
        }
        return credential;
    }

    private void setSelectedHomes(BootstrapParams bootstrapParams) throws OPatchAutoException {
        PatchInfo patchInfo = bootstrapParams.getPatchInfo();
        if (!StringUtil.isNullOrEmpty((String)patchInfo.getPatchId())) {
            String patchPath = patchInfo.getPatchId();
            if (patchPath.trim().equals("PATCH_INFO_NOT_REQ")) {
                return;
            }
            _log.info("Setting home for rollback using ID");
            if (bootstrapParams.isBinaryPatching()) {
                String oracleHome = BootstrapHelper.getValue(this.mainArgList, "-oh");
                if (null == oracleHome) {
                    oracleHome = System.getenv("ORACLE_HOME");
                }
                if (null == oracleHome || !new File(oracleHome).exists()) {
                    throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)"68035", (Object[])new Object[]{oracleHome}), new Object[0]);
                }
                bootstrapParams.setHomes(Arrays.asList(oracleHome));
            } else if (this.mainArgList.contains("-oh")) {
                String ohList = BootstrapHelper.getValue(this.mainArgList, "-oh");
                if (StringUtil.isNullOrEmpty((String)ohList)) {
                    throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)"68035", (Object[])new Object[]{ohList}), new Object[0]);
                }
                List<String> homes = BootstrapHelper.getValidHomes(Arrays.asList(ohList.split(",")));
                bootstrapParams.setHomes(homes);
            } else {
                File invPtrLoc;
                if (bootstrapParams.isRemotePatching() && (invPtrLoc = new File(bootstrapParams.getBaseLocation(), "oraInst.loc")).exists()) {
                    System.setProperty("oracle.installer.invPtrLoc", invPtrLoc.getAbsolutePath());
                }
                bootstrapParams.setHomes(BootstrapHelper.getValidHomes(null));
            }
        }
    }

    private boolean ifNeedBootstrapping(BootstrapParams bootstrapParams) throws OPatchAutoException, IOException {
        boolean ifNeedPerformBootstrapping = true;
        if (bootstrapParams.isRemotePatching() && (ifNeedPerformBootstrapping = this.ifNeedToPerformBootstrappingForRemote(bootstrapParams))) {
            int indexOf = this.mainArgList.indexOf("-container");
            if (indexOf > 0) {
                PatchActionExecutorContainer container = BootstrapHelper.deserializeContainer(this.mainArgList.get(indexOf + 1));
                if (container != null && this.ifSkipBootstrapping(container)) {
                    ifNeedPerformBootstrapping = false;
                }
            } else {
                throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72081), (Object[])new Object[0]), new Object[0]);
            }
        }
        return ifNeedPerformBootstrapping;
    }

    private boolean ifSkipBootstrapping(PatchActionExecutorContainer container) {
        if (container != null) {
            if (container.getCommand().isReport()) {
                return true;
            }
            if (container.getPatchActionParameterValue(DBProductParameterConstants.SKIP_GRID_HOME.getValue()) != null) {
                return (Boolean)container.getPatchActionParameterValue(DBProductParameterConstants.SKIP_GRID_HOME.getValue());
            }
        }
        return false;
    }

    private boolean ifNeedToPerformBootstrappingForRemote(BootstrapParams bootstrapParams) throws IOException, OPatchAutoException {
        boolean ifNeedToPerformBootstrapping = false;
        String dbSessionInfoPath = bootstrapParams.getCustomConfigDir() + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR;
        String currentHostName = System.getProperty("OPatchauto.HOSTNAME");
        String lastSessionInfoFilepath = dbSessionInfoPath + "lastsessioninfo_" + DBPatchingHelper.getHostNameWithoutDomain((String)currentHostName) + ".txt";
        String sessionInfoFilepath = bootstrapParams.getCustomConfigDir() + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR + "sessioninfo.txt";
        String lastSessionId = BootstrapHelper.readFileContents(lastSessionInfoFilepath);
        _log.info("Last Session Id : " + lastSessionId);
        String sessionId = BootstrapHelper.readFileContents(sessionInfoFilepath);
        _log.info("Session Id : " + sessionId);
        if (!StringUtil.isNullOrEmpty((String)sessionId)) {
            if (!sessionId.equals(lastSessionId)) {
                ifNeedToPerformBootstrapping = true;
            } else {
                BootstrapHelper.setPatchworkProperty(bootstrapParams.getCustomConfigDir());
            }
        }
        _log.info("Need to perfrom bootstrapping : " + ifNeedToPerformBootstrapping);
        return ifNeedToPerformBootstrapping;
    }

    private void processInputParameters(BootstrapParams bootstrapParams) throws OPatchAutoException, ReportingException {
        File baseLocFile = new File(bootstrapParams.getBaseLocation());
        long space1 = baseLocFile.getFreeSpace();
        _log.info("Space available: " + space1 / 0x100000L + " MB");
        String oracleHome = System.getProperty(BootstrapConstants.OPATCH_ORACLE_HOME.getValue());
        DBPatchingHelper.setupEnvironment((String)oracleHome, (String)bootstrapParams.getInvPtrLocation());
        if (bootstrapParams.isRemotePatching()) {
            PatchActionExecutorContainer container;
            int indexOf = this.mainArgList.indexOf("-container");
            if (indexOf > 0 && (container = BootstrapHelper.deserializeContainer(this.mainArgList.get(indexOf + 1))) != null) {
                this.processContainerParameters(bootstrapParams, container);
            }
        } else if (BootstrapParams.OperationType.APPLY.equals((Object)bootstrapParams.getOperationType()) || BootstrapParams.OperationType.ROLLBACK.equals((Object)bootstrapParams.getOperationType())) {
            if (!bootstrapParams.isBinaryPatching() && !bootstrapParams.isShardSidbPatching()) {
                BootstrapOptionValidator bootstrapOptionValidator = new BootstrapOptionValidator();
                bootstrapOptionValidator.validateOptions(this.mainArgList, bootstrapParams.getGridVersion());
                if (!BootstrapHelper.ignoreWallet(this.mainArgList)) {
                    String walletLocation = BootstrapHelper.getValue(this.mainArgList, WALLET);
                    String walletPassword = BootstrapHelper.getValue(this.mainArgList, WALLET_PASS);
                    bootstrapParams.setCredential(this.validateWalletAndGetCredential(walletLocation, walletPassword));
                }
                bootstrapParams.setOOPPatching(BootstrapHelper.isOOPPatchingSession(this.mainArgList));
            }
            PatchInfo patchInfo = PatchReaderUtil.getPatchInformation(this.mainArgList, bootstrapParams.getOperationType(), bootstrapParams.getGridVersion());
            _log.info("The patchInfo is : " + patchInfo);
            if (null != patchInfo) {
                bootstrapParams.setPatchInfo(patchInfo);
            } else {
                throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72080), (Object[])new Object[0]), new Object[0]);
            }
        }
        this.setSelectedHomes(bootstrapParams);
    }

    private Credential validateWalletAndGetCredential(String walletLocation, String walletPassword) throws OPatchAutoException {
        Credential credential = null;
        if (StringUtil.isNullOrEmpty((String)walletLocation)) {
            _log.info("Invalid wallet information");
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72046), (Object[])new Object[0]), new Object[0]);
        }
        char[] pwd = null;
        if (walletPassword != null) {
            pwd = walletPassword.toCharArray();
        }
        if ((credential = BootstrapHelper.getWalletInformation(new File(walletLocation), pwd)) == null) {
            _log.info("No credentials found in wallet");
            Reporting.report((String)OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72048), (Object[])new Object[]{""}));
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72048), (Object[])new Object[]{""}), new Object[0]);
        }
        this.validateCurrentUserPrivilage(credential);
        return credential;
    }

    public void validateCurrentUserPrivilage(Credential credential) throws OPatchAutoException {
        boolean failed = false;
        int retValue = 255;
        try {
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add(BootstrapHelper.getBashCmd());
            cmds.add("-c");
            String home = OPatchAutoHelper.getOPatchAutoHome();
            if (!ClusterInformationLoader.isGridHome((String)home)) {
                return;
            }
            BootstrapHelper.cleanSudoSession();
            cmds.add("echo '" + new String(credential.getPassword()) + "'" + " | " + BootstrapHelper.getSudoCmd() + " -S -u root pwd");
            retValue = BootstrapHelper.execute(cmds, false);
        }
        catch (OPatchAutoException e) {
            _log.info("Failed to validate current user privileges");
            failed = true;
        }
        if (retValue != 0 || failed) {
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72055), (Object[])new Object[]{credential.getUsername()}), new Object[0]);
        }
    }

    private void processContainerParameters(BootstrapParams bootstrapParams, PatchActionExecutorContainer container) throws OPatchAutoException {
        PatchInfo patchInfo;
        String walletLocation = ((String)container.getPatchActionParameterValue("wallet")).trim();
        bootstrapParams.setOperationType(container.getCommand().name().toUpperCase());
        ValueHolder valueHolder = (ValueHolder)container.getPatchActionParameterValue("value.holder");
        char[] walletPasswordFromContainer = valueHolder != null ? valueHolder.getValue() : null;
        String walletPassword = null;
        if (null != walletPasswordFromContainer) {
            walletPassword = new String(walletPasswordFromContainer).trim();
        }
        bootstrapParams.setCredential(this.validateWalletAndGetCredential(walletLocation, walletPassword));
        if (null != container.getPatchActionParameterValue(DBProductParameterConstants.GRID_HOME.getValue())) {
            String gridHome = (String)container.getPatchActionParameterValue(DBProductParameterConstants.GRID_HOME.getValue());
            gridHome = BootstrapHelper.getBootstrapHome(bootstrapParams.getOperationType(), false, gridHome, "", bootstrapParams.getBaseLocation(), true, container);
            bootstrapParams.setGridHome(gridHome);
        }
        if (null != container.getPatchActionParameterValue("oop-patching-session")) {
            Boolean isOOPPatching = (Boolean)container.getPatchActionParameterValue("oop-patching-session");
            bootstrapParams.setOOPPatching(isOOPPatching);
        }
        if (null != container.getPatchActionParameterValue(DBProductParameterConstants.PATCH_WITH_FILES_FROM_LOC.getValue())) {
            String pathWithFilesFromLoc = (String)container.getPatchActionParameterValue(DBProductParameterConstants.PATCH_WITH_FILES_FROM_LOC.getValue());
            bootstrapParams.setPathWithFilesFromLoc(pathWithFilesFromLoc);
        }
        if (null == (patchInfo = PatchReaderUtil.getPatchInfoFromContainerPath(container))) {
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72080), (Object[])new Object[0]), new Object[0]);
        }
        bootstrapParams.setPatchInfo(patchInfo);
    }

    private void performBootstrapping(BootstrapParams bootstrapParams) throws OPatchAutoException {
        BootstrapController bootstrapController = new BootstrapController();
        List<BootstrapResult> bootstrapResults = bootstrapController.executeBootstrapping(bootstrapParams);
        _log.info("The bootstrap execution result is : " + bootstrapResults);
        for (BootstrapResult bootstrapResult : bootstrapResults) {
            if (bootstrapResult.getResult().isSuccess()) continue;
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72083), (Object[])new Object[]{bootstrapResult.getErrorMessage()}), new Object[0]);
        }
    }

    private void setPatchingInfoProperty(BootstrapParams bootstrapParams) throws OPatchAutoException {
        Properties patchingInfoProperty = new Properties();
        String ohList = "";
        if (!bootstrapParams.isBinaryPatching() && this.mainArgList.contains("-oh")) {
            ohList = BootstrapHelper.getValue(this.mainArgList, "-oh");
            if (StringUtil.isNullOrEmpty((String)ohList)) {
                throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)"68035", (Object[])new Object[]{ohList}), new Object[0]);
            }
            patchingInfoProperty.setProperty(HOME_LIST, ohList);
        }
        if (!(bootstrapParams.isRemotePatching() || bootstrapParams.isBinaryPatching() || bootstrapParams.isShardSidbPatching())) {
            String crsVer = "";
            if (!this.mainArgList.contains("-sidb")) {
                BootstrapHelper.enableSRVMTrace(bootstrapParams.getCustomLogDir());
                ClusterInformationLoader crs = ClusterInformationLoader.getInstance();
                crsVer = crs.getCrsVersion(crs.isStackRunning());
                String gridhome = BootstrapHelper.getBootstrapHome(bootstrapParams.getOperationType(), this.mainArgList.contains("-switch-clone"), crs.getGridHome(), ohList, bootstrapParams.getBaseLocation(), false, null);
                bootstrapParams.setGridHome(gridhome);
            } else {
                crsVer = BootstrapHelper.getVersion(bootstrapParams.getBaseLocation());
            }
            bootstrapParams.setGridVersion(crsVer);
            patchingInfoProperty.setProperty(GRID_HOME_VERSION, crsVer);
            patchingInfoProperty.setProperty(IS_HELP_SESSION, "false");
            String patchingInfoLocation = System.getProperty("OPatch.PATCH_INFO_LOCATION");
            BootstrapUtil.storePropertiesFile((Properties)patchingInfoProperty, (String)patchingInfoLocation);
        }
    }

    static {
        ResourceBundleManager.manageBundle((String)"opatchauto", (String)"resources/opatchautodb/messages");
        ResourceBundleManager.manageBundle((String)"opatchauto", (String)"resources/opatchautodb/opatchauto-db");
        ResourceBundleManager.setPrefix((String)"opatchauto", (String)"OPATCHAUTO");
    }
}

