/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.util;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.util.BootstrapHelper;
import com.oracle.glcm.patch.auto.db.util.PatchReaderUtil;
import com.oracle.glcm.patch.auto.db.utils.BootstrapUtil;
import dbmodel.common.OUIComponent;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;

public class BootstrapOptionValidator {
    private static final Map<String, List<String>> SUPPORTED_OPTIONS = new HashMap<String, List<String>>();
    private static final String DB_TWELVE_TWO = "12.2.0.0.0";
    private static final String SHARD_REMOTE = "-shardremote";
    private static Logger _log = Logger.getLogger(PatchReaderUtil.class.getName());

    public void validateOptions(List<String> mainArgList, String crsVer) throws OPatchAutoException {
        ArrayList<String> newArg = new ArrayList<String>();
        newArg.addAll(mainArgList);
        String firstElement = (String)newArg.get(0);
        newArg.remove(0);
        firstElement = firstElement.replaceAll("^\"|\"$", "");
        newArg.add(0, firstElement);
        String lastElement = (String)newArg.get(newArg.size() - 1);
        newArg.remove(newArg.size() - 1);
        lastElement = lastElement.replaceAll("^\"|\"$", "");
        newArg.add(lastElement);
        this.loadOptions(newArg, crsVer);
        String command = (String)newArg.get(0);
        ArrayList<String> invalidOptions = new ArrayList<String>();
        List<String> supportedOptions = SUPPORTED_OPTIONS.get(command);
        for (int i = 1; i < newArg.size(); ++i) {
            String arg = (String)newArg.get(i);
            if (!arg.startsWith("-") || supportedOptions.contains(arg)) continue;
            invalidOptions.add(arg);
        }
        if (invalidOptions.size() > 0) {
            if (invalidOptions.contains(SHARD_REMOTE)) {
                if (ClusterInformationLoader.getInstance().getCRSType() != ClusterInformationLoader.CrsType.CRS) {
                    throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72071), (Object[])new Object[]{""}), new Object[0]);
                }
                if (!ClusterInformationLoader.getInstance().isStackRunning()) {
                    throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72072), (Object[])new Object[]{""}), new Object[0]);
                }
            } else {
                _log.info("Invalid arguments: " + ((Object)invalidOptions).toString());
                throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72153), (Object[])new Object[]{((Object)invalidOptions).toString()}), 72153);
            }
        }
    }

    private void loadOptions(List<String> mainArgList, String crsVer) {
        ArrayList<String> applyOptions = new ArrayList<String>();
        this.loadBasicApplyOptions(applyOptions);
        ArrayList<String> rollbackOptions = new ArrayList<String>();
        this.loadBasicRollbackOptions(rollbackOptions);
        if (!(mainArgList.indexOf("-sidb") != -1 || ClusterInformationLoader.getInstance().getCRSType() == ClusterInformationLoader.CrsType.CRS && ClusterInformationLoader.getInstance().isStackRunning())) {
            applyOptions.remove(SHARD_REMOTE);
            rollbackOptions.remove(SHARD_REMOTE);
        }
        if (mainArgList.contains("-oh")) {
            String ohList = BootstrapHelper.getValue(mainArgList, "-oh");
            if (!this.containsDBTwelveTwoHome(ohList.split(","))) {
                this.handleOOPOptionForDBTwelveOne(applyOptions, rollbackOptions);
            }
        } else if (crsVer.compareTo(DB_TWELVE_TWO) < 0) {
            this.handleOOPOptionForDBTwelveOne(applyOptions, rollbackOptions);
        }
        SUPPORTED_OPTIONS.put("apply", applyOptions);
        SUPPORTED_OPTIONS.put("rollback", rollbackOptions);
    }

    private boolean containsDBTwelveTwoHome(String[] homeList) {
        ArrayList<String> ohList = new ArrayList<String>();
        for (String home : homeList) {
            ohList.add(home.trim());
        }
        for (String home : ohList) {
            List homes = OUIDriver.getLocalInfo();
            for (OracleHome oh : homes) {
                _log.fine("oh: " + oh.getPath());
                if (!BootstrapUtil.removeTrailingFileSeperator((String)home).equalsIgnoreCase(BootstrapUtil.removeTrailingFileSeperator((String)oh.getPath()))) continue;
                List ouiComp = oh.getTopLevelOUI();
                String ver = ((OUIComponent)ouiComp.get(0)).getVersion();
                _log.fine("version: " + ver);
                if (!BootstrapHelper.isVersionEqualOrlater(ver, DB_TWELVE_TWO)) continue;
                return true;
            }
        }
        return false;
    }

    private void loadBasicApplyOptions(List<String> applyOptions) {
        applyOptions.add("-oh");
        applyOptions.add("-log");
        applyOptions.add("-logLevel");
        applyOptions.add("-customLogDir");
        applyOptions.add("-customConfigDir");
        applyOptions.add("-analyze");
        applyOptions.add("-invPtrLoc");
        applyOptions.add("-wallet");
        applyOptions.add(SHARD_REMOTE);
        applyOptions.add("-nonrolling");
        applyOptions.add("-generatesteps");
        applyOptions.add("-norestart");
        applyOptions.add("-database");
        applyOptions.add("-ocmrf");
        applyOptions.add("-systemsnapshotfilepath");
        applyOptions.add("-phBaseDir");
        applyOptions.add("-parentid");
        applyOptions.add("-force_conflict");
        applyOptions.add("-skip_conflict");
        applyOptions.add("-no_relink");
        applyOptions.add("-family");
        applyOptions.add("-sshuserequivalence");
        applyOptions.add("-sshaccesskey");
        applyOptions.add("-inplace");
        applyOptions.add("-help");
        applyOptions.add("-deployonly");
        applyOptions.add("-report-analyze-failure");
        applyOptions.add("-outofplace");
        applyOptions.add("-prepare-clone");
        applyOptions.add("-switch-clone");
        applyOptions.add("-silent");
        applyOptions.add("-port");
        applyOptions.add("-sidb");
        applyOptions.add("-sid");
    }

    private void loadBasicRollbackOptions(List<String> rollbackOptions) {
        rollbackOptions.add("-systemsnapshotfilepath");
        rollbackOptions.add("-oh");
        rollbackOptions.add("-log");
        rollbackOptions.add("-logLevel");
        rollbackOptions.add("-customLogDir");
        rollbackOptions.add("-customConfigDir");
        rollbackOptions.add("-analyze");
        rollbackOptions.add("-invPtrLoc");
        rollbackOptions.add("-wallet");
        rollbackOptions.add(SHARD_REMOTE);
        rollbackOptions.add("-nonrolling");
        rollbackOptions.add("-generatesteps");
        rollbackOptions.add("-norestart");
        rollbackOptions.add("-database");
        rollbackOptions.add("-phBaseDir");
        rollbackOptions.add("-no_relink");
        rollbackOptions.add("-parentid");
        rollbackOptions.add("-id");
        rollbackOptions.add("-family");
        rollbackOptions.add("-sshuserequivalence");
        rollbackOptions.add("-sshaccesskey");
        rollbackOptions.add("-inplace");
        rollbackOptions.add("-help");
        rollbackOptions.add("-switch-clone");
        rollbackOptions.add("-outofplace");
        rollbackOptions.add("-silent");
        rollbackOptions.add("-deployonly");
        rollbackOptions.add("-report-analyze-failure");
        rollbackOptions.add("-port");
        rollbackOptions.add("-sidb");
        rollbackOptions.add("-sid");
    }

    private void handleOOPOptionForDBTwelveOne(List<String> applyOptions, List<String> rollbackOptions) {
        applyOptions.remove("-inplace");
        rollbackOptions.remove("-inplace");
        rollbackOptions.remove("-outofplace");
        rollbackOptions.remove("-switch-clone");
        applyOptions.remove("-outofplace");
        applyOptions.remove("-prepare-clone");
        applyOptions.remove("-switch-clone");
        applyOptions.remove("-silent");
        rollbackOptions.remove("-silent");
    }
}

